$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnIncluir',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma Solicitação.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir as solicitações de compras filtradas.',
          position: 'right'
        }
      },
      {
        element: '#tabelaSolCompra',
        popover: {
          title: 'Tabela Solicitações',
          description: 'Aqui estão os dados das solicitações cadastradas.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

if (colunas == null || colunas.acessoSolicitacaoCompra == undefined) {
  colunas = { ...colunas, acessoSolicitacaoCompra: [] }
  colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
}

if (colunas == null || colunas.acessoSolicitacaoCompraItens == undefined) {
  colunas = { ...colunas, acessoSolicitacaoCompraItens: [] }
  colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
}

if (colunas == null || colunas.acessoSolicitacaoCompraFornecedores == undefined) {
  colunas = { ...colunas, acessoSolicitacaoCompraFornecedores: [] }
  colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
}

if (colunas == null || colunas.acessoSolicitacaoCompraEstoque == undefined) {
  colunas = { ...colunas, acessoSolicitacaoCompraEstoque: [] }
  colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
}

localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify(colunas));

async function validaAlteraSolicitacao(sNumero) {
  let dadosSelect = {
    tabela: 'SOL_ITEN',
    camposSelect: ['NUMERO'],
    where: [`NUMERO = '${sNumero}' AND SITUACAO <> 'B'`]
  };
  let retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
  if (!retornoSelect) {
    return;
  }
  if (retornoSelect.length === 0) {
    msgAlertaSemConfirmacao("Todos os itens já foram baixados. Não é mais permitido Alterar!")
    return false
  }

  // dadosSelect = {
  //   tabela: 'SOL_ITEN',
  //   camposSelect: ['NUMERO'],
  //   where: [`NUMERO = '${sNumero}'`, `((STATUS <> '' AND STATUS IS NOT NULL) AND STATUS <> 'D')`]
  // }
  // retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect))

  // if (retornoSelect.length > 0) {
  //   msgAlertaSemConfirmacao('Existem itens com situação diferente de Digitado, é possível realizar alterações somente pela Central de Compras.')
  //   return false
  // }
  return true;
};

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("SOLICITACAO_COMPRA");

  addFuncoesBotoes();
  await consultaSolicitacao();

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await consultaSolicitacao();
  });

  $('#txtSolCompraConsulta').on('blur', function () {
    let solCompra = $('#txtSolCompraConsulta').val();
    if (solCompra.includes("[")) {
      solCompra = pegaChave($('#txtSolCompraConsulta'));
    } else {
      solCompra = $('#txtSolCompraConsulta').val();
    }
    solCompra = solCompra.replace('\w', '');
    const listaSolCompra = $('#txtListaSolCompra').val();
    if (solCompra == '') {
      return;
    }
    $('#txtListaSolCompra').val((listaSolCompra == '') ? `'${solCompra}'` : `${listaSolCompra},'${solCompra}'`);
    $('#txtSolCompraConsulta').val('');
    $('#txtSolCompraConsulta').focus();
  });

  $('#txtSolCompraConsulta').on('keydown', async function (event) {
    if (event.key == 'Enter') {
      $('#txtSolCompraConsulta').trigger('blur');
      $('#txtSolCompraConsulta').focus();
    }
  });

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "solicitacao_compra/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#tabelaSolCompra').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaSolCompra').DataTable().row($(this).parents('tr')).data();
      if (await validaAlteraSolicitacao(data[0])) {
        window.location.href = `solicitacao_compra/${btoa(data[0])}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaSolCompra').on('click', '#btn-imprimirItem', async function () {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaSolCompra').DataTable().row($(this).parents('tr')).data();
      const url = `/sisplan/impressao/v1/acesso_solicitacao_compra?`;

      const filtros = await retornaFiltros(`'${data[0]}'`);
      const ordem = `&TELA_ORDENACAO=acesso_solicitacao_compra&ORDEM_ORDENACAO=1`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelSolicitacaoA');
      let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelSolicitacaoA');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  retornaHintRelatorio('btnImprimir', 'RelSolicitacaoA')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/acesso_solicitacao_compra?`;

        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=acesso_solicitacao_compra&ORDEM_ORDENACAO=1`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelSolicitacaoA');
        let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelSolicitacaoA');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#tabelaSolCompra').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaSolCompra').DataTable().row($(this)).data();
      if (await validaAlteraSolicitacao(data[0])) {
        window.location.href = `solicitacao_compra/${btoa(data[0])}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaSolCompra').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      const data = $("#tabelaSolCompra").DataTable().row($(this).parents("tr")).data();
      const pesquisa = {
        tabela: 'SOL_ITEN',
        camposSelect: ['STATUS'],
        where: [`NUMERO = '${data[0]}'`, "STATUS NOT IN ('D', 'R')", 'STATUS IS NOT NULL'],
      }
      const result = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa))

      if (!result) {
        return
      }

      const existeAlgumItemJaEfetivado = result.length > 0

      if (existeAlgumItemJaEfetivado) {
        msgErro('Impossível excluir, existem itens já efetivados nessa solicitação.')
        return
      }

      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  function retornaBotaoOpcoes() {
    return '<div class="divBtnOpcoes" style="width:60%; max-width:100%;""> ' +
      '    <button class="botaoOpcoes" type="button" title="Editar" id="btn-editar"><span class="fas fa-edit" style="color:green"></span></button>     ' +
      '    <button class="botaoOpcoes" type="button" title="Imprimir" id="btn-imprimirItem"><span class="fas fa-print" style="color:green"></span> </button>  ' +
      '    <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      '    <button class="botaoOpcoes" type="button" title="Gestão Documentos" id="btnAnexos"><span class="fas fa-folder-open" style="color:tan;"></span></button>     ' +
      '   </div>';
  };

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" id="btn-imprimirItem">Imprimir</button>  ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '    <button class="dropdown-item" type="button" title="Anexos" id="btnAnexos">Gestão Documentos</button>     ' +
      '</div>';
    retornaHintRelatorio('btn-imprimirItem', 'RelSolicitacaoA')
    return retorno;
  };


  async function retornaFiltros(sNumero = '') {
    const numero = $('#txtListaSolCompra').val();
    const solicitante = pegaChave('#txtSolicitanteConsulta');
    const status = $('#txtStatus').val();
    const statusLib = pegaChave('#txtStatusLib');
    const emissaoDe = $("#txtDataEmiDe").val();
    const emissaoAte = $("#txtDataEmiAte").val();
    const ordensCompra = await formataListas($('#txtOrdemCompra').val().toString())
    const itens = await formataListas($('#txtItemSolicitacao').val().toString())
    const tipoItem = $('#txtTipoItem').val()

    const filtros = `NUMERO=${sNumero == '' ? numero : sNumero}` +
      `&SOLICITANTE=${solicitante}` +
      `&STATUS=${status}` +
      `&LIBERADO=${statusLib}` +
      `&EMISSAODE=${emissaoDe}` +
      `&EMISSAOATE=${emissaoAte}` +
      `&ORDENS_COMPRA=${ordensCompra}` +
      `&ITENS=${itens}` +
      `&TIPO_ITEM=${tipoItem}`;

    return filtros;
  };

  function retornarFiltroEmpresas(codigoUsuario) {
    if (codigoUsuario !== '0000') {
      return { tabela: 'ACESSO_EMPRESA', condicao: `ACESSO_EMPRESA.EMPRESA = SOL_COMPRA.EMPRESA AND ACESSO_EMPRESA.USUARIO = '${codigoUsuario}'` }
    }

    return null
  }

  async function retornarFiltroOrdemCompra() {
    const numeros = await formataListas($('#txtOrdemCompra').val().toString())

    if (!numeros) {
      return ''
    }

    return ` AND (EXISTS (SELECT 1 FROM [COMPRA] COMPRA WHERE COMPRA.SOLICITACAO = SOL_COMPRA.NUMERO AND COMPRA.NUMERO IN (${numeros})) OR EXISTS (SELECT 1 FROM [CO_SOL_IT_AGRUP] CO_SOL_IT_AGRUP WHERE SOL_ITEN.ID = CO_SOL_IT_AGRUP.ID_SOL_ITEN AND CO_SOL_IT_AGRUP.NUMERO IN (${numeros})))`
  }

  async function retornarFiltroItem() {
    const itens = await formataListas($('#txtItemSolicitacao').val().toString())

    if (!itens) {
      return ''
    }

    return ` AND EXISTS (SELECT 1 FROM [SOL_ITEN] ITEN WHERE ITEN.NUMERO = SOL_COMPRA.NUMERO AND ITEN.CODIGO IN (${itens}))`
  }

  async function consultaSolicitacao() {
    try {
      let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      if (colunasInvisiveis == null || colunasInvisiveis.acessoSolicitacaoCompra == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoSolicitacaoCompra: ['EMPRESA'] }));
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      }

      $.LoadingOverlay("show");
      let where = '';
      where = pegaChave('#txtListaSolCompra') != '' ? ` AND SOL_COMPRA.NUMERO IN (${$('#txtListaSolCompra').val()})` : '';
      where += pegaChave('#txtSolicitanteConsulta') != '' ? ` AND SOL_COMPRA.SOLICITANTE = '${pegaChave('#txtSolicitanteConsulta')}'` : '';
      where += $('#txtStatus').val() != '' ? ` AND SOL_COMPRA.STATUS IN (${$('#txtStatus').val()})` : '';
      where += pegaChave('#txtStatusLib') != '' ? ` AND SOL_COMPRA.LIBERADO = '${pegaChave('#txtStatusLib')}'` : '';
      const tipoItem = $('#txtTipoItem').val()
      if (tipoItem) {
        where += ` AND EXISTS (SELECT 1 FROM [SOL_ITEN] ITEN WHERE ITEN.NUMERO = SOL_COMPRA.NUMERO AND ITEN.TP_ITEM = '${tipoItem}')`
      }

      const filtroOrdemCompra = await retornarFiltroOrdemCompra()

      where += filtroOrdemCompra

      const filtroItem = await retornarFiltroItem()

      where += filtroItem

      if ($("#txtDataEmiDe").val() != "01-01-1200" || $$("#txtDataEmiAte").val() != "01-12-2500") {
        where += ` and SOL_COMPRA.DATA >= '${$("#txtDataEmiDe").val()}' and SOL_COMPRA.DATA <= '${$("#txtDataEmiAte").val()}'`;
      }

      const innerJoin = []
      const filtroEmpresas = retornarFiltroEmpresas(getCookie('cod_usuario'))
      if (filtroEmpresas) {
        innerJoin.push(filtroEmpresas)
      }

      const tipoBanco = await retornaDatabase()
      let campoSolicitacao = ''

      switch (tipoBanco.toString().toUpperCase()) {
        case 'FIREBIRD':
          campoSolicitacao = "(SELECT LIST(DISTINCT CO_SOL_IT_AGRUP.NUMERO, ', ') FROM [CO_SOL_IT_AGRUP] CO_SOL_IT_AGRUP WHERE ID_SOL_ITEN IN (SELECT ID FROM [SOL_ITEN] WHERE NUMERO = SOL_COMPRA.NUMERO))"
          break
        case 'ORACLE':
          campoSolicitacao = "(SELECT LISTAGG(DISTINCT CO_SOL_IT_AGRUP.NUMERO, ', ') FROM [CO_SOL_IT_AGRUP] CO_SOL_IT_AGRUP WHERE ID_SOL_ITEN IN (SELECT ID FROM [SOL_ITEN] WHERE NUMERO = SOL_COMPRA.NUMERO))"
          break
        case 'SQLSERVER':
          campoSolicitacao = "(SELECT STRING_AGG(t.NUMERO, ', ') FROM (SELECT DISTINCT CO_SOL_IT_AGRUP.NUMERO FROM [CO_SOL_IT_AGRUP] CO_SOL_IT_AGRUP JOIN [SOL_ITEN] SOL_ITEN ON SOL_ITEN.ID = CO_SOL_IT_AGRUP.ID_SOL_ITEN WHERE SOL_ITEN.NUMERO = SOL_COMPRA.NUMERO) t)"
          break
        case 'POSTGRES':
          campoSolicitacao = "(SELECT STRING_AGG(DISTINCT CO_SOL_IT_AGRUP.NUMERO, ', ') FROM [CO_SOL_IT_AGRUP] CO_SOL_IT_AGRUP WHERE ID_SOL_ITEN IN (SELECT ID FROM [SOL_ITEN] WHERE NUMERO = SOL_COMPRA.NUMERO))"
          break
        default:
          break
      }

      const pesquisaParam = {
        tabela: "SOL_COMPRA",
        camposSelect: [
          'SOL_COMPRA.NUMERO',
          'SOL_COMPRA.NUM_OF',
          'SOL_COMPRA.SOLICITANTE',
          'PESSOAL.NOME',
          'SOL_COMPRA.ORCAMENTO',
          'SOL_COMPRA.DATA',
          'SOL_COMPRA.ENTREGA',
          'SOL_COMPRA.PEDIDO',
          campoSolicitacao,
          'SOL_COMPRA.SETOR',
          'SOL_COMPRA.CENTRO_CUSTO',
          'CENTROCUSTO.DESCRICAO DESC_CENTRO_CUSTO',
          'SOL_COMPRA.STATUS',
          'SOL_COMPRA.LIBERADO',
          'SOL_COMPRA.DT_BAIXA',
          'SOL_COMPRA.USUARIO_BAIXA',
          'SOL_COMPRA.COLECAO',
          'SOL_COMPRA.DT_INICIO',
          'SOL_COMPRA.MOTIVO',
          'MENSAGEM.DESCRICAO DESC_MOTIVO',
          'SOL_COMPRA.USUARIO',
          'SOL_COMPRA.CODCLI',
          'ENTIDADE.NOME NOME_CLI',
          'SOL_COMPRA.PRAZO',
          'TABPRZ.DESCRICAO DESC_PRAZO',
          'SOL_COMPRA.EMPRESA',
          'SOL_COMPRA.PROTOTIPO',
          'SOL_COMPRA.MODELO',
          'SOL_COMPRA.DT_LIBERACAO',
          'SOL_COMPRA.ID_SITPROD COD_SITPROD',
          'SITPROD.DESCRICAO DESC_SITPROD',
          '(SELECT MAX(COTACAO.NUMERO) SOLICITACAO FROM [COTACAO] COTACAO WHERE COTACAO.SOLICITACAO = SOL_COMPRA.NUMERO) NUMERO_COTACAO',
        ],
        leftJoin: [
          { tabela: 'PESSOAL', condicao: 'SOL_COMPRA.SOLICITANTE = PESSOAL.CODIGO' },
          { tabela: 'SOL_ITEN', condicao: 'SOL_COMPRA.NUMERO = SOL_ITEN.NUMERO' },
          { tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = SOL_ITEN.CODIGO' },
          { tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = SOL_ITEN.CODIGO' },
          { tabela: 'CENTROCUSTO', condicao: 'CENTROCUSTO.CODIGO = SOL_COMPRA.CENTRO_CUSTO' },
          { tabela: 'CADCOR', condicao: 'SOL_ITEN.COR = CADCOR.COR' },
          { tabela: 'MENSAGEM', condicao: 'MENSAGEM.CODMEN = SOL_COMPRA.MOTIVO' },
          { tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = SOL_COMPRA.CODCLI' },
          { tabela: 'TABPRZ', condicao: ' SOL_COMPRA.PRAZO = TABPRZ.PRAZO' },
          { tabela: 'SITPROD', condicao: 'SITPROD.CODIGO = CAST(SOL_COMPRA.ID_SITPROD AS VARCHAR(100))' },
        ],
        innerJoin,
        where: [`1=1 ${where}`],
        groupBy: [
          'SOL_COMPRA.NUMERO',
          'SOL_COMPRA.NUM_OF',
          'SOL_COMPRA.SOLICITANTE',
          'PESSOAL.NOME',
          'SOL_COMPRA.ORCAMENTO',
          'SOL_COMPRA.DATA',
          'SOL_COMPRA.ENTREGA',
          'SOL_COMPRA.PEDIDO',
          'SOL_COMPRA.SETOR',
          'SOL_COMPRA.CENTRO_CUSTO',
          'CENTROCUSTO.DESCRICAO',
          'SOL_COMPRA.STATUS',
          'SOL_COMPRA.LIBERADO',
          'SOL_COMPRA.DT_BAIXA',
          'SOL_COMPRA.USUARIO_BAIXA',
          'SOL_COMPRA.COLECAO',
          'SOL_COMPRA.DT_INICIO',
          'SOL_COMPRA.MOTIVO',
          'MENSAGEM.DESCRICAO',
          'SOL_COMPRA.USUARIO',
          'SOL_COMPRA.CODCLI',
          'ENTIDADE.NOME',
          'SOL_COMPRA.PRAZO',
          'TABPRZ.DESCRICAO',
          'SOL_COMPRA.EMPRESA',
          'SOL_COMPRA.PROTOTIPO',
          'SOL_COMPRA.MODELO',
          'SOL_COMPRA.DT_LIBERACAO',
          'SOL_COMPRA.ID_SITPROD',
          'SITPROD.DESCRICAO'
        ],
        orderBy: ['SOL_COMPRA.DATA DESC'],
        camposWhereServerside: [
          'SOL_COMPRA.NUMERO',
          'SOL_COMPRA.NUM_OF',
          'SOL_COMPRA.SOLICITANTE',
          'PESSOAL.NOME',
          'SOL_COMPRA.ORCAMENTO',
          'SOL_COMPRA.DATA',
          'SOL_COMPRA.ENTREGA',
          'SOL_COMPRA.PEDIDO',
          'SOL_COMPRA.SETOR',
          'SOL_COMPRA.CENTRO_CUSTO',
          'CENTROCUSTO.DESCRICAO',
          'SOL_COMPRA.STATUS',
          'SOL_COMPRA.LIBERADO',
          'SOL_COMPRA.DT_BAIXA',
          'SOL_COMPRA.USUARIO_BAIXA',
          'SOL_COMPRA.COLECAO',
          'SOL_COMPRA.DT_INICIO',
          'SOL_COMPRA.MOTIVO',
          'MENSAGEM.DESCRICAO',
          'SOL_COMPRA.USUARIO',
          'SOL_COMPRA.CODCLI',
          'ENTIDADE.NOME',
          'SOL_COMPRA.PRAZO',
          'TABPRZ.DESCRICAO',
          'SOL_COMPRA.EMPRESA',
          'SOL_COMPRA.PROTOTIPO',
          'SOL_COMPRA.MODELO',
          'SOL_COMPRA.DT_LIBERACAO',
          'SOL_COMPRA.ID_SITPROD',
          'SITPROD.DESCRICAO',
        ]
      };

      $("#tabelaSolCompra").DataTable({
        destroy: true,
        lengthChange: true,
        serverSide: true,
        processing: true,
        ajax: {
          url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
          type: "POST",
          headers: { Authorization: BASIC_AUTH },
          data: {
            EMPRESA: getCookie("empresa"),
            JSON: JSON.stringify(pesquisaParam),
            CLIENTE: "S",
          },
        },
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
        rowCallback: function (row, data) {
          if (data[30]) {
            $(row).attr("style", "color: blue !important;")
          }
        }
      });

      $('#tabelaSolCompra_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaSolCompra_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');
      $('#tabelaSolCompra_length').append(`
                        <div class="d-flex align-items-center ml-3">
                          <div class="quadrado" style="background: blue;">
                          </div>
                          <span style="font-size: 1.1rem"> Possui cotação </span>
                        </div>`)

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar');

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        activeColVis = 'buttonColVis'
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#tabelaSolCompra').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.acessoSolicitacaoCompra).indexOf(this.dataSrc().toString()) != -1) {
            this.visible(false);
          }
        }
      )

      $('#buttonExcel').on('click', async function () {
        const dados = $("#tabelaSolCompra").DataTable().data().toArray();
        await exportaCSV("", "", undefined, null, 'Relatório da aba acesso Solicitação de Compra', '', '', 999, false, false, dados);
      });

      await criaGraficosCabecalho();
      setTimeout(() => {
        $($('#tabelaSolCompra tr')[1]).trigger('click')
      }, 150)
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  async function carregaDadosSolicitacaoCompraBaixadas() {
    $.LoadingOverlay('show');
    try {
      let where = '';
      where = pegaChave('#txtListaSolCompra') != '' ? ` AND SOL_COMPRA.NUMERO IN (${$('#txtListaSolCompra').val()})` : '';
      where += pegaChave('#txtSolicitanteConsulta') != '' ? ` AND SOL_COMPRA.SOLICITANTE = '${pegaChave('#txtSolicitanteConsulta')}'` : '';
      where += $('#txtStatus').val() != '' ? ` AND SOL_COMPRA.STATUS IN (${$('#txtStatus').val()})` : '';
      where += pegaChave('#txtStatusLib') != '' ? ` AND SOL_COMPRA.LIBERADO = '${pegaChave('#txtStatusLib')}'` : '';

      if ($("#txtDataEmiDe").val() != "01-01-1200" || $$("#txtDataEmiAte").val() != "01-12-2500") {
        where += ` and SOL_COMPRA.DATA >= '${$("#txtDataEmiDe").val()}' and SOL_COMPRA.DATA <= '${$("#txtDataEmiAte").val()}'`;
      }

      const pesquisaParam = {
        tabela: "SOL_COMPRA",
        camposSelect: [
          'SOL_COMPRA.NUMERO',
          'SOL_COMPRA.SOLICITANTE',
          'PESSOAL.NOME',
          'SUM(CAST(SOL_ITEN.QTDE_B AS NUMERIC(10,2)) * CAST(SOL_ITEN.PRECO AS NUMERIC(10,2))) VALOR_BAIXADO'
        ],
        leftJoin: [
          { tabela: 'SOL_ITEN', condicao: 'SOL_ITEN.NUMERO = SOL_COMPRA.NUMERO' },
          { tabela: 'PESSOAL', condicao: 'SOL_COMPRA.SOLICITANTE = PESSOAL.CODIGO' },
        ],
        where: [`1=1 ${where} AND SOL_ITEN.QTDE_B > 0`],
        groupBy: [
          "SOL_COMPRA.NUMERO",
          "SOL_COMPRA.SOLICITANTE",
          "PESSOAL.NOME",
        ]
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      if (jsonStr.length == 0) {
        return [];
      }

      return jsonStr;
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function carregaDadosSolicitacaoCompraPendentes() {
    $.LoadingOverlay('show');
    try {
      let where = '';
      where = pegaChave('#txtListaSolCompra') != '' ? ` AND SOL_COMPRA.NUMERO IN (${$('#txtListaSolCompra').val()})` : '';
      where += pegaChave('#txtSolicitanteConsulta') != '' ? ` AND SOL_COMPRA.SOLICITANTE = '${pegaChave('#txtSolicitanteConsulta')}'` : '';
      where += $('#txtStatus').val() != '' ? ` AND SOL_COMPRA.STATUS IN (${$('#txtStatus').val()})` : '';
      where += pegaChave('#txtStatusLib') != '' ? ` AND SOL_COMPRA.LIBERADO = '${pegaChave('#txtStatusLib')}'` : '';

      if ($("#txtDataEmiDe").val() != "01-01-1200" || $$("#txtDataEmiAte").val() != "01-12-2500") {
        where += ` and SOL_COMPRA.DATA >= '${$("#txtDataEmiDe").val()}' and SOL_COMPRA.DATA <= '${$("#txtDataEmiAte").val()}'`;
      }

      const pesquisaParam = {
        tabela: "SOL_COMPRA",
        camposSelect: [
          'SOL_COMPRA.NUMERO',
          'SOL_COMPRA.SOLICITANTE',
          'PESSOAL.NOME',
          'SUM(CAST(SOL_ITEN.QTDE AS NUMERIC(10,2)) * SOL_ITEN.PRECO) VALOR_PENDENTE'
        ],
        leftJoin: [
          { tabela: 'SOL_ITEN', condicao: 'SOL_ITEN.NUMERO = SOL_COMPRA.NUMERO' },
          { tabela: 'PESSOAL', condicao: 'SOL_COMPRA.SOLICITANTE = PESSOAL.CODIGO' },
        ],
        where: [`1=1 ${where} AND SOL_ITEN.QTDE > 0`],
        groupBy: [
          "SOL_COMPRA.NUMERO",
          "SOL_COMPRA.SOLICITANTE",
          "PESSOAL.NOME",
        ]
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      if (jsonStr.length == 0) {
        return [];
      }

      return jsonStr;
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function criaGraficosCabecalho() {
    const dadosPendentes = await carregaDadosSolicitacaoCompraPendentes();
    const dadosBaixadas = await carregaDadosSolicitacaoCompraBaixadas();

    Graficos.criarGrafico({
      container: 'graficosSolicitacaoCompra',
      tipo: 'pie',
      dados: dadosPendentes,
      nomeSerie: 'Valor Pendente',
      colunasAgrupamento: ['NOME'],
      colunasValor: ['VALOR_PENDENTE'],
      title: 'Solicitações de Compras Pendentes'
    })
    Graficos.criarGrafico({
      container: 'graficosSolicitacaoCompra1',
      tipo: 'pie',
      dados: dadosBaixadas,
      nomeSerie: 'Valor Faturado',
      colunasAgrupamento: ['NOME'],
      colunasValor: ['VALOR_BAIXADO'],
      title: 'Solicitações de Compras Baixadas'
    })

  }

  async function retornaDadosItens(sNumero) {
    const tipoBanco = await retornaDatabase()

    const camposSelect = [
      'SOL_ITEN.CODIGO',
      `CASE WHEN SOL_ITEN.TP_ITEM = 'P' THEN PRODUTO.DESCRICAO ELSE CASE WHEN SOL_ITEN.TP_ITEM = 'M' THEN MATERIAL.DESCRICAO ELSE SERVICO.DESCRICAO END END AS DESCRICAO`,
      'SOL_ITEN.COR',
      'CADCOR.DESCRICAO DESC_COR',
      'SOL_ITEN.TAM',
      'SOL_ITEN.QTDE SALDO',
    ]

    switch (tipoBanco.toString().toUpperCase()) {
      case 'FIREBIRD':
        camposSelect.push('(UDF_NVL(SOL_ITEN.QTDE) [SOMA] UDF_NVL(SOL_ITEN.QTDE_B) [SOMA] UDF_NVL(SOL_ITEN.QTDE_CANC)) QTDE')
        break
      case 'ORACLE':
        camposSelect.push('(NVL(SOL_ITEN.QTDE, 0) [SOMA] NVL(SOL_ITEN.QTDE_B, 0) [SOMA] NVL(SOL_ITEN.QTDE_CANC, 0)) QTDE')
        break
      case 'SQLSERVER':
        camposSelect.push('(CAST(ISNULL(SOL_ITEN.QTDE, 0) AS FLOAT) [SOMA] CAST(ISNULL(SOL_ITEN.QTDE_B, 0) AS FLOAT) [SOMA] CAST(ISNULL(SOL_ITEN.QTDE_CANC, 0) AS FLOAT) ) QTDE')
        break
      case 'POSTGRES':
        camposSelect.push('(COALESCE(SOL_ITEN.QTDE, 0) [SOMA] COALESCE(SOL_ITEN.QTDE_B, 0) [SOMA] COALESCE(SOL_ITEN.QTDE_CANC, 0)) QTDE')
        break
      default:
        break
    }

    [
      'SOL_ITEN.QTDE_B',
      'SOL_ITEN.QTDE_CANC',
      'SOL_ITEN.PRECO',
      'SOL_ITEN.TP_ITEM',
      'SOL_ITEN.LOTE',
      'SOL_ITEN.DEPOSITO',
      'SOL_ITEN.OBS',
      "CASE SOL_ITEN.STATUS WHEN 'D' THEN 'Digitado' WHEN 'B' THEN 'Bloqueado' WHEN 'R' THEN 'Retornado' WHEN 'L' THEN 'Liberado' WHEN 'C' THEN 'Cotado' WHEN 'N' THEN 'Cancelado' WHEN 'A' THEN 'Atendido' END STATUS",
      'ACESSO_USUARIOS.NOME USUÁRIO_CANCELAMENTO'
    ].forEach((it) => camposSelect.push(it))

    const dadosSelect = {
      tabela: 'SOL_ITEN',
      camposSelect,
      leftJoin: [
        { tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = SOL_ITEN.CODIGO' },
        { tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = SOL_ITEN.CODIGO' },
        { tabela: 'SERVICO', condicao: 'SERVICO.CODIGO = SOL_ITEN.CODIGO' },
        { tabela: 'CADCOR', condicao: 'CADCOR.COR = SOL_ITEN.COR' },
        { tabela: 'ACESSO_USUARIOS', condicao: 'ACESSO_USUARIOS.ID = SOL_ITEN.ID_ACE_USU_RET' },
      ],
      where: [`SOL_ITEN.NUMERO = '${sNumero}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados dos itens.');
      return;
    }
    return retornoSelect;
  };

  async function retornaDadosEstoque(codigo, cor, tpItem) {
    let dadosSelect;
    if (tpItem == 'P') {
      dadosSelect = {
        tabela: 'PA_ITEN',
        camposSelect: [
          'PA_ITEN.CODIGO',
          'PRODUTO.DESCRICAO',
          'PA_ITEN.COR',
          'CADCOR.DESCRICAO DESC_COR',
          'PA_ITEN.DEPOSITO',
          'DEPOSITO.DESCRICAO DESC_DEP',
          'SUM(PA_ITEN.QUANTIDADE) QTDE'
        ],
        leftJoin: [
          { tabela: 'DEPOSITO', condicao: 'DEPOSITO.CODIGO = PA_ITEN.DEPOSITO' },
          { tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = PA_ITEN.CODIGO' },
          { tabela: 'CADCOR', condicao: 'CADCOR.COR = PA_ITEN.COR' },
        ],
        where: [`PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.COR = '${cor}'`],
        groupBy: ['PA_ITEN.CODIGO', 'PA_ITEN.COR', 'PA_ITEN.DEPOSITO', 'DEPOSITO.DESCRICAO', 'PRODUTO.DESCRICAO', 'CADCOR.DESCRICAO']
      };
    }
    if (tpItem == 'M') {
      dadosSelect = {
        tabela: 'MAT_ITEN',
        camposSelect: [
          'MAT_ITEN.CODIGO',
          'MATERIAL.DESCRICAO',
          'MAT_ITEN.COR',
          'CADCOR.DESCRICAO DESC_COR',
          'MAT_ITEN.DEPOSITO',
          'DEPOSITO.DESCRICAO DESC_DEP',
          'SUM(MAT_ITEN.QTDE) QTDE'
        ],
        leftJoin: [
          { tabela: 'DEPOSITO', condicao: 'DEPOSITO.CODIGO = MAT_ITEN.DEPOSITO' },
          { tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = MAT_ITEN.CODIGO' },
          { tabela: 'CADCOR', condicao: 'CADCOR.COR = MAT_ITEN.COR' },
        ],
        where: [`MAT_ITEN.CODIGO = '${codigo}' AND MAT_ITEN.COR = '${cor}'`],
        groupBy: ['MAT_ITEN.CODIGO', 'MAT_ITEN.COR', 'MAT_ITEN.DEPOSITO', 'DEPOSITO.DESCRICAO', 'MATERIAL.DESCRICAO', 'CADCOR.DESCRICAO']
      };
    }

    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados dos itens.');
      return;
    }
    return retornoSelect;

  }

  async function retornaDadosFornecedor(codigo, numero) {
    const dadosSelect = {
      tabela: 'SOL_ITEN',
      camposSelect: [
        'DISTINCT CONV_MATERIAL.CODFOR',
        'ENTIDADE.NOME',
        '(SELECT MAX(CT.COR1) FROM [CADCORTI] CT WHERE CONV_MATERIAL.CODFOR = CT.CODCLI AND CT.CODIGO = SOL_ITEN.CODIGO AND CT.COR = SOL_ITEN.COR) COR_FORNECEDOR'
      ],
      innerJoin: [
        { tabela: 'CONV_MATERIAL', condicao: 'SOL_ITEN.CODIGO = CONV_MATERIAL.CODIGO_MAT' },
      ],
      leftJoin: [
        { tabela: 'ENTIDADE', condicao: 'CONV_MATERIAL.CODFOR = ENTIDADE.CODCLI' },
      ],
      where: [`SOL_ITEN.CODIGO = '${codigo}' AND SOL_ITEN.NUMERO = '${numero}'`],
    };

    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados dos itens.');
      return;
    }
    return retornoSelect;
  }

  async function retornaInformacoesItensSolicitacaoCompra(data, dataSolCompra) {

    if (!data.TP_ITEM || data.TP_ITEM == 'S') {
      return;
    }

    const estoque = await retornaDadosEstoque(data.CODIGO, data.COR, data.TP_ITEM);
    const fornecedor = await retornaDadosFornecedor(data.CODIGO, dataSolCompra[0][0]);
    const dataSetCols = []
    const dataSetCols2 = []

    var keys = Object.keys(estoque[0]);
    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k],
        'data': keys[k]
      });
    }

    var keys2 = Object.keys(fornecedor[0]);
    for (var k in keys2) {
      dataSetCols2.push({
        'title': keys2[k],
        'data': keys2[k]
      });
    }

    criaDataTablePadrao(
      '#tabelaEstoqueSolicitacaoCompraVisualizacao',
      true,
      false,
      false,
      false,
      true,
      true,
      false,
      estoque,
      dataSetCols,
      [],
      [],
      [],
      [],
      {},
      '',
      'buttonColVisEstoque',
      'buttonExcel3',
      false,
      [],
      [],
      false,
      false,
      false,
      false,
      [],
      25,
      '55vh',
      false,
    )

    criaDataTablePadrao(
      '#tabelaFornecedorSolicitacaoCompraVisualizacao',
      true,
      false,
      false,
      false,
      true,
      true,
      false,
      fornecedor,
      dataSetCols2,
      [],
      [],
      [],
      [],
      {},
      '',
      'buttonColVisFornecedores',
      'buttonExcel4',
      false,
      [],
      [],
      false,
      false,
      false,
      false,
      [],
      25,
      '55vh',
      false,
    )

    $('#buttonExcel3').on('click', async function () {
      await exportaCSV('', '', true, null, 'Estoque do item', undefined, '', 999, false, false, estoque);
    })
    $('#buttonExcel4').on('click', async function () {
      await exportaCSV('', '', true, null, 'Fornecedores do item', undefined, '', 999, false, false, fornecedor);
    })

    $('#buttonColVisFornecedores').on('click', async function () {
      $.LoadingOverlay('show')
      try {
        activeColVis = 'buttonColVisFornecedores'
        $('#modal-ColunasVisiveis').modal('show');
      } finally {
        $.LoadingOverlay('hide')
      }
    });

    $('#buttonColVisEstoque').on('click', async function () {
      $.LoadingOverlay('show')
      try {
        activeColVis = 'buttonColVisEstoque'
        $('#modal-ColunasVisiveis').modal('show');
      } finally {
        $.LoadingOverlay('hide')
      }
    });

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaEstoqueSolicitacaoCompraVisualizacao').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.acessoSolicitacaoCompraEstoque).indexOf(this.dataSrc().toString()) != -1) {
          this.visible(false);
        }
      }
    )

    $('#tabelaFornecedorSolicitacaoCompraVisualizacao').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.acessoSolicitacaoCompraFornecedores).indexOf(this.dataSrc().toString()) != -1) {
          this.visible(false);
        }
      }
    )
  }

  async function retornaInformacoesSolicitacaoCompra(compra) {
    try {
      $.LoadingOverlay('show');
      const numero = compra[0];
      const itens = await retornaDadosItens(numero);
      const dataSetCols = []

      if (itens.length == 0) {
        if ($.fn.DataTable.isDataTable('#tabelaSolicitacaoCompraVisualizacao')) {
          $('#tabelaSolicitacaoCompraVisualizacao').DataTable().destroy();
          $('#tabelaSolicitacaoCompraVisualizacao').empty();
        };
        return;
      }

      var keys = Object.keys(itens[0]);
      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      }

      criaDataTablePadrao(
        '#tabelaSolicitacaoCompraVisualizacao',
        true,
        false,
        false,
        false,
        true,
        true,
        false,
        itens,
        dataSetCols,
        [],
        [],
        [],
        [],
        {},
        '',
        'buttonColVisItens',
        'buttonExcel2',
        false,
        [],
        [],
        false,
        false,
        false,
        false,
        [],
        25,
        '55vh',
        false,
      );

      $('#buttonExcel2').on('click', async function () {
        await exportaCSV('', '', true, null, 'Itens da Solicitação de Compra', undefined, '', 999, false, false, itens);
      })

      $('#buttonColVisItens').on('click', async function () {
        $.LoadingOverlay('show')
        try {
          activeColVis = 'buttonColVisItens'
          $('#modal-ColunasVisiveis').modal('show');
        } finally {
          $.LoadingOverlay('hide')
        }
      });
      let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

      $('#tabelaSolicitacaoCompraVisualizacao').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.acessoSolicitacaoCompraItens).indexOf(this.dataSrc().toString()) != -1) {
            this.visible(false);
          }
        }
      )

      $($('#tabelaSolicitacaoCompraVisualizacao tr')[1]).addClass('selected')

      await retornaInformacoesItensSolicitacaoCompra($('#tabelaSolicitacaoCompraVisualizacao').DataTable().row($($('#tabelaSolicitacaoCompraVisualizacao tr')[1])).data(), $("#tabelaSolCompra").DataTable().rows(".selected").data().toArray())

    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#tabelaSolicitacaoCompraVisualizacao').on('click', 'tr', async function () {
    const data = $('#tabelaSolicitacaoCompraVisualizacao').DataTable().row($(this)).data();
    const dataSolCompra = $("#tabelaSolCompra").DataTable().rows(".selected").data().toArray();

    if ($(this).hasClass('selected')) {
      $(this).removeClass('selected');
    } else {
      $('#tabelaSolicitacaoCompraVisualizacao').DataTable().$('tr.selected').removeClass('selected');
      $(this).addClass('selected');
    }

    await retornaInformacoesItensSolicitacaoCompra(data, dataSolCompra)
  });

  $('#tabelaSolCompra').on('click', 'tr', async function () {
    const data = $('#tabelaSolCompra').DataTable().row($(this)).data();

    if ($(this).hasClass('selected')) {
      $(this).removeClass('selected');
    } else {
      $('#tabelaSolCompra').DataTable().$('tr.selected').removeClass('selected');
      $('#tabelaSolCompra').DataTable().$('tr.selected').attr("style", "color: var(--font-color) !important;")
      $(this).addClass('selected');
      if (data[30]) {
        $(this).attr("style", "color: blue !important;")
      }
    }

    await retornaInformacoesSolicitacaoCompra(data)
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        const response = await requisicao('DELETE', '/sisplan/solicitacao_compra/v1/solicitacao_compra?', `NUMERO=${encodeURIComponent(data[0])}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          const jsonStr = await response.json();
          msgAlerta(jsonStr.mensagem);
          return;
        }

        criaMensagemSucesso('Exclusão efetuada com sucesso!', () => { window.location.reload() });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  $("#tabelaSolCompra").on('click', "#btnAnexos", async function () {
    const data = $('#tabelaSolCompra').DataTable().row($(this).parents('tr')).data();

    await abreModalAnexos(data[0], data[1], 'SOLICITACAO_COMPRA');
  })

  function addFuncoesBotoes() {
    $('#btn-limpa-SolCompra').on('click', function () {
      $('#txtListaSolCompra').val('');
    });

    const innerJoinPesquisaSolicitacoes = []
    const filtroEmpresas = retornarFiltroEmpresas(getCookie('cod_usuario'))
    if (filtroEmpresas) {
      innerJoinPesquisaSolicitacoes.push(filtroEmpresas)
    }
    $("#btn-SolCompraConsulta").pesquisa_serverside(["#txtSolCompraConsulta"], ["NUMERO"], ["SOLICITANTE"], `{"tabela":"SOL_COMPRA", "camposSelect":[ "NUMERO", "SOLICITANTE" ], "innerJoin": ${JSON.stringify(innerJoinPesquisaSolicitacoes)}}`, "Pesquisa Solicitação");

    $("#txtSolicitanteConsulta").autocompleta(2, `JSON={ "tabela":"PESSOAL", "camposSelect":["PESSOAL.CODIGO CHAVE, PESSOAL.NOME DESCRICAO"]}`);
    $("#btn-SolicitanteSolCompra").pesquisa_serverside(["#txtSolicitanteConsulta"], ["CODIGO"], ["NOME"], `{"tabela":"PESSOAL", "camposSelect":[ "CODIGO", "NOME" ]}`, "Pesquisa Solicitante");
    $('#btn-limpa-SolicitanteSolCompra').on('click', function () { $('#txtSolicitanteConsulta').val(''); });

    $('#btnFiltros').on('click', function () {
      $('#modal-filtros').modal('show');
    });

    $('#btnLimparFiltros').on('click', async function () {
      $('#txtSolCompraConsulta').val('');
      $('#txtListaSolCompra').val('');
      $('#txtSolicitanteConsulta').val('');
      $("#txtDataEmiDe").val("1200-01-01");
      $("#txtDataEmiAte").val("2500-12-01");
      $("#txtStatusLib").val('');
      $("#txtStatus").val('');
      $("#txtTipoItem").val('');
      $('#txtOrdemCompra').empty().trigger('change')
      $('#txtItemSolicitacao').empty().trigger('change')
    });
  };

  componenteFiltro('ordemCompra', true, true)
  componenteFiltro('itemSolicitacao', true, true)

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    let tabela = ''

    if (activeColVis == 'buttonColVis') {
      tabela = '#tabelaSolCompra'
    }
    if (activeColVis == 'buttonColVisItens') {
      tabela = '#tabelaSolicitacaoCompraVisualizacao'
    }
    if (activeColVis == 'buttonColVisFornecedores') {
      tabela = '#tabelaFornecedorSolicitacaoCompraVisualizacao'
    }
    if (activeColVis == 'buttonColVisEstoque') {
      tabela = '#tabelaEstoqueSolicitacaoCompraVisualizacao'
    }
    $(tabela).DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text().trim(),
        'data': this.dataSrc()
      })
    });

    if (activeColVis == 'buttonColVis') {
      adicionaColunas(cols, colunasInvisiveis.acessoSolicitacaoCompra ?? [], [])
    }
    if (activeColVis == 'buttonColVisItens') {
      adicionaColunas(cols, colunasInvisiveis.acessoSolicitacaoCompraItens ?? [], [])
    }
    if (activeColVis == 'buttonColVisFornecedores') {
      adicionaColunas(cols, colunasInvisiveis.acessoSolicitacaoCompraFornecedores ?? [], [])
    }
    if (activeColVis == 'buttonColVisEstoque') {
      adicionaColunas(cols, colunasInvisiveis.acessoSolicitacaoCompraEstoque ?? [], [])
    }
  })

  $("#btnConfirmarColunas").on("click", async function () {
    try {
      $.LoadingOverlay("show");
      let tabela = ''

      const novasColunas = retornaNovasColunasInvisiveis();
      if (activeColVis == 'buttonColVis') {
        tabela = '#tabelaSolCompra'
        localStorage.setItem(
          "colunasInvisiveisRelatorios",
          JSON.stringify({
            ...colunas,
            acessoSolicitacaoCompra: novasColunas,
          })
        );
      }
      if (activeColVis == 'buttonColVisItens') {
        tabela = '#tabelaSolicitacaoCompraVisualizacao'
        localStorage.setItem(
          "colunasInvisiveisRelatorios",
          JSON.stringify({
            ...colunas,
            acessoSolicitacaoCompraItens: novasColunas,
          })
        );
      }
      if (activeColVis == 'buttonColVisFornecedores') {
        tabela = '#tabelaFornecedorSolicitacaoCompraVisualizacao'
        localStorage.setItem(
          "colunasInvisiveisRelatorios",
          JSON.stringify({
            ...colunas,
            acessoSolicitacaoCompraFornecedores: novasColunas,
          })
        );
      }
      if (activeColVis == 'buttonColVisEstoque') {
        tabela = '#tabelaEstoqueSolicitacaoCompraVisualizacao'
        localStorage.setItem(
          "colunasInvisiveisRelatorios",
          JSON.stringify({
            ...colunas,
            acessoSolicitacaoCompraEstoque: novasColunas,
          })
        );
      }

      $(tabela).DataTable().columns().visible(true);

      $(tabela)
        .DataTable()
        .columns()
        .every(function () {
          const colAtual = String(this.dataSrc());
          if (novasColunas.indexOf(colAtual) != -1) {
            this.visible(false);
          }
        });

    } finally {
      $.LoadingOverlay("hide");
      $("#modal-ColunasVisiveis").modal("hide");
    }
  });
});