$(document).ready(async function () {

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relPosCtasRec == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relPosCtasRec: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  componenteFiltro("cliente", true);
  componenteFiltro("representante", true, false);
  componenteFiltro("classe", true);
  componenteFiltro("situacao", true);
  componenteFiltro("banco", true);
  componenteFiltro("historico", true);
  componenteFiltro("grupoCli", true);
  componenteFiltro("moeda", true);
  componenteFiltro("conta", true);

  $("#btnFiltrosRel").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnLimpaFiltros").on("click", function () {
    limpaFiltros();
  });

  $("#btnCarregaEmpresas").on("click", function () {
    carregaEmpresasDisponiveis();
  });

  $("#btnConsultar").on("click", async function () {
    await fazConsulta();
    $('#modal-filtros').modal('hide');
  });

  await preencheOrdenacaoTela('RelPosCtasRec');

  async function fazConsulta() {
    if ($.fn.DataTable.isDataTable('#tabelaPosicaoCtasRec')) {
      $("#tabelaPosicaoCtasRec").DataTable().destroy();
      $("#tabelaPosicaoCtasRec").empty();
    }
    try {
      dataSetCols = [];
      $.LoadingOverlay('show');
      try {
        const url = "/sisplan/impressao/v1/consultarelposctasrec?";
        const filtros = await retornaFiltros();
        const response = await requisicao("GET", url, `${filtros}&COD_USUARIO=${getCookie("cod_usuario")}`, "", 360000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (jsonStr.length == 0) {
          msgAlerta("Nenhum registro encontrado!");
          $("#txtMeta").val();
          if ($.fn.DataTable.isDataTable('#tabelaPosicaoCtasRec')) {
            $('#tabelaPosicaoCtasRec').DataTable().destroy();
            $('#tabelaPosicaoCtasRec').empty();
          }
          Graficos.limpaGrafico(['graficoRelPosCtasRec', 'graficoRelPosCtasRec1']);
          return;
        }

        if (response.status != 200) {
          msgAlerta(jsonStr.mensagem);
          return;
        };

        let keys = Object.keys(jsonStr[0]);

        keys.forEach((k) => {
          dataSetCols.push({
            title: k,
            data: k,
          });
        });

        $('#tabelaPosicaoCtasRec').DataTable({
          bPaginate: true,
          destroy: true,
          colReorder: true,
          autoWidth: true,
          columns: dataSetCols,
          data: jsonStr,
          columnDefs: [
            {
              "render": function (data) {
                return data > 0 ? parseFloat(data).toLocaleString('pt-BR', {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                }) : parseFloat(0.00);

              },
              "targets": [7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20],
              "className": 'pr-4 text-right'
            },
            {
              "type": 'date-br',
              "targets": [5, 6],
              "render": function (data) {
                if (data != undefined && data != '') {
                  x = data.slice(0, 10).split('-');
                  return `${x[2]}/${x[1]}/${x[0]}`;
                } else {
                  return ''
                }
              }
            }
          ],
        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaPosicaoCtasRec_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaPosicaoCtasRec_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = '/sisplan/impressao/v1/consultarelposctasrec?';
          const filtros = await retornaFiltros();
          await exportaCSV(url, filtros, false, null, 'Relatório de Posição de Constas a Receber', '#tabelaPosicaoCtasRec');
        })


        $('#tabelaPosicaoCtasRec').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.relPosCtasRec).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

        const dados = $('#tabelaPosicaoCtasRec').DataTable().data().toArray();

        Graficos.criarGrafico({
          container: 'graficoRelPosCtasRec',
          tipo: 'pie',
          dados: dados,
          nomeSerie: 'PosCtasRec',
          colunasAgrupamento: ['VAL_PAG', 'JURO', 'DESCONTO', 'DESP_COB', 'VAL_DEV'],
          colunasValor: ['VAL_PAG', 'JURO', 'DESCONTO', 'DESP_COB', 'VAL_DEV'],
          title: 'Valores'
        })

        Graficos.criarGrafico({
          container: 'graficoRelPosCtasRec1',
          tipo: 'pie',
          dados: dados,
          nomeSerie: 'PosCtasRec',
          colunasAgrupamento: ['DESC_HISTORICO'],
          colunasValor: ['VAL_PAG'],
          title: 'Valor pago por histórico'
        })
      } catch (error) {
        console.error(error);
        msgErro("Não foi possível fazer consulta do relatório! Tente novamente.");
        return;
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaPosicaoCtasRec').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relReceber ?? [])
  });

  async function retornaFiltros() {
    const empresasFiltradas = $(".empresa_selecionada:checked").toArray().length > 0 ? $(".empresa_selecionada:checked").toArray().map((input) => input.id.substring(input.id.indexOf("-") + 1, input.id.length)) : [getCookie("emp_id")];
    const empresasFiltradasFormatada = await formataListas(empresasFiltradas.toString());
    const clientesFitlrados = await formataListas($("#txtCliente").val().toString());
    const representantesFiltrados = await formataListas($("#txtRepresentante").val().toString());
    const classesFiltradas = await formataListas($("#txtClasse").val().toString());
    const situacoesFiltradas = await formataListas($("#txtSituacao").val().toString());
    const bancosFiltrados = await formataListas($("#txtBanco").val().toString());
    const historicosFiltrados = await formataListas($("#txtSituacao").val().toString());
    const gruposCliFiltrados = await formataListas($("#txtGrupoCli").val().toString());
    const moedasFiltradas = await formataListas($("#txtMoeda").val().toString());
    const contasFiltradas = await formataListas($("#txtConta").val().toString());
    const posicaoDe = $("#txtPosicaoDe").val();
    const posicaoAte = $("#txtPosicaoAte").val();
    const ordemOrdenacao = $("#txtOrdem").val();
    const filtroData = $('input[name="rdfiltroData"]:checked').val();
    const pagtoEntreDataContabil = $("#cbPagtoEntreDtContabil").is(":checked") ? true : false;
    const considerarPerdidas = $("#cbConsideraPerdidas").is(":checked") ? true : false;
    const statusFiltrados = $('.configCheckBusca').toArray().filter(a => a.checked == true);
    const todasEmpresas = $("#cbTodasAsEmpresas").is(':checked') ? true : false;
    let statusFiltradosFormatados = [];

    for (i = 0; i < statusFiltrados.length; i++) {
      const valorCb = $(`#${statusFiltrados[i].id}`).val()
      statusFiltradosFormatados.push(valorCb);
    };

    const consideraCliente = $("#cbConsideraCliente").is(":checked") ? true : false;
    const consideraRepresentante = $("#cbConsideraRep").is(":checked") ? true : false;
    const consideraClasses = $("#cbConsideraClasse").is(":checked") ? true : false;
    const consideraSituacoes = $("#cbConsideraSituacao").is(":checked") ? true : false;
    const consideraBanco = $("#cbConsideraBanco").is(":checked") ? true : false;
    const consideraHistorico = $("#cbConsideraHistorico").is(":checked") ? true : false;
    const consideraGrupoCli = $("#cbConsideraGrupoCli").is(":checked") ? true : false;

    statusFiltradosFormatados = await formataListas(statusFiltradosFormatados.toString());

    const filtros =
      `CLIENTES=${clientesFitlrados}&` +
      `REPRESENTATES=${representantesFiltrados}&` +
      `CLASSES=${classesFiltradas}&` +
      `BANCOS=${bancosFiltrados}&` +
      `SITUACOES=${situacoesFiltradas}&` +
      `HISTORICOS=${historicosFiltrados}&` +
      `GRUPOSCLI=${gruposCliFiltrados}&` +
      `EMPRESASFILTRADAS=${empresasFiltradasFormatada}&` +
      `POSICAODE=${posicaoDe}&` +
      `POSICAOATE=${posicaoAte}&` +
      `ORDEMORDENACAO=${ordemOrdenacao}&` +
      `ENTREDATA=${pagtoEntreDataContabil}&` +
      `FILTRODATA=${filtroData}&` +
      `CONSIDERACLIENTES=${consideraCliente}&` +
      `CONSIDERAREPRESENTANTE=${consideraRepresentante}&` +
      `CONSIDERACLASSES=${consideraClasses}&` +
      `CONSIDERASITUACOES=${consideraSituacoes}&` +
      `CONSIDERABANCOS=${consideraBanco}&` +
      `CONSIDERAHISTORICO=${consideraHistorico}&` +
      `CONSIDERAGRUPOSCLI=${consideraGrupoCli}&` +
      `CONSIDERAPERDIDA=${considerarPerdidas}&` +
      `STATUSFILTRADOS=${statusFiltradosFormatados}&` +
      `MOEDA=${moedasFiltradas}&` +
      `CONTA=${contasFiltradas}&` +
      `TODASEMPRESAS=${todasEmpresas}`;

    return filtros;
  }

  function limpaFiltros() {
    $("#txtPosicaoDe").val("1200-01-01");
    $("#txtPosicaoAte").val("2500-12-31");
    $("#txtCliente").empty().trigger("change");
    $("#txtRepresentante").empty().trigger("change");
    $("#txtClasse").empty().trigger("change");
    $("#txtSituacao").empty().trigger("change");
    $("#txtBanco").empty().trigger("change");
    $("#txtHistorico").empty().trigger("change");
    $("#txtGrupoCli").empty().trigger("change");
    $("#txtMoeda").empty().trigger("change");
    $("#txtConta").empty().trigger("change");
    $("#rdDataPagto").prop("checked", true);
    $("#cbPagtoEntreDtContabil").prop("checked", false);
    $("#cbConsideraPerdidas").prop("checked", false);
    $("#cbDevolucao").prop("checked", false);
    $("#cbOrcamento").prop("checked", false);
    $("#cbAvisoDebito").prop("checked", true);
    $("#cbAntecipacoes").prop("checked", false);
    $("#cbChequesDev").prop("checked", false);
    $("#cbCheques").prop("checked", false);
    $("#cbDuplicatas").prop("checked", true);

    const checksConsidera = $(".checkfiltros");

    for (let i = 0; i < checksConsidera.length; i++) {
      if (!$(`#${checksConsidera[i].id}`).is(":checked")) {
        $(`#${checksConsidera[i].id}`).prop("checked", true);
      }
    }
  }

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relPosCtasRec: novasColunas }))

      $('#tabelaPosicaoCtasRec').DataTable().columns().visible(true);
      $('#tabelaPosicaoCtasRec').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $("#tutorial").on("click", function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: "Sair",
        closeBtnText: "Fechar",
        nextBtnText: "Próximo",
        prevBtnText: "Anterior",
        allowClose: false,
      });
      driver.defineSteps([
        {
          element: "#btnFiltrosRel",
          popover: {
            title: "Botão Filtros",
            description:
              "Clique aqui para abrir os filtros e realizar alguma consulta.",
            position: "right",
          },
        },
        {
          element: "#btnImprimir",
          popover: {
            title: "Botão Imprimir",
            description: "Clique aqui para imprimir um relatório.",
            position: "right",
          },
        },
      ]);
      driver.start();
    });
  });

  retornaHintRelatorio('btnImprimir', 'RelPosCtasRecPadrao')

  $("#btnImprimir").on("click", async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/imprimirrelposctasrec?`;
        const ordem = `&TELA_ORDENACAO=RelPosCtasRec&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const filtros = await retornaFiltros();
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelPosCtasRec');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelPosCtasRec');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  })
});
