$(document).ready(async function () {

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relInspecaoTingimento == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relInspecaoTingimento: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relInspecaoTingimento: novasColunas }))

      $('#tabelaRelInspecaoTingimento').DataTable().columns().visible(true);
      $('#tabelaRelInspecaoTingimento').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  addTutorial();
  preencheOrdenacaoTela('RelInspecaoTingimento');

  retornaHintRelatorio('btnImprimir', 'RelInspecaoTingimento')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/imprimirrelinspecaotingimento?`;
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelInspecaoTingimento&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelInspecaoTingimento');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelInspecaoTingimento');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', async function () {
    $.LoadingOverlay('show');
    if ($("#txtOrdem option").toArray().length > 0) {
      retornaHintRelatorio('btnImprimir', $("#txtOrdem option").toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1], true)
    }
    try {
      let dataSetCols = [];
      const url = '/sisplan/impressao/v1/consultarelinspecaotingimento?';
      const filtros = await retornaFiltros();

      const response = await requisicao('GET', url, filtros, 130000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (jsonStr.length == 0) {
        return;
      }

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        return;
      }

      let keys = Object.keys(jsonStr[0]);

      keys.forEach(k => {
        dataSetCols.push({
          'title': k,
          'data': k
        });
      });

      criaDataTablePadrao('#tabelaRelInspecaoTingimento', true, true, true, true, true, false, false, jsonStr, dataSetCols, [], [11], [], [], '', 2, 'buttonColVis', 'buttonExcel', true, [], []);

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const url = '/sisplan/impressao/v1/consultarelInspecaotingimento?';
        const filtros = await retornaFiltros();

        await exportaCSV(url, filtros, false, null, 'Relatório de Inspecao Tingimento', '#tabelaRelInspecaoTingimento');
      });


      $('#tabelaRelInspecaoTingimento').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.relInspecaoTingimento).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        }
      )

      $('#tabelaRelInspecaoTingimento tbody').unbind('click');
      $('#tabelaRelInspecaoTingimento tbody').on('click', 'tr', async function (e) {
        const cell = $(e.target).closest('td');
        const index = cell.index();

        if (index === 0) return;
        
        if ($('#tabelaRelInspecaoTingimento').DataTable().data().length > 0) {
            $('#tabelaRelInspecaoTingimento').DataTable().$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
            const dados = $('#tabelaRelInspecaoTingimento').DataTable().row($(this)).data();
            await carregaDados(dados);
        }
      });
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  async function carregaDados(dados) {
    $.LoadingOverlay('show');
    try {
      const pesquisa = {
        tabela: 'MAT_TESTE',
        camposSelect: [
          'MAT_VERIF.VERIFICACAO',
          'VERIFICACAO.DESCRICAO',
          'MAT_VERIF.UNIDADE',
          'MAT_VERIF.VALOR VALOR_VERIFICADO',
          'MAT_VERIF.TOLERANCIA TOLERANCIA_INFERIOR',
          'MAT_VERIF.TOLERANCIA_SUP TOLERANCIA_SUPERIOR',
          'MAT_VERIF.PESO',
          'VERIFICACAO.UNID_TOLERANCIA',
          'MAT_VERIF.QTDE_VERIFICACAO',
          'LAUDO_VERIF.VALOR_VERIF VALOR_INFORMADO',
          'MAT_VERIF.DESC_PADRAO',
          'MAT_VERIF.FREQ_PADRAO',
          `CASE WHEN LAUDO_VERIF.SITUACAO = 'A' THEN 'APROVADO' WHEN LAUDO_VERIF.SITUACAO = 'R' THEN 'REPROVADO' END SITUACAO`
        ],
        leftJoin: [
          { tabela: 'MAT_VERIF', condicao: 'MAT_VERIF.QUALIDADE = MAT_TESTE.TESTE AND MAT_VERIF.MATERIAL = MAT_TESTE.CODIGO' },
          { tabela: 'VERIFICACAO', condicao: 'VERIFICACAO.CODIGO = MAT_VERIF.VERIFICACAO' },
          { tabela: 'LAUDO_VERIF', condicao: 'MAT_TESTE.TESTE = LAUDO_VERIF.TESTE AND MAT_VERIF.VERIFICACAO = LAUDO_VERIF.VERIFICACAO AND MAT_TESTE.CODIGO = LAUDO_VERIF.CODIGO' }
        ],
        where: [`LAUDO_VERIF.VALOR_VERIF <> 0 AND LAUDO_VERIF.OB = '${dados.FAL}' AND MAT_TESTE.CODIGO = '${dados.CODIGO}'`]
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

      criaTb(jsonStr);
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível buscar os dados: ${e}`);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function criaTb(data) {
    if (!data) {
      $('#tabelaDados').empty();
      setTimeout(() => {
        $('#tabelaDados').DataTable().columns.adjust().draw(false);
      }, 500);
      return;
    };

    const dataSetCols = []
    const keys = Object.keys(data[0]);

    keys.forEach((k) => {
      dataSetCols.push({
        title: k,
        data: k,
      });
    });

  criaDataTablePadrao('#tabelaDados', false, false, false, true, true, '300px', '500px', data, dataSetCols, [], [], [], []);
}

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnLimparFiltros').on('click', function () {
    $('#dtDe').val('');
    $('#dtAte').val('');
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRelInspecaoTingimento').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relInspecaoTingimento ?? [])
  })

  async function retornaFiltros() {
    const retorno = `CODCLI=${getCookie('cod_usuario')}&DATAINI=${$('#dtDe').val() ?? ''}&DATAFIM=${$('#dtAte').val() ?? ''}`;
    return retorno;
  }

  function addTutorial() {
    $('#tutorial').on('click', function () {
      $(document).ready(async function () {
        const driver = new Driver({
          doneBtnText: 'Sair',
          closeBtnText: 'Fechar',
          nextBtnText: 'Próximo',
          prevBtnText: 'Anterior',
          allowClose: false
        });
        driver.defineSteps([{
          element: '#btnFiltros',
          popover: {
            title: 'Botão Filtros',
            description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
            position: 'right'
          }
        },
        {
          element: '#btnImprimir',
          popover: {
            title: 'Botão Imprimir',
            description: 'Clique aqui para imprimir um relatório.',
            position: 'right'
          }
        },
        ]);
        driver.start();
      });
    });
  }

});