<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Pagamento Terceiros</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.261.14.1">

  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.261.14.1">
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.261.14.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.261.14.1">
  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.261.14.1">
  <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.261.14.1">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.261.14.1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.261.14.1">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.261.14.1" />
  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.261.14.1">
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.261.14.1">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.261.14.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.261.14.1">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.261.14.1">

  <style>
    #btnOpcoesFiltros {
      margin-left: 15px;
    }

    .form-check {
      margin-left: 8px;
      margin-bottom: 10px;
    }

    .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      padding: 0 0.5em 0 0.5rem !important;
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      border-radius: 3px !important;
    }

    .border-Field2 {
      border: 1px solid var(--font-color) !important;
      padding: 0.5em !important;
      /* margin: 1em !important; */
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      border-radius: 3px !important;
    }

    .icheck-primary {
      margin-top: 0px !important;
    }

    .table.dataTable tbody td,
    .table.dataTable thead {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }

    .modal-header {
      padding: 0.5rem 1rem 0.1rem !important;
      align-items: center !important;
    }

    .modal-footer .btn {
      padding: 0.375rem 0.75rem !important;
    }

    #divFechamento {
      width: 10.5%;
      /* min-width: 130px; */
    }

    #tabelaDados_filter {
      display: none;
    }
  </style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <main class="wrapper">
    <?php
    include_once('../../menu.php');
    ?>
    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Relatório de Pagamento de Terceiros</h1>
            </div>
            <div class="col-sm-6">

            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <fieldset>
                <div class="row">
                  <div class="col-lg-3 col-12">
                    <div class="buttons ml-2">
                      <button class="btn btn-success btn-sisp mr-1" id="btnFiltros" type="button"><span class="fas fa-filter"></span> Filtros</button>
                      <button id="btnImprimir" class="btn-sisp btn btn-danger"><i class="fas fa-print"></i> Imprimir</button>
                    </div>
                    <div class="mt-3">
                      <legend class="textoBorda" style="margin-bottom: 0.2em!important">Fechamento:</legend>
                      <fieldset class="form border-Field2" id="boxFechamento">
                        <div class="d-flex flex-row">
                          <input type="date" value="1200-01-01" class="input-default focus form-control" id="txtPagamento" class="form-control" style="width: 120px; margin-right: 6px">
                          <button id="btnPagamento" class="btn-sisp btn btn-danger"><i class="fas fa-wallet"></i> Pagamento</button>
                        </div>
                      </fieldset>
                    </div>
                  </div>
                </div>
                <div class="row col-12" style="margin: 0px!important; padding: 0px!important;">
                  <div class="card">
                    <div class="row">
                      <div class="col-sm-6 d-flex justify-content-center align-items-center" style="height: 100%;">
                        <div id="graficoRelFacPag" style="width: 100%;"></div>
                      </div>
                      <div class="col-sm-6 d-flex justify-content-center align-items-center" style="height: 100%;">
                        <div id="graficoRelFacPag1" style="width: 100%;"></div>
                      </div>
                    </div>
                    <div class="col-lg-12 card-body" style="max-height: 450px" id="cardDados">
                      <table id="tabelaDados" class="table table-sm-sisp table-select table-hover" width="100%">
                        <thead>
                        </thead>
                        <tbody>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
                <div class="row col-12 d-none" style="margin: 0px!important; padding: 0px!important;" id="cardConsumos">
                  <div class="col-lg-12 table-responsive card-body" style="max-height: 220px">
                    <table id="tabelaConsumos" class="table table-sm table-select table-hover" width="100%">
                      <thead>
                      </thead>
                      <tbody>
                      </tbody>
                    </table>
                  </div>
                </div>
              </fieldset>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header">
            <h4 class="modal-title">Filtros</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body pb-0">
            <div>
              <!-- <div class="card-body pt-0"> -->

              <div class="form-row">
                <div class="form-group col-lg-3 col-12">
                  <legend class="textoBorda">Filtrar OF:</legend>
                  <fieldset class="form border-Field" style="margin-bottom: 0px!important; padding-left: 0px!important; margin-left: 0px!important">
                    <div class="d-flex justify-content-around mt-2 mb-1 mx-0">
                      <div class="icheck-primary">
                        <input type="radio" name="rdFiltrarOF" id="rdFiltrarOFT" value="T" checked>
                        <label class="form-check-label" for="rdFiltrarOFT">Todas</label>
                      </div>
                      <div class="icheck-primary">
                        <input type="radio" name="rdFiltrarOF" id="rdFiltrarOFS" value="S">
                        <label class="form-check-label" for="rdFiltrarOFS">Simples</label>
                      </div>
                      <div class="icheck-primary">
                        <input type="radio" name="rdFiltrarOF" id="rdFiltrarOFN" value="N">
                        <label class="form-check-label" for="rdFiltrarOFN">Normal</label>
                      </div>
                    </div>
                  </fieldset>
                </div>
                <div class="form-group col-lg-3 col-12">
                  <legend class="textoBorda">Buscar:</legend>
                  <fieldset class="form border-Field" style="margin-bottom: 0px!important; padding-left: 0px!important; margin-left: 0px!important">
                    <div class="d-flex justify-content-around mt-2 mb-1 mx-0">
                      <div class="icheck-primary">
                        <input type="radio" name="rdBuscar" id="rdBuscarT" value="T">
                        <label class="form-check-label" for="rdBuscarT">Todas</label>
                      </div>
                      <div class="icheck-primary">
                        <input type="radio" name="rdBuscar" id="rdBuscarN" value="N" checked>
                        <label class="form-check-label" for="rdBuscarN">Não pagas</label>
                      </div>
                      <div class="icheck-primary">
                        <input type="radio" name="rdBuscar" id="rdBuscarS" value="S">
                        <label class="form-check-label" for="rdBuscarS">Pagas</label>
                      </div>
                    </div>
                  </fieldset>
                </div>
                <div class="form-group col-lg-6 col-12">
                  <legend class="textoBorda">Buscar desconto/acréscimo:</legend>
                  <fieldset class="form border-Field" style="margin-bottom: 0px!important; padding-left: 0px!important; margin-left: 0px!important">
                    <div class="d-flex justify-content-around mt-2 mb-1 mx-0">
                      <div class="icheck-primary">
                        <input type="checkbox" class="form-check-input" name="cbDescAcresc" id="cbDescAcresc" checked>
                        <label class="form-check-label" for="cbDescAcresc">Buscar desc/acrésc.</label>
                      </div>
                      <div class="icheck-primary">
                        <input type="checkbox" class="form-check-input" name="cbIdentAposNumero" id="cbIdentAposNumero">
                        <label class="form-check-label" for="cbIdentAposNumero">Ident. após número</label>
                      </div>
                      <div class="icheck-primary">
                        <input type="checkbox" class="form-check-input" name="cbFiltrarOFs" id="cbFiltrarOFs" checked>
                        <label class="form-check-label" for="cbFiltrarOFs">Filtrar OFs</label>
                      </div>
                      <div class="icheck-primary">
                        <input type="checkbox" class="form-check-input" name="cbFiltrarColecoes" id="cbFiltrarColecoes" checked>
                        <label class="form-check-label" for="cbFiltrarColecoes">Filtrar coleções</label>
                      </div>
                    </div>
                  </fieldset>
                </div>
                <div class="form-group col-lg-12 col-12">
                  <legend class="textoBorda">Opções:</legend>
                  <fieldset class="form border-Field" style="margin-bottom: 0px!important; padding-left: 0px!important; margin-left: 0px!important">
                    <div class="d-flex justify-content-between mt-2 mb-1 mx-0">
                      <div class="p-0 ml-1 d-flex flex-wrap">
                        <div class="icheck-primary">
                          <input type="checkbox" class="form-check-input" name="cbBuscarPendentes" id="cbBuscarPendentes">
                          <label class="form-check-label" for="cbBuscarPendentes">Buscar pendentes</label>
                        </div>
                        <div class="icheck-primary">
                          <input type="checkbox" class="form-check-input" name="cbBuscarReprocesso" id="cbBuscarReprocesso">
                          <label class="form-check-label" for="cbBuscarReprocesso">Buscar reprocesso</label>
                        </div>
                      </div>
                      <div class="p-0 ml-1 d-flex flex-wrap">
                        <div class="icheck-primary">
                          <input type="checkbox" class="form-check-input" name="cbIndiceReprocesso" id="cbIndiceReprocesso">
                          <label class="form-check-label" for="cbIndiceReprocesso">Somente com índice reprocesso</label>
                        </div>
                        <div class="icheck-primary">
                          <input type="checkbox" class="form-check-input" name="cbDefeitosValor" id="cbDefeitosValor">
                          <label class="form-check-label" for="cbDefeitosValor">Somente defeitos com valor</label>
                        </div>
                      </div>
                      <div class="p-0 ml-1 d-flex flex-wrap">
                        <div class="icheck-primary">
                          <input type="checkbox" class="form-check-input" name="cbPaginaPorFaccao" id="cbPaginaPorFaccao">
                          <label class="form-check-label" for="cbPaginaPorFaccao">Página por facção</label>
                        </div>
                        <div class="icheck-primary">
                          <input type="checkbox" class="form-check-input" name="cbDepositoLanc" id="cbDepositoLanc">
                          <label class="form-check-label" for="cbDepositoLanc">Filtrar depósito lançamentos</label>
                        </div>
                      </div>
                      <div class="p-0 ml-1 d-flex flex-wrap">
                        <div class="icheck-primary">
                          <input type="checkbox" class="form-check-input" name="cbBuscarInspecoes" id="cbBuscarInspecoes">
                          <label class="form-check-label" for="cbBuscarInspecoes">Buscar inspeções</label>
                        </div>
                        <div class="icheck-primary">
                          <input type="checkbox" class="form-check-input" name="cbBuscarConsumos" id="cbBuscarConsumos">
                          <label class="form-check-label" for="cbBuscarConsumos">Buscar consumos baixados</label>
                        </div>
                      </div>
                      <div class="p-0 ml-1 d-flex flex-wrap">
                        <div class="icheck-primary">
                          <input type="checkbox" class="form-check-input" name="cbValidarOFPedidos" id="cbValidarOFPedidos">
                          <label class="form-check-label" for="cbValidarOFPedidos">Validar OF pedidos</label>
                        </div>
                        <div class="icheck-primary">
                          <input type="checkbox" class="form-check-input" name="cbLancDefeitos" id="cbLancDefeitos" checked>
                          <label class="form-check-label" for="cbLancDefeitos">Buscar lançamento defeitos</label>
                        </div>
                      </div>
                    </div>
                  </fieldset>
                </div>
                <div class="form-group col-lg-3 col-12">
                  <label data-error="wrong" data-success="right" for="dtRetornoDe">Retorno de/até: </label>
                  <div class="input-group">
                    <input type="date" max="2500-12-31" class="input-default focus form-control mr-3" id="dtRetornoDe" value="1200-01-01" name="dtRetornoDe" class="form-control">
                    <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtRetornoAte" value="2500-12-31" name="dtRetornoAte" class="form-control">
                  </div>
                </div>
                <div class="form-group col-lg-3 col-12">
                  <label data-error="wrong" data-success="right" for="dtEnvioDe">Envio de/até: </label>
                  <div class="input-group">
                    <input type="date" max="2500-12-31" class="input-default focus form-control mr-3" id="dtEnvioDe" value="1200-01-01" name="dtEnvioDe" class="form-control">
                    <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtEnvioAte" value="2500-12-31" name="dtEnvioAte" class="form-control">
                  </div>
                </div>
                <div class="form-group col-lg-3 col-12">
                  <label data-error="wrong" data-success="right" for="dtPagamentoDe">Pagamento de/até: </label>
                  <div class="input-group">
                    <input type="date" max="2500-12-31" class="input-default focus form-control mr-3" id="dtPagamentoDe" value="1200-01-01" name="dtPagamentoDe" class="form-control">
                    <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtPagamentoAte" value="2500-12-31" name="dtPagamentoAte" class="form-control">
                  </div>
                </div>
                <div class="form-group col-lg-3 col-12">
                  <label data-error="wrong" data-success="right" for="txtAPDe">Número AP de/até: </label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control mr-3" id="txtAPDe" name="txtAPDe" class="form-control" placeholder="Número AP">
                    <input type="text" class="input-default focus form-control" id="txtAPAte" name="txtAPAte" class="form-control" placeholder="Número AP">
                  </div>
                </div>
                <div class="form-group col-lg-3 col-12">
                  <label data-error="wrong" data-success="right" for="txtOFDe">Número OF de/até: </label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control mr-3" id="txtOFDe" name="txtOFDe" class="form-control" placeholder="Número OF">
                    <input type="text" class="input-default focus form-control" id="txtOFAte" name="txtOFAte" class="form-control" placeholder="Número OF">
                  </div>
                </div>
                <div class="form-group col-lg-6 col-12">
                  <label data-error="wrong" data-success="right" for="txtPeriodoOFDe">Período OF de/até: </label>
                  <div class="d-flex justify-content-between">
                    <div class="input-group mr-2">
                      <input type="text" class="input-default focus form-control" id="txtPeriodoOFDe" name="txtPeriodoOFDe" class="form-control" placeholder="Período">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnPeriodoOFDe" name="btnPeriodoOFDe" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaPeriodoOFDe" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtPeriodoOFAte" name="txtPeriodoOFAte" class="form-control" placeholder="Período">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnPeriodoOFAte" name="btnPeriodoOFAte" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaPeriodoOFAte" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-3 col-12">
                  <!-- <label data-error="wrong" data-success="right" for="dtFechamento">Fechamento: </label>
                  <div class="input-group">
                    <input type="date" max="2500-12-31" class="input-default focus form-control col-lg-6 col-12" id="dtFechamento" value="1200-01-01" name="dtFechamento" class="form-control">
                  </div> -->
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtProduto">Produto: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtProduto" name="txtProduto" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnProduto" name="btnProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtSetor">Setor: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtSetor" name="txtSetor" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnSetor" name="btnSetor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaSetor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtMarca">Marca: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtMarca" name="txtMarca" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnMarca" name="btnMarca" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaMarca" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtColecao">Coleção: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtColecao" name="txtColecao" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnColecao" name="btnColecao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaColecao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <div class="row p-0 m-0">
                    <label data-error="wrong" data-success="right" for="txtFaccao">Facção: </label>
                    <div class="icheck-primary">
                      <input type="checkbox" class="form-check-input" name="cbConsiderarFaccao" id="cbConsiderarFaccao" checked>
                      <label class="form-check-label" for="cbConsiderarFaccao"></label>
                    </div>
                  </div>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtFaccao" name="txtFaccao" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnFaccao" name="btnFaccao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaFaccao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtPedido">Pedido: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtPedido" name="txtPedido" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnPedido" name="btnPedido" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaPedido" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtGrupo">Grupo: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtGrupo" name="txtGrupo" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnGrupo" name="btnGrupo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaGrupo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtFicha">Ficha: </label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtFicha" class="form-control" placeholder="Ficha">
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtProgramacao">Programação: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtProgramacao" name="txtProgramacao" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnProgramacao" name="btnProgramacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaProgramacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtNota">Nota: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtNota" name="txtNota" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnNota" name="btnNota" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaNota" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtParte">Parte: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtParte" name="txtParte" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnParte" name="btnParte" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaParte" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtEtiqueta">Etiqueta: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtEtiqueta" name="txtEtiqueta" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnEtiqueta" name="btnEtiqueta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaEtiqueta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtLote">Lote: </label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtLote" class="form-control" placeholder="Lote">
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtDescAcresc" class="classDescAresc">Desconto/Acréscimo: </label>
                  <div class="input-group classDescAresc">
                    <select class="js-example-programmatic js-states form-control" id="txtDescAcresc" name="txtDescAcresc" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnDescAcresc" name="btnDescAcresc" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaDescAcresc" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtFuncionario">Funcionário: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtFuncionario" name="txtFuncionario" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnFuncionario" name="btnFuncionario" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaFuncionario" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtMovimento">Movimento: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtMovimento" name="txtMovimento" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnMovimento" name="btnMovimento" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaMovimento" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtMaquina">Máquina: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtMaquina" name="txtMaquina" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnMaquina" name="btnMaquina" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaMaquina" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtComposicao">Composição: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtComposicao" name="txtComposicao" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnComposicao" name="btnComposicao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaComposicao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtLinha">Linha: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtLinha" name="txtLinha" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnLinha" name="btnLinha" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaLinha" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <div class="row p-0 m-0">
                    <label data-error="wrong" data-success="right" for="txtOF">OF: </label>
                    <div class="icheck-primary">
                      <input type="checkbox" class="form-check-input" name="cbConsiderarOF" id="cbConsiderarOF" checked>
                      <label class="form-check-label" for="cbConsiderarOF"></label>
                    </div>
                  </div>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtOF" name="txtOF" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnOF" name="btnOF" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaOF" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtTipo">Tipo: </label>
                  <div class="input-group">
                    <!-- <select class="js-example-programmatic js-states form-control" id="txtTipo" name="txtTipo" multiple="multiple">
                    </select> -->
                    <input type="text" class="input-default focus form-control" id="txtTipo" name="txtTipo" class="form-control" placeholder="Tipo">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnTipo" name="btnTipo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaTipo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtGramatura">Gramatura: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtGramatura" name="txtGramatura" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnGramatura" name="btnGramatura" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaGramatura" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtDeposito">Depósito: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtDeposito" name="txtDeposito" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnDeposito" name="btnDeposito" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaDeposito" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtGrupoCli">Grupo Cliente: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtGrupoCli" name="txtGrupoCli" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnGrupoCli" name="btnGrupoCli" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaGrupoCli" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtCelula">Célula: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtCelula" name="txtCelula" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnCelula" name="btnCelula" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaCelula" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtEmpresa">Empresa: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtEmpresa" name="txtEmpresa" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnEmpresa" name="btnEmpresa" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaEmpresa" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-lg-4 col-12">
                  <label data-error="wrong" data-success="right" for="txtCliente">Cliente: </label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtCliente" name="txtCliente" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnCliente" name="btnCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer justify-content-start pl-0">
            <div class="row col-12">
              <div class="col-md-4 col-sm-12 col-4">
                <label for="txtOrdem">Opção de Relatório:</label>
                <div class="relative d-flex align-items-center">
                  <select id="txtOrdem" class="input-default focus custom-select">
                  </select>
                  <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                    <i class="fas fa-check"></i>
                  </button>
                </div>
              </div>
              <div class="col-6 col-lg-8 d-flex justify-content-end align-items-end pr-0">
                <div class="d-flex">
                  <button class="btn btn-primary btn-sisp mr-2" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222">
                    <span class="fas fa-trash"></span> Limpar Filtros
                  </button>
                  <button id="btnConsultar" class="btn btn-primary btn-sisp" type="button">
                    <span class="fas fa-search"></span> Consultar
                  </button>
                </div>
              </div>
            </div>
          </div>

        </div>
      </div>
    </div>

    <div id="modal-pagamento-faccao" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header">
            <h4 class="modal-title">Pagamento Terceiros</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body pb-0">
            <div class="form-row col-12">
              <div class="form-group col-lg-4 col-12">
                <label data-error="wrong" data-success="right" for="txtClassePagamento">Classe Gerencial: </label>
                <div class="input-group">
                  <input type="text" id="txtClassePagamento" class="input-default focus form-control" name="txtClassePagamento" multiple="multiple" placeholder="Classe Gerencial">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnClassePagamento" name="btnClassePagamento" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaClassePagamento" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    <button class="btn bg-danger" id="btnClickClassePagamento" type="button"><i class="m-0 p-0 fas fa-check"></i></button>
                  </div>
                </div>
              </div>
              <div class="form-group col-lg-4 col-12">
                <label data-error="wrong" data-success="right" for="txtHistoricoPagamento">Histórico: </label>
                <div class="input-group">
                  <input type="text" id="txtHistoricoPagamento" class="input-default focus form-control" name="txtHistoricoPagamento" multiple="multiple" placeholder="Histórico">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnHistoricoPagamento" name="btnHistoricoPagamento" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaHistoricoPagamento" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    <button class="btn bg-danger" id="btnClickHistoricoPagamento" type="button"><i class="m-0 p-0 fas fa-check"></i></button>
                  </div>
                </div>
              </div>
              <div class="form-group col-lg-4 col-12">
                <label data-error="wrong" data-success="right" for="txtBancoPagamento">Banco: </label>
                <div class="input-group">
                  <input type="text" id="txtBancoPagamento" class="input-default focus form-control" name="txtBancoPagamento" multiple="multiple" placeholder="Banco">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnBancoPagamento" name="btnBancoPagamento" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaBancoPagamento" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    <button class="btn bg-danger" id="btnClickBancoPagamento" type="button"><i class="m-0 p-0 fas fa-check"></i></button>
                  </div>
                </div>
              </div>
              <div class="form-group col-lg-4 col-12">
                <label data-error="wrong" data-success="right" for="txtSituacaoPagamento">Situação: </label>
                <div class="input-group">
                  <input type="text" id="txtSituacaoPagamento" class="input-default focus form-control" name="txtSituacaoPagamento" multiple="multiple" placeholder="Situação">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnSituacaoPagamento" name="btnSituacaoPagamento" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaSituacaoPagamento" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    <button class="btn bg-danger" id="btnClickSituacaoPagamento" type="button"><i class="m-0 p-0 fas fa-check"></i></button>
                  </div>
                </div>
              </div>
              <div class="form-group col-lg-2 col-12">
                <label data-error="wrong" data-success="right" for="txtVencimentoPagamento">Vencimento: </label>
                <div class="input-group">
                  <input type="date" id="txtVencimentoPagamento" class="input-default focus form-control" name="txtVencimentoPagamento" multiple="multiple" value="1200-01-01">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnClickVencimentoPagamento" type="button"><i class="m-0 p-0 fas fa-check"></i></button>
                  </div>
                </div>
              </div>
              <div class="form-group col-lg-2 col-12">
                <label for="txtValorTotal">Valor Total:</label>
                <input type="text" id="txtValorTotal" class="input-default focus form-control" name="txtValorTotal" multiple="multiple" placeholder="0,00" disabled>
              </div>
            </div>
            <div class="row col-12" style="margin: 0px!important; padding: 0px!important;">
              <div class="col-lg-12 table-responsive card-body" style="max-height: 450px">
                <table id="tabelaPagamentos" class="table table-sm table-select table-hover" width="100%">
                  <thead>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
          <div class="modal-footer border-top d-flex justify-content-between align-items-end">
            <div class="mr-auto">
              <button id="btnGerarAPs" class="btn btn-primary btn-sisp" type="button"> Gravar
              </button>
            </div>
            <div class="ml-auto">
              <button id="btnFecharPagamento" class="btn bg-gradient-danger btn-sisp" type="button"> Fechar
              </button>
            </div>
          </div>
        </div>

      </div>
    </div>

    <aside class="control-sidebar control-sidebar-dark">
    </aside>
    <?php include_once('../../modais.php'); ?>
  </main>

  <script src="plugins/jquery/jquery.min.js?versao=3.261.14.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.261.14.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.261.14.1"></script>
  <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.261.14.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.261.14.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.261.14.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.261.14.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.261.14.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.261.14.1"></script>
  <script src="dist/js/valida_cpf_cnpj.js?versao=3.261.14.1"></script>
  <script src="plugins/jquery-validation/jquery.validate.min.js?versao=3.261.14.1"></script>
  <script src="dist/js/dataTables.keyTable.js?versao=3.261.14.1"></script>
  <script src="dist/js/sisplan.js?versao=3.261.14.1"></script>
  <script src="utils/cookies.js?versao=3.261.14.1"></script>
  <script src="dist/js/driver.min.js?versao=3.261.14.1"></script>
  <script src="config.js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="plugins/jszip/jszip.min.js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="plugins/pdfmake/pdfmake.min.js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="plugins/pdfmake/vfs_fonts.js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/dataTables.buttons.min.js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/buttons.html5.min.js?versao=3.261.14.1"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.261.14.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.261.14.1"></script>
  <script src="utils/funcoes.js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="dist/js/apexcharts.js?versao=3.261.14.1"></script>
  <script src="graficos/graficos.js?versao=3.261.14.1"></script>
  <script src="plugins/high-charts/highcharts.js"></script>
  <script src="plugins/high-charts/highcharts-3d.js"></script>
  <script src="plugins/high-charts/cylinder.js"></script>
  <script src="plugins/high-charts/exporting.js"></script>
  <script src="plugins/high-charts/export-data.js"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('RELFACPAG');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/relfacpag/relfacpag.js?versao=3.261.14.1`;
      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');

      await insereJavaScriptPagina(sArquivo);

      // habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>

</body>

</html>