<?php include_once('../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Etiqueta de Composição</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.261.14.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.261.14.1">
  <!-- Google Font: Source Sans Pro -->
  <!-- <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet"> -->
  <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.261.14.1" />

  <link href='../dist/css/bootstrap.min.css?versao=3.261.14.1'>
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.261.14.1">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.261.14.1">
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.261.14.1">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.261.14.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.261.14.1" />
  <link rel="stylesheet" href="../plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.261.14.1">
  <link rel="stylesheet" href="../plugins/select2/css/select2.min.css?versao=3.261.14.1">
  <link rel="stylesheet" href="../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.261.14.1">
  <link rel="stylesheet" href="../dist/css/PesquisaVariosSelect2.css?versao=3.261.14.1">
  <!-- AutoComplete -->
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.261.14.1">

  <style>
    .input-group button,
    .input-group input {
      height: 40px;
    }

    .input-group button {
      min-width: 45px;
    }

    .btn.bg-danger {
      border: 1px solid white;
    }

    .info-box-text {
      font-size: 20px;
      font-weight: bold;
      color: grey;
    }

    #cardPrincipal {
      min-height: 400px;
      display: flex;
      justify-content: center;
    }

    .botoes {
      margin-top: 19px !important;
      margin-left: 7px;
    }

    .bordaCampos {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      padding-top: 2%;
      padding-bottom: 0%;
    }

    .bordaCampos:first-child {
      display: flex;
      flex-direction: row;
      flex-wrap: wrap;
      justify-content: flex-end;
      align-items: center;
    }

    .border-Field .textoBorda {
      font-size: 1.0em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1.0px solid var(--font-color) !important;
      padding: 0 1.0em 1.0em 1.0em !important;
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      padding-bottom: 0px !important;
    }
  </style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Etiqueta de Composição</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i>
              </button>
            </div>
          </div>

          <div class="card" id="cardPrincipal">
            <div class="row ml-2 mt-3 mr-2" id="tourbotoes">
              <div class="col-sm-12 mt-12">
                <div class="row">
                  <div class="col-lg-4 col-12">
                    <label data-error="wrong" data-success="right" for="txtNumOF">Num. OF</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtNumOF" name="txtNumOF" class="form-control" placeholder="Num. OF">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnNumOF" name="btnNumOF" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimparNumOF" name="btnLimparNumOF" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-4 col-12">
                    <label data-error="wrong" data-success="right" for="txtProduto">Produto</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtProduto" name="txtProduto" class="form-control" placeholder="Produto">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btn-Produto" name="btn-Produto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btn-limpar-Produto" name="btn-limpar-Produto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-12">
                    <label data-error="wrong" data-success="right" for="txtNumPedido">Num. Pedido</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtNumPedido" name="txtNumPedido" class="form-control" placeholder="Num. Pedido">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnNumPedido" name="btnNumPedido" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaNumPedido" name="btnLimpaNumPedido" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="icheck-primary form-check d-flex" style="align-items: end;">
                    <input type="checkbox" class="form-check-input" id="cbExportacao">
                    <label class="form-check-label pr-2" for="cbExportacao">Exportação</label>
                  </div>

                  <div class="col-lg-3 col-12 d-none" id="divCliente">
                    <label data-error="wrong" data-success="right" for="txtCliente">Cliente</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtCliente" name="txtCliente" class="form-control" placeholder="Cliente">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnCliente" name="btnCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaCliente" name="btnLimpaCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>

                  <div class="col-lg-3 col-12" hidden>
                    <label data-error="wrong" data-success="right" for="txtColunas">Colunas</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtColunas" name="txtColunas" class="form-control" disabled readonly>
                    </div>
                  </div>
                  <div class="col-lg-3 col-12" hidden>
                    <label data-error="wrong" data-success="right" for="txtColunaInicial">Coluna Inicial</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtColunaInicial" name="txtColunaInicial" class="form-control" disabled readonly>
                    </div>
                  </div>
                  <div class="d-flex float-left col-lg-12 col-12 mt-2">
                    <div class="col-12 pl-0 mt-4 pt-1">
                      <button id="btnGerar" class="btn-sisp btn btn-success"><i class="fas fa-cogs"></i> Gerar</button>
                      <button id="btnLimpar" class="ml-1 btn-sisp btn btn-danger"><i class="fas fa-trash"></i> Limpar</button>
                      <button id="btnImprimir" class="ml-1 btn-sisp btn btn-primary"><i class="fas fa-print"></i> Imprimir</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="card-body" id="">
              <div class="card">
                <div class="card-body">
                  <div id="divTabGrade">
                    <div class="row">
                      <div class="col-12">
                        <h5><b>Grade</b></h5>
                      </div>
                    </div>
                    <div class="row pt-2">
                      <div class="col-sm-12 table-responsive">
                        <table id="tabelaGrade" class="table table-responsive-sm table-select table-hover" width="100%">
                          <thead>
                          </thead>
                          <tbody>
                          </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <button id="btnConsultar" class='btn btn-primary btn-sisp d-none' type='button'><span class="fas fa-search"></span>Consultar </button>

  <div class="modal fade" id="modalBuscar" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar NF</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <nav class="col-12 px-0">
            <div class="nav nav-tabs d-flex flex-nowrap" id="nav-tab" role="tablist" style="text-decoration: none; max-width: none!important; white-space: nowrap!important; overflow-x: auto!important; overflow-y: hidden">
              <a class="nav-link abaLink active" id="tabNotaEntrada" data-toggle="tab" href="#divNotaEntrada" role="tab" aria-controls="divNotaEntrada" aria-selected="true">Nota de Entrada</a>
              <a class="nav-link abaLink" id="tabMovimentacao" data-toggle="tab" href="#divMovimentacao" role="tab" aria-controls="divMovimentacao" aria-selected="false">Movimentação</a>
            </div>
          </nav>
          <div class="tab-content col-12 px-0" id="nav-tabContent">
            <div id="divNotaEntrada" class="tab-pane fade show active" role="tabpanel" aria-labelledby="tabNotaEntrada">
              <div class="form-row pt-1">
                <div class="col-4 form-group">
                  <label for="txtNFEntrada">Nota: </label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtNFEntrada" name="txtNFEntrada" class="form-control" placeholder="Nota">
                  </div>
                </div>
                <div class="col-2 form-group">
                  <label for="txtSerieEntrada">Série: </label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtSerieEntrada" name="txtSerieEntrada" class="form-control" placeholder="Série">
                  </div>
                </div>
                <div class="col-6">
                  <div class="col-sm-12 icheck-secondary pt-4">
                    <input class="form-check-input" type="checkbox" id="cbCompEtiqueta">
                    <label class="form-check-label mb-2" for="cbCompEtiqueta">Buscar Composição Etiqueta</label>
                  </div>
                </div>
                <div class="col-12 form-group">
                  <label for="txtCodCreEntrada">Fornecedor: </label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtCodCreEntrada" name="txtCodCreEntrada" class="form-control" placeholder="Fornecedor">
                    <div class="input-group-append">
                      <button class="btn bg-danger create" id="btnCodCre" name="btnCodCre" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger create" id="btnACodCre" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div id="divMovimentacao" class="tab-pane fade" role="tabpanel" aria-labelledby="tabMovimentacao">
              <div class="form-row pt-1">
                <div class="col-3 form-group">
                  <label data-error="wrong" data-success="right" for="selectEntradaSaida">Entrada/Saída:</label>
                  <select style="width:100%;" class="form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="selectEntradaSaida" class="custom-select focus">
                    <option value="E">Entrada</option>
                    <option value="S">Saída</option>
                    </option>
                  </select>
                </div>
                <div class="col-9 form-group">
                  <label for="txtDocumento">Documento: </label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtDocumento" name="txtDocumento" class="form-control" placeholder="Documento">
                    <div class="input-group-append">
                      <button class="btn bg-danger create" id="btnDocumento" name="btnDocumento" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger create" id="btnLimpaDocumento" name="btnLimpaDocumento" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConsultarModal" class="btn btn-sisp btn-primary"> Consultar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php
  include_once('../../modais.php');
  ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
  </div>
  <!-- ./wrapper -->

  <!-- jQuery -->
  <script src="../plugins/jquery/jquery.min.js?versao=3.261.14.1"></script>
  <script src="../dist/js/jquery.maskMoney.min.js?versao=3.261.14.1"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.261.14.1"></script>
  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    if ($('[type="date"]').prop('type') != 'date') {
      $('[type="date"]').datepicker();
    }
    $.widget.bridge('uibutton', $.ui.button)
  </script>

  <!-- Bootstrap 4 -->
  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.261.14.1"></script>
  <script src="../dist/js/sisplan.js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="../utils/funcoes.js?versao=3.261.14.1"></script>
  <script src="../dist/js/adminlte.min.js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="../dist/js/loadingoverlay.min.js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.261.14.1"></script>
  <script src="../dist/js/dataTables.keyTable.js?versao=3.261.14.1"></script>
  <script src="../dist/js/requisicoes.js?versao=3.261.14.1"></script>
  <script src="../utils/cookies.js?versao=3.261.14.1"></script>
  <!-- SweetAlert2 -->
  <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.261.14.1"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.261.14.1"></script>
  <script src="../dist/js/driver.min.js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="../dist/js/sum().js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="../config.js?versao=3.261.14.1"></script>
  <script src="../plugins/select2/js/select2.full.min.js?versao=3.261.14.1"></script>
  <script>
    $(document).ready(async function() {

      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('RELETIQUETA_COMPOSICAO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/reletiqueta_composicao/reletiqueta_composicao.js?versao=3.261.14.1`;
      insereJavaScriptPagina(sArquivo);
    });
  </script>

</body>

</html>