$('#tutorial').on('click', function () {
  $(document).ready(async function () {

    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true
    });

    driver.defineSteps([{
      element: '#btnFiltros',
      popover: {
        title: 'Filtros',
        description: 'Clicando aqui, podemos aplicar os filtros para fazer uma pesquisa detalhada.',
        position: 'bottom'
      }
    },
    {
      element: '#btnImprimir',
      popover: {
        title: 'Impressão',
        description: 'Esse é o botão de impressão do relatório, fazemos a impressão após fazer a pesquisa pelo filtro.',
        position: 'bottom'
      },
    },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  let abaAtiva = 'Comissao';
  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relComissaoCom == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relComissaoCom: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  if (colunas == null || colunas.relComissaoTroca == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relComissaoTroca: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      let cols = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      if (abaAtiva == 'Comissao') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...cols, relComissaoCom: novasColunas }))
        $('#tabelaComissao').DataTable().columns().visible(true);

        $('#tabelaComissao').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...cols, relComissaoTroca: novasColunas }))
        $('#tabelaTroca').DataTable().columns().visible(true);

        $('#tabelaTroca').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      }

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  preencheOrdenacaoTela('RelComissao');

  const Troca = $("#cbTrazerTroca").is(':checked', true) ? 1 : 0;
  if (Troca != 1) {
    $("#tabTroca").addClass('d-none')
  }

  manipulaTabTroca();

  $("#divTroca").addClass('d-none');

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  //Quantidade de linhas das tabelas referente ao tamanho da tela
  const qtdeLinhasTabela = ((screen.width == 1366) && (screen.height == 768)) ? 7 : 17;

  // autocompleta
  $("#txtVendedor").autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtGuia').autocompleta(1, `JSON={ "tabela": "REPRESEN", "camposSelect": ["CODREP CHAVE", "NOME DESCRICAO"], "where": ["REPRESEN.ATIVO = 'S'", "REPRESEN.GRUPO_REP = 'U'"]}`);
  $("#txtIndicador").autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP CHAVE", "NOME DESCRICAO"], "where": null}`);
  $("#txtMoeda").pesquisa_variosServerside(1, `{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO"], "where": null}`, 'CODMOE', 'DESCRICAO');
  $('#txtTabela').autocompleta(1, `JSON={ "tabela": "REGIAO", "camposSelect": ["REGIAO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $("#txtCoordenador").autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP CHAVE", "NOME DESCRICAO"], "where": null}`);

  //pesquisa serverside
  $("#btnVendedor").pesquisa_serverside(['#txtVendedor'], ["CODREP"], ["NOME"], `{"tabela":"REPRESEN", "camposSelect":["CODREP", "NOME"]}`, 'Pesquisa Vendedor');
  $("#btnGuia").pesquisa_serverside(['#txtGuia'], ["CODREP"], ["NOME"], `{"tabela":"REPRESEN", "camposSelect":["CODREP", "NOME"], "where": ["ATIVO = 'S'", "GRUPO_REP = 'U'"]}`, 'Pesquisa Guia');
  $("#btnIndicador").pesquisa_serverside(['#txtIndicador'], ["CODREP"], ["NOME"], `{"tabela":"REPRESEN", "camposSelect":["CODREP", "NOME"]}`, 'Pesquisa Indicador');
  $("#btnMoeda").pesquisa_serversideSel('#txtMoeda', `{"tabela":"MOEDA", "camposSelect":["CODMOE", "DESCRICAO"]}`, 'Pesquisa Moeda');
  $("#btnTabela").pesquisa_serverside(['#txtTabela'], ["REGIAO"], ["DESCRICAO"], `{"tabela":"REGIAO", "camposSelect":["REGIAO", "DESCRICAO"]}`, 'Pesquisa Tabela');
  $("#btnCoordenador").pesquisa_serverside(['#txtCoordenador'], ["CODREP"], ["NOME"], `{"tabela":"REPRESEN", "camposSelect":["CODREP", "NOME"]}`, 'Pesquisa Coordenador');

  //Fazer a limpeza dos campos
  $("#btnLimpaVendedor").on("click", function () {
    $("#txtVendedor").val("");
  });

  $("#btnLimpaGuia").on("click", function () {
    $("#txtGuia").val("");
  });

  $("#btnLimpaIndicador").on("click", function () {
    $("#txtIndicador").val("");
  });

  $("#btnLimpaMoeda").on("click", function () {
    $('#txtMoeda').empty().trigger('change');
  });

  $("#btnLimpaTabela").on("click", function () {
    $("#txtTabela").val("");
  });

  $("#btnLimpaCoordenador").on("click", function () {
    $("#txtCoordenador").val("");
  });

  $('#btnLimparFiltros').on('click', async function () {
    $("#txtVendedor").val("");
    $("#txtGuia").val("");
    $("#txtIndicador").val("");
    $('#txtMoeda').empty().trigger('change');
    $("#txtTabela").val("");
    $("#txtCoordenador").val("");
    $('#radioOperTodos').prop('checked', true);
    $('#cbSeparaComissao').prop('checked', false);
    $('#cbLancamentosManuais').prop('checked', false);
    $('#cbValZerado').prop('checked', false);
    $('#cbTrazerTroca').prop('checked', false);
    $('#dtInicioDe').val('1200-01-01')
    $('#dtInicioAte').val('2500-12-31')
    $('#dtVencimentoDe').val('1200-01-01')
    $('#dtVencimentoAte').val('2500-12-31')
  });

  //Modais
  $("#btnFiltros").on("click", async function () {
    $("#modal-filtros").modal("show");
  });

  retornaHintRelatorio('btnImprimir', 'RelComissao')

  $("#btnImprimir").on("click", async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const ordem = `&TELA_ORDENACAO=RelComissao&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const url = `/sisplan/impressao/v1/imprimirrelcomissao?`;
        const Filtros = await preencheFiltros();
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelComissao');
        const arquivo = await GeraRelatorio(`${url}${Filtros}${ordem}`, "GET", 100000, false, 'RelComissao');

        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
          }
          await limparRelatorios();
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  async function preencheFiltros() {
    let radioOper = '';
    try {
      //Inputs
      const sDtInicioDe = $("#dtInicioDe").val();
      const sDtInicioAte = $("#dtInicioAte").val();
      const sDtVencimentoDe = $("#dtVencimentoDe").val();
      const sDtVencimentoAte = $("#dtVencimentoAte").val();
      const sVendedor = pegaChave("#txtVendedor");
      const sGuia = pegaChave("#txtGuia");
      const sIndicador = pegaChave("#txtIndicador");
      const sMoeda = await formataListas($('#txtMoeda').val().toString());
      const sTabela = pegaChave("#txtTabela");
      const sCoordenador = $("#txtCoordenador").val();
      //CheckBox
      const consMoeda = $("#cbConsiderarMoeda").is(':checked', true) ? 'S' : 'N';
      const sDebNegativos = $("#cbTrazerNegativos").is(':checked', true) ? 'S' : 'N';
      const sSeparaComissao = $("#cbSeparaComissao").is(':checked', true) ? 'S' : 'N';
      const sValZerado = $("#cbValZerado").is(':checked', true) ? 'S' : 'N';
      const sConsideraValorFrete = $("#cbConsideraValorFrete").is(':checked', true) ? 'S' : 'N';
      const sTrazerTroca = $("#cbTrazerTroca").is(':checked', true) ? 'S' : 'N';
      const listaEmpIds = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
        : [getCookie('emp_id')];
      //RadioButton
      if ($('#radioOperSim').is(':checked')) {
        radioOper = 1;
      }
      if ($('#radioOperNao').is(':checked')) {
        radioOper = 0;
      }
      const retorno =
        `VENDEDOR=${sVendedor}` +
        `&GUIA=${sGuia}` +
        `&INDICADOR=${sIndicador}` +
        `&MOEDA=${sMoeda}` +
        `&CONSMOEDA=${consMoeda}` +
        `&TABELA=${sTabela}` +
        `&COORDENADOR=${sCoordenador}` +
        `&DTINICIODE=${sDtInicioDe}` +
        `&DTINICIOATE=${sDtInicioAte}` +
        `&DTVENCIMENTODE=${sDtVencimentoDe}` +
        `&DTVENCIMENTOATE=${sDtVencimentoAte}` +
        `&SEPARA_COMISSAO=${sSeparaComissao}` +
        `&VALOR_ZERADO=${sValZerado}` +
        `&TRAZER_TROCA=${sTrazerTroca}` +
        `&DEBNEGATIVOS=${sDebNegativos}` +
        `&CONSIDERAVALORFRETE=${sConsideraValorFrete}` +
        `&EMP_IDS=${listaEmpIds}` +
        `&OPER_FISCAL=${radioOper}`;

      return retorno;

    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  async function limpaTabela() {
    $('#tabelaComissao').DataTable().destroy().draw(false);
    $('#tabelaComissao').html('<thead></thead><tbody></tbody>');
  }

  $('#tabComissao').on('click', function () {
    $('#divTroca').addClass('d-none');
    $('#divComissao').removeClass('d-none');
    abaAtiva = 'Comissao';
  })

  async function buscaTabelaComissao() {
    if ($('#tabelaComissao')[0].rows.length > 0) {
      await limpaTabela();
    }

    $('#divTabelaComissao').removeClass('d-none')
    if ($.fn.DataTable.isDataTable('#tabelaComissao')) {
      $('#tabelaComissao').DataTable().destroy();
      $('#tabelaComissao').empty();
    };

    try {
      let dataSetCols = [];
      const ordemOrdenacao = $('#txtOrdem').val();
      const url = `/sisplan/impressao/v1/consultarelcomissao?ordem_ordenacao=${ordemOrdenacao}&`;
      const Filtros = await preencheFiltros();
      const response = await requisicao("GET", url, Filtros, '', 30000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (jsonStr.length == 0) {
        msgAlerta("Nenhum registro encontrado!");
        $("#txtVendedor").val();
        $("#txtGuia").val();
        $("#txtIndicador").val();
        $("#txtMoeda").val();
        $("#txtTabela").val();
        $("#txtCoordenador").val();
        return;
      }

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        return;
      }

      let keys = Object.keys(jsonStr[0]);

      keys.forEach((k) => {
        dataSetCols.push({
          title: k,
          data: k,
        });
      });

      const indiceValor = [];
      const indiceDireita = [];
      const camposValor = ['VALOR', 'VAL_PAGO', 'VAL_PAGO_1', 'VAL_PAGO_2', 'VAL_PAGO_3', 'REP_VALOR'];
      const camposDireita = [
        'COM_REP',
        'COM_REP2',
        'COM_REP3',
        'COM_REP4',
        'COMISSAO',
        'COMISSAO2',
        'COMISSAO3',
        'COMISSAO4',
        'COM_REP5',
        'COMISSAO_GUIA',
        'COMISSAO_GUIA2',
        'COMISSAO_GUIA3',
        'COMISSAO_GUIA4',
        'COMISSAO_INDC',
        'COMISSAO_INDC2',
        'COMISSAO_INDC3',
        'COMISSAO_INDC4',
        'COM_REP_VEND_INDIC',
        'QTDE_VENDAS'
      ];
      for (let i = 0; i < keys.length; i++) {
        if (camposValor.includes(keys[i])) {
          indiceValor.push(i);
        } else if (camposDireita.includes(keys[i])) {
          indiceDireita.push(i);
        }
      }

      $("#tabelaComissao").DataTable({
        destroy: true,
        filter: false,
        info: false,
        order: false,
        colReorder: true,
        autoWidth: true,
        data: jsonStr,
        columns: dataSetCols,
        "columnDefs": [
          {
            render(data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              });
            },
            targets: indiceValor,
            "className": 'pr-4 text-right'
          },
          {
            targets: indiceDireita,
            "className": 'pr-4 text-right'
          }
        ],
      });

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaComissao_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaComissao_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const ordemOrdenacao = $('#txtOrdem').val();
        const url = `/sisplan/impressao/v1/consultarelcomissao?ordem_ordenacao=${ordemOrdenacao}&`;
        const filtros = await preencheFiltros();
        await exportaCSV(url, filtros, false, null, 'Relatório de Comissão de Vendas - Comissão', '#tabelaComissao');
      })

      $('#tabelaComissao').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.relComissaoCom).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } catch (error) {
      console.log(error)
    }
    finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (abaAtiva == 'Comissao') {

      $('#tabelaComissao').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });

      adicionaColunas(cols, colunasInvisiveis.relComissaoCom ?? [])
    } else {
      $('#tabelaTroca').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });

      adicionaColunas(cols, colunasInvisiveis.relComissaoTroca ?? [])
    }
  })

  $('#tabTroca').on('click', async function () {
    await buscaTabelaTroca();
    $('#divTroca').removeClass('d-none');
    $('#divComissao').addClass('d-none');
    abaAtiva = 'Troca';
  });

  async function buscaTabelaTroca() {
    $('#tabTroca').removeClass('d-none');
    $('#divTabelaTroca').removeClass('d-none');

    if ($.fn.DataTable.isDataTable('#tabelaTroca')) {
      $('#tabelaTroca').DataTable().destroy();
      $('#tabelaTroca').empty();
    };

    try {
      let dataSetCols = [];
      const ordemOrdenacao = $('#txtOrdem').val();
      const url = `/sisplan/impressao/v1/consultarelcomissaotrocas?ordem_ordenacao=${ordemOrdenacao}&`;
      const Filtros = await preencheFiltros();
      const response = await requisicao("GET", url, Filtros, '', 30000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        return;
      }

      let keys = Object.keys(jsonStr[0]);

      keys.forEach((k) => {
        dataSetCols.push({
          title: k,
          data: k,
        });
      });

      const indiceValor = [];
      const indiceDireita = [];
      const camposValor = ['VALOR', 'VAL_PAGO', 'VAL_PAGO_1', 'VAL_PAGO_2', 'VAL_PAGO_3', 'REP_VALOR'];
      const camposDireita = [
        'COM_REP',
        'COM_REP2',
        'COM_REP3',
        'COM_REP4',
        'COMISSAO',
        'COMISSAO2',
        'COMISSAO3',
        'COMISSAO4',
        'COM_REP5',
        'COMISSAO_GUIA',
        'COMISSAO_GUIA2',
        'COMISSAO_GUIA3',
        'COMISSAO_GUIA4',
        'COMISSAO_INDC',
        'COMISSAO_INDC2',
        'COMISSAO_INDC3',
        'COMISSAO_INDC4',
        'COM_REP_VEND_INDIC',
        'QTDE_VENDAS'
      ];
      for (let i = 0; i < keys.length; i++) {
        if (camposValor.includes(keys[i])) {
          indiceValor.push(i);
        } else if (camposDireita.includes(keys[i])) {
          indiceDireita.push(i);
        }
      }

      $("#tabelaTroca").DataTable({
        destroy: true,
        filter: false,
        info: false,
        order: false,
        colReorder: true,
        "pageLength": qtdeLinhasTabela,
        autoWidth: true,
        data: jsonStr,
        columns: dataSetCols,
        "columnDefs": [
          {
            "targets": indiceDireita,
            "className": 'pr-4 text-right'
          },
          {
            render(data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              });
            },
            targets: indiceValor,
            "className": 'pr-4 text-right'
          },
        ],
      });

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaTroca_length').prepend('<button class="buttonColVis" id="buttonColVis2"><i class="fas fa-cogs"></i></button>');
      $('#tabelaTroca_length').prepend('<button class="buttonExcel" id="buttonExcel2"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis2').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel2').prop('title', 'Exportar')

      $('#buttonColVis2').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel2').on('click', async function () {
        const ordemOrdenacao = $('#txtOrdem').val();
        const url = `/sisplan/impressao/v1/consultarelcomissaotrocas?ordem_ordenacao=${ordemOrdenacao}&`;
        const filtros = await preencheFiltros();
        await exportaCSV(url, filtros, false, null, 'Relatório de Comissão de Vendas - Troca', '#tabelaTroca');
      })

      $('#tabelaTroca').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.relComissaoTroca).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } catch (error) {
      console.log(error)
    }
    finally {
      $.LoadingOverlay('hide')
    }
  }

  $("#btnConsultar").on("click", async function () {
    try {
      $.LoadingOverlay("show");
      if ($("#txtOrdem option").toArray().length > 0) {
        retornaHintRelatorio('btnImprimir', $("#txtOrdem option").toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1])
      }
      try {
        await buscaTabelaComissao();

        const Troca = $("#cbTrazerTroca").is(':checked', true) ? 1 : 0;
        if (Troca == 1) {
          await buscaTabelaTroca();
        }

      } catch (error) {
        console.error(error);
      }

    } finally {
      $.LoadingOverlay("hide");
      $("#modal-filtros").modal("hide");
    }
  });

  function manipulaTabTroca() {
    if (Troca == 1) {
      $('#tabTroca').removeClass('d-none')
    } else if (Troca == 0) {
      $('#tabTroca').addClass('d-none')
    }
  }

});
