$(document).ready(async function () {

  carregaFuncoesDataTable('relatorioAniversario', '#tabelaAniversario');
  let registrosSelecionados = [];

  // let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // // aqui so valida se nao existe tem que criar para nao dar erro
  // if (colunas == null || colunas.relatorioAniversario == undefined) {
  //   localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relatorioAniversario: [] }));
  //   colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  // }

  // // confirma as colunas
  // $('#btnConfirmarColunas').on('click', async function () {
  //   try {
  //     $.LoadingOverlay('show');

  //     const novasColunas = retornaNovasColunasInvisiveis();
  //     localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relatorioAniversario: novasColunas }))

  //     $('#tabelaAniversario').DataTable().columns().visible(true);
  //     $('#tabelaAniversario').DataTable().columns().every(
  //       function () {
  //         if ((novasColunas).indexOf(this.dataSrc()) != -1) {
  //           this.visible(false);
  //         }
  //       })

  //   } finally {
  //     $.LoadingOverlay('hide');
  //     $('#modal-ColunasVisiveis').modal('hide');
  //   }
  // });

  var ultimaColunaOrdenada = {
    nome: '',
    ordenacao: 'ASC'
  };

  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir um relatório.',
          position: 'right'
        }
      },
      {
        element: '#btnRelCliente',
        popover: {
          title: 'Tabela de cliente',
          description: 'Tabela onde os dados consultados serão listados.',
          position: 'right'
        }
      },
      ]);
      driver.start();
    });
  });

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  $('#txtUF').listaFiltros();
  $('#txtCliente').listaFiltros();
  $('#txtCidade').listaFiltros();
  //Buscar automaticamente ao digitar
  $('#txtCliente').autocompleta(3, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME ||' - '|| CNPJ DESCRICAO, CNPJ"], "where": [] }`, ['#txtCNPJ'], ['CNPJ'], ['CNPJ']);
  $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": [] }`, ['#txt-cnpj'], ['CNPJ'], ['CNPJ']);
  $('#txtUF').autocompleta(1, `JSON={ "tabela":"TABUF", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtCidade').autocompleta(1, `JSON={ "tabela":"CIDADE", "camposSelect":[ "CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);

  $('#btnCliente').pesquisa_serverside(['#txtCliente', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], '{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": null}', 'Pesquisa Cliente');
  $("#btnUF").pesquisa("#txtUF", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABUF", "camposSelect":[ "CODIGO", "DESCRICAO"] }`, "Pesquisa UF", "TABUF");
  $("#btnCidade").pesquisa("#txtCidade", "CODIGO", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CIDADE", "camposSelect":[ "CODIGO", "NOME"] }`, "Pesquisa Cidade", "CIDADE");
  //limpar os campos
  $('#btnLimpaCliente').on('click', function () {
    $('#listaCliente').val('');
  });

  $('#btnLimpaUF').on('click', function () {
    $('#listaUF').val('');
  });

  $('#btnLimpaCidade').on('click', function () {
    $('#listaCidade').val('');
  });

  $('#txtMesDe').inputmask('99/99', { placeholder: 'dd/mm' });
  $('#txtMesAte').inputmask('99/99', { placeholder: 'dd/mm' });

  //limpas todos os campos
  $('#btnLimparFiltros').on('click', async function () {
    $('#dtCadastroDe').val('1200-01-01');
    $('#dtCadastroAte').val('2500-12-31');
    $('#dtNascimentoDe').val('1200-01-01');
    $('#dtNascimentoAte').val('2500-12-31');
    $('#listaCliente').val('');
    $('#txtMesDe').val('');
    $('#txtMesAte').val('');
    $('#listaUF').val('');
    $('#listaCidade').val('');
    $('#txtEmpresa').empty().trigger('change');
  });


  componenteFiltro('empresaEmp_Pat', true, true, 'Empresa');
  const parametrosVenda = await BuscaParametrosVenda();

  if (['1', '2'].includes(parametrosVenda[51])) {
    $('.divSelecionarEmpresas').removeClass('d-none');
  } else {
    $('.divEmpCadastro').removeClass('d-none');
  }

  async function retornaFiltros() {
    const cbEmpresa = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : getCookie('emp_id');
    const sCadastroDe = $('#dtCadastroDe').val() != '1200-01-01' ? $('#dtCadastroDe').val() : '';
    const sCadastroAte = $('#dtCadastroAte').val() != '2500-12-31' ? $('#dtCadastroAte').val() : '';
    const sNascimentoDe = $('#dtNascimentoDe').val() != '1200-01-01' ? $('#dtNascimentoDe').val() : '';
    const sNascimentoAte = $('#dtNascimentoAte').val() != '2500-12-31' ? $('#dtNascimentoAte').val() : '';
    const sMesDe = pegaValor('#txtMesDe') != '' ? pegaValor('#txtMesDe') : '';
    const sMesAte = pegaValor('#txtMesAte') != '' ? pegaValor('#txtMesAte') : '';
    const sCliente = await formataListas(registrosSelecionados.length > 0 ? registrosSelecionados.toString() : $('#listaCliente').val());
    const sUFs = await formataListas($('#listaUF').val());
    const sOrdenacao = $('#txtOrdenacao').val();
    const sCidade = await formataListas($('#listaCidade').val());
    const somenteComVendas = $('#cbSomenteComVendas').prop('checked') ? '1' : '';
    const empresasCad = await formataListas($('#txtEmpresa').val().toString().replaceAll('_', ''));


    const retorno =
      `CADASTRO_DE=${sCadastroDe}` +
      `&CADASTRO_ATE=${sCadastroAte}` +
      `&NASCIMENTO_DE=${sNascimentoDe}` +
      `&NASCIMENTO_ATE=${sNascimentoAte}` +
      `&CLIENTE=${sCliente}` +
      `&UFS=${sUFs}` +
      `&MES=${pegaValor('#txtMes')}` +
      `&EMPRESAS_FILTRO=${cbEmpresa}` +
      `&EMPRESAS_CADASTRO=${empresasCad}` +
      `&MESDE=${sMesDe}` +
      `&MESATE=${sMesAte}` +
      `&ORDENACAO=${sOrdenacao}` +
      `&CIDADE=${sCidade}` +
      `&SOMENTE_COM_VENDAS=${somenteComVendas}`;

    return retorno;
  }

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  retornaHintRelatorio('btnImprimir', 'RelAniversario');

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/imprimirrelaniversario?`;
        const filtros = await retornaFiltros();
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelAniversario');
        const arquivo = await GeraRelatorio(`${url}${filtros}&`, 'GET', 100000, false, 'RelAniversario');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function buscaDados(colunaOrdenacao = '') {
    if ($('#tabelaAniversario')[0].rows.length > 0) {
      await limpaTabela();
    }

    ultimaColunaOrdenada.nome = colunaOrdenacao.replaceAll(' ASC', '').replaceAll(' DESC', '');
    ultimaColunaOrdenada.ordenacao = colunaOrdenacao.indexOf(' ASC') > -1 ? 'ASC' : 'DESC';

    const where = await montaWhere();
    const campos = await montaCamposSelect();
    const ligacao = await montaLigacoes();
    const ordemOrdenacao = await montaOrderBy($('#txtOrdenacao').val());

    const orderBy = colunaOrdenacao == '' ? await montaOrderBy(ordemOrdenacao) : colunaOrdenacao;

    let dataSetCols = [];

    try {
      try {
        $.LoadingOverlay("show");

        dataSetCols.push({
          'title': 'SEL',
          'data': 'SEL'
        })

        for (let i = 0; i < campos.colunas.length; i++) {
          dataSetCols.push({
            'title': campos.colunas[i],
            'data': campos.colunas[i]
          });
        }

        dataSetCols[0].render = function (data, type, row) {
          return `<div class="icheck-primary d-inline">
              <input type="checkbox" id="check${row.CODCLI}" class="campoSel" nome="${row.NOME}">
              <label for="check${row.CODCLI}"></label>
            </div>`
        }

        const colsData = dataSetCols.map(e => e.data);

        const pesquisa = await retornaPesquisa();

        $('#tabelaAniversario').DataTable({
          paging: true,
          lengthChange: true,
          filter: false,
          info: true,
          order: false,
          autoWidth: true,
          destroy: true,
          serverSide: true,
          processing: true,
          ajax: {
            url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
            type: "POST",
            headers: {
              'Authorization': BASIC_AUTH
            },
            data: {
              EMPRESA: getCookie('empresa'),
              JSON: JSON.stringify(pesquisa),
              CLIENTE: 'n'
            },
            dataSrc: function (data) {
              const cols = colsData;
              const array = data.data;
              return array.map(row => {
                return row.reduce((obj, value, index) => {
                  obj[cols[index]] = value;
                  return obj;
                }, {});
              });
            }
          },
          colReorder: true,
          columns: dataSetCols,
        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaAniversario_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaAniversario_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');
        $("#tabelaAniversario_length").css("margin-bottom", "10px");
        $("#tabelaAniversario_length").parent().append(`<div class="col-sm-12 icheck-primary d-inline" style="margin-left: 4px;">` +
          `<input class="form-check-input" type="checkbox" id="checkSelecionarTodos">` +
          `<label class="form-check-label" for="checkSelecionarTodos">Selecionar Todos</label>` +
          `</div>`);

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = '/Sisplan/Funcoes/v1/pesquisa?';
          const pesquisa = await retornaPesquisa();
          await exportaCSV(url, `JSON=${JSON.stringify(pesquisa)}`, true, null, 'Relatório de Aniversariantes', '#tabelaAniversario', '', 999, true);
        })


        $('#tabelaAniversario').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.relatorioAniversario).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

        $('#tabelaAniversario th').on('click', async function () {
          const nomeColuna = $(this).html();
          const novaOrdenacao = ultimaColunaOrdenada.ordenacao == 'ASC' ? 'DESC' : 'ASC';
          const ordenacao = ultimaColunaOrdenada.nome == nomeColuna ? novaOrdenacao : 'ASC';
          await buscaDados(nomeColuna + ' ' + ordenacao);
        });

        $("#tabelaAniversario").off("change", ".campoSel");
        $("#tabelaAniversario").on("change", ".campoSel", function () {
          const codigo = $(this)[0].id.substring(5);
          if (!$(this).prop("checked")) {
            registrosSelecionados = registrosSelecionados.filter(cod => (cod != codigo));
            $($(this).closest("tr").removeClass("selected"));
          } else {
            registrosSelecionados.push(codigo);
            $($(this).closest("tr")).addClass("selected");
          }
        })

        $("#tabelaAniversario").on("draw.dt", function () {
          const codigos = $("#tabelaAniversario").DataTable().rows().data().toArray().map(dados => dados.CODCLI);

          if (registrosSelecionados.length > 0) {
            registrosSelecionados.forEach(registro => {
              codigos.forEach((codigo, i) => {
                if (registro == codigo) {
                  $($(".campoSel")[i]).prop("checked", true);
                  $($(".campoSel")[i]).closest("tr").addClass("selected");
                }
              })
            })
          }

        })

        $('#checkSelecionarTodos').on('change', async function () {

          async function callBack() {
            $.LoadingOverlay("show");
            try {
              $("#tabelaAniversario").DataTable().page.len(200).draw(false);
              $($(".page-link")[1]).trigger("click");
              await sleep(700);
              const totalPaginas = $("#tabelaAniversario").DataTable().page.info().pages;

              for (let i = 1; i <= totalPaginas; i++) {
                $('input[class=campoSel]:checked').trigger('click');
                if ($("#checkSelecionarTodos").prop("checked")) {
                  $(".campoSel").trigger("click");
                }
                $("#tabelaAniversario_next").trigger("click");
                await sleep(700);
                if (totalPaginas == i) {
                  $($(".page-link")[1]).trigger("click");
                  $("#tabelaAniversario").DataTable().page.len(10).draw(false);
                }

              }
            } finally {
              $.LoadingOverlay("hide");
            }
          }

          msgAlerta(`Tem certeza que deseja ${!$("#checkSelecionarTodos").prop("checked") ? "desmarcar" : "selecionar"} todos os registros? \nEssa ação percorrerá todas as páginas da tabela e resultará na seleção completa dos registros.`,
            callBack,
            () => { $("#checkSelecionarTodos").prop("checked", !$("#checkSelecionarTodos").prop("checked")); },
            undefined,
            () => { $("#checkSelecionarTodos").prop("checked", !$("#checkSelecionarTodos").prop("checked")); },
            true);

        });

      } catch (error) {
        console.error(error);
        msgErro('Não foi possível buscar os dados.');
      }
    } finally {
      $.LoadingOverlay("hide");
      $('#modal-filtros').modal('hide');
    }
  };

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaAniversario').DataTable().columns().every(function () {
      if ($(this.header()).text() != "SEL") {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      }
    });

    adicionaColunas(cols, colunasInvisiveis.relatorioAniversario ?? []);
  });

  async function montaWhere() {
    const empresasCad = await formataListas($('#txtEmpresa').val().toString().replaceAll('_', ''));
    let where = '';
    where += $('#dtNascimentoDe').val() != '1200-01-01' && $('#dtNascimentoDe').val() != '' ? ` AND ENTIDADE.DT_NASC >= '${$('#dtNascimentoDe').val()}'` : '';
    where += $('#dtNascimentoAte').val() != '2500-12-31' && $('#dtNascimentoAte').val() != '' ? ` AND ENTIDADE.DT_NASC <= '${$('#dtNascimentoAte').val()}'` : '';
    where += $('#dtCadastroDe').val() != '' ? $('#dtCadastroDe').val() != '1200-01-01' ? ` AND ENTIDADE.DATA_CAD >= '${$('#dtCadastroDe').val()}'` : '' : '';
    where += $('#dtCadastroAte').val() != '' ? $('#dtCadastroAte').val() != '2500-12-31' ? ` AND ENTIDADE.DATA_CAD <= '${$('#dtCadastroAte').val()}'` : '' : '';
    where += $('#listaCliente').val() != '' || registrosSelecionados.length > 0 ? ` AND ENTIDADE.CODCLI in (${await formataListas(registrosSelecionados.length > 0 ? registrosSelecionados.toString() : $('#listaCliente').val())})` : '';
    where += $('#listaUF').val() != '' ? ` AND TABUF.CODIGO in (${await formataListas($('#listaUF').val())})` : '';
    where += pegaValor('#txtMesDe') != '' ? ` AND UDF_DAY(ENTIDADE.DT_NASC) >= ${$('#txtMesDe').val().split('/')[0]} AND UDF_MONTH(ENTIDADE.DT_NASC) >= ${$('#txtMesDe').val().split('/')[1]}` : '';
    where += pegaValor('#txtMesAte') != '' ? ` AND UDF_DAY(ENTIDADE.DT_NASC) <= ${$('#txtMesAte').val().split('/')[0]} AND UDF_MONTH(ENTIDADE.DT_NASC) <= ${$('#txtMesAte').val().split('/')[1]}` : '';
    where += $('#listaCidade').val() != '' ? ` AND CIDADE.CODIGO IN (${await formataListas($('#listaCidade').val())})` : '';
    if (empresasCad != '') {
      where += ` AND ENTIDADE.EMP_CAD IN (${empresasCad}) `;
    } else {
      const empresa = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
        : [getCookie('emp_id')];
      if (empresa != '') {
        let listaEmp = '';
        empresa.map(e => {
          if (listaEmp == '') {
            listaEmp += `${e}`;
          } else {
            listaEmp += `, ${e}`;
          }
        });

        where += ` AND EMP_VALOR.EMP_ID IN (${listaEmp})`;
      }
    }
    return where;
  }

  async function montaLigacoes() {
    let ligacao = ''
    if ($('.empresa_selecionada:checked').toArray().length > 0) {
      ligacao = `{"tabela": "CADCEP", "condicao": "CADCEP.CEP = ENTIDADE.CEP", "alias": "CADCEP"},` +
        `{"tabela": "CIDADE", "condicao": "CADCEP.CODMUN = CIDADE.CODIGO", "alias": "CIDADE"},` +
        `{"tabela": "TABUF", "condicao": "TABUF.CODIGO = CIDADE.COD_UF", "alias": "TABUF"}`;
      // `{"tabela": "EMP_VALOR", "condicao": "EMP_VALOR.VALOR = ENTIDADE.CODCLI", "alias": "EMP_VALOR"}`;
    } else {
      ligacao = `{"tabela": "CADCEP", "condicao": "CADCEP.CEP = ENTIDADE.CEP", "alias": "CADCEP"},` +
        `{"tabela": "CIDADE", "condicao": "CADCEP.CODMUN = CIDADE.CODIGO", "alias": "CIDADE"},` +
        `{"tabela": "TABUF", "condicao": "TABUF.CODIGO = CIDADE.COD_UF", "alias": "TABUF"}`;
    }

    return ligacao;
  }

  async function montaInnerJoin() {
    let innerJoin = [];
    const empresasCad = await formataListas($('#txtEmpresa').val().toString().replaceAll('_', ''));

    if ($('#cbSomenteComVendas').prop('checked')) {
      innerJoin.push(`{"tabela": "VENDA", "condicao": "VENDA.CODCLI = ENTIDADE.CODCLI AND VENDA.CANCELADA = 0 AND VENDA.DEVOLUCAO = 0", "alias": "VENDA"}`);
    }

    if (empresasCad == '') {
      innerJoin.push(`{"tabela": "EMP_VALOR", "condicao": "EMP_VALOR.VALOR = ENTIDADE.CODCLI", "alias": "EMP_VALOR"}`);
    }

    return innerJoin.toString();
  }

  async function montaCamposSelect() {
    let camposSelect = [];
    let colunas = [];

    camposSelect = `["'' AS SEL", "ENTIDADE.CODCLI", "ENTIDADE.NOME","ENTIDADE.DT_NASC","ENTIDADE.DATA_CAD",  "ENTIDADE.DDD_FONE", "ENTIDADE.TELEFONE"]`;

    colunas = ["CODCLI", "NOME", "DT_NASC", "DATA_CAD", "DDD_FONE", "TELEFONE"];

    return objeto = {
      camposSelect: camposSelect,
      colunas: colunas
    };
  }

  async function montaGroupBy() {
    return ["ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.DT_NASC", "ENTIDADE.DATA_CAD", "ENTIDADE.DDD_FONE", "ENTIDADE.TELEFONE"];
  }

  async function montaOrderBy(ordenacao) {
    let order = '';
    switch (ordenacao) {
      case '0':
        order = 'ENTIDADE.CODCLI';
        break;
      case '1':
        order = 'ENTIDADE.NOME';
        break;
      case '2':
        order = 'UDF_DAY(ENTIDADE.DT_NASC)';
        break;
      case '3':
        order = 'ENTIDADE.DATA_CAD';
        break;
      default:
        break;
    }

    return order;
  }

  $('#btnConsultar').on('click', async function () {
    registrosSelecionados = [];
    await buscaDados();
  });

  async function limpaTabela() {
    if ($.fn.DataTable.isDataTable('#tabelaAniversario') && $('#tabelaAniversario').DataTable().data().length > 0) {
      $('#tabelaAniversario').DataTable().destroy().draw(false);
      $('#tabelaAniversario').html('<thead></thead><tbody></tbody>');
    }
  }

  async function retornaPesquisa() {
    const colunaOrdenacao = 1;
    const where = await montaWhere();
    const campos = await montaCamposSelect();
    const ligacao = await montaLigacoes();
    const innerJoin = await montaInnerJoin();
    const groupBy = await montaGroupBy();
    const ordemOrdenacao = await montaOrderBy($('#txtOrdenacao').val());
    const orderBy = colunaOrdenacao == '' ? ordemOrdenacao : colunaOrdenacao;
    const pesquisa = {
      tabela: "ENTIDADE",
      camposSelect: JSON.parse(campos.camposSelect),
      leftJoin: JSON.parse(`[${ligacao}]`),
      innerjoin: JSON.parse(`[${innerJoin}]`),
      where: [`1=1 ${where}`],
      groupby: groupBy,
      orderBy: orderBy != '' ? [orderBy] : ""
    };
    return pesquisa;
  }

  $("#btnWpp").on("click", async function () {

    if (registrosSelecionados.length <= 0) {
      throw msgAlerta("Nenhum registro selecionado.");
    }

    $.LoadingOverlay("show");
    const objMsgWpp = [];
    try {

      for (let i = 0; i < registrosSelecionados.length; i++) {
        const celular = await getWhatsapp(registrosSelecionados[i]);
        const parametrosMensagem = [`CODCLI: ${registrosSelecionados[i]}`, `EMP_ID: ${getCookie("emp_id")}`];

        objMsgWpp.push({
          CELULAR: celular,
          NOME: $(`#check${registrosSelecionados[i]}`).attr("nome"),
          PARAMETROSMENSAGEM: parametrosMensagem.toString(),
          MENSAGEMPERSONALIZADA: ""
        });

      }

      const listaNaoEnviados = await enviarMsgPersonalizadaWpp('RELANIVERSARIO',
        objMsgWpp,
        undefined,
        async () => {
          const codigos = listaNaoEnviados.map(naoEnviados => naoEnviados.split("-")[0].split(":")[1].replaceAll(" ", ""));
          $("#btnLimparFiltros").trigger("click");
          $("#listaCliente").val(codigos.toString());
          registrosSelecionados = codigos;
          await buscaDados();
          await sleep(500);
          $("#btnWpp").trigger("click");
        },
        'RelAniversario');

    } finally {
      $.LoadingOverlay("hide");
    }
  })

  $('#btnCupomDesc').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      if (registrosSelecionados.length <= 0) {
        await msgAlerta('Nenhum registro selecionado, deseja abrir o cadastro de cupom de desconto?', async () => {
          parent.document.querySelector('#menu_cupomdesconto .nav-link').click();
        })
      } else {
        const documentoPrincipal = window.parent.document
        const tabCupomDesconto = documentoPrincipal.querySelector('.content-wrapper.iframe-mode').querySelector('.tab-content').querySelector('#panel--sisplan_web-cadcupomdesconto')

        if ((tabCupomDesconto == null) ||
          (tabCupomDesconto.querySelector('iframe').contentDocument.querySelector('#billGates') == null)) {
          localStorage.setItem('clientescupom', JSON.stringify(registrosSelecionados))
          parent.document.querySelector('#menu_cupomdesconto .nav-link').click();
        } else {
          await msgAlerta('Já existe um cupom de desconto em inclusão/alteração, finalize o cadastro antes de continuar.')
        }
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

});