$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    })
    driver.defineSteps([
      {
        element: "#formPrincipal",
        popover: {
          title: "Campos",
          description:
            "Aqui se encontram os campos essenciais para consultar e gravar as informações.",
          position: "bottom",
        },
      },
      {
        element: '#btnVoltar',
        popover: {
          title: 'Voltar',
          description: 'Aqui se encontra o botão para voltar à consulta.',
          position: 'bottom'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Gravar',
          description: 'Aqui se encontra o botão para gravar as informações.',
          position: 'bottom'
        }
      }
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  const url = window.location.href
  const parametroUrl = url.split('/')[url.split('/').length - 1]

  if (!parametroUrl) {
    msgErro(
      'Ocorreu um erro ao carregar o registro.',
      () => window.location.href = `${BASE_URI}/perfil_compras`,
      () => window.location.href = `${BASE_URI}/perfil_compras`,
    )
  }

  const chaveUrl = parametroUrl.split('CHAVE=')[1]

  if (!chaveUrl) {
    msgErro(
      'Ocorreu um erro ao carregar o registro.',
      () => window.location.href = `${BASE_URI}/perfil_compras`,
      () => window.location.href = `${BASE_URI}/perfil_compras`,
    )
  }

  const { id, duplicar } = JSON.parse(decodeURIComponent(chaveUrl))

  if (id && id !== 'create') {
    carregarCadastro({ id })
  }

  componenteFiltro('usuario3', false, false, 'Usuario')
  componenteFiltro('centroCusto', true, true)
  componenteFiltro('tipo', true, true, 'Tipo')
  componenteFiltro('grupoMA', true, true, 'GrupoMaterial', ["TIPO = 'M'"])
  componenteFiltro('grupoPA', true, true, 'GrupoProduto')
  componenteFiltro('grupoMA', true, true, 'GrupoServico', ["TIPO = 'S'"])
  componenteFiltro('subGrupo', true, true, 'SubgrupoMaterial')

  async function buscarDados({ id }) {
    const response = await requisicao('GET', `/sisplan/perfil_compras/v1/retornardadoscadastro?`, `&ID=${id}`, '', 3600000)
    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  }

  function carregarCadastro({ id }) {
    buscarDados({ id }).then((dados) => {
      preencherDadosCapa({ capa: dados })
    })
  }

  function preencherDadosCapa({ capa }) {
    if (!capa) return
    if (duplicar) {
      $('#txtId').val('')
      $('#txtUsuario').val('')
    } else {
      $('#txtId').val(capa.id)
      insereValor('#txtUsuario', capa.idUsuario, capa.nomeUsuario)
    }
    $('#selectEtapa').val(capa.etapa)
    if (capa.centrosCusto) capa.centrosCusto.forEach((item) => adicionaValorPadraoVarios('centroCusto', item?.codigo, item?.descricao))
    if (capa.tipos) capa.tipos.forEach((item) => adicionaValorPadraoVarios('tipo', item?.codigo, item?.descricao))
    if (capa.gruposMaterial) capa.gruposMaterial.forEach((item) => adicionaValorPadraoVarios('grupoMaterial', item?.codigo, item?.descricao))
    if (capa.gruposProduto) capa.gruposProduto.forEach((item) => adicionaValorPadraoVarios('grupoProduto', item?.codigo, item?.descricao))
    if (capa.gruposServico) capa.gruposServico.forEach((item) => adicionaValorPadraoVarios('grupoServico', item?.codigo, item?.descricao))
    if (capa.subgruposMaterial) capa.subgruposMaterial.forEach((item) => adicionaValorPadraoVarios('subgrupoMaterial', item?.codigo, item?.descricao))
  }

  $('#formPrincipal').validate({
    rules: {
      usuario: {
        required: true,
      }
    },
    messages: {
      usuario: {
        required: 'Usuário é obrigatório.'
      }
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback')
      element.closest('.form-group').append(error)
    },
    highlight(element) {
      $(element).addClass('is-invalid')
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid')
    },
    submitHandler: async (_form, event) => {
      event.preventDefault()
      gravar()
    }
  })

  const retornarDadosGravar = async () => {
    const idGravar = $('#txtId').val()
    const idUsuario = pegaChave('#txtUsuario')
    const nomeUsuario = pegaDescricao('#txtUsuario')
    const etapa = $('#selectEtapa').val()
    const centrosCusto = tratarMaximoCaracteresArrayString(4000, await formataListas($('#txtCentroCusto').val().toString()))
    const tipos = tratarMaximoCaracteresArrayString(4000, await formataListas($('#txtTipo').val().toString()))
    const gruposMaterial = tratarMaximoCaracteresArrayString(4000, await formataListas($('#txtGrupoMaterial').val().toString()))
    const gruposProduto = tratarMaximoCaracteresArrayString(4000, await formataListas($('#txtGrupoProduto').val().toString()))
    const gruposServico = tratarMaximoCaracteresArrayString(4000, await formataListas($('#txtGrupoServico').val().toString()))
    const subgruposMaterial = tratarMaximoCaracteresArrayString(4000, await formataListas($('#txtSubgrupoMaterial').val().toString()))

    return {
      id: idGravar,
      idUsuario,
      nomeUsuario,
      etapa,
      centrosCusto,
      tipos,
      gruposMaterial,
      gruposProduto,
      gruposServico,
      subgruposMaterial,
    }
  }

  const gravar = async () => {
    $.LoadingOverlay('show')
    const dados = await retornarDadosGravar()
    enviarDadosGravar({ dados })
      .then(() => {
        toastr.success("Dados gravados com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/perfil_compras`
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      })
      .catch((error) => {
        console.error(error)
        msgErro('Ocorreu um erro ao gravar os dados.')
      })
      .finally(() => $.LoadingOverlay('hide'))
  }

  const enviarDadosGravar = async ({ dados }) => {
    const response = await requisicao('POST', `/sisplan/perfil_compras/v1/gravar?`, '', JSON.stringify(dados), 3600000)
    const json = await response.json()

    if (json) {
      const { mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }
    }
  }

  $('#txtUsuario').on('focusout', () => {
    const usuarioInformado = pegaChave('#txtUsuario')
    const etapa = $('#selectEtapa').val()
    validarUsuarioExistente({ usuario: usuarioInformado, etapa })
  })

  $('#selectEtapa').on('change', () => {
    const usuarioInformado = pegaChave('#txtUsuario')
    const etapa = $('#selectEtapa').val()
    validarUsuarioExistente({ usuario: usuarioInformado, etapa })
  })

  const validarUsuarioExistente = async ({ usuario, etapa }) => {
    try {
      if (!usuario || !etapa) return
      const where = [`ID_ACE_USU = ${usuario}`, `ETAPA = '${etapa}'`]
      if (id !== 'create') {
        where.push(`ID <> ${id}`)
      }
      const pesquisa = {
        tabela: 'PERFIL_COMPRAS',
        camposSelect: ['ID_ACE_USU'],
        where,
      }

      const [response] = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa))
      if (response?.ID_ACE_USU) {
        $('#txtUsuario').val('')
        msgErro(
          'Usuário já cadastrado para essa etapa, impossível continuar.',
          () => $('#txtUsuario').focus(),
          () => $('#txtUsuario').focus(),
        )
      }
    } catch (error) {
      console.error(error)
      msgErro('Ocorreu um erro ao validar o usuário.')
    }
  }

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/perfil_compras`
  })
})