$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnIncluir',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma ordem de compra.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir as ordens de compras filtradas.',
          position: 'right'
        }
      },
      {
        element: '#tabelaOrdemCompra',
        popover: {
          title: 'Tabela Ordem Compra',
          description: 'Aqui estão os dados das ordens de compra cadastradas.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

componenteFiltro('solicitacao', true, true)
componenteFiltro('itemCompra', true, true)
componenteFiltro('cor', true, true)

async function validaAlteraOrdemCompra(sNumero) {
  const dadosSelect = {
    tabela: 'CO_ITEN',
    camposSelect: ['CO_ITEN.NUMERO'],
    leftJoin: [{ tabela: 'COMPRA', condicao: 'COMPRA.NUMERO   = CO_ITEN.NUMERO' }],
    where: [`CO_ITEN.NUMERO = '${sNumero}' AND CO_ITEN.SITUACAO <> 'B'`]
  };
  const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
  if (!retornoSelect) {
    return;
  }
  if (retornoSelect.length > 0) {
    return true;
  }
  return false;
};

$(document).ready(async function () {
  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  if (colunas == null || colunas.acessoOrdemCompra == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, acessoOrdemCompra: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  await preencheOrdenacaoTela('RelOrdemCompraA');

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();

      $('#tabelaOrdemCompra').DataTable().columns().visible(true);
      $('#tabelaOrdemCompra').DataTable().columns(novasColunas).visible(false);

      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, acessoOrdemCompra: novasColunas }))
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  const permissaoUsuarioLogado = await permissaoAcessos("ORDEM_COMPRA");

  addFuncoesBotoes();
  await consultaOrdemCompra();

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await consultaOrdemCompra();
  });

  $('#txtOrdemCompraConsulta').on('blur', function () {
    let OrdemCompra = $('#txtOrdemCompraConsulta').val();
    if (OrdemCompra.includes("[")) {
      OrdemCompra = pegaChave($('#txtOrdemCompraConsulta'));
    } else {
      OrdemCompra = $('#txtOrdemCompraConsulta').val();
    }
    OrdemCompra = OrdemCompra.replace('\w', '');
    const listaOrdemCompra = $('#txtListaOrdemCompra').val();
    if (OrdemCompra == '') {
      return;
    }
    $('#txtListaOrdemCompra').val((listaOrdemCompra == '') ? `'${OrdemCompra}'` : `${listaOrdemCompra},'${OrdemCompra}'`);
    $('#txtOrdemCompraConsulta').val('');
    $('#txtOrdemCompraConsulta').focus();
  });

  $('#txtOrdemCompraConsulta').on('keydown', async function (event) {
    if (event.key == 'Enter') {
      $('#txtOrdemCompraConsulta').trigger('blur');
      $('#txtOrdemCompraConsulta').focus();
    }
  });

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "ordem_compra/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#tabelaOrdemCompra').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaOrdemCompra').DataTable().row($(this).parents('tr')).data();
      if (await validaAlteraOrdemCompra(data[0])) {
        window.location.href = `ordem_compra/${btoa(data[0])}`;
      } else {
        msgAlertaSemConfirmacao("Todos os itens já foram baixados. Não é mais permitido Alterar!");
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaOrdemCompra').on('click', '#btn-imprimirItem', async function () {
    try {
      const data = $('#tabelaOrdemCompra').DataTable().row($(this).parents('tr')).data();
      const numero = data[0]

      const pesquisa = {
        tabela: 'CO_ITEN',
        camposSelect: ['NUMERO'],
        where: [`NUMERO = '${numero}'`, `STATUS_COMPRA = 'L'`],
        limit: 1,
      }

      const [resultadoSelect] = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
      if (!resultadoSelect) {
        await imprimirItem({ numero })
        return
      }

      msgAlerta(
        'Deseja enviar a ordem de compra para o fornecedor?',
        () => null,
        () => imprimirItem({ numero }),
        () => {
          enviarOrdemCompra({ numero })
        },
        () => null,
        true,
      )
      return
    } catch (error) {
      console.error(error)
      msgErro('Ocorreu um erro ao validar os dados.')
    }
  });

  const imprimirItem = async ({ numero }) => {
    $.LoadingOverlay('show');
    try {
      const url = `/sisplan/impressao/v1/acesso_ordem_compra?`;
      const filtros = await retornaFiltros(`'${numero}'`);
      const ordem = `&INDIVIDUAL=S`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelOrdemCompra');
      let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelOrdemCompra');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
      msgErro('Ocorreu um erro ao realizar a impressão.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  const enviarOrdemCompra = async ({ numero }) => {
    try {
      requisicao(
        'PATCH',
        '/sisplan/ordem_compra/v1/enviarordemcompra?',
        ``,
        numero,
        30000
      ).then((response) => {
        if (!response || response.status !== 204) {
          toastr.error("Ocorreu um erro ao enviar a ordem de compra!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 1000,
            fadeOut: 1000,
            onHidden() {
              imprimirItem({ numero })
            },
          }).css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          })
          return
        }

        toastr.success("Ordem de compra enviada com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onHidden() {
            imprimirItem({ numero })
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      })
    } catch (error) {
      console.error(`Ocorreu um erro ao enviar ordem de compra para o fornecedor\n${error}.`);
    }
  }

  retornaHintRelatorio('btnImprimir', 'RelOrdemCompraA')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/acesso_ordem_compra?`;
        const ordenacao = $('#txtOrdem').val()

        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelOrdemCompraA&ORDEM_ORDENACAO=${$('#txtOrdem').val()}&INDIVIDUAL=N`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelOrdemCompraA');
        let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelOrdemCompraA');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#tabelaOrdemCompra').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaOrdemCompra').DataTable().row($(this)).data();
      if (await validaAlteraOrdemCompra(data[0])) {
        window.location.href = `ordem_compra/${btoa(data[0])}`;
      } else {
        msgAlertaSemConfirmacao("Todos os itens já foram baixados. Não é mais permitido Alterar!");
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaOrdemCompra').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      const data = $("#tabelaOrdemCompra").DataTable().row($(this).parents("tr")).data();
      const pesquisa = {
        tabela: 'CO_ITEN',
        camposSelect: ['STATUS_COMPRA'],
        where: [`NUMERO = '${data[0]}'`, "STATUS_COMPRA <> 'D'", 'STATUS_COMPRA IS NOT NULL'],
      }
      const result = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa))

      if (!result) {
        return
      }

      const existeAlgumItemJaEfetivado = result.length > 0

      if (existeAlgumItemJaEfetivado) {
        msgErro('Impossível excluir, existem itens já efetivados nessa solicitação.')
        return
      }
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  $("#tabelaOrdemCompra").on('click', "#btnAnexos", async function () {
    const data = $('#tabelaOrdemCompra').DataTable().row($(this).parents('tr')).data();

    await abreModalAnexos(data[0], data[1], 'ORDEM_COMPRA');
  })

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" id="btn-imprimirItem" title="Este botão chama o Layout RelOrdemCompra.fr3">Imprimir</button>  ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '    <button class="dropdown-item" type="button" title="Anexos" id="btnAnexos">Gestão Documentos</button>     ' +
      '</div>';

    retornaHintRelatorio('btn-imprimirItem', 'RelOrdemCompra')
    return retorno;
  };

  async function retornaFiltros(sNumero = '') {
    const numero = $('#txtListaOrdemCompra').val();
    const codFor = pegaChave('#txtFornecedor');
    const usuario = pegaValor('#txtUsuario');
    const emissaoDe = $("#txtDataEmiDe").val();
    const emissaoAte = $("#txtDataEmiAte").val();
    const solicitacoes = await formataListas($('#txtSolicitacao').val().toString())
    const itens = await formataListas($('#txtItemCompra').val().toString())
    const cores = await formataListas($('#txtCor').val().toString())
    const tipoItem = $('#txtTipoItem').val()
    const emailEnviado = $('#txtEmail').val()
    const analise = $('#txtFiltro').val()
    const situacao = $('#txtSituacao').val()
    const somenteEmAtraso = $('#txtSomenteEmAtraso').val()

    const status = pegaChave('#txtStatus');
    const empresa = pegaChave('#txtEmpresa').replace('_', '');

    const filtros = `NUMERO=${sNumero == '' ? numero : sNumero}` +
      `&CODFOR=${codFor}` +
      `&USUARIOCADASTRO=${usuario}` +
      `&EMISSAODE=${emissaoDe}` +
      `&EMISSAOATE=${emissaoAte}` +
      `&EMP=${empresa}` +
      `&STATUS=${status}` +
      `&SOLICITACOES=${solicitacoes}` +
      `&ITENS=${itens}` +
      `&TIPO_ITEM=${tipoItem}` +
      `&EMAIL=${emailEnviado}` +
      `&ANALISE=${analise}` +
      `&SITUACAO=${situacao}` +
      `&CORES=${cores}` +
      `&SOMENTE_EM_ATRASO=${somenteEmAtraso}`

    return filtros;
  };

  async function retornarFiltroItem() {
    const itens = await formataListas($('#txtItemCompra').val().toString())

    if (!itens) {
      return ''
    }

    return ` AND EXISTS (SELECT 1 FROM [CO_ITEN] ITEN WHERE ITEN.NUMERO = COMPRA.NUMERO AND ITEN.CODIGO IN (${itens}))`
  }

  function retornarFiltroTipoItem() {
    const tipoItem = $('#txtTipoItem').val()
    if (!tipoItem) {
      return ''
    }

    return ` AND EXISTS (SELECT 1 FROM [CO_ITEN] ITEN WHERE ITEN.NUMERO = COMPRA.NUMERO AND ITEN.TP_ITEM = '${tipoItem}')`
  }

  async function retornarFiltroCor() {
    const cores = await formataListas($('#txtCor').val().toString())

    if (!cores) {
      return ''
    }

    return ` AND EXISTS (SELECT 1 FROM [CO_ITEN] ITEN WHERE ITEN.NUMERO = COMPRA.NUMERO AND ITEN.COR IN (${cores}))`
  }

  async function consultaOrdemCompra() {
    try {
      $.LoadingOverlay("show");
      let where = '';
      where += pegaChave('#txtEmpresa') != '' ? ` AND COMPRA.EMPRESA = '${pegaChave('#txtEmpresa').replace('_', '')}'` : '';
      where += pegaChave('#txtListaOrdemCompra') != '' ? ` AND COMPRA.NUMERO IN (${$('#txtListaOrdemCompra').val()})` : '';
      where += pegaChave('#txtFornecedor') != '' ? ` AND COMPRA.CODFOR = '${pegaChave('#txtFornecedor')}'` : '';
      where += pegaDescricao('#txtUsuario') != '' ? ` AND COMPRA.USUARIO = '${pegaDescricao('#txtUsuario')}'` : '';
      where += pegaChave('#txtStatus') != '' ? ` AND COMPRA.STATUS = '${pegaChave('#txtStatus')}'` : '';
      const filtroSolicitacao = await formataListas($('#txtSolicitacao').val().toString())
      const filtroEmail = $('#txtEmail').val()
      const filtroAnalise = $('#txtFiltro').val()
      const filtroSituacao = $('#txtSituacao').val()
      const filtroItem = await retornarFiltroItem()
      const filtroTipoItem = retornarFiltroTipoItem()
      const filtroCor = await retornarFiltroCor()
      if ($('#txtSomenteEmAtraso').val() === 'S') {
        const dataAtual = formataData(new Date())
        where += ` AND COMPRA.DT_ENTREGA < '${dataAtual}'`
      }

      if ($("#txtDataEmiDe").val() != "01-01-1200" || $$("#txtDataEmiAte").val() != "01-12-2500") {
        where += ` and COMPRA.DT_EMISSAO >= '${$("#txtDataEmiDe").val()}' and COMPRA.DT_EMISSAO <= '${$("#txtDataEmiAte").val()}'`;
      }

      if (filtroSolicitacao) {
        where += ` AND (COMPRA.SOLICITACAO IN (${filtroSolicitacao}) OR EXISTS (SELECT 1 FROM [CO_SOL_IT_AGRUP] CO_SOL_IT_AGRUP WHERE COMPRA.NUMERO = CO_SOL_IT_AGRUP.NUMERO AND CO_SOL_IT_AGRUP.ID_SOL_ITEN IN (SELECT ID FROM [SOL_ITEN] WHERE NUMERO IN (${filtroSolicitacao}))))`
      }

      if (filtroEmail) {
        where += filtroEmail === 'S' ? ` AND COMPRA.ENVIO = 'S'` : ` AND (COMPRA.ENVIO = 'N' OR COMPRA.ENVIO IS NULL OR COMPRA.ENVIO = '')`
      }

      if (filtroAnalise) {
        where += filtroAnalise === 'A' ? ` AND CO_ITEN.SITUACAO = 'A'` : ` AND (CO_ITEN.QTDE_B >= CO_ITEN.QTDE OR CO_ITEN.SITUACAO = 'B')`
      }

      if (filtroSituacao) {
        where += ` AND COMPRA.LIBERADO = '${filtroSituacao}'`
      }

      where += filtroItem
      where += filtroTipoItem
      where += filtroCor

      const tipoBanco = await retornaDatabase()
      let campoNotaFiscal = ''

      switch (tipoBanco.toString().toUpperCase()) {
        case 'FIREBIRD':
          campoNotaFiscal = "(SELECT LIST(DISTINCT NF_ENTRA_ITEN.NUMERO, ', ') FROM [NF_ENTRA_ITEN] NF_ENTRA_ITEN WHERE NF_ENTRA_ITEN.DOCTO = COMPRA.NUMERO)"
          break
        case 'ORACLE':
          campoNotaFiscal = "(SELECT LISTAGG(DISTINCT NF_ENTRA_ITEN.NUMERO, ', ') FROM [NF_ENTRA_ITEN] NF_ENTRA_ITEN WHERE NF_ENTRA_ITEN.DOCTO = COMPRA.NUMERO)"
          break
        case 'SQLSERVER':
          campoNotaFiscal = "(SELECT STRING_AGG(t.NUMERO, ', ') FROM (SELECT DISTINCT NF_ENTRA_ITEN.NUMERO FROM [NF_ENTRA_ITEN] NF_ENTRA_ITEN WHERE NF_ENTRA_ITEN.DOCTO = COMPRA.NUMERO) t)"
          break
        case 'POSTGRES':
          campoNotaFiscal = "(SELECT STRING_AGG(DISTINCT NF_ENTRA_ITEN.NUMERO, ', ') FROM [NF_ENTRA_ITEN] NF_ENTRA_ITEN WHERE NF_ENTRA_ITEN.DOCTO = COMPRA.NUMERO)"
          break
        default:
          break
      }

      const pesquisaParam = {
        tabela: "COMPRA",
        camposSelect: [
          'COMPRA.NUMERO',
          'FORNECED.CODCLI',
          'FORNECED.NOME',
          'COMPRA.CONDICAO',
          'SUM((CO_ITEN.QTDE [MAIS] CO_ITEN.QTDE_B [MAIS] CO_ITEN.QTDE_CANC) * CO_ITEN.PRECO) VALOR_TOTAL',
          'COMPRA.STATUS',
          'SITPROD.DESCRICAO AS DESC_STATUS',
          'FORNECED.ENDERECO',
          'FORNECED.BAIRRO',
          'FORNECED.NUMERO AS NUM_END',
          'FORNECED.COMPLEMENTO AS COMPL_END',
          'COMPRA.COLECAO',
          'COLECAO.DESCRICAO DESC_COLECAO',
          'FORNECED.CNPJ',
          'CI.COD_UF AS ESTADO',
          'FORNECED.CEP',
          'CADCEP.CODMUN',
          'CI.NOME CIDADE',
          'FORNECED.DDD_FONE',
          'FORNECED.TELEFONE',
          'FORNECED.INSCRICAO',
          'COMPRA.DT_EMISSAO',
          'COMPRA.DT_ENTREGA',
          'COMPRA.SOLICITACAO',
          'COMPRA.ENVIO',
          'PESSOAL.NOME AS NOME_SOLICITANTE',
          'COMPRA.LIBERADO',
          'COMPRA.MOTIVO',
          'MENSAGEM.DESCRICAO',
          'OBRA.CODIGO AS OBRA',
          'OBRA.DESCRICAO AS DESC_OBRA',
          'ENTIDADE.NOME NOME_COMPRADOR',
          'COMPRA.NUM_CONTATO',
          'COMPRA.DEPOSITO',
          'DEPOSITO.DESCRICAO DESC_DEPOSITO',
          'COMPRA.CODTRAN CODTRAN',
          'TABTRAN.NOME TRANSPORTADORA',
          'COMPRA.USUARIO',
          'HISTCP.HISTORICO',
          'COMPRA.DT_ENTREGA_ORIG',
          'COMPRA.EMPRESA',
          'COMPRA.DT_DEPOSITO',
          'COMPRA.PRAZO',
          'COMPRA.FRETE',
          `CASE WHEN COMPRA.FRETE = '0' THEN '(CIF) Contrata  o do Frete por conta do Remetente' WHEN COMPRA.FRETE = '1' THEN '(FOB) Contrata  o do Frete por conta do Destinat rio' WHEN COMPRA.FRETE = '2' THEN 'Contrata  o do Frete por conta de Terceiros' WHEN COMPRA.FRETE = '3' THEN 'Transporte Pr prio por conta do Remetente' WHEN COMPRA.FRETE = '4' THEN 'Transporte Pr prio por conta do Destinat rio' WHEN COMPRA.FRETE = '9' THEN 'Sem Ocorr ncia de Transporte' END DESC_FRETE`,
          'COMPRA.REFERENCIA',
          'COMPRA.COMPRADOR',
          'COMPRA.PRAZO_MED',
          'COMPRA.ID_CENTROCUSTO',
          'CENTROCUSTO.CODIGO COD_CENTROCUSTO',
          'CENTROCUSTO.DESCRICAO DESC_CENTROCUSTO',
          campoNotaFiscal,
        ],
        leftJoin: [
          { tabela: 'CO_ITEN', condicao: 'COMPRA.NUMERO = CO_ITEN.NUMERO' },
          { tabela: 'ENTIDADE', condicao: 'COMPRA.CODFOR = FORNECED.CODCLI', alias: 'FORNECED' },
          { tabela: 'CADCEP', condicao: 'FORNECED.CEP = CADCEP.CEP' },
          { tabela: 'OBRA', condicao: 'OBRA.CODIGO = COMPRA.OBRA' },
          { tabela: 'SOL_COMPRA', condicao: 'COMPRA.SOLICITACAO = SOL_COMPRA.NUMERO' },
          { tabela: 'PESSOAL', condicao: 'SOL_COMPRA.SOLICITANTE = PESSOAL.CODIGO' },
          { tabela: 'MENSAGEM', condicao: 'COMPRA.MOTIVO = MENSAGEM.CODMEN' },
          { tabela: 'CI', condicao: 'CI.CODIGO = CADCEP.CODMUN' },
          { tabela: 'DEPOSITO', condicao: 'DEPOSITO.CODIGO = COMPRA.DEPOSITO' },
          { tabela: 'SITPROD', condicao: 'SITPROD.CODIGO = COMPRA.STATUS' },
          { tabela: 'TABTRAN', condicao: 'COMPRA.CODTRAN = TABTRAN.CODIGO' },
          { tabela: 'COLECAO', condicao: 'COLECAO.CODIGO = COMPRA.COLECAO' },
          { tabela: 'HISTCP', condicao: 'HISTCP.HISTORICO = COMPRA.HISTORICO' },
          { tabela: 'ENTIDADE', condicao: 'COMPRA.COMPRADOR = ENTIDADE.CODCLI' },
          { tabela: 'CENTROCUSTO', condicao: 'CENTROCUSTO.ID = COMPRA.ID_CENTROCUSTO' }
        ],
        groupBy: [
          'COMPRA.NUMERO',
          'FORNECED.CODCLI',
          'FORNECED.NOME',
          'COMPRA.CONDICAO',
          'COMPRA.STATUS',
          'SITPROD.DESCRICAO',
          'FORNECED.ENDERECO',
          'FORNECED.BAIRRO',
          'FORNECED.NUMERO',
          'FORNECED.COMPLEMENTO',
          'FORNECED.CNPJ',
          'CI.COD_UF',
          'FORNECED.CEP',
          'CADCEP.CODMUN',
          'CI.NOME',
          'FORNECED.DDD_FONE',
          'FORNECED.TELEFONE',
          'FORNECED.INSCRICAO',
          'COMPRA.DT_EMISSAO',
          'COMPRA.DT_ENTREGA',
          'COMPRA.SOLICITACAO',
          'COMPRA.ENVIO',
          'PESSOAL.NOME',
          'COMPRA.LIBERADO',
          'COMPRA.MOTIVO',
          'MENSAGEM.DESCRICAO',
          'COLECAO.DESCRICAO',
          'COMPRA.COLECAO',
          'OBRA.CODIGO',
          'OBRA.DESCRICAO',
          'COMPRA.DESCONTO',
          'COMPRA.CODFOR',
          'COMPRA.PRAZO',
          'COMPRA.VAL_FRETE',
          'COMPRA.VALDESCONTO',
          'COMPRA.DEPOSITO',
          'DEPOSITO.DESCRICAO',
          'COMPRA.CODTRAN',
          'TABTRAN.NOME',
          'COMPRA.USUARIO',
          'COMPRA.DT_ENTREGA_ORIG',
          'COMPRA.EMPRESA',
          'COMPRA.DT_DEPOSITO',
          'HISTCP.HISTORICO',
          'COMPRA.FRETE',
          'COMPRA.REFERENCIA',
          'COMPRA.COMPRADOR',
          'ENTIDADE.NOME',
          'COMPRA.NUM_CONTATO',
          'COMPRA.PRAZO_MED',
          'COMPRA.ID_CENTROCUSTO',
          'CENTROCUSTO.CODIGO',
          'CENTROCUSTO.DESCRICAO',
        ],
        where: [`1=1 ${where}`],
        orderBy: ['COMPRA.NUMERO']
      };

      $("#tabelaOrdemCompra").DataTable({
        destroy: true,
        lengthChange: true,
        serverSide: true,
        processing: true,
        filter: false,
        colReorder: true,
        scrollX: true,
        scrollY: '350px',
        ajax: {
          url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
          type: "POST",
          headers: { Authorization: BASIC_AUTH },
          data: {
            EMPRESA: getCookie("empresa"),
            JSON: JSON.stringify(pesquisaParam),
            CLIENTE: "S",
          },
        },
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
          {
            targets: [4],
            render: function (data) {
              return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
            },
            className: 'text-right',
          }
        ],
        rowCallback: function (row, data) {
          const [dia, mes, ano] = data[22]?.split("/")
          if (!dia || !mes || !ano) {
            return
          }
          const dataEntrega = new Date(ano, mes - 1, dia)
          const dataAtual = new Date()
          if (dataEntrega < dataAtual) {
            $(row).attr("style", "color: red !important;")
          }
        }
      });

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaOrdemCompra_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaOrdemCompra_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');
      $('#tabelaOrdemCompra_length').append(`
                        <div class="d-flex align-items-center ml-3">
                          <div class="quadrado" style="background: red;">
                          </div>
                          <span style="font-size: 1.1rem"> Entrega menor que hoje </span>
                        </div>`)

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const url = `/Sisplan/Funcoes/v1/pesquisa?`;
        await exportaCSV(url, `JSON=${encodeURIComponent(JSON.stringify(pesquisaParam))}`, true, null, 'Acesso ordem de compra', '#tabelaOrdemCompra');
      })

      $('#tabelaOrdemCompra').DataTable().columns(colunasInvisiveis.acessoOrdemCompra).visible(false);

      await criaGraficosCabecalho();
      $($('#tabelaOrdemCompra tr')[1]).addClass('selected')
      await retornaInformacoesOrdemCompra($('#tabelaOrdemCompra').DataTable().row($($('#tabelaOrdemCompra tr')[1])).data());
      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  };

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaOrdemCompra').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    const colunasVisiveis = cols.slice(1)
    adicionaColunas(colunasVisiveis, colunasInvisiveis.acessoOrdemCompra ?? [''])
  })

  async function carregaDadosOrdemCompraBaixadas() {
    $.LoadingOverlay('show');
    try {
      let where = '';
      where += pegaChave('#txtEmpresa') != '' ? ` AND COMPRA.EMPRESA = '${pegaChave('#txtEmpresa').replace('_', '')}'` : '';
      where += pegaChave('#txtListaOrdemCompra') != '' ? ` AND COMPRA.NUMERO IN (${$('#txtListaOrdemCompra').val()})` : '';
      where += pegaChave('#txtFornecedor') != '' ? ` AND COMPRA.CODFOR = '${pegaChave('#txtFornecedor')}'` : '';
      where += pegaValor('#txtUsuario') != '' ? ` AND COMPRA.USUARIO = '${pegaValor('#txtUsuario')}'` : '';
      where += pegaChave('#txtStatus') != '' ? ` AND COMPRA.STATUS = '${pegaChave('#txtStatus')}'` : '';

      if ($("#txtDataEmiDe").val() != "01-01-1200" || $$("#txtDataEmiAte").val() != "01-12-2500") {
        where += ` and COMPRA.DT_EMISSAO >= '${$("#txtDataEmiDe").val()}' and COMPRA.DT_EMISSAO <= '${$("#txtDataEmiAte").val()}'`;
      }

      const pesquisaParam = {
        tabela: "COMPRA",
        camposSelect: [
          'COMPRA.NUMERO',
          'COMPRA.CODFOR',
          'ENTIDADE.NOME',
          'SUM(CAST(CO_ITEN.QTDE_B AS NUMERIC(10,2)) * CAST(CO_ITEN.PRECO AS NUMERIC(10,2))) VALOR_BAIXADO'
        ],
        leftJoin: [
          { tabela: 'CO_ITEN', condicao: 'CO_ITEN.NUMERO = COMPRA.NUMERO' },
          { tabela: 'ENTIDADE', condicao: 'COMPRA.CODFOR = ENTIDADE.CODCLI' },
        ],
        where: [`1=1 ${where} AND CO_ITEN.QTDE_B > 0`],
        groupBy: [
          "COMPRA.NUMERO",
          "COMPRA.CODFOR",
          "ENTIDADE.NOME",
        ]
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      if (jsonStr.length == 0) {
        return [];
      }

      return jsonStr;
    } finally {
      $.LoadingOverlay('hide');
    }
  };


  async function carregaDadosOrdemCompraPendentes() {
    $.LoadingOverlay('show');
    try {
      let where = '';
      where += pegaChave('#txtEmpresa') != '' ? ` AND COMPRA.EMPRESA = '${pegaChave('#txtEmpresa').replace('_', '')}'` : '';
      where += pegaChave('#txtListaOrdemCompra') != '' ? ` AND COMPRA.NUMERO IN (${$('#txtListaOrdemCompra').val()})` : '';
      where += pegaChave('#txtFornecedor') != '' ? ` AND COMPRA.CODFOR = '${pegaChave('#txtFornecedor')}'` : '';
      where += pegaValor('#txtUsuario') != '' ? ` AND COMPRA.USUARIO = '${pegaValor('#txtUsuario')}'` : '';
      where += pegaChave('#txtStatus') != '' ? ` AND COMPRA.STATUS = '${pegaChave('#txtStatus')}'` : '';

      if ($("#txtDataEmiDe").val() != "01-01-1200" || $$("#txtDataEmiAte").val() != "01-12-2500") {
        where += ` and COMPRA.DT_EMISSAO >= '${$("#txtDataEmiDe").val()}' and COMPRA.DT_EMISSAO <= '${$("#txtDataEmiAte").val()}'`;
      }

      const pesquisaParam = {
        tabela: "COMPRA",
        camposSelect: [
          'COMPRA.NUMERO',
          'COMPRA.CODFOR',
          'ENTIDADE.NOME',
          'SUM(CAST(CO_ITEN.QTDE AS NUMERIC(10,2)) * CO_ITEN.PRECO) VALOR_PENDENTE'
        ],
        leftJoin: [
          { tabela: 'CO_ITEN', condicao: 'CO_ITEN.NUMERO = COMPRA.NUMERO' },
          { tabela: 'ENTIDADE', condicao: 'COMPRA.CODFOR = ENTIDADE.CODCLI' },
        ],
        where: [`1=1 ${where} AND CO_ITEN.QTDE > 0`],
        groupBy: [
          "COMPRA.NUMERO",
          "COMPRA.CODFOR",
          "ENTIDADE.NOME",
        ]
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      if (jsonStr.length == 0) {
        return [];
      }

      return jsonStr;
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function criaGraficosCabecalho() {
    const dadosPendentes = await carregaDadosOrdemCompraPendentes();
    const dadosBaixadas = await carregaDadosOrdemCompraBaixadas();

    Graficos.criarGrafico({
      container: 'graficosOrdemCompra',
      tipo: 'pie',
      dados: dadosPendentes,
      nomeSerie: 'Valor Pendente',
      colunasAgrupamento: ['NOME'],
      colunasValor: ['VALOR_PENDENTE'],
      title: 'Ordens de Compras Pendentes'
    })

    Graficos.criarGrafico({
      container: 'graficosOrdemCompra1',
      tipo: 'pie',
      dados: dadosBaixadas,
      nomeSerie: 'Valor Faturado',
      colunasAgrupamento: ['NOME'],
      colunasValor: ['VALOR_FATURADO'],
      title: 'Ordens de Compras Baixadas'
    })
  }

  async function retornaDadosItens(sNumero) {
    const tipoBanco = await retornaDatabase()

    const camposSelect = [
      'CO_ITEN.CODIGO',
      `CASE WHEN CO_ITEN.TP_ITEM = 'P' THEN PRODUTO.DESCRICAO ELSE CASE WHEN CO_ITEN.TP_ITEM = 'M' THEN MATERIAL.DESCRICAO ELSE SERVICO.DESCRICAO END END AS DESCRICAO`,
      'CO_ITEN.COR',
      'CADCOR.DESCRICAO DESC_COR',
      'CO_ITEN.TAM',
    ]

    switch (tipoBanco.toString().toUpperCase()) {
      case 'FIREBIRD':
        camposSelect.push('(UDF_NVL(CO_ITEN.QTDE) [SOMA] UDF_NVL(CO_ITEN.QTDE_B) [SOMA] UDF_NVL(CO_ITEN.QTDE_CANC)) QTDE')
        break
      case 'ORACLE':
        camposSelect.push('(NVL(CO_ITEN.QTDE, 0) [SOMA] NVL(CO_ITEN.QTDE_B, 0) [SOMA] NVL(CO_ITEN.QTDE_CANC, 0)) QTDE')
        break
      case 'SQLSERVER':
        camposSelect.push('(CAST(ISNULL(CO_ITEN.QTDE, 0) AS FLOAT) [SOMA] CAST(ISNULL(CO_ITEN.QTDE_B, 0) AS FLOAT) [SOMA] CAST(ISNULL(CO_ITEN.QTDE_CANC, 0) AS FLOAT) ) QTDE')
        break
      case 'POSTGRES':
        camposSelect.push('(COALESCE(CO_ITEN.QTDE, 0) [SOMA] COALESCE(CO_ITEN.QTDE_B, 0) [SOMA] COALESCE(CO_ITEN.QTDE_CANC, 0)) QTDE')
        break
      default:
        break
    }

    [
      'CO_ITEN.QTDE_CANC',
      'CO_ITEN.QTDE_B',
      'CO_ITEN.PRECO',
      'CO_ITEN.PRECO_ORIG',
      'CO_ITEN.TP_ITEM',
      'CO_ITEN.LOTE',
      'CO_ITEN.DEPOSITO',
      'CO_ITEN.OBS',
    ].forEach((it) => camposSelect.push(it))

    const dadosSelect = {
      tabela: 'CO_ITEN',
      camposSelect,
      leftJoin: [
        { tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = CO_ITEN.CODIGO' },
        { tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = CO_ITEN.CODIGO' },
        { tabela: 'SERVICO', condicao: 'SERVICO.CODIGO = CO_ITEN.CODIGO' },
        { tabela: 'CADCOR', condicao: 'CADCOR.COR = CO_ITEN.COR' }
      ],
      where: [`CO_ITEN.NUMERO = '${sNumero}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados dos itens.');
      return;
    }
    return retornoSelect;
  };


  async function retornaObservacaoCompraCotacao(numero) {
    const dadosSelect = {
      tabela: 'COMPRA',
      camposSelect: [
        'OBS',
        'OBS_COTACAO',
      ],
      leftJoin: [

      ],
      where: [`COMPRA.NUMERO = '${numero}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados dos itens.');
      return;
    }
    return retornoSelect;
  }

  async function retornaInformacoesOrdemCompra(compra) {
    try {
      $.LoadingOverlay('show');
      const numero = compra[0];
      const itens = await retornaDadosItens(numero);
      const obs = await retornaObservacaoCompraCotacao(numero);
      const dataSetCols = []

      if (itens.length == 0) {
        if ($.fn.DataTable.isDataTable('#tabelaOrdemCompraVisualizacao')) {
          $('#tabelaOrdemCompraVisualizacao').DataTable().destroy();
          $('#tabelaOrdemCompraVisualizacao').empty();
        };
        return;
      }


      var keys = Object.keys(itens[0]);
      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      }

      criaDataTablePadrao('#tabelaOrdemCompraVisualizacao', true, false, false, false, true, true, false, itens, dataSetCols, [], [], [], [], {}, '', '', 'buttonExcel2');

      $('#txtObsCompra').val(obs[0].OBS)
      $('#txtObsCotacao').val(obs[0].OBS_COTACAO)
      $('#buttonExcel2').on('click', async function () {
        await exportaCSV('', '', true, null, 'Itens da Ordem de Compra', undefined, '', 999, false, false, itens);
      })

    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#tabelaOrdemCompra').on('click', 'tr', async function () {
    const data = $('#tabelaOrdemCompra').DataTable().row($(this)).data();

    if ($(this).hasClass('selected')) {
      $(this).removeClass('selected');
    } else {
      $('#tabelaOrdemCompra').DataTable().$('tr.selected').removeClass('selected');
      $('#tabelaOrdemCompra').DataTable().$('tr.selected').attr("style", "color: var(--font-color) !important;")
      $(this).addClass('selected');
      if (data[22]) {
        $(this).attr("style", "color: red !important;")
      }
    }

    await retornaInformacoesOrdemCompra(data)
  });


  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        const response = await requisicao('DELETE', '/sisplan/ordem_compra/v1/ordem_compra?', `NUMERO=${encodeURIComponent(data[0])}`, 15000);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          const jsonStr = await response.json();
          msgAlerta(jsonStr.mensagem);
          return;
        }

        criaMensagemSucesso('Exclusão efetuada com sucesso!', () => { window.location.reload() });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  function addFuncoesBotoes() {
    const dtMes = retornarDataPrimeiroDiaMesAtual()
    $("#txtDataEmiDe").val(dtMes);
    $('#btn-limpa-OrdemCompra').on('click', function () {
      $('#txtListaOrdemCompra').val('');
    });

    $("#btn-OrdemCompraConsulta").pesquisa_serverside(["#txtOrdemCompraConsulta"], ["NUMERO"], ["CODFOR"], `{"tabela":"COMPRA", "camposSelect":[ "NUMERO", "CODFOR" ]}`, "Pesquisa Ordem Compra");

    $("#txtFornecedor").autocompleta(2, `JSON={ "tabela":"ENTIDADE", "camposSelect":["ENTIDADE.CODCLI CHAVE, ENTIDADE.NOME DESCRICAO"], "where": ["TIPO_ENTIDADE LIKE '[PERCENTUAL]F[PERCENTUAL]'"]}`);
    $("#btn-Fornecedor").pesquisa_serverside(["#txtFornecedor"], ["CODCLI"], ["NOME"], `{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ], "where": ["TIPO_ENTIDADE LIKE '[PERCENTUAL]F[PERCENTUAL]'"]}`, "Pesquisa Fornecedor");
    $('#btn-limpa-Fornecedor').on('click', function () { $('#txtFornecedor').val(''); });

    $("#txtUsuario").autocompleta(2, `JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"]}`);
    $("#btnUsuario").pesquisa_serverside(["#txtUsuario"], ["CODIGO"], ["NOME"], `{"tabela":"ACESSO_USUARIOS", "camposSelect":[ "CODIGO", "NOME" ]}`, "Pesquisa Usuario", "ACESSO_USUARIOS");
    $('#btnLimpaUsuario').on('click', function () { $('#txtUsuario').val('') })

    $("#txtStatus").autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"]}`);
    $("#btn-Status").pesquisa_serverside(["#txtStatus"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Status");
    $('#btn-limpa-Status').on('click', function () { $('#txtStatus').val(''); });

    $("#txtEmpresa").autocompleta(1, `JSON={ "tabela":"EMPRESA", "camposSelect":["EMP_PAT CHAVE, EMP_NOME DESCRICAO"]}`);
    $("#btn-Empresa").pesquisa_serverside(["#txtEmpresa"], ["EMP_PAT"], ["EMP_NOME"], `{"tabela":"EMPRESA", "camposSelect":[ "EMP_PAT", "EMP_NOME" ]}`, "Pesquisa Empresa");
    $('#btn-limpa-Empresa').on('click', function () { $('#txtEmpresa').val(''); });

    $('#btnFiltros').on('click', function () {
      $('#modal-filtros').modal('show');
    });

    $('#btnLimparFiltros').on('click', async function () {
      $('#txtOrdemCompraConsulta').val('');
      $('#txtListaOrdemCompra').val('');
      $('#txtFornecedor').val('');
      $("#txtDataEmiDe").val("1200-01-01");
      $("#txtDataEmiAte").val("2500-12-01");
      $("#txtUsuario").val('');
      $('#txtStatus').val('');
      $('#txtEmpresa').val('');
      $('#txtSolicitacao').empty().trigger('change')
      $('#txtItemCompra').empty().trigger('change')
      $('#txtCor').empty().trigger('change')
      $('#txtTipoItem').val('')
      $('#txtEmail').val('')
      $('#txtFiltro').val('')
      $('#txtSituacao').val('')
    });
  };

});