$(document).ready(async function () {
  const acessoMetas = new AcessoMetas();
  componenteFiltro('metas', true);
  const permissaoUsuarioLogado = await permissaoAcessos("METAS");


  $('#btnFiltros').on('click', function () {

    $('#modal-filtros').modal('show');
  });

  $('#btnLimparFiltros').on('click', function () {
    acessoMetas.limparFiltros();
  });

  $('#btnConsultar').on('click', async function () {
    await acessoMetas.buscar();
    setTimeout(() => {
      $('#tabelaMetas').DataTable().columns.adjust().draw(false);
      $('#tabelaValoresMetas').DataTable().columns.adjust().draw(false);
      $('#tabelaItensValoresMetas').DataTable().columns.adjust().draw(false);
    }, 1000);
  });

  $("#btnIncluir").on("click", function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "metas/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#btnConsultar').trigger('click');

  $('#tutorial').on('click', function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
    });
    driver.defineSteps([{
      element: '#gravarCampos',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para gravar a capa da Meta!.',
        position: 'rigth'
      }
    },
    {
      element: '#txtNomeMeta',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'bottom'
      }
    },
    {
      element: '#txtSelectTipos',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'bottom'
      }
    },
    {
      element: '#txtDtInicial',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtDtFinal',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#btnGravarMeta',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar a meta!',
        position: 'left'
      }
    },
    {
      element: '#tabelaTour',
      popover: {
        title: 'Tabela de Metas',
        description: 'Aqui estarão todas as metas cadastradas!',
        position: 'top'
      }
    }
    ]);
    driver.start();
  });

}); 