<?php include_once('../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Caixa</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.261.14.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.261.14.1">
  <!-- Google Font: Source Sans Pro -->
  <!-- <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet"> -->
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.261.14.1" />

  <link href='../dist/css/bootstrap.min.css?versao=3.261.14.1'>
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.261.14.1">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.261.14.1">
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.261.14.1">
  <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.261.14.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.261.14.1" />
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.261.14.1">
  <!-- AutoComplete -->
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.261.14.1">
  <link rel="stylesheet" href="dist/css/cards-financeiro.css">


  <style>
    .content-wrapper {
      margin-left: 0px !important;
    }

    .main-header,
    .main-sidebar {
      display: none;
    }

    .troco_off {
      border: none !important;
    }

    .ui-autocomplete-loading {
      background: white url("./dist/img/ui-anim_basic_16x16.gif") center center no-repeat;
    }


    .input-group button,
    .input-group input {
      height: 40px;
    }

    .input-group button {
      min-width: 45px;
    }

    .btn.bg-danger {
      border: 1px solid white;
    }

    th {
      white-space: nowrap;
    }

    #tabelaVendasGrid thead,
    #tabelaVendasGrid tbody {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }

    /* th, td {
    border-top: 1px solid #dddddd;
    border-bottom: 1px solid #dddddd;
    border-right: 1px solid #dddddd;
  } */

    th:first-child {
      border-left: 1px solid #dddddd;
    }

    .info-box-text {
      font-size: 20px;
      font-weight: bold;
      color: grey;
    }

    #tabelaVendas th,
    #tabelaVendas td,
    #tabelaManual th,
    #tabelaManual td {
      min-height: 40px !important;
      border-top: none !important;
      border-bottom: 0px;
      border-right: 0px;
      border-left: 0px;
    }

    #cardPrincipal {
      min-height: 400px;
      display: flex;
      justify-content: center;
    }
  </style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../menu.php');
    ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Fechamento de Caixa</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i>
              </button>
            </div><!-- /.col -->
            <div class="col-sm-6">
              <!-- <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="./loja">Loja</a></li>
                <li class="breadcrumb-item active">Fechamento de Caixa</li>
              </ol> -->
            </div><!-- /.col -->
          </div><!-- /.row -->

          <div class="row mt-4">
            <div class="col-md-3 col-sm-3 col-12">
              <div class="info-box">
                <span class="info-box-icon bg-info"><i class="fas fa-history"></i></span>
                <div class="info-box-content">
                  <span class="info-box-text">Total Saldo Anterior</span>
                  <span class="info-box-number" id="txt_val_saldo_anterior">0.00</span>
                </div>
              </div>
            </div>
            <div class="col-md-3 col-sm-3 col-12">
              <div class="info-box">
                <span class="info-box-icon bg-info"><i class="fas fa-coins"></i></span>
                <div class="info-box-content">
                  <span class="info-box-text">Total Entradas</span>
                  <span class="info-box-number" id="txt_val_entradas">0.00</span>
                </div>
              </div>
            </div>
            <div class="col-md-3 col-sm-3 col-12">
              <div class="info-box">
                <span class="info-box-icon text-white" style="background-color:var(--info-box-success)"><i class="fas fa-money-bill"></i></span>

                <div class="info-box-content">
                  <span class="info-box-text">Total Saídas</span>
                  <span class="info-box-number" id="txt_val_saidas">0.00</span>
                </div>
              </div>
            </div>
            <div class="col-md-3 col-sm-3 col-12">
              <div class="info-box">
                <span class="info-box-icon text-white" style="background-color:var(--info-box-danger)"><i class="fas fa-dollar-sign"></i></span>

                <div class="info-box-content">
                  <span class="info-box-text">Total Saldo</span>
                  <span class="info-box-number" id="txt_val_saldo">0.00</span>
                </div>
              </div>
            </div>
          </div>
          <!-- final dos info box -->

          <div class="card" id="cardPrincipal">
            <div class="row ml-2 mt-3 mr-2" id="tourbotoes">
              <div class="col-sm-12 mt-12">
                <div class="row">
                  <div class="col-lg-4 col-12 fechamentoCaixaDataHora">
                    <label data-error="wrong" data-success="right" for="txtCaixa">Caixa</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtCaixa" name="txtCaixa" class="form-control" placeholder="Caixa" disabled>
                      <div class="input-group-append">
                        <button class="btn bg-danger d-none" id="btn-impostor" name="btn-impostor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btn-caixa" name="btn-caixa" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-4 col-12 d-none fechamentoCaixaDataHora">
                    <label data-error="wrong" data-success="right" for="txtID">ID</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtID" name="txtID" class="form-control" placeholder="ID" disabled>
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btn-ID" name="btn-ID" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-4 col-12 fechamentoCaixaDataHora">
                    <div class="group-default form-group">
                      <label for="txtDataDe">Data:</label>
                      <div class="relative">
                        <input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDataDe" name="txtDataDe">
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-4 col-12 d-none fechamentoCaixaDataHora">
                    <div class="group-default form-group">
                      <label for="txtDataAte">Até:</label>
                      <div class="relative">
                        <input type="datetime-local" max="2500-12-31" class="input-default focus form-control validate" id="txtDataAte" name="txtDataAte" disabled>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-sm-6 mt-3">
                <button id="btn-relatorio" class="btn-sisp btn btn-secondary"><i class="fas fa-print"></i>
                  Relatório</button>
                <button class="btn btn-primary btn-sisp" data-toggle="modal" id="btnSangria" data-target=".bd-sangria-modal-sm">Sangria</button>
                <button class="btn btn-primary btn-sisp" data-toggle="modal" id="btnSuprimento" data-target=".bd-suprimento-modal-sm">Suprimento</button>
                <button class="btn btn-primary btn-sisp" data-toggle="modal" id="btnAnexos">Anexos</button>
              </div>
            </div>

            <div class="card-body">
              <div class="card" id="tourlancamentosmanuais">
                <div class="modal-body">
                  <nav>
                    <div class="nav nav-tabs justify-content-center" id="nav-tab" role="tablist" style="text-decoration: none">
                      <a class="nav-link abaLink active" id="tabLancManuais" data-toggle="tab" href="#divLancManuais" role="tab" aria-controls="divLancManuais" aria-selected="true">Lançamentos Manuais</a>
                      <a class="nav-link abaLink" id="tabVendas" data-toggle="tab" href="#divVendas" role="tab" aria-controls="divVendas" aria-selected="false">Vendas</a>
                    </div>
                  </nav>
                  <div class="tab-content" id="nav-tabContent">

                    <div class="tab-pane fade show active" id="divLancManuais" role="tabpanel" aria-labelledby="tabLancManuais">
                      <div class="card-body">
                        <div class="row pt-2 escondeCampos">
                          <div class="form-group col-sm-2">
                            <label>Operação</label>
                            <select id="rgOperacao" class="custom-select">
                              <option value="E" selected>Entrada</option>
                              <option value="S">Saída</option>
                            </select>
                          </div>
                          <div class="form-group col-sm-4">
                            <label>Observação</label>
                            <input type="text" class="form-control" id="txtObs" maxlength="200">
                          </div>
                          <div class="form-group col-sm-4">
                            <label>Valor</label>
                            <input type="text" class="form-control" id="txtValor">
                          </div>
                          <div class="form-group col-sm-2">
                            <label>Moeda</label>
                            <select id="rgMoeda" class="custom-select">
                            </select>
                          </div>
                        </div>
                        <div class="row escondeCampos d-flex" id="botoesTabelaManual">
                          <!-- <div class="form-group col-sm-12"> -->
                          <input id="btnIncluir" type="submit" style="font-size:15px;" class="ml-auto btn btn-danger btn-lg action-button btn-sisp" value="Incluir">
                          <!-- </div> -->
                        </div>
                        <div class="row pt-2">
                          <div class="col-sm-12 table-responsive">
                            <table id="tabelaManual" class="table table-sm table-select table-hover" width="100%">
                              <thead>
                                <tr>
                                  <th class="th-sm">Código
                                  </th>
                                  <th class="th-sm">Moeda
                                  </th>
                                  <th class="th-sm">Valor
                                  </th>
                                  <th class="th-sm">Juros
                                  </th>
                                  <th class="th-sm">Valor Orig
                                  </th>
                                  <th class="th-sm">Data Vencto
                                  </th>
                                  <th class="th-sm">Operação
                                  </th>
                                  <th class="th-sm">Duplicata
                                  </th>
                                  <th class="th-sm">Observação
                                  </th>
                                  <th class="th-sm">Ordem
                                  </th>
                                  <th class="th-sm">Opções
                                  </th>
                                </tr>
                              </thead>
                            </table>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="tab-pane fade show active" id="divVendas" role="tabpanel" aria-labelledby="tabVendas">
                      <div class="card-body">
                        <div class="row d-flex" id="botoesTabelaVendas">
                        </div>
                        <div class="row pt-2">
                          <div class="col-sm-12 table-responsive">
                            <table id="tabelaVendasGrid" class="table table-sm table-select table-hover" width="100%">
                              <thead>
                                <!-- <tr>
                                  <th class="th-sm">Venda
                                  </th>
                                  <th class="th-sm">Forma Pagto.
                                  </th>
                                  <th class="th-sm">Condição
                                  </th>
                                  <th class="th-sm">Quantidade
                                  </th>
                                  <th class="th-sm">Valor Bruto
                                  </th>
                                  <th class="th-sm">Valor
                                  </th>
                                </tr> -->
                              </thead>
                            </table>
                          </div>
                        </div>
                      </div>
                    </div>

                  </div>
                </div>
              </div>
            </div>

            <!-- <div class="card-body">
              <div class="card" id="tourlancamentosmanuais">
                <div class="card-body">
                  <div class="row">
                    <div class="col-12">
                      <h5><b> Lançamentos Manuais</b></h5>
                    </div>
                  </div>
                  <div class="row pt-2 escondeCampos">
                    <div class="form-group col-sm-2">
                      <label>Operação</label>
                      <select id="rgOperacao" class="custom-select">
                        <option value="E" selected>Entrada</option>
                        <option value="S">Saída</option>
                      </select>
                    </div>
                    <div class="form-group col-sm-4">
                      <label>Observação</label>
                      <input type="text" class="form-control" id="txtObs" maxlength="60">
                    </div>
                    <div class="form-group col-sm-4">
                      <label>Valor</label>
                      <input type="text" class="form-control" id="txtValor">
                    </div>
                    <div class="form-group col-sm-2">
                      <label>Moeda</label>
                      <select id="rgMoeda" class="custom-select">
                      </select>
                    </div>
                  </div>
                  <div class="row escondeCampos">
                    <div class="form-group col-sm-12">
                      <input id="btnIncluir" type="submit" style="font-size:15px;" class="float-right btn btn-danger btn-lg action-button btn-sisp" value="Incluir">
                    </div>
                  </div>
                  <div class="row pt-2">
                    <div class="col-sm-12 table-responsive">
                      <table id="tabelaManual" class="table table-sm table-select table-hover" width="100%">
                        <thead>
                          <tr>
                            <th class="th-sm">Código
                            </th>
                            <th class="th-sm">Moeda
                            </th>
                            <th class="th-sm">Valor
                            </th>
                            <th class="th-sm">Juros
                            </th>
                            <th class="th-sm">Valor Orig
                            </th>
                            <th class="th-sm">Data Vencto
                            </th>
                            <th class="th-sm">Operação
                            </th>
                            <th class="th-sm">Duplicata
                            </th>
                            <th class="th-sm">Observação
                            </th>
                            <th class="th-sm">Ordem
                            </th>
                            <th class="th-sm">Opção
                            </th>
                          </tr>
                        </thead>
                      </table>
                    </div>
                  </div>
                </div>
              </div>
            </div> -->

            <div class="card-body" id="caixatour" style="margin-top: -2.5rem;">
              <div class="card">
                <div class="card-body">
                  <div class="row">
                    <div class="col-12">
                      <h5><b>Caixa</b></h5>
                    </div>
                  </div>
                  <div class="row d-flex" id="botoesTabelaCaixa">
                  </div>
                  <div class="row pt-2">
                    <div class="col-sm-12 table-responsive">
                      <table id="tabelaVendas" class="table table-sm table-select table-hover shadow-sm  p-3 mb-5 bg-body rounded" width="100%">
                        <thead>
                          <tr>
                            <th class="th-sm">Código
                            </th>
                            <th class="th-sm">Descrição
                            </th>
                            <th class="th-sm">Condição
                            </th>
                            <th class="th-sm">Saldo Anterior
                            </th>
                            <th class="th-sm">Entradas
                            </th>
                            <th class="th-sm">Saídas
                            </th>
                            <th class="th-sm">Saldo Atual
                            </th>
                            <th class="th-sm">Troco
                            </th>
                            <th id="th_conferido" class="th-sm d-none">Conferido
                            </th>
                            <th id="th_diferenca" class="th-sm d-none">Diferença
                            </th>
                            <th class="th-sm">A Retirar
                            </th>
                            <th class="th-sm">Saldo Final
                            </th>
                          </tr>
                        </thead>
                      </table>
                    </div>
                  </div>

                  <div class="float-right mt-2">
                    <input id="btnGravar" type="submit" style="font-size:15px;" class="btn btn-danger btn-lg action-button  btn-sisp mt-2" value="Fechar Caixa">
                    <input id="btnAbrir" type="submit" style="font-size:15px;" class="btn btn-danger btn-lg action-button  btn-sisp mt-2" value="Reabrir Caixa">
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <button id="btnConsultar" class='btn btn-primary btn-sisp d-none' type='button'><span class="fas fa-search"></span>Consultar </button>
  <div id="modalFinanceiroSaidaManual" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
      <div class="modal-content" id="modalBody">
        <div class="modal-header">
          <h4 class="modal-title">Lançar Financeiro</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <form id="msformPagar">
            <div class="row">
              <div class="col-sm-12 col-lg-12 form-group">
                <label data-error="wrong" data-success="right" for="txtFornecedorPagar">Cliente/Fornecedor *</label>
                <div class="input-group">
                  <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtFornecedorPagar" name="txtFornecedorPagar" class="form-control" placeholder="Fornecedor" required>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnFornecedorPagar" name="btnFornecedorPagar" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaFornecedorPagar" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-sm-12 col-lg-12 form-group">
                <label data-error="wrong" data-success="right" for="txtClasseGerencialPagar">Classe Gerencial *</label>
                <div class="input-group">
                  <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtClasseGerencialPagar" name="txtClasseGerencialPagar" class="form-control" placeholder="Classe Gerencial" required>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnClasseGerencialPagar" name="btnClasseGerencialPagar" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaClasseGerencialPagar" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-sm-12 col-lg-12 form-group">
                <label data-error="wrong" data-success="right" for="txtHistoricoPagar">Histórico *</label>
                <div class="input-group">
                  <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtHistoricoPagar" name="txtHistoricoPagar" class="form-control" placeholder="Histórico" required>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnHistoricoPagar" name="btnHistoricoPagar" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaHistoricoPagar" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-sm-12 col-lg-12 form-group">
                <label data-error="wrong" data-success="right" for="txtSituacaoPagar">Situação *</label>
                <div class="input-group">
                  <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtSituacaoPagar" name="txtSituacaoPagar" class="form-control" placeholder="Situação" required>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnSituacaoPagar" name="btnSituacaoPagar" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaSituacaoPagar" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-sm-12 col-lg-12 form-group">
                <label data-error="wrong" data-success="right" for="txtBancoPagar">Banco *</label>
                <div class="input-group">
                  <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtBancoPagar" name="txtBancoPagar" class="form-control" placeholder="Banco" required>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnBancoPagar" name="btnBancoPagar" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaBancoPagar" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-sm-12 col-lg-12 form-group">
                <label data-error="wrong" data-success="right" for="txtContaPagar">Conta *</label>
                <div class="input-group">
                  <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtContaPagar" name="txtContaPagar" class="form-control" placeholder="Conta" required>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnContaPagar" name="btnContaPagar" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaContaPagar" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
            </div>
          </form>
        </div>
        <div class="modal-footer">
          <div class="row button-group">
            <button class="btn btn-primary btn-sisp" id="btnConfirmarPagar" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-check"></span> Confirmar</button>     
            <button class="btn btn-secondary btn-sisp" id="btnDesistirPagar"><span class="fas fa-times"></span> Desistir</button>
          </div>

        </div>
      </div>
    </div>
  </div>
  <?php
  include_once('../../modais.php');
  include_once('../../modals/modal_lancRateio.html');
  include_once('../../modals/modal_anexos.html');
  ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
  </div>
  <!-- ./wrapper -->

  <!-- jQuery -->
  <script src="plugins/jquery/jquery.min.js?versao=3.261.14.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.261.14.1"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.261.14.1"></script>
  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    if ($('[type="date"]').prop('type') != 'date') {
      $('[type="date"]').datepicker();
    }
    $.widget.bridge('uibutton', $.ui.button)
  </script>

  <!-- Bootstrap 4 -->
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.261.14.1"></script>
  <script src="dist/js/sisplan.js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="utils/funcoes.js?versao=3.261.14.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="dist/js/loadingoverlay.min.js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.261.14.1"></script>
  <script src="dist/js/dataTables.keyTable.js?versao=3.261.14.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.261.14.1"></script>
  <script src="utils/cookies.js?versao=3.261.14.1"></script>
  <!-- SweetAlert2 -->
  <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.261.14.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.261.14.1"></script>
  <script src="pages/loja/js/rotinas.js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="modals/modal_anexos.js?versao=3.261.14.1"></script>
  <script src="dist/js/driver.min.js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="config.js?versao=3.261.14.1"></script>
  <script src="plugins/jquery-validation/jquery.validate.min.js?versao=3.261.14.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.261.14.1"></script>
  <script type="text/javascript" src="modals/modal_lancRateio.js?versao=3.261.14.1"></script>
  <script>
    $('#tutorial').on('click', function() {
      $(document).ready(async function() {
        const driver = new Driver({
          doneBtnText: 'Sair',
          closeBtnText: 'Fechar',
          nextBtnText: 'Próximo',
          prevBtnText: 'Anterior',
          allowClose: false,
        });
        driver.defineSteps([{
            element: '.mt-4',
            popover: {
              title: 'Totais do Caixa',
              description: 'Aqui você poderá ver os valores totais do caixa.',
              position: 'bottom'
            }
          },
          {
            element: '#tourbotoes',
            popover: {
              title: 'Botões',
              description: 'Aqui estão os botões do caixa, onde você poderá filtrar sua busca, imprimir um relatório, fazer uma sangria ou um suprimento.',
              position: 'bottom'
            }
          },
          {
            element: '#tourlancamentosmanuais',
            popover: {
              title: 'Lançamentos Manuais',
              description: 'Aqui você poderá ver e criar lançamentos manuais para o caixa.',
              position: 'top'
            }
          },
          {
            element: '#caixatour',
            popover: {
              title: 'Dados Caixa',
              description: 'Aqui você poderá verificar os valores de cada moeda, sendo possível adicionar o valor de troco nas moedas que possuem essa opção.',
              position: 'top'
            }
          },
          {
            element: '#btnGravar',
            popover: {
              title: 'Botão Fechar Caixa',
              description: 'Clicando aqui você efetua o fechamento de caixa, após verificar os dados do passo anterior.',
              position: 'left'
            }
          }
        ]);
        //iniciar tour
        driver.start();
      });
    });

    $(document).ready(async function() {

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      const temAcesso = await temAcessoTela('LOJA_CAIXA');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      if (await CopiaParametro('VENDA', 66) == 1) {
        await senhaSupervisor('', () => {}, '', false, () => {
          window.location.href = 'index'
        }, () => {
          window.location.href = 'index'
        }, () => {
          window.location.href = 'caixa'
        }, false, 'CAIXA');
      }

      const listaMoedasEmpresa = await retornaMoedasEmpresa();
      const parametrosVenda = await BuscaParametrosVenda();
      const caixaDataHora = parametrosVenda[83] == '1';
      const utilizaProcessoCaixaCego = parametrosVenda[64] == '1';
      let diasConferenciaPadrao = 0;

      $('#msformPagar').validate({
        debug: false,
        ignore: "",
        rules: {
          txtFornecedorPagar: {
            required: true,
          },
          txtClasseGerencialPagar: {
            required: true,
          },
          txtHistoricoPagar: {
            required: true,
          },
          txtSituacaoPagar: {
            required: true,
          },
          txtBancoPagar: {
            required: true,
          },
          txtContaPagar: {
            required: true,
          }
        },
        messages: {
          txtFornecedorPagar: {
            required: "Informe um fornecedor.",
          },
          txtClasseGerencialPagar: {
            required: "Informe uma classe gerencial."
          },
          txtHistoricoPagar: {
            required: "Informe um histórico."
          },
          txtSituacaoPagar: {
            required: "Informe uma situação."
          },
          txtBancoPagar: {
            required: "Informe um banco."
          },
          txtContaPagar: {
            required: "Informe uma conta."
          }
        },
        errorElement: 'span',
        errorPlacement(error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight(element) {
          $(element).addClass('is-invalid');
        },
        unhighlight(element) {
          $(element).removeClass('is-invalid');
        }
      });

      if (caixaDataHora) {
        $('.fechamentoCaixaDataHora').removeClass('d-none');
        $('.fechamentoCaixaDataHora').removeClass('col-lg-4');
        $('.fechamentoCaixaDataHora').addClass('col-lg-3');
        $('#btn-caixa').prop('disabled', true);
        let label = $('label[for="txtDataDe"]');
        label.text('De: ');
        $('#txtDataDe').prop('disabled', true);
        $('#txtDataDe').prop('type', 'text');
        $('#txtDataAte').prop('type', 'text');
      }

      if (utilizaProcessoCaixaCego) {
        $('#btnSangria').attr('disabled', true).attr('readonly', true);
        $('#btnSuprimento').attr('disabled', true);
        $('#btnAnexos').attr('disabled', true);
        $('#btnIncluir').attr('disabled', true);
        $('#btnGravar').attr('disabled', true);
        $('#btnAbrir').attr('disabled', true);

        $('#th_diferenca').removeClass('d-none');
        $('#th_conferido').removeClass('d-none');
        //removido redirecionamento abaixo, apenas desabilitado botões acima.
        // window.location.href = `${BASE_URI}/contagem_caixa`;
        // return;
      }

      if (!caixaDataHora) {
        await setarDataAtual('txtDataDe');
      }

      $('#txtDataDe').on('blur', async function() {
        $('#btnConsultar').trigger('click');
      });

      async function usuarioMasterOuSupervisor() {
        try {
          const usuario = await retornaJsonPesquisaPadrao(`{"tabela": "ACESSO_USUARIOS", "camposSelect": ["TIPO"], "WHERE": ["CODIGO = '${getCookie('cod_usuario')}'"] }`) ?? 0;

          return usuario[0].TIPO != 0;

        } catch (error) {
          console.error(error);
        }
      }

      function changeCaixa() {
        if ($('#txtCaixa').val() == '') {
          $('#btn-caixa').trigger('click');
          return;
        }
        $('#btnConsultar').trigger('click');
      }

      sEmpresa = getCookie('empresa');

      let abaAtiva;

      let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      if (colunas == null || colunas.fechamentoCaixaManual == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({
          ...colunas,
          fechamentoCaixaManual: []
        }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
      }

      if (colunas == null || colunas.fechamentoCaixaVendas == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({
          ...colunas,
          fechamentoCaixaVendas: []
        }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
      }

      if (colunas == null || colunas.fechamentoCaixa == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({
          ...colunas,
          fechamentoCaixa: []
        }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
      }

      async function carregaValoresPadroesLoja() {
        const jsonStr = await buscaValoresPadroes('LOJA');

        jsonStr.map(async item => {
          switch (item.CAMPO) {
            case 'DIAS_CONFERENCIA': {
              if (item.VALOR !== '' && item.VALOR !== null) {
                diasConferenciaPadrao = Number(item.VALOR) ?? 0;
              }
              break;
            }
          }
        });
      }

      await carregaValoresPadroesLoja();

      function pesquisaLancaPagar() {
        $('#txtFornecedorPagar').autocompleta(3, `JSON={ "tabela":"ENTIDADE", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": null }`);
        $('#btnFornecedorPagar').pesquisa_serverside(['#txtFornecedorPagar'], ['CODCLI'], ['NOME'], `{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ], "where": null}`, 'Pesquisa Fornecedor');
        $('#btnLimpaFornecedorPagar').on('click', function() {
          $('#txtFornecedorPagar').val('')
        });

        $('#txtClasseGerencialPagar').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", 
    "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], 
    "where": null }
    `);
        $('#btnClasseGerencialPagar').pesquisa_serverside(['#txtClasseGerencialPagar'], ['CODIGO'], ['DESCRICAO'],
          `{
      "tabela":"CLASSE_GER", 
      "camposSelect":[ "CODIGO", "DESCRICAO" ], 
        "where": null
      }`,
          'Pesquisa Classe Gerencial'
        );
        $('#btnLimpaClasseGerencialPagar').on('click', function() {
          $('#txtClasseGerencialPagar').val('')
        });

        $('#txtHistoricoPagar').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":["HISTORICO CHAVE, DESCRICAO"], "where": null }`);
        $('#btnHistoricoPagar').pesquisa_serverside(['#txtHistoricoPagar'], ['HISTORICO'], ['DESCRICAO'], `{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO" ], "where": null}`, 'Pesquisa Histórico');
        $('#btnLimpaHistoricoPagar').on('click', function() {
          $('#txtHistoricoPagar').val('')
        });

        $('#txtSituacaoPagar').autocompleta(1, `JSON={ "tabela":"TABSIT", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": null }`);
        $('#btnSituacaoPagar').pesquisa_serverside(['#txtSituacaoPagar'], ['CODIGO'], ['DESCRICAO'], `{"tabela":"TABSIT", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa Situação');
        $('#btnLimpaSituacaoPagar').on('click', function() {
          $('#txtSituacaoPagar').val('')
        });

        $('#txtBancoPagar').autocompleta(1, `JSON={ "tabela":"CADBAN", "camposSelect":["BANCO CHAVE, NOME_BANCO DESCRICAO"], "where": null }`);
        $('#btnBancoPagar').pesquisa_serverside(['#txtBancoPagar'], ['BANCO'], ['NOME_BANCO'], `{"tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO" ], "where": null}`, 'Pesquisa Banco');
        $('#btnLimpaBancoPagar').on('click', function() {
          $('#txtBancoPagar').val('')
        });

        $('#txtContaPagar').autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":["CONTA CHAVE, DESCRICAO"], "where": null }`);
        $('#btnContaPagar').pesquisa_serverside(['#txtContaPagar'], ['CONTA'], ['DESCRICAO'], `{"tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO" ], "where": null}`, 'Pesquisa Conta');
        $('#btnLimpaContaPagar').on('click', function() {
          $('#txtContaPagar').val('')
        });
      }

      async function carregaValoresPadroes() {
        $.LoadingOverlay("show");
        try {
          const jsonStr = await buscaValoresPadroes('PAGTO')

          jsonStr.map(async item => {
            switch (item.CAMPO) {
              case 'FORNECEDOR': {
                if (item.VALOR !== '' && item.VALOR !== null) {
                  insereValor('#txtFornecedorPagar', item.VALOR, 'VALOR PADRÃO');
                }
                break;
              }

              case 'CLASSE_GERENCIA': {
                if (item.VALOR !== '' && item.VALOR !== null) {
                  insereValor('#txtClasseGerencialPagar', item.VALOR, 'VALOR PADRÃO');
                }
                break;
              }

              case 'HISTORICO': {
                if (item.VALOR !== '' && item.VALOR !== null) {
                  insereValor('#txtHistoricoPagar', item.VALOR, 'VALOR PADRÃO');
                }
                break;
              }

              case 'SITUACAO_CODIGO': {
                if (item.VALOR !== '' && item.VALOR !== null) {
                  insereValor('#txtSituacaoPagar', item.VALOR, 'VALOR PADRÃO');
                }
                break;
              }

              case 'BANCO': {
                if (item.VALOR !== '' && item.VALOR !== null) {
                  insereValor('#txtBancoPagar', item.VALOR, 'VALOR PADRÃO');
                }
                break;
              }

              case 'CONTA': {
                if (item.VALOR !== '' && item.VALOR !== null) {
                  insereValor('#txtContaPagar', item.VALOR, 'VALOR PADRÃO');
                }
                break;
              }
            }
          });
        } catch (error) {
          console.log(`Erro na função carregaValoresPadroes. ${error}`);
        } finally {
          $.LoadingOverlay("hide");
        }
      }

      $('#btnDesistirPagar').on('click', async function() {
        $('#modalFinanceiroSaidaManual').modal('hide');
      });

      $('#btnConfirmarPagar').click(async function() {
        $('#btnConfirmarPagar').prop('disabled', true);
        try {
          let validator = $("#msformPagar").validate();
          validator.form();
          let erros = 0;
          erros = validator.numberOfInvalids();

          if (erros == 0) {
            if (tipo == 'sangria') {
              await lancaSangria();
              $('#modalFinanceiroSaidaManual').modal('hide');
            } else if (tipo == 'lancamentoManual') {
              await lancamentoManual(pegaChave('#txtCaixa'));
              $('#modalFinanceiroSaidaManual').modal('hide');
            }
          } else {
            msgAlerta('Necessário informar os campos obrigatórios.');
          }
        } finally {
          $('#btnConfirmarPagar').prop('disabled', false);
        }
      });


      $('#btnConfirmarColunas').on('click', async function() {
        try {
          $.LoadingOverlay('show');

          const novasColunas = retornaNovasColunasInvisiveis();
          let cols = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

          if (abaAtiva == '1') {
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({
              ...cols,
              fechamentoCaixa: novasColunas
            }))
            $('#tabelaVendas').DataTable().columns().visible(true);

            $('#tabelaVendas').DataTable().columns().every(
              function() {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                  this.visible(false);
                }
              })
          } else if (abaAtiva == '2') {
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({
              ...cols,
              fechamentoCaixaManual: novasColunas
            }))
            $('#tabelaManual').DataTable().columns().visible(true);

            $('#tabelaManual').DataTable().columns().every(
              function() {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                  this.visible(false);
                }
              })
          } else {
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({
              ...cols,
              fechamentoCaixaVendas: novasColunas
            }))
            $('#tabelaVendasGrid').DataTable().columns().visible(true);

            $('#tabelaVendasGrid').DataTable().columns().every(
              function() {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                  this.visible(false);
                }
              })
          }

        } finally {
          $.LoadingOverlay('hide');
          $('#modal-ColunasVisiveis').modal('hide');
        }
      })

      var bUsaECF = await CopiaParametro('VENDA', 8);
      const bLancaPagarSaida = await CopiaParametro('VENDA', 88) == '2';
      pesquisaLancaPagar();
      let where = '';
      if (listaMoedasEmpresa.length > 0) {
        where = ` AND CODMOE IN (${listaMoedasEmpresa.toString()})`;
      }
      $("#txtMoedaSangria").pesquisa("#txtMoedaSangria", "CODMOE", "DESCRICAO",
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao" ], "where": ["((DESCRICAO LIKE '[PERCENTUAL]DINHEIRO[PERCENTUAL]') OR (DESCRICAO LIKE '[PERCENTUAL]EFECTIVO[PERCENTUAL]') OR (DESCRICAO LIKE '[PERCENTUAL]MONEY[PERCENTUAL]'))"]}`,
        "Pesquisa Moeda", "moeda");
      $("#txtMoedaSuprimento").pesquisa("#txtMoedaSuprimento", "CODMOE", "DESCRICAO",
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao" ], "where": ["((DESCRICAO LIKE '[PERCENTUAL]DINHEIRO[PERCENTUAL]') OR (DESCRICAO LIKE '[PERCENTUAL]EFECTIVO[PERCENTUAL]') OR (DESCRICAO LIKE '[PERCENTUAL]MONEY[PERCENTUAL]'))"]}`,
        "Pesquisa Moeda", "moeda");
      $('#txtCaixa').pesquisa('#txtCaixa', 'CODIGO', 'DESCRICAO',
        '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAIXA_LOJA", "camposSelect":[ "CODIGO", "descricao"]}',
        'Pesquisa Caixa', 'CAIXA_LOJA', null, changeCaixa);
      $('#btn-caixa').pesquisa('#txtCaixa', 'CODIGO', 'DESCRICAO',
        '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAIXA_LOJA", "camposSelect":[ "CODIGO", "descricao"]}',
        'Pesquisa Caixa', 'CAIXA_LOJA', null, changeCaixa);
      $("#btn-MoedaSangria").pesquisa("#txtMoedaSangria", "CODMOE", "DESCRICAO",
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao" ], "where": ["((DESCRICAO LIKE '[PERCENTUAL]DINHEIRO[PERCENTUAL]') OR (DESCRICAO LIKE '[PERCENTUAL]EFECTIVO[PERCENTUAL]') OR (DESCRICAO LIKE '[PERCENTUAL]MONEY[PERCENTUAL]')) ${where}"]}`,
        "Pesquisa Moeda", "moeda");
      $("#btn-MoedaSuprimento").pesquisa("#txtMoedaSuprimento", "CODMOE", "DESCRICAO",
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao" ], "where": ["((DESCRICAO LIKE '[PERCENTUAL]DINHEIRO[PERCENTUAL]') OR (DESCRICAO LIKE '[PERCENTUAL]EFECTIVO[PERCENTUAL]') OR (DESCRICAO LIKE '[PERCENTUAL]MONEY[PERCENTUAL]')) ${where}"]}`,
        "Pesquisa Moeda", "moeda");

      $("#btn-limpa-MoedaSangria").on("click", function() {
        $("#txtMoedaSangria").val("");
      });
      $("#btn-limpa-MoedaSuprimento").on("click", function() {
        $("#txtMoedaSuprimento").val("");
      });

      $('#btnLancaManual').on('click', function() {
        $('#modal-lancamento').modal('show');
      });


      function NaoTemCaixaVinculado() {
        return !sessionStorage.getItem('g_caixa_logado') || sessionStorage.getItem('g_caixa_logado') == 'undefined';
      }

      async function VinculaCaixaComUsuario() {
        const _url = '/sisplan/funcoes/v1/pesquisa?';
        let where = `CAIXA_F.EMP_ID = ${getCookie('emp_id')}`;
        const nomeUsuario = getCookie('cod_usuario') == '0000' ? 'SISPLAN' : getCookie('usuario');
        const _usuarioCaixa =
          `JSON={"tabela": "VENDA_CAIXA", 
          "camposSelect": ["VENDA_CAIXA.NRCAIXA", "VENDA_CAIXA.USUARIO", "CAIXA_LOJA.DESCRICAO", "VENDA_CAIXA.EMP_ID"], 
          "where": ["VENDA_CAIXA.USUARIO = '${nomeUsuario}'"],
          "innerjoin": [{"tabela" : "CAIXA_LOJA", "condicao" : "CAIXA_LOJA.CODIGO = VENDA_CAIXA.NRCAIXA"}]}`;
        try {
          const response = await requisicao('GET', _url, _usuarioCaixa, nomeUsuario, null);
          if (!response) {
            msgErro('Erro ao buscar caixas vinculados ao usuário.');
            return;
          }

          if (response.status == 200) {
            var jsonStr = await response.json();
            if (jsonStr['RESULT'][0].length >= 1) {
              const dados = jsonStr.RESULT[0];
              const dadosFiltrados = dados.filter(dado => dado.EMP_ID == getCookie('emp_id'));
              const possuiVinculoEmpresaLogada = dadosFiltrados.length > 0;
              if (possuiVinculoEmpresaLogada) {
                const caixa = '[' + dadosFiltrados[0].NRCAIXA + '] - ' + dadosFiltrados[0].DESCRICAO;
                sessionStorage.setItem('g_caixa_logado', caixa);
                where = `CAIXA_F.EMP_ID = ${getCookie('emp_id')} AND CAIXA_F.NRCAIXA = '${dadosFiltrados[0].NRCAIXA}'`;
              } else {
                const sCaixa = '[' + jsonStr['RESULT'][0][0].NRCAIXA + '] - ' + jsonStr['RESULT'][0][0].DESCRICAO;
                sessionStorage.setItem('g_caixa_logado', sCaixa);
                where = `CAIXA_F.EMP_ID = ${getCookie('emp_id')} AND CAIXA_F.NRCAIXA = '${jsonStr['RESULT'][0][0].NRCAIXA}'`;
              }
              $('#btn-impostor').removeClass('d-none');
              $('#btn-caixa').addClass('d-none');
            }
          } else {
            msgErro('Erro ao buscar caixas vinculados ao usuário.');
            return;
          }

          if (caixaDataHora) {
            $('#btn-ID').pesquisa_serverside(
              ['#txtID', '#txtCaixa', '#txtDataDe', '#txtDataAte'],
              ['CAIXA_F.ID', 'CAIXA_F.NRCAIXA', 'CAIXA_F.DT_INI', 'CAIXA_F.DT_FIM'],
              ['CAIXA_F.DT_INI', 'CAIXA_LOJA.DESCRICAO', 'CAIXA_F.DT_INI', 'CAIXA_F.DT_FIM'],
              `{ 
                "tabela":"CAIXA_F", "camposSelect":[ "CAIXA_F.ID", "CAIXA_F.NRCAIXA", "CAIXA_LOJA.DESCRICAO", "CAIXA_F.DT_INI", "CAIXA_F.DT_FIM"], 
                "leftJoin": [{"tabela": "CAIXA_LOJA", "condicao": "CAIXA_LOJA.CODIGO = CAIXA_F.NRCAIXA"}],
                "where": ["${where}"],
                "orderBy": ["CAIXA_F.ID DESC"]
              }`,
              'Pesquisa de caixa_f',
              async function() {
                  $('#btnConsultar').trigger('click')
                },
                [undefined, undefined, true, true]
            );
          }
        } catch (error) {
          console.error(error);
          msgErro('Erro ao buscar caixas vinculados ao usuário.');
          return;
        }

      }

      await VinculaCaixaComUsuario();

      await VerificaCaixa();


      $('#btn-impostor').on('click', async function() {
        function abrePesquisaCaixa() {
          $('#btn-caixa').trigger('click');
        }
        await senhaSupervisor(
          `Usuário com caixa vinculado.`,
          abrePesquisaCaixa, '', false, undefined, undefined, undefined, false, 'CAIXA');
      });

      async function VerificaCaixa() {
        try {
          if (sessionStorage.getItem('g_caixa_logado') == '' || (sessionStorage.getItem('g_caixa_logado') == null) || (sessionStorage.getItem('g_caixa_logado') == 'undefined') || (sessionStorage.getItem('g_caixa_logado') == undefined)) {
            let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?',
              'JSON={ "tabela":"CAIXA_LOJA", "camposSelect":[ "CODIGO", "descricao"]}', null);

            if (!response) {
              return;
            }

            let jsonStr = await response.json();

            if (jsonStr.RESULT[0].length > 1) {
              $('#btn-caixa').trigger('click');
            } else {
              $('#txtCaixa').val(`[${jsonStr.RESULT[0][0].CODIGO}] - ${jsonStr.RESULT[0][0].DESCRICAO}`);
            }
          } else {
            $("#txtCaixa").val(sessionStorage.getItem('g_caixa_logado'));
          }
        } catch (error) {
          msgErro('Erro ao buscar caixa!');
          $('#btn-caixa').trigger('click');
          console.error(error);
        }
      }

      async function VerificaUnicoRegistro() {
        const _url = '/sisplan/funcoes/v1/pesquisa?';
        const _paramsCaixa =
          `JSON={ "tabela":"CAIXA_LOJA", "camposSelect":["CODIGO", "DESCRICAO"], "where": null}`;
        try {
          const response = await requisicao('GET', _url, _paramsCaixa, null);
          if (!response) {
            msgErro('Erro ao buscar caixas disponíveis.');
            return;
          }

          if (response.status == 200) {
            var jsonStr = await response.json();
            if (jsonStr['RESULT'][0].length == 1) {
              const sCaixa = '[' + jsonStr['RESULT'][0][0].CODIGO + '] - ' + jsonStr['RESULT'][0][0].DESCRICAO;
              sessionStorage.setItem('g_caixa_logado', sCaixa);
            } else {
              sessionStorage.setItem('g_caixa_logado', '');
            }
          } else {
            msgErro('Erro ao buscar caixas disponíveis.');
            return;
          }
        } catch (error) {
          console.error(error);
          msgErro('Erro ao buscar caixas disponíveis.');
          return;
        }
      }

      try {
        $.LoadingOverlay("show");
        let where = null
        if (listaMoedasEmpresa.length > 0) {
          where = `"CODMOE IN (${listaMoedasEmpresa.toString()})"`;
        }
        var response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?',
          `JSON={"tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO"], "where": [${where}], "orderBy": ["CODMOE"]}`, null);

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }

        var jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr['RESULT'][0].mensagem);
          return;
        }

        for (const moeda of jsonStr['RESULT'][0]) {
          var opcao = new Option(`${moeda.CODMOE+' - '+moeda.DESCRICAO}`, `${moeda.CODMOE}`);
          /// jquerify the DOM object 'o' so we can use the html method
          $(opcao).html(`${moeda.CODMOE+' - '+moeda.DESCRICAO}`);
          $("#rgMoeda").append(opcao);
        }
        $.LoadingOverlay("hide");
      } catch (error) {
        $.LoadingOverlay("hide");
        console.log(error);
        msgErro('Não foi possível buscar as empresas cadastradas.');
      }


      async function ValidaStatusCaixa() {
        if (await CaixaFechado() == true) {
          $('#btnAbrir').removeClass('d-none');
          $('#btnGravar').addClass('d-none');
          $('#btnSangria').addClass('d-none');
          $('#btnSuprimento').addClass('d-none');
          $('#btnIncluir').addClass('d-none');
          $('.txtDINHEIRO').prop('disabled', true);
          // $('.btnOpcao').prop('disabled', true);
          $('.escondeCampos').addClass('d-none');
          $(".estornarLancamentoManual").addClass("d-none");
        } else {
          $('#tabelaVendas').DataTable().rows()[0].length > 0 ? $('#btnGravar').removeClass('d-none') : $(
            '#btnGravar').addClass('d-none');
          $('#btnAbrir').addClass('d-none');
          $('#btnSangria').removeClass('d-none');
          $('#btnSuprimento').removeClass('d-none');
          $('#btnIncluir').removeClass('d-none');
          $('.txtDINHEIRO').prop('disabled', false);
          $('.btnOpcao').prop('disabled', false);
          $('.escondeCampos').removeClass('d-none');
          $(".estornarLancamentoManual").removeClass("d-none");
        }

      }

      async function CaixaFechado() {
        try {
          $.LoadingOverlay('show');
          try {
            var caixa = pegaChave('#txtCaixa');
            var data = $('#txtDataDe').val();

            let response = await requisicao('GET', '/Sisplan/vendas/V1/VerificaStatusCaixa?',
              `CAIXA=${caixa}&DATA=${data}&IDCAIXA=${pegaChave('#txtID')}&CONSULTA=true`, null);

            if (!response) {
              return false;
            }

            var jsonStr = await response.json();
            if (response.status != 200) {
              msgErro(jsonStr.mensagem);
              return false;
            }

            if (jsonStr == "true") {
              return true;
            }

          } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
            msgErro('Erro ao verificar se o caixa está fechado ou aberto!');
          }
        } finally {
          $.LoadingOverlay('hide');
        }
      }

      function retornaBotaoOpcoes(tipo) {

        if (tipo != 'V') {
          return '<div style="text-align: start;"> ' +
            '   <div class="dropdown"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnOpcao" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      Opções' +
            '    </button> ' +
            '    <div class="dropdown-menu" style="min-width: 2rem;"> ' +
            '    <a class="dropdown-item estornarLancamentoManual" href="#" data-toggle="modal" data-target=".bd-visualizar-modal-lg">Estornar</a>' +
            '    <a class="dropdown-item reciboLancamentoManual" href="#" data-toggle="modal" data-target=".bd-visualizar-modal-lg">Emitir Recibo</a>' +
            '    </div>' +
            '  </div>' +
            '</div>';
        } else {
          return '<div style="text-align: start;"> ' +
            '   <div class="dropdown"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnOpcao" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" disabled> ' +
            '      Opções' +
            '    </button> ' +
            '  </div>' +
            '</div>';
        }
      };

      $('#modal-filtros').on('hidden.bs.modal', function(e) {
        $('#btnConsultar').trigger('click');
      })

      async function criaDataTable(data, data2, data3) {
        let dataSetCols = [];
        let datasetCols2 = [];
        let datasetCols3 = [];

        dataSetCols.push({
          "data": "CODIGO"
        });
        dataSetCols.push({
          "data": "DESCRICAO"
        });
        dataSetCols.push({
          "data": "CONDICAO"
        });
        dataSetCols.push({
          "data": "SALDO_ANTERIOR"
        });
        dataSetCols.push({
          "data": "ENTRADAS"
        });
        dataSetCols.push({
          "data": "SAIDAS"
        });
        dataSetCols.push({
          "data": "SALDO_ATUAL"
        });
        dataSetCols.push({
          "data": "TROCO"
        });

        if (utilizaProcessoCaixaCego) {
          dataSetCols.push({
            "data": "CONFERIDO"
          });
          dataSetCols.push({
            "data": "DIFERENCA"
          });
        }
        
        dataSetCols.push({
          "data": "A_RETIRAR"
        });
        dataSetCols.push({
          "data": "SALDO_FINAL"
        });

        dataSetCols[7].render = function(data, type, row) {
          if (['DINHEIRO', 'EFECTIVO', 'MONEY'].includes(row['DESCRICAO'].toUpperCase().split(' ')[0])) {
            return `<input type="text" value='${row["TROCO"]}' id="txtMoeda-${row['CODIGO']}" placeholder="Troco" class="input-default focus form-control validate txtDINHEIRO" style="min-width:100px; height: 30px;" min="0">`
          } else {
            return `<input type="text" value='${row["TROCO"]}' id="txtMoeda-${row['CODIGO']}" placeholder="Troco" class="input-default focus form-control validate troco_off" style="min-width:100px; height: 30px;" readonly>`
          }
        }

        datasetCols2.push({
          "data": "CODMOE"
        });
        datasetCols2.push({
          "data": "DESCMOE"
        });
        datasetCols2.push({
          "data": "VALOR"
        });
        datasetCols2.push({
          "data": "JUROS"
        });
        datasetCols2.push({
          "data": "VALOR_ORIG"
        });
        datasetCols2.push({
          "data": "DT_VENCTO"
        });
        datasetCols2.push({
          "data": "DESCTIPO"
        });
        datasetCols2.push({
          "data": "DUPLICATA"
        });
        datasetCols2.push({
          "data": "DESCRICAO"
        });
        datasetCols2.push({
          "data": "ORDEM"
        });
        datasetCols2.push({
          "data": "OPCOES"
        });
        datasetCols2[10].render = function(data, type, row) {
          let tipo = row['TIPO'];
          return retornaBotaoOpcoes(tipo);
        };

        datasetCols3.push({
          "data": "VENDA",
          "title": "Venda"
        });
        datasetCols3.push({
          "data": "MOEDA",
          "title": "Moeda"
        });
        datasetCols3.push({
          "data": "DESC_MOEDA",
          "title": "Desc Moeda"
        });
        datasetCols3.push({
          "data": "CONDICAO",
          "title": "Condição"
        });
        datasetCols3.push({
          "data": "CODCLI",
          "title": "Codcli"
        });
        datasetCols3.push({
          "data": "NOME_CLI",
          "title": "Nome Cli"
        });
        datasetCols3.push({
          "data": "CODREP",
          "title": "Codrep"
        });
        datasetCols3.push({
          "data": "NOME_REP",
          "title": "Nome Rep"
        });
        datasetCols3.push({
          "data": "QUANTIDADE",
          "title": "Quantidade"
        });
        datasetCols3.push({
          "data": "VALOR_VENDA",
          "title": "Valor Bruto"
        });
        datasetCols3.push({
          "data": "VALOR",
          "title": "Valor Venda"
        });
        datasetCols3.push({
          "data": "DESCONTO",
          "title": "Desconto"
        });
        datasetCols3.push({
          "data": "HORA_VENDA",
          "title": "Data Venda"
        });
        datasetCols3.push({
          "data": "FATURA_NFCE",
          "title": "Fatura NFCE"
        });
        datasetCols3.push({
          "data": "FATURA_NFE",
          "title": "Fatura NFE"
        });

        let table3 = $('#tabelaVendasGrid').DataTable({
          searching: false,
          ordering: true,
          paging: false,
          info: true,
          destroy: true,
          colReorder: true,
          "autoWidth": true,
          "data": data3,
          "columns": datasetCols3,
          "columnDefs": [{
              "render": function(data) {
                return parseFloat(data ?? 0).toLocaleString("pt-BR", {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                })
              },
              "targets": [9, 10, 11],
              "className": 'pr-4 text-right'
            },
            {
              "targets": 8,
              "className": 'pr-4 text-right'
            },
            {
              "type": 'date-br',
              "render": function(data) {
                if (data != undefined) {
                  x = data.slice(0, 10).split('-');
                  y = data.slice(11, 19);
                  return `${x[2]}/${x[1]}/${x[0]} ${y}`;
                } else {
                  return ''
                }
              },
              "targets": [12]
            }
          ]
        });

        $('#tabVendas').trigger('click');

        const colunasNumericas = utilizaProcessoCaixaCego 
                               ? [3, 4, 5, 6, 8, 9, 10, 11]
                               : [3, 4, 5, 6, 8, 9]

        let table = $('#tabelaVendas').DataTable({
          ordering: true,
          searching: false,
          paging: false,
          info: true,
          destroy: true,
          colReorder: true,
          "columnDefs": [{
            "render": function(data) {
              return parseFloat(data ?? 0).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              })
            },
            "targets": colunasNumericas,
            "className": 'pr-4 text-right'
          }],
          "autoWidth": true,
          "data": data,
          "columns": dataSetCols,
        });

        $('#tabelaVendas tbody').on('change', 'tr', function(e) {
          var rowArray = table.row(this).data();

          if (rowArray) {
            if ($(`#txtMoeda-${rowArray['CODIGO']}`).val() < 0) {
              msgAlerta('Valor informado negativo');
              $(`#txtMoeda-${rowArray['CODIGO']}`).val(0);
            }

            if ((parseFloat($(`#txtMoeda-${rowArray['CODIGO']}`).val()) > rowArray['SALDO_ATUAL']) && (
                rowArray['SALDO_ATUAL'] > 0)) {
              msgAlerta('Valor informado superior ao saldo atual');
              $(`#txtMoeda-${rowArray['CODIGO']}`).val(0);
            }

            rowArray['TROCO'] = Number($(`#txtMoeda-${rowArray['CODIGO']}`).val());
            rowArray['A_RETIRAR'] = rowArray['SALDO_ATUAL'] - rowArray['TROCO'];
            rowArray['A_RETIRAR'] = Number(rowArray['A_RETIRAR'].toFixed(2));

            rowArray['SALDO_FINAL'] = Number(rowArray['SALDO_ATUAL'] - rowArray['A_RETIRAR']);
            rowArray['SALDO_FINAL'] = Number(rowArray['SALDO_FINAL'].toFixed(2));

            table.row(this).invalidate();
            $(function() {
              $('.txtDINHEIRO').maskMoney({
                decimal: '.',
                thousands: '',
                precision: 2
              });
            })
          }
        });

        $(function() {
          $('.txtDINHEIRO').maskMoney({
            decimal: '.',
            thousands: '',
            precision: 2
          });
        })

        let table2 = $('#tabelaManual').DataTable({
          ordering: true,
          searching: false,
          paging: false,
          info: true,
          destroy: true,
          colReorder: true,
          "autoWidth": true,
          "data": data2,
          "columns": datasetCols2,
          "columnDefs": [{
              "type": 'date-br',
              "render": function(data) {
                if (data != undefined) {
                  x = data.slice(0, 10).split('-');
                  return `${x[2]}/${x[1]}/${x[0]}`;
                } else {
                  return ''
                }
              },
              "targets": 5,
            },
            {
              "render": function(data) {
                return parseFloat(data ?? 0).toLocaleString("pt-BR", {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                })
              },
              "targets": [2, 3, 4],
              "className": 'pr-4 text-right'
            }
          ]
        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        if ($('#botoesTabelaManual').find('#buttonColVisManual').length <= 0) {
          $('#botoesTabelaManual').prepend('<button class="buttonColVis" id="buttonColVisManual"><i class="fas fa-cogs"></i></button>');
          $('#botoesTabelaManual').prepend('<button class="buttonExcel" id="buttonExcelManual"><i class="fas fa-file-excel"></i></button>');

          $('#buttonColVisManual').on('click', async function() {
            $.LoadingOverlay('show');
            abaAtiva = '2';
            $('#modal-ColunasVisiveis').modal('show');
            $.LoadingOverlay('hide');
          })

          $('#buttonExcelManual').on('click', async function() {
            var codusuario = getCookie('cod_usuario');
            var caixa = $('#txtCaixa').val().substring(1, $('#txtCaixa').val().indexOf('] - '));
            const filtros = `caixa=${caixa}&CODUSUARIO=${codusuario}&DATA=${retornaDataFormatada($('#txtDataDe').val())}&IDCAIXA=${pegaChave('#txtID')}`;
            const url = '/sisplan/vendas/v1/fechamentocaixa?';
            const formataCampos = montaComandosCamposManual();
            await exportaCSV(url, filtros, false, null, 'Fechamento de Caixa - Manual', '#tabelaManual', formataCampos, 1);
          })

          $('#buttonColVisManual').prop('title', 'Configurar colunas')
          $('#buttonExcelManual').prop('title', 'Exportar CSV')
        }

        if ($('#botoesTabelaVendas').find('#buttonColVisVendas').length <= 0) {
          $('#botoesTabelaVendas').prepend('<button class="buttonColVis" id="buttonColVisVendas"><i class="fas fa-cogs"></i></button>');
          $('#botoesTabelaVendas').prepend('<button class="buttonExcel" id="buttonExcelVendas"><i class="fas fa-file-excel"></i></button>');

          $('#buttonColVisVendas').on('click', async function() {
            $.LoadingOverlay('show');
            abaAtiva = '3';
            $('#modal-ColunasVisiveis').modal('show');
            $.LoadingOverlay('hide');
          })

          $('#buttonExcelVendas').on('click', async function() {
            var codusuario = getCookie('cod_usuario');
            var caixa = $('#txtCaixa').val().substring(1, $('#txtCaixa').val().indexOf('] - '));
            const filtros = `caixa=${caixa}&CODUSUARIO=${codusuario}&DATA=${retornaDataFormatada($('#txtDataDe').val())}&IDCAIXA=${pegaChave('#txtID')}`;
            const url = '/sisplan/vendas/v1/fechamentocaixa?';
            const formataCampos = montaComandosCamposVendas();
            await exportaCSV(url, filtros, false, null, 'Fechamento de Caixa - Vendas', '#tabelaVendasGrid', formataCampos, 2);
          })

          $('#buttonColVisVendas').prop('title', 'Configurar colunas')
          $('#buttonExcelVendas').prop('title', 'Exportar CSV')

        }

        if ($('#botoesTabelaCaixa').find('#buttonColVisCaixa').length <= 0) {
          $('#botoesTabelaCaixa').prepend('<button class="buttonColVis" id="buttonColVisCaixa"><i class="fas fa-cogs"></i></button>');
          $('#botoesTabelaCaixa').prepend('<button class="buttonExcel" id="buttonExcelCaixa"><i class="fas fa-file-excel"></i></button>');

          $('#buttonColVisCaixa').on('click', async function() {
            $.LoadingOverlay('show');
            abaAtiva = '1';
            $('#modal-ColunasVisiveis').modal('show');
            $.LoadingOverlay('hide');
          })

          $('#buttonExcelCaixa').on('click', async function() {
            var codusuario = getCookie('cod_usuario');
            var caixa = $('#txtCaixa').val().substring(1, $('#txtCaixa').val().indexOf('] - '));
            const filtros = `caixa=${caixa}&CODUSUARIO=${codusuario}&DATA=${retornaDataFormatada($('#txtDataDe').val())}&IDCAIXA=${pegaChave('#txtID')}`;
            const url = '/sisplan/vendas/v1/fechamentocaixa?';
            const formataCampos = montaComandosCamposCaixa();
            await exportaCSV(url, filtros, false, null, 'Fechamento de Caixa', '#tabelaVendas', formataCampos, 0);
          })

          $('#buttonColVisCaixa').prop('title', 'Configurar colunas')
          $('#buttonExcelCaixa').prop('title', 'Exportar CSV')

        }

        $('#tabelaManual').DataTable().columns().every(
          function() {
            if ((colunasInvisiveis.fechamentoCaixaManual).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          }
        )

        $('#tabelaVendasGrid').DataTable().columns().every(
          function() {
            if ((colunasInvisiveis.fechamentoCaixaVendas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          }
        )

        $('#tabelaVendas').DataTable().columns().every(
          function() {
            if ((colunasInvisiveis.fechamentoCaixa).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          }
        )

        $('.reciboLancamentoManual').unbind('click');
        $('.reciboLancamentoManual').on('click', async function() {
          try {
            $.LoadingOverlay('show');
            try {
              const table = $('#tabelaManual').DataTable();
              const data = table.row($(this).parents('tr')).data();
              const caixa = pegaChave('#txtCaixa');
              const dataDe = retornaDataFormatada($('#txtDataDe').val());
              const lancamento = data.LANCAMENTO;
              const ordem = data.ORDEM;
              const tipo = data.TIPO;

              const url = `/sisplan/impressao/v1/recibocaixa?NRCAIXA=${caixa}&TIPO=${tipo}&ORDEM=${ordem}&DATA=${dataDe}`;
              const bImprimeAutomatico = await verificaImprimirAutomatico('ReciboCaixa');
              const arquivo = await GeraRelatorio(`${url}&`, 'GET', 15000, false, 'ReciboCaixa');
              if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                  window.open(`<?php echo BASE_URI; ?>/relatorios_api/pdf/${arquivo}`, '_blank');
                }
                await limparRelatorios();
              }
            } catch (error) {
              console.error(error);
              msgErro('Não foi possível emetir recibo', error)
            }
          } finally {
            $.LoadingOverlay('hide');
          }
        });


        $('.estornarLancamentoManual').unbind('click');
        $('.estornarLancamentoManual').on('click', async function() {
          $.LoadingOverlay("show");
          const parametroEstornoLancamentoManual = parametrosVenda[82];
          const data = $('#tabelaManual').DataTable().row($(this).parents('tr')).data();
          try {

            if (parametroEstornoLancamentoManual == '2') {
              await senhaSupervisor('Estornar lançamento', async () => {
                await estornarLancamentoManual(data);
              }, '', false, undefined, undefined, undefined, false, 'CAIXA');
            } else if (parametroEstornoLancamentoManual == '1') {
              msgAlerta("Estorno do lançamento manual está bloqueado, impossível realizar a ação.");
            } else {
              await estornarLancamentoManual(data);
            }

          } finally {
            $.LoadingOverlay("hide");
          }
        });
        atualizaTotais();
        setTimeout(() => {
          $('#tabLancManuais').trigger('click');
        }, 200);
      }

      function montaComandosCamposManual() {
        let retorno = `dados.map(e => {
          delete e['DESCONTO'];
          delete e['LANCAMENTO'];
          delete e['NRCAIXA'];
          delete e['TIPO'];
          delete e['TIPO_ORD'];
        });
        `;

        retorno += `dados = dados.map((key) => {
          let v1 = key.VALOR 
          if (typeof v1 == 'string') {
          v1 = parseFloat(v1.replaceAll(".", "").replace(",", ".")).toFixed(2)
          } else {
          if (v1 == null) {
            v1 = 0;
          }
          v1 = parseFloat(v1).toFixed(2) }
          let v2 = key.JUROS
          if (typeof v2 == 'string') {
          v2 = parseFloat(v2.replaceAll(".", "").replace(",", ".")).toFixed(2)
          } else {
          if (v2 == null) {
            v2 = 0;
          }
          v2 = parseFloat(v2).toFixed(2) }
          let v3 = key.VALOR_ORIG
          if (typeof v3 == 'string') {
          v3 = parseFloat(v3.replaceAll(".", "").replace(",", ".")).toFixed(2)
          } else {
          if (v3 == null) {
            v3 = 0;
          }
          v3 = parseFloat(v3).toFixed(2) }
          
          return { ...key, VALOR: v1, JUROS: v2, VALOR_ORIG: v3 }
          }) \n`
        return retorno;
      }

      function montaComandosCamposCaixa() {
        let retorno = `dados.map(e => {
          delete e['DIFERENCA'];
          delete e['CONFERIDO'];
        })
        `;

        retorno += `dados = dados.map((key) => {
          let v1 = key.ENTRADAS 
          if (typeof v1 == 'string') {
          v1 = parseFloat(v1.replaceAll(".", "").replace(",", ".")).toFixed(2)
          } else {
          v1 = parseFloat(v1).toFixed(2) }
          let v2 = key.SAIDAS
          if (typeof v2 == 'string') {
          v2 = parseFloat(v2.replaceAll(".", "").replace(",", ".")).toFixed(2)
          } else {
          v2 = parseFloat(v2).toFixed(2) }
          let v3 = key.SALDO_ANTERIOR
          if (typeof v3 == 'string') {
          v3 = parseFloat(v3.replaceAll(".", "").replace(",", ".")).toFixed(2)
          } else {
          v3 = parseFloat(v3).toFixed(2) }
          let v4 = key.SALDO_ATUAL
          if (typeof v4 == 'string') {
          v4 = parseFloat(v4.replaceAll(".", "").replace(",", ".")).toFixed(2)
          } else {
          v4 = parseFloat(v4).toFixed(2) }
          let v5 = key.A_RETIRAR
          if (typeof v5 == 'string') {
          v5 = parseFloat(v5.replaceAll(".", "").replace(",", ".")).toFixed(2)
          } else {
          v5 = parseFloat(v5).toFixed(2) }
          let v6 = key.SALDO_FINAL
          if (typeof v6 == 'string') {
          v6 = parseFloat(v6.replaceAll(".", "").replace(",", ".")).toFixed(2)
          } else {
          v6 = parseFloat(v6).toFixed(2) }
          let v7 = key.TROCO
          if (typeof v7 == 'string') {
          v7 = parseFloat(v7.replaceAll(".", "").replace(",", ".")).toFixed(2)
          } else {
          v7 = parseFloat(v7).toFixed(2) }
          return { ...key, ENTRADAS: v1, SAIDAS: v2, SALDO_ANTERIOR: v3, SALDO_ATUAL: v4, A_RETIRAR: v5, SALDO_FINAL: v6, TROCO: v7 }
          }) \n`
        return retorno;
      }

      function montaComandosCamposVendas() {
        let retorno = `dados = dados.map((key) => {
          let v1 = key.VALOR 
          if (typeof v1 == 'string') {
          v1 = parseFloat(v1.replaceAll(".", "").replace(",", ".")).toFixed(2)
          } else {
          v1 = parseFloat(v1).toFixed(2) }
          let v2 = key.VALOR_VENDA
          if (typeof v2 == 'string') {
          v2 = parseFloat(v2.replaceAll(".", "").replace(",", ".")).toFixed(2)
          } else {
          v2 = parseFloat(v2).toFixed(2) }
          let v3 = key.DESCONTO
          if (typeof v3 == 'string') {
          v3 = parseFloat(v3.replaceAll(".", "").replace(",", ".")).toFixed(2)
          } else {
          v3 = parseFloat(v3).toFixed(2) }
          let v4 = key.HORA_VENDA
          let x = v4.slice(0, 10).split('-');
          let y = v4.slice(11, 19);` +
          'v4 = `${x[2]}/${x[1]}/${x[0]} ${y}`;' +
          'return { ...key, VALOR: v1, VALOR_VENDA: v2, DESCONTO: v3, HORA_VENDA: v4 }' +
          '});'
        return retorno;
      }

      $('#modal-ColunasVisiveis').on('show.bs.modal', function() {
        const cols = [];

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        if (abaAtiva == '1') {

          $('#tabelaVendas').DataTable().columns().every(function() {
            cols.push({
              'title': $(this.header()).text().trim(),
              'data': this.dataSrc()
            })
          });

          adicionaColunas(cols, colunasInvisiveis.fechamentoCaixa ?? [])
        } else if (abaAtiva == '2') {
          $('#tabelaManual').DataTable().columns().every(function() {
            cols.push({
              'title': $(this.header()).text().trim(),
              'data': this.dataSrc()
            })
          });

          adicionaColunas(cols, colunasInvisiveis.fechamentoCaixaManual ?? [])
        } else {
          $('#tabelaVendasGrid').DataTable().columns().every(function() {
            cols.push({
              'title': $(this.header()).text().trim(),
              'data': this.dataSrc()
            })
          });

          adicionaColunas(cols, colunasInvisiveis.fechamentoCaixaVendas ?? [])
        }
      })

      $('#btnSangria').on('click', async function() {
        $('#txtSangria').val('0.0');
        const moeda = await buscaMoedaDinheiro();
        insereValor('#txtMoedaSangria', moeda.CODMOE, moeda.DESCRICAO);
        $("#txtObservacaoSangria").val("");
        // $('#txtMoedaSangria').val('[0] - DINHEIRO');
      });
      $('#btnSuprimento').on('click', async function() {
        $('#txtSuprimento').val('0.0');
        const moeda = await buscaMoedaDinheiro();
        insereValor('#txtMoedaSuprimento', moeda.CODMOE, moeda.DESCRICAO);
        // $('#txtMoedaSuprimento').val('[0] - DINHEIRO');
      });

      $('#btnAnexos').on('click', async function() {
        await abreModalAnexos(pegaChave('#txtCaixa'), pegaDescricao('#txtCaixa'), 'CAIXA', $('#txtDataDe').val());
      });

      async function SangriaCupom(valor) {
        const _url = '/cupom/sangria?';
        try {
          var response = await requisicao_ecf('POST', _url, `VALOR=${(valor)}`, null);
          if (!response) {
            return false;
          }

          var jsonStr = await response.json();
          if (response.status != 200) {
            return false;
          } else {
            if (jsonStr.status == 0) {
              return true;
            } else {
              return false;
            }
          }
          await ValidaStatusCaixa();
        } catch (error) {
          console.error(error);
          return false;
        }
      }

      async function SuprimentoCupom(valor) {
        const _url = '/cupom/suprimento?';
        try {
          var response = await requisicao_ecf('POST', _url, `VALOR=${(valor)}`, null);
          if (!response) {
            return false;
          }

          var jsonStr = await response.json();
          if (response.status != 200) {
            return false
          } else {
            if (jsonStr.status == 0) {
              return true;
            } else {
              return false;
            }
          }
          await ValidaStatusCaixa();
        } catch (error) {
          console.error(error);
          return false;
        }
      }

      async function InsereSuprimentoCaixa(valor, data, caixa) {
        var Suprimento = new Object();

        Suprimento.VALOR = parseFloat(valor);
        Suprimento.DESCRICAO = 'SUPRIMENTO';
        Suprimento.TIPO = 'E';
        Suprimento.MOEDA = pegaChave($('#txtMoedaSuprimento'));
        Suprimento.DATA = data;
        Suprimento.NRCAIXA = caixa;
        Suprimento.ID_CAIXA = pegaChave('#txtID');
        Suprimento.OPERACAO = 'U';
        try {
          let response = await requisicao('POST', '/sisplan/vendas/v1/Suprimento?',
            `JSON=${encodeURIComponent(JSON.stringify(Suprimento))}`);

          if (!response) {
            return
          }
          let jsonStr = await response.json()

          if (response.status != 200) {
            msgErro(jsonStr['RESULT'][0].mensagem);
            return;
          }

          toastr.success(
            'Suprimento Cadastrada com sucesso!',
            'Confirmação', {
              toastClass: 'alert',
              iconClasses: {
                error: 'alert-error',
                info: 'alert-info',
                success: 'alert-success',
                warning: 'alert-warning'
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 3000,
              fadeOut: 1000,
              onHidden: function() {
                $("#btnConsultar").trigger("click");
                $('.bd-suprimento-modal-sm').modal('hide');
              }
            }
          ).css({
            "margin-top": "20%",
            "width": "500px",
            "max-width": "500px"
          });;

        } catch (error) {
          console.error(error);
          msgErro('Erro ao inserir o Suprimento.');
          return;
        }
      }

      async function InsereSangriaCaixa(valor, data, caixa, observacao) {
        var Sangria = new Object();

        Sangria.VALOR = parseFloat(valor);
        Sangria.DESCRICAO = 'SANGRIA ' + observacao;
        Sangria.TIPO = 'S';
        Sangria.MOEDA = pegaChave($('#txtMoedaSangria'));
        Sangria.DATA = data;
        Sangria.NRCAIXA = caixa;
        Sangria.OPERACAO = 'S';
        Sangria.ID_CAIXA = pegaChave('#txtID');
        try {
          let response = await requisicao('POST', '/sisplan/vendas/v1/Sangria?',
            `JSON=${encodeURIComponent(JSON.stringify(Sangria))}`);
          if (!response) {
            return
          }
          let jsonStr = await response.json()

          if (response.status != 200) {
            msgErro(jsonStr['RESULT'][0].mensagem);
            return;
          }
          toastr.success(
            'Sangria Cadastrada com sucesso!',
            'Confirmação', {
              toastClass: 'alert',
              iconClasses: {
                error: 'alert-error',
                info: 'alert-info',
                success: 'alert-success',
                warning: 'alert-warning'
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 3000,
              fadeOut: 1000,
              onHidden: function() {
                $("#btnConsultar").trigger("click");
                $('.bd-sangria-modal-sm').modal('hide');
              }
            }
          ).css({
            "margin-top": "20%",
            "width": "500px",
            "max-width": "500px"
          });;
        } catch (error) {
          console.error(error);
          msgErro('Erro ao inserir sangria.');
          return;
        }
      }

      function validaValorSaida(moeda, valor) {
        const dados = $('#tabelaVendas').DataTable().rows().data().toArray();
        const indice = dados.findIndex((item) => item.CODIGO == moeda);
        if (indice != -1) {
          if (valor > dados[indice].SALDO_ATUAL) {
            return false;
          }
        } else {
          return false;
        }
        return true;
      }

      $('#btnConfirmaSangria').on('click', async function() {
        try {
          $.LoadingOverlay("show");
          $('#btnConfirmaSangria').prop('disabled', true)

          try {
            const caixa = pegaChave('#txtCaixa');
            const valor = parseFloat($('#txtSangria').val().replaceAll('.', '').replace(',', '.'));
            const data = retornaDataFormatada($('#txtDataDe').val());
            const moeda = pegaChave($('#txtMoedaSangria'));
            const observacao = $("#txtObservacaoSangria").val();

            if ($('#txtMoedaSangria').val() == '') {
              msgAlerta('Moeda não pode estar vazia!');
              return;
            }

            if (!validaValorSaida(moeda, valor)) {
              msgAlerta('Valor de sangria é maior que o saldo para essa moeda, impossível continuar.');
              return;
            }

            if ((bUsaECF != 0) && (valor > 0)) {
              if (await SangriaCupom(String(valor).replaceAll('.', ','))) {
                await InsereSangriaCaixa(valor, data, caixa, observacao);
              } else {
                msgErro('Não foi possível realizar Sangria na impressora fiscal.');
                return;
              }
            } else {
              if (valor > 0) {
                await InsereSangriaCaixa(valor, data, caixa, observacao);
              } else {
                msgAlerta('Valor da Sangria precisa ser maior que 0')
              }
            }
          } catch (error) {
            msgErro('Não foi possivel cadastrar a sangria');
          }
        } finally {
          $.LoadingOverlay('hide')
          $('#btnConfirmaSangria').prop('disabled', false)
        }
      });

      //retirado replace pois ao confirmar a sangria, dizia que o valor tinha que ser acima de 0

      $('#btnConfirmaSuprimento').on('click', async function() {
        try {
          $.LoadingOverlay("show");
          $('#btnConfirmaSuprimento').prop('disabled', true);

          try {
            var caixa = pegaChave('#txtCaixa');
            var valor = parseFloat($('#txtSuprimento').val().replaceAll('.', '').replace(',', '.'));
            var data = retornaDataFormatada($('#txtDataDe').val());

            if ($('#txtMoedaSuprimento').val() == '') {
              msgAlerta('Moeda não pode estar vazia!');
              return;
            }

            if ((bUsaECF != 0) && (valor > 0)) {
              if (await SuprimentoCupom(String(valor).replaceAll('.', ','))) {
                await InsereSuprimentoCaixa(valor, data, caixa);
              } else {
                msgErro('Não foi possível realizar Suprimento na impressora fiscal.');
                return;
              }
            } else {
              if (valor > 0) {
                await InsereSuprimentoCaixa(valor, data, caixa);
              } else {
                msgAlerta('Valor do Suprimento precisa ser maior que 0.');
              }
            }
          } catch (error) {
            msgErro('Não foi possivel cadastrar o Suprimento');
          }
        } finally {
          $.LoadingOverlay('hide');
          $('#btnConfirmaSuprimento').prop('disabled', false)
        }
      });

      $('#btnConsultar').click(async function() {
        try {
          $.LoadingOverlay("show");
          var codusuario = getCookie('cod_usuario');
          var caixa = $('#txtCaixa').val().substring(1, $('#txtCaixa').val().indexOf('] - '));
          let filtros = `caixa=${caixa}&CODUSUARIO=${getCookie('cod_usuario')}&DATA=${$('#txtDataDe').val()}`;
          if (caixaDataHora) {
            if (pegaChave('#txtID') == '') {
              $('#btn-ID').trigger('click');
              return;
            }
            filtros += `&IDCAIXA=${pegaChave('#txtID')}`
          }
          var response = await requisicao('GET', '/sisplan/vendas/v1/fechamentocaixa?', filtros, null, 300000);
          $('#numeroCaixa').html(caixa);
          $('#dataCaixa').html($('#txtDataDe').val());

          if (!response) {
            $.LoadingOverlay("hide");
            return;
          }

          var jsonStr = await response.json();
          if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgAlerta(jsonStr.mensagem);
            return;
          }

          var table = criaDataTable(jsonStr[0], jsonStr[1], jsonStr[2]);
          await retornaDataFechamento();
          $('#tabelaVendas_wrapper').css("width", "100%");
          $('#modal-filtros').modal('hide');
          await ValidaStatusCaixa();
          $.LoadingOverlay("hide");
        } catch (error) {
          console.log(error);
        } finally {
          $.LoadingOverlay("hide");
        }
      });
      if (NaoTemCaixaVinculado()) {
        await VerificaUnicoRegistro();
      }
      if ($('#txtCaixa').val() != '') {
        $('#btnConsultar').trigger('click');
      }

      retornaHintRelatorio('btn-relatorio', 'Caixa')

      $("#btn-relatorio").on('click', async function() {
        try {
          $.LoadingOverlay("show");
          var caixa = pegaChave('#txtCaixa');
          if (caixa == '') {
            msgErro('Caixa não informado, necessário informar para impressão.');
            return;
          }
          var data = retornaDataFormatada($('#txtDataDe').val());
          var url = `/sisplan/impressao/v1/caixa?NR_CAIXA=${caixa}&DATA=${data}&IDCAIXA=${pegaChave('#txtID')}`;
          const bImprimeAutomatico = await verificaImprimirAutomatico('Caixa');
          var arquivo = await GeraRelatorio(url + '&', 'GET', 300000, false, 'Caixa');
          if (arquivo != undefined) {
            if (!bImprimeAutomatico) {
              window.open('./relatorios_api/pdf/' + arquivo, '_blank');
            }
            await limparRelatorios();
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      });

      async function validaMercadoriaNaoConferida() {
        try {
          if (diasConferenciaPadrao == 0) {
            return true;
          }

          if (parametrosVenda[113] != '1') {
            return true;
          }

          $.LoadingOverlay('show');
          const dataAtual = new Date();
          dataAtual.setDate(dataAtual.getDate() - Number(diasConferenciaPadrao));

          const ano = dataAtual.getFullYear();
          const mes = String(dataAtual.getMonth() + 1).padStart(2, '0');
          const dia = String(dataAtual.getDate()).padStart(2, '0');

          const dataFormatada = `${ano}-${mes}-${dia}T00:00:00Z`;

          const empId = getCookie('emp_id');
          const pesquisa = {
            tabela: "NF_CONF_ENTRA",
            camposSelect: ["SUM(QTDE - QTDE_CONFERIDA - QTDE_REJEITADA) QTDE_PENDENTE"],
            where: [`NF_CONF_ENTRA.CONFERIDA <> 'S' AND NF_CONF_ENTRA.EMP_ID = ${empId} AND NF_CONF_ENTRA.DT_SAIDA >= '${dataFormatada}'`]
          };

          const response = await requisicao("GET", "/Sisplan/Funcoes/V1/pesquisa?", `JSON=${JSON.stringify(pesquisa)}`, null);
          if (!response) {
            return false;
          }

          const jsonStr = await response.json();
          if (response.status != 200) {
            msgAlerta(jsonStr.RESULT[0].mensagem);
            return false;
          }

          if (jsonStr.RESULT[0][0].QTDE_PENDENTE > 0) {
            msgAlerta('Impossível gravar, há mercadorias não conferidas.');
            return false;
          }
          return true;
        } finally {
          $.LoadingOverlay('hide');
        }
      };



      $('#btnGravar').click(async function() {
        let caixa = $('#txtCaixa').val().substring(1, $('#txtCaixa').val().indexOf('] - '));
        if (caixa == "") {
          msgAlerta("Caixa não informado");
          return;
        }

        if (!await validaMercadoriaNaoConferida()) {
          return;
        }

        try {
          $.LoadingOverlay("show");

          let jsonVendas = JSON.stringify($('#tabelaVendas').DataTable().rows({
            search: 'applied'
          }).data().toArray());

          let response = await requisicao('POST', '/sisplan/vendas/v1/fechamentocaixa?',
            `caixa=${caixa}&CODUSUARIO=${getCookie('cod_usuario')}&DATA=${$('#txtDataDe').val()}&IDCAIXA=${pegaChave('#txtID')}`, `JSON=${jsonVendas}`, 30000);
          if (!response) {
            $.LoadingOverlay("hide");
            return;
          }

          if (response.status != 200) {
            let jsonStr = await response.json()
            $.LoadingOverlay("hide");
            msgErro(jsonStr.mensagem);
            return;
          } else {
            toastr.success(
              'Fechamento efetuado com sucesso!',
              'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                  error: 'alert-error',
                  info: 'alert-info',
                  success: 'alert-success',
                  warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden: function() {
                  $("#btnConsultar").trigger("click");
                }
              }
            ).css({
              "margin-top": "20%",
              "width": "500px",
              "max-width": "500px"
            });;
          }

          $.LoadingOverlay("hide");
        } catch (error) {
          console.log(error);
          $.LoadingOverlay("hide");
        }
      });

      $('#btnAbrir').click(async function() {

        let caixa = $('#txtCaixa').val().substring(1, $('#txtCaixa').val().indexOf('] - '));
        if (caixa == "") {
          msgAlerta("Caixa não informado");
          return;
        }

        await senhaSupervisor('', reabreCaixa, '', false, undefined, undefined, undefined, false, 'CAIXA');

      });

      async function reabreCaixa() {
        try {
          $.LoadingOverlay("show");

          let caixa = $('#txtCaixa').val().substring(1, $('#txtCaixa').val().indexOf('] - '));
          const data = retornaDataFormatada($('#txtDataDe').val());
          let response = await requisicao('POST', '/sisplan/vendas/v1/fechamentocaixa?',
            `caixa=${caixa}&CODUSUARIO=${getCookie('cod_usuario')}&DATA=${data}&REABRIR=True&IDCAIXA=${pegaChave('#txtID')}`, null);
          if (!response) {
            $.LoadingOverlay("hide");
            return;
          }

          if (response.status != 200) {
            let jsonStr = await response.json();
            $.LoadingOverlay("hide");
            msgErro(jsonStr.mensagem);
            return;
          }
          await ValidaStatusCaixa();

          $('#btnConsultar').trigger('click');
          $.LoadingOverlay("hide");
        } catch (error) {
          console.log(error)
          $.LoadingOverlay("hide");
        }
      }

      async function retornaDataFechamento() {
        if (caixaDataHora) {
          const dadosSelect = {
            tabela: 'CAIXA_F',
            camposSelect: ['DT_FIM'],
            where: [`ID = ${pegaChave('#txtID')} AND EMP_ID = ${getCookie('emp_id')}`],
          };
          const retornoSelect = await retornaJsonPesquisaPadrao(
            JSON.stringify(dadosSelect)
          );
          if (!retornoSelect) {
            return;
          }
          let retorno = retornoSelect[0].DT_FIM;
          if (retorno != null) {
            retorno = retorno.substring(0, 10).split('-');
            retorno = retorno[2] + '/' + retorno[1] + '/' + retorno[0] + retornoSelect[0].DT_FIM.substring(10);
          }
          $('#txtDataAte').val(retorno);
        }
      }

      async function buscaMoedaDinheiro() {
        let moeda;
        if (listaMoedasEmpresa.length > 0) {
          where = `CODMOE IN (${listaMoedasEmpresa.toString()})`;
          const response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?',
            `JSON={"tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO"], "where": ["${where} AND ((DESCRICAO LIKE '[PERCENTUAL]DINHEIRO[PERCENTUAL]') OR (DESCRICAO LIKE '[PERCENTUAL]EFECTIVO[PERCENTUAL]') OR (DESCRICAO LIKE '[PERCENTUAL]MONEY[PERCENTUAL]'))"]}`, null);

          if (!response) {
            $.LoadingOverlay("hide");
            moeda = {
              DESCRICAO: '',
              CODMOE: ''
            };
            return moeda;
          }

          var jsonStr = await response.json();
          if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgErro(jsonStr['RESULT'][0].mensagem);
            moeda = {
              DESCRICAO: '',
              CODMOE: ''
            };
            return moeda;
          }
          moeda = jsonStr['RESULT'][0][0];
        } else {
          moeda = await buscaValor('MOEDA', ['DESCRICAO', 'CODMOE'], 'DESCRICAO', `DINHEIRO' OR DESCRICAO = 'EFECTIVO' OR DESCRICAO = 'MONEY`);
        }
        return moeda;
      }

      async function lancamentoManual(caixa) {
        try {
          $.LoadingOverlay("show");
          $('#txtValor').val();
          let obj = {
            moeda: Number($('#rgMoeda').val()),
            valor: parseFloat($('#txtValor').val().replaceAll('.', '').replace(',', '.')),
            descricao: `${$('#txtObs').val()}`,
            tipo: `${$('#rgOperacao').val()}`,
            nrcaixa: caixa,
            data: retornaDataFormatada($('#txtDataDe').val()) + 'T00:00:00Z',
            dt_fechamento: retornaDataFormatada($('#txtDataDe').val()) + 'T00:00:00Z',
            duplicata: '',
            lancamento: 0,
            manual: 'S',
            id_caixa: pegaChave('#txtID'),
            validaTransferencia: true
          }

          const objFinan = {
            VALOR: parseFloat($('#txtValor').val().replaceAll('.', '').replace(',', '.')),
            OBS: `${$('#txtObs').val()}. Financeiro gerado através de lançamento manual do caixa ${caixa}`,
            EMP_ID: getCookie('emp_id'),
            CODCLI: pegaChave('#txtFornecedorPagar'),
            SITUACAO: pegaChave('#txtSituacaoPagar'),
            CLASSEGER: pegaChave('#txtClasseGerencialPagar'),
            BANCO: pegaChave('#txtBancoPagar'),
            CONTA: pegaChave('#txtContaPagar'),
            HISTORICO: pegaChave('#txtHistoricoPagar'),
            MOEDA: Number($('#rgMoeda').val())
          }

          if ((obj.tipo == 'S') && (!validaValorSaida(obj.moeda, obj.valor))) {
            msgAlerta('Valor de saída é maior que o saldo para essa moeda, impossível continuar.');
            $.LoadingOverlay('hide');
            return;
          }

          const jsonVendas = encodeURIComponent(JSON.stringify(obj));
          const jsonFinan = bLancaPagarSaida ? encodeURIComponent(JSON.stringify(objFinan)) : '';

          let response = await requisicao('POST', '/sisplan/vendas/v1/fechamentocaixa?',
            `caixa=${caixa}&CODUSUARIO=${getCookie('cod_usuario')}&DATA=${retornaDataFormatada($('#txtDataDe').val())}&MANUAL=True`, `JSON=${jsonVendas}&JSONFINAN=${jsonFinan}`, 3600000)

          if (!response) {
            $.LoadingOverlay("hide");
            return;
          }

          if (response.status != 200) {
            let jsonStr = await response.json();
            $.LoadingOverlay("hide");
            msgErro(jsonStr.mensagem);
            return;
          }

          const tipoRateio = obj.tipo == 'S' ? 'CP' : 'CR';
          const retorno = await response.json();
          const numero = retorno?.mensagem;
          await lancaRateio(numero, tipoRateio);

          $('#txtObs').val('');
          $('#txtValor').val('');
          $('#rgMoeda').val(obj.moeda);
          $('#rgOperacao').val('E');
          $("#btnConsultar").trigger("click");

          $.LoadingOverlay("hide");
        } catch (error) {
          console.log(error);
          $.LoadingOverlay("hide");
        }
      }

      async function lancaRateio(numero, tipoRateio) {
        if (!bLancaPagarSaida) return

        const lancaRateio = (await buscaValor('CLASSE_GER', ['LANCA_RATEIO'], 'CODIGO', pegaChave('#txtClasseGerencialPagar'))).LANCA_RATEIO;

        if (lancaRateio != 'S') return

        let lancamento = 0;
        if (tipoRateio == 'CP') {
          lancamento = (await buscaValor('PAGTO', ['LANCAMENTO'], 'NUM_AP', numero)).LANCAMENTO;
        } else {
          lancamento = (await buscaValor('RECEBER', ['LANCAMENTO'], 'NUMERO', numero)).LANCAMENTO;
        }

        $('#txtNumeroRateio').val(numero);
        $('#txtLancamentoRateio').val(lancamento);
        $('#txtClasseRateio').val(pegaChave('#txtClasseGerencialPagar'));
        $('#txtTipoRateio').val(tipoRateio);
        $('#txtValorRateio').val(parseFloat($('#txtValor').val().replaceAll('.', '').replace(',', '.')));
        $('#txtDataRateio').val(formataData(new Date()));
        $('#txtNumeroAnt').val(numero);
        $('#txtDataVencto').val(formataData(new Date()));
        $('#txtDuplicata').val('');
        $('#txtNumeroOC').val('');
        $('#txtCentroCustoFixo').val('');
        $('#txtEmpId').val(0);
        $('#modalLancRateio').modal('show');
      }

      function atualizaTotais() {
        const val_anterior = $('#tabelaVendas').DataTable().column(3, {
          search: 'none'
        }).data().sum();
        const val_entradas = $('#tabelaVendas').DataTable().column(4, {
          search: 'none'
        }).data().sum();
        const val_saidas = $('#tabelaVendas').DataTable().column(5, {
          search: 'none'
        }).data().sum();

        const val_saldo = val_entradas + val_anterior - val_saidas;

        $("#txt_val_entradas").html(parseFloat(val_entradas).toLocaleString('pt-BR', {
          style: 'currency',
          currency: 'BRL'
        }));

        $("#txt_val_saidas").html(parseFloat(val_saidas).toLocaleString('pt-BR', {
          style: 'currency',
          currency: 'BRL'
        }));

        $("#txt_val_saldo").html(parseFloat(val_saldo).toLocaleString('pt-BR', {
          style: 'currency',
          currency: 'BRL'
        }));

        $("#txt_val_saldo_anterior").html(parseFloat(val_anterior).toLocaleString('pt-BR', {
          style: 'currency',
          currency: 'BRL'
        }));
      }

      $('#btnIncluir').click(async function() {
        let caixa = $('#txtCaixa').val().substring(1, $('#txtCaixa').val().indexOf('] - '));
        if (caixa == "") {
          msgAlerta("Caixa não informado");
          return;
        }

        if (bLancaPagarSaida) {
          tipo = 'lancamentoManual';
          await carregaValoresPadroes();
          $('#modalFinanceiroSaidaManual').modal('show');
        } else {
          await lancamentoManual(caixa);
        }
      });

      function retornaDataFormatada(data) {
        if (caixaDataHora) {
          let dataFormatada = data.substring(0, 10).split('/');
          dataFormatada = dataFormatada[2] + '-' + dataFormatada[1] + '-' + dataFormatada[0];
          return dataFormatada;
        }

        return data;
      }

      async function estornarLancamentoManual(registro) {
        try {
          const caixa = pegaChave('#txtCaixa');
          const dataDe = retornaDataFormatada($('#txtDataDe').val());
          const lancamento = registro.LANCAMENTO;
          const ordem = registro.ORDEM;
          const tipo = registro.TIPO;
          const idCaixa = pegaChave('#txtID');
          let jsonStr;

          const response = await requisicao('DELETE', '/Sisplan/vendas/V1/Estornar?',
            `CAIXA=${caixa}&DATA=${dataDe}&ORDEM=${ordem}&LANCAMENTO=${lancamento}&TIPO=${tipo}&IDCAIXA=${idCaixa}`, null
          );

          if (!response) {
            return;
          }

          if (response.status != 200) {
            jsonStr = await response.json();
            msgErro(jsonStr.mensagem);
            return false;
          }

          toastr.success(
            'Lançamento manual estornado com sucesso!',
            'Confirmação', {
              toastClass: 'alert',
              iconClasses: {
                error: 'alert-error',
                info: 'alert-info',
                success: 'alert-success',
                warning: 'alert-warning'
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 3000,
              fadeOut: 1000,
              onHidden: function() {
                $('#btnConsultar').trigger('click');
              }
            }
          ).css({
            "margin-top": "20%",
            "width": "500px",
            "max-width": "500px"
          });
        } catch (error) {
          console.error(error);
          msgErro('Não foi possível estornar o lançamento manual', error)
        }
      }

      $(function() {
        $('#txtValor').maskMoney({
          decimal: ',',
          thousands: '.',
          precision: 2,
          allowZero: true,
          defaultZero: true
        });
        $(function() {
          $('#txtSangria').maskMoney({
            decimal: ',',
            thousands: '.',
            precision: 2,
            allowZero: true,
            defaultZero: true
          });
        });
        $(function() {
          $('#txtSuprimento').maskMoney({
            decimal: ',',
            thousands: '.',
            precision: 2,
            allowZero: true,
            defaultZero: true,
            reversed: true
          });
        })
      })
    })
  </script>
</body>

</html>