$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#campostuto",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtCodigo",
        popover: {
          title: "Código",
          description:
            "Esse campo é preenchido automáticamente após realizar a gravação deste registro.",
          position: "top",
        },
      },
      {
        element: "#txtDescricao",
        popover: {
          title: "Descrição",
          description:
            "Adicionamos aqui uma descrição sobre este registro.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar o tipo de baixa.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  const columns = [{ data: 'CODIGO' }, { data: 'DESCRICAO' }, { data: 'REMOVER', width: '15px' }];
  criaDataTablePadrao('#tabelaDeposito', false, false, false, false, true, false, '200px', null, columns);

  $("#btnAdicionar").pesquisa("#txtDeposito", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "orderBy": ["CODIGO"]}`, "Pesquisa Deposito", "DEPOSITO", undefined, addDeposito);

  $("#msform").validate({
    debug: false,
    ignore: "",
    rules: {
      txtCodigo: {
        required: true,
      },
      txtDescricao: {
        required: true,
      },
    },
    messages: {
      txtCodigo: {
        required: "Informe um código válido.",
      },
      txtDescricao: {
        required: "Informe uma descrição válida.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
  });

  $('#txtQtde').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  $('#txtCubagem').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  $('#txtQtdeVol').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  $("#btnVoltar").on("click", async function () {
    window.location.href = `${BASE_URI}/local`;
  });

  const local = $(window.location.href.split('/')).get(-1);

  carregaDados(local);

  $('#tabelaDeposito').on('click', '#btn-excluir', async function () {
    $("#tabelaDeposito").DataTable().row($(this).parents("tr")).remove().draw(false);
  });

  function addDeposito() {
    if (pegaValor('#txtDeposito') == '') {
      return;
    }

    if (validaDepExiste(pegaChave('#txtDeposito'))) {
      msgAlerta('Depósito já adicionado, favor verificar.');
      $('#txtDeposito').val('');
      return;
    }

    $("#tabelaDeposito").DataTable().row.add({ CODIGO: pegaChave('#txtDeposito'), DESCRICAO: pegaDescricao('#txtDeposito'), REMOVER: retornaBotaoExcluir() }).draw(false);
    $('#txtDeposito').val('');
  }

  function validaDepExiste(sDeposito) {
    let retorno = false;
    $("#tabelaDeposito").DataTable().rows().data().map(item => {
      if (item.CODIGO == sDeposito) {
        retorno = true;
      }
    });
    return retorno;
  }

  function retornaBotaoExcluir() {
    return '<div class="divBtnOpcoes"> ' +
      '       <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      '     </div>';
  }

  async function carregaDados(localBusca) {
    if (localBusca == 'create') {
      return;
    }
    $.LoadingOverlay("show");
    try {
      const pesquisaParam = {
        tabela: 'CAD_LOC_ESTOQ',
        camposSelect: [
          'CAD_LOC_ESTOQ.CODIGO', 'CAD_LOC_ESTOQ.DESCRICAO', 'CAD_LOC_ESTOQ.ATIVO', 'CAD_LOC_ESTOQ.TIPO', 'CAD_LOC_ESTOQ.QUANTIDADE', 'CAD_LOC_ESTOQ.CUBAGEM',
          'CAD_LOC_ESTOQ.QTDE_VOLUMES', 'CAD_LOC_ESTOQ.OBS', 'CAD_LOC_ESTOQ.LOCAL_PADRAO', 'LOCAL_DEP.DEPOSITO', 'DEPOSITO.DESCRICAO DESC_DEPOSITO'
        ],
        where: [`CAD_LOC_ESTOQ.CODIGO = '${localBusca}'`],
        leftJoin: [
          { tabela: 'LOCAL_DEP', condicao: 'LOCAL_DEP.LOCAL = CAD_LOC_ESTOQ.CODIGO' },
          { tabela: 'DEPOSITO', condicao: 'DEPOSITO.CODIGO = LOCAL_DEP.DEPOSITO' }
        ]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      insereValor('#txtCodigo', localBusca);
      insereValor('#txtDescricao', jsonStr[0].DESCRICAO);
      insereValor('#txtQtde', jsonStr[0].QUANTIDADE);
      insereValor('#txtCubagem', jsonStr[0].CUBAGEM);
      insereValor('#txtQtdeVol', jsonStr[0].QTDE_VOLUMES);
      insereValor('#txtObs', jsonStr[0].OBS);
      $('#radioTodos').prop('checked', jsonStr[0].TIPO == 'T');
      $('#radioProdutos').prop('checked', jsonStr[0].TIPO == 'P');
      $('#radioMateriais').prop('checked', jsonStr[0].TIPO == 'M');
      $('#cbAtivo').prop('checked', jsonStr[0].ATIVO == 'S');
      $('#cbPadrao').prop('checked', jsonStr[0].LOCAL_PADRAO == 'S');

      preencheDepositos(jsonStr);

    } finally {
      $.LoadingOverlay("hide");
    }
  }

  function preencheDepositos(jsonStr) {
    if (jsonStr[0].DEPOSITO == '') {
      return
    }

    jsonStr.map(item => {
      $("#tabelaDeposito").DataTable().row.add(
        { CODIGO: item.DEPOSITO, DESCRICAO: item.DESC_DEPOSITO, REMOVER: retornaBotaoExcluir() }
      ).draw(false);
    });
  }

  $('#btnGravar').click(async function () {
    const validator = $('#msform').validate();
    validator.form();
    const erros = validator.numberOfInvalids();

    if (erros != 0) {
      return;
    }

    $.LoadingOverlay('show');
    try {
      let arrDep = [];

      $('#tabelaDeposito').DataTable().rows().data().map(item => {
        arrDep.push({ CODIGO: item.CODIGO, DESCRICAO: item.DESCRICAO });
      });

      const local = {
        CODIGO: pegaValor('#txtCodigo') == '' ? await RetornaProximo('CAD_LOC_ESTOQ', 'CAD_LOC_ESTOQ', 'CODIGO', 0) : pegaValor('#txtCodigo'),
        DESCRICAO: pegaValor('#txtDescricao').toUpperCase(),
        OBS: pegaValor('#txtObs').toUpperCase(),
        QUANTIDADE: pegaValor('#txtQtde'),
        CUBAGEM: pegaValor('#txtCubagem'),
        QTDE_VOLUMES: pegaValor('#txtQtdeVol'),
        ATIVO: isChecked('#cbAtivo') ? 'S' : 'N',
        LOCAL_PADRAO: isChecked('#cbPadrao') ? 'S' : 'N',
        TIPO: isChecked('#radioTodos') ? 'T' : (isChecked('#radioProdutos') ? 'P' : 'M'),
        DEPOSITOS: arrDep
      };

      const response = await requisicao('POST', '/sisplan/cadastros/v1/local?', '', JSON.stringify(local), null);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        $.LoadingOverlay('hide');
        msgAlerta(jsonStr.mensagem);
        return;
      }
      $.LoadingOverlay('hide');

      criaMensagemSucesso('Cadastro efetuado com sucesso!', () => { window.location.href = `${BASE_URI}/local` })

    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
      msgAlerta(error);
    }
  });

});
