$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([
      {
        element: '#abaGeral',
        popover: {
          title: 'Campos de Filtro',
          description: 'Campos para filtrar o pedido a ser liberado.',
          position: 'bottom'
        }
      },
      {
        element: '#btnConsultar',
        popover: {
          title: 'Botão Consultar',
          description: 'Clique aqui para realizar a consulta de pedidos.',
          position: 'left'
        }
      },
      {
        element: '#btnLiberar',
        popover: {
          title: 'Botão Confirmar',
          description: 'Clique aqui para liberar/bloquear os pedidos selecionados.',
          position: 'left'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  const existePedRegra = await verificaExistePedRegra()

  if (existePedRegra) {
    $('.containerMotivo').removeClass('d-none')
    $('.periodoEntregaPadrao').addClass('d-none')
    $('.periodoEntregaMotivo').removeClass('d-none')
  } else {
    $('.containerMotivo').addClass('d-none')
    $('.periodoEntregaPadrao').removeClass('d-none')
    $('.periodoEntregaMotivo').addClass('d-none')
  }

  addPesquisaAutocompleta();

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  if (colunas == null || colunas.liberacaoFinanceiraPedidos == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, liberacaoFinanceiraPedidos: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();

      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, liberacaoFinanceiraPedidos: novasColunas }))
      $('#tabelaPedido').DataTable().columns().visible(true);
      $('#tabelaPedido').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

      $('#modal-ColunasVisiveis').modal('hide');
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaPedido').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });
    adicionaColunas(cols, colunasInvisiveis.liberacaoFinanceiraPedidos ?? [], ['Selecionar'])
  })
  /////COLUNAS INVISIVEIS

  $('#btnConsultar').on('click', async () => { await buscaPedidos() });

  $('#tabelaPedido').on('click', 'tr', async function () {
    $('.selected').removeClass('selected');
    $(this).closest('tr').addClass('selected');
    await buscaDadosPedido($(this).closest('tr')[0].children[1].innerHTML, $(this).closest('tr')[0].children[2].innerHTML);
  });

  $('#btnLiberar').on('click', async function () {
    await gravaDados();
  });

  async function gravaDados() {
    let arrPedidos = [];
    const liberarBloquear = $('#radioLiberar').prop('checked') ? '1' : '0';
    const mensagem = liberarBloquear == '0' ? pegaValor('#txtMotivo') : ''
    if (liberarBloquear == '0' && mensagem == '') {
      msgAlerta('Para prosseguir com o bloqueio de pedidos, é necessário informar o motivo.')
      return
    }

    $('.selecionado').closest('tr').map((index, item) => {
      arrPedidos.push({
        NUMERO: item.children[1].innerHTML,
        CODCLI: item.children[2].innerHTML,
        FINANCEIRO: liberarBloquear
      })
    });

    if (arrPedidos.length == 0) {
      msgAlerta('Nenhum pedido selecionado para liberar.');
      return;
    }

    const response = await requisicao('POST', '/sisplan/pedido/v1/liberapedido?', 'TELA=LIBERACAO_FINANCEIRO_WEB', JSON.stringify({ PEDIDOS: arrPedidos, MENSAGEM: mensagem }));

    if (!response) {
      $.LoadingOverlay('hide');
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      $.LoadingOverlay('hide');
      msgErro(jsonStr.mensagem);
      return;
    }
    criaMensagemSucesso('Liberação efetuada com sucesso.', () => { window.location.reload() })
  }

  async function buscaDadosPedido(sPedido, sCodcli) {
    $.LoadingOverlay('show');
    try {
      const itens = await retornaItens(sPedido);
      insereItens(itens);

      await retornaReceber(sCodcli);
    } catch (err) {
      console.error(err)
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function buscaPedidos() {
    $.LoadingOverlay('show');
    try {
      if (existePedRegra) {
        const sWhereNumPed = await retornaFiltro(true);
        const numerosPed = await retornaNumerosPed(sWhereNumPed)

        await aplicaRegraPedidos(numerosPed)
      }

      const tipoBanco = await retornaDatabase()

      const sWhere = await retornaFiltro();
      const sGroupBy = retornaGroupBy(tipoBanco);
      const dados = await retornaDados(sWhere, sGroupBy);

      if (dados.length == 0) {
        msgAlerta('Nenhum dado encontrado, favor verificar os filtros.')
        return;
      }

      insereDadosTabela(dados);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function retornaNumerosPed(sWhere) {
    const camposSelect = ['PEDIDO.NUMERO',];

    const dadosSelect = {
      tabela: 'PEDIDO',
      camposSelect,
      where: [`${sWhere}`],
      groupBy: ['PEDIDO.NUMERO']
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados do pedido.');
      return;
    }
    return retornoSelect;
  }

  $('#txtDtEmissaoDe').val('2026-01-01')
  $('#txtDtEmissaoAte').val('2026-01-31')

  async function retornaDados(sWhere, sGroupBy) {
    const listaLeftJoin = [{ tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = PEDIDO.CODCLI' },
    { tabela: 'PED_ITEN', condicao: 'PEDIDO.NUMERO = PED_ITEN.NUMERO' },
    { tabela: "VENPEDREGRAS", condicao: "VENPEDREGRAS.ID_PED = PEDIDO.ID AND VENPEDREGRAS.TIPO = 'F'" },
    { tabela: "REPRESEN", condicao: "REPRESEN.CODREP = ENTIDADE.CODREP" },
    { tabela: "PERFIL", condicao: "PERFIL.CODIGO = ENTIDADE.PERFIL" },
    { tabela: "NOTA_EMBARQUE", condicao: "NOTA_EMBARQUE.FATURA = PEDIDO.NOTA" },
    { tabela: "REGIAO", condicao: "REGIAO.REGIAO = PEDIDO.TAB_PRE" },
    { tabela: "COND_PAGTO", condicao: "CAST(COND_PAGTO.CODCOND AS VARCHAR(999)) = CAST(PEDIDO.COND_PAGTO AS VARCHAR(999))" },
    { tabela: "CONDICAO", condicao: "CAST(CONDICAO.CODCOND AS VARCHAR(999)) = CAST(PEDIDO.COND_PAGTO AS VARCHAR(999))" },
    { tabela: "PED_REGRAS", condicao: "PED_REGRAS.CODIGO = VENPEDREGRAS.COD_REGRA" }];

    const tipoBanco = await retornaDatabase();

    const campoEmissao =
      tipoBanco === 'ORACLE'
        ? 'CAST(PEDIDO.DT_EMISSAO AS VARCHAR2(4000)) EMISSAO'
        : 'PEDIDO.DT_EMISSAO EMISSAO';

    const campoObs =
      tipoBanco === 'ORACLE'
        ? 'CAST(PEDIDO.OBS AS VARCHAR2(4000)) OBS'
        : 'PEDIDO.OBS OBS';

    const camposSelect = [
      'PEDIDO.NUMERO',
      'ENTIDADE.NOME',
      'ENTIDADE.CODCLI',
      'ENTIDADE.CREDITO LIMITE',
      campoEmissao,
      'PEDIDO.COND_PAGTO COND_PAGTO',
      campoObs,
      'ENTIDADE.CNPJ CNPJ',
      'ENTIDADE.GRUPO GRUPO',
      'REPRESEN.NOME REPRESENTANTE',
      'PERFIL.CODIGO COD_PERFIL',
      'PERFIL.DESCRICAO DESC_PERFIL',
      'NOTA_EMBARQUE.DT_CADASTRO DT_EMBARQUE',
      'REGIAO.REGIAO TAB_PRECO',
      'REGIAO.DESCRICAO DESC_TABPRECO',
      'PEDIDO.COND_PAGTO PGTO',
      'CONDICAO.DESCRICAO DESC_PGTO',
      'SUM(PED_ITEN.PRECO_ORIG) - SUM(PED_ITEN.PRECO) TOTAL_DESCONTO',
      `SUM((PED_ITEN.QTDE_F [SOMA] PED_ITEN.QTDE [SOMA] PED_ITEN.QTDE_CANC) * CAST(PED_ITEN.PRECO_ORIG AS ${tipoBanco === 'ORACLE' ? 'NUMBER' : 'DECIMAL(18,5)'})) VALOR_BRUTO`,
      `SUM((PED_ITEN.QTDE_F [SOMA] PED_ITEN.QTDE [SOMA] PED_ITEN.QTDE_CANC) * CAST(PED_ITEN.PRECO AS ${tipoBanco === 'ORACLE' ? 'NUMBER' : 'DECIMAL(18,5)'})) TOTAL_LIQUIDO`,
      'VENPEDREGRAS.COD_REGRA MOTIVO',
      'PED_REGRAS.REGRA DESC_MOTIVO',
      'VENPEDREGRAS.LIBERADO',
      'SUM(PED_ITEN.QTDE) QTDE_PEND',
      `SUM(PED_ITEN.QTDE * CAST(PED_ITEN.PRECO AS ${tipoBanco === 'ORACLE' ? 'NUMBER' : 'DECIMAL(18,5)'})) VALOR_PEND`,
      'SUM(PED_ITEN.QTDE_F) QTDE_FAT',
      `SUM(PED_ITEN.QTDE_F * CAST(PED_ITEN.PRECO AS ${tipoBanco === 'ORACLE' ? 'NUMBER' : 'DECIMAL(18,5)'})) VALOR_FAT`,
      'SUM(PED_ITEN.QTDE_CANC) QTDE_CANC',
      `SUM(PED_ITEN.QTDE_CANC * CAST(PED_ITEN.PRECO AS ${tipoBanco === 'ORACLE' ? 'NUMBER' : 'DECIMAL(18,5)'})) VALOR_CANC`,
      'SUM(PED_ITEN.QTDE_F [SOMA] PED_ITEN.QTDE [SOMA] PED_ITEN.QTDE_CANC) QTDE_TOT',
      `SUM((PED_ITEN.QTDE_F [SOMA] PED_ITEN.QTDE [SOMA] PED_ITEN.QTDE_CANC) * CAST(PED_ITEN.PRECO AS ${tipoBanco === 'ORACLE' ? 'NUMBER' : 'DECIMAL(18,5)'})) VALOR_TOT`,
      'PEDIDO.ID'
    ];


    const dadosSelect = {
      tabela: 'PEDIDO',
      camposSelect,
      leftJoin: listaLeftJoin,
      where: [`${sWhere}`],
      groupBy: [sGroupBy]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados do pedido.');
      return;
    }
    return retornoSelect;
  }

  async function retornaReceber(sCodcli) {

    const dadosSelect = {
      tabela: 'RECEBER',
      camposSelect: ['RECEBER.NUMERO', 'RECEBER.DT_EMISSAO', 'RECEBER.DT_VENCTO', 'MAX(RECEBERB.DT_PAGTO) AS DT_PAGTO',
        'RECEBER.SITUACAO', 'TABSIT.DESCRICAO AS DESCSIT', 'RECEBER.VALOR2 AS VALOR', 'CADBAN.BANCO', 'CADBAN.NOME_BANCO',
        'RECEBER.VALOR_PAGO', 'RECEBER.STATUS'],
      leftJoin: [{ tabela: 'TABSIT', condicao: 'RECEBER.SITUACAO = TABSIT.CODIGO' },
      { tabela: 'RECEBERB', condicao: 'RECEBER.NUMERO = RECEBERB.NUMERO' },
      { tabela: 'CADBAN', condicao: 'CADBAN.BANCO = RECEBER.BANCO' }],
      where: [`RECEBER.CODCLI = '${sCodcli}'`,
        `((RECEBER.VALOR2 [SOMA] RECEBER.JUROS) > (RECEBER.VALOR_PAGO [SOMA] RECEBER.DESCONTO [SOMA] RECEBER.VAL_DEV))`,
        `RECEBER.STATUS NOT IN ('DESD', 'AGRU', 'CANC')`],
      groupBy: ['RECEBER.NUMERO', 'RECEBER.DT_EMISSAO', 'RECEBER.DT_VENCTO',
        'RECEBER.SITUACAO', 'TABSIT.DESCRICAO', 'RECEBER.VALOR2', 'CADBAN.BANCO', 'CADBAN.NOME_BANCO',
        'RECEBER.VALOR_PAGO', 'RECEBER.STATUS',],
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      throw new Error('Não foi possível buscar os dados do receber do pedido.')
    }

    const dataSetCols = [
      { title: "Número", data: 'NUMERO' },
      { title: "Emissão", data: 'DT_EMISSAO' },
      { title: "Vencimento", data: 'DT_VENCTO' },
      { title: "Data Pag.", data: 'DT_PAGTO' },
      { title: "Situação", data: 'SITUACAO' },
      { title: "Desc. Situação", data: 'DESCSIT' },
      { title: "Valor", data: 'VALOR' },
      { title: "Valor Pago", data: 'VALOR_PAGO' },
      { title: "Banco", data: 'BANCO' },
      { title: "Nome Banco", data: 'NOME_BANCO' },
      { title: "Status", data: 'STATUS' },
    ];

    criaDataTablePadrao('#tabelaReceber', false, false, false, false, true, true, '300px', retornoSelect, dataSetCols, [10], [1, 2, 3], [], [6, 7], {}, 2, '', '', false, [], [6, 7]);
  }

  function insereItens(sDados) {
    const dataSetCols = [];

    criaDataTablePadrao('#tabelaItens', false, false, false, false, true, false, '300px', sDados, dataSetCols, [], [], [], [], {}, 2, '', '', false, [], [4]);
  }

  async function retornaItens(sPedido) {
    const dadosSelect = {
      tabela: 'PED_ITEN',
      camposSelect: ['PED_ITEN.CODIGO', 'PRODUTO.DESCRICAO', 'PED_ITEN.COR', 'PED_ITEN.TAM', 'PED_ITEN.QTDE'],
      leftJoin: [{ tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = PED_ITEN.CODIGO' }],
      where: [`PED_ITEN.NUMERO = '${sPedido}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados dos itens.');
      return;
    }
    return retornoSelect;
  }

  function insereItens(sDados) {
    let dataSetCols = [];

    const keys = Object.keys(sDados[0]);

    for (var k in keys) {
      dataSetCols.push({
        'data': keys[k]
      });
    };

    criaDataTablePadrao('#tabelaItens', false, false, false, false, true, false, '300px', sDados, dataSetCols, [], [], [], [], {}, 2, '', '', false, [], [4]);
  }

  function insereDadosTabela(sDados) {
    const dataSetCols = [
      {
        title: "Selecionar",
        data: "SEL",
        render: function (data, type, row, meta) {
          return `<div class="icheck-primary d-inline">
                  <input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel">
                  <label for="check_col_${meta.row}_row_${meta.col}"></label>
                </div>`;
        },
      },
      { title: "Número", data: "NUMERO" },
      { title: "Codcli", data: "CODCLI" },
      {
        title: "Nome",
        data: "NOME",
        render: function (data, type, row, meta) {
          const buttonAnaliseFinan = `<i class="nav-icon fas fa-clipboard-check ml-2 icon-blue btn-analise" title="Análise Financeira"></i>`;
          const buttonBloqueioComercial = existePedRegra ? `<i class="nav-icon fas fa-info-circle ml-2 icon-red btn-bloqueios" title="Bloqueios Comerciais"></i>` : ``;
          const buttonLimiteCredito = `<i class="nav-icon fas fa-dollar-sign ml-2 icon-green btn-limite" title="Alterar Limite de Crédito"></i>`;
          return `<div data-id="${row.id}" style="cursor: pointer; display: flex; align-items: center;"> <label class="mt-2">${data}</label> <div>${buttonAnaliseFinan}${buttonBloqueioComercial}${buttonLimiteCredito}</div> </div>`;
        }
      },
      { title: "CNPJ", data: "CNPJ" },
      { title: "Representante", data: "REPRESENTANTE" },
      { title: "Grupo Econômico", data: "COD_PERFIL" },
      { title: "Desc Grupo Econômico", data: "DESC_PERFIL" },
      { title: "Motivo", data: "MOTIVO" },
      { title: "Desc Motivo", data: "DESC_MOTIVO", },
      {
        title: "Status Motivo",
        data: "LIBERADO",
        render: function (data) {
          if (data == 'N') {
            return 'Bloqueado'
          } else if (data == 'S') {
            return 'Liberado';
          }

          return ''
        },

      },
      { title: "Qtde Pendente", data: "QTDE_PEND" },
      { title: "Valor Pendente", data: "VALOR_PEND" },
      { title: "Qtde Faturado", data: "QTDE_FAT" },
      { title: "Valor Faturado", data: "VALOR_FAT" },
      { title: "Qtde Cancelado", data: "QTDE_CANC" },
      { title: "Valor Cancelado", data: "VALOR_CANC" },
      { title: "Cond. Pagto", data: "PGTO" },
      { title: "Desc Cond. Pagto", data: "DESC_PGTO" },
      { title: "Tab Preço", data: "TAB_PRECO" },
      { title: "Desc Tab Preço", data: "DESC_TABPRECO" },
      { title: "Data Embarque", data: "DT_EMBARQUE" },
      { title: "Obs", data: "OBS" },
      { title: "Limite", data: "LIMITE" },
      { title: "Valor Bruto", data: "VALOR_BRUTO" },
      { title: "Valor Liquido", data: "TOTAL_LIQUIDO" },
      { title: "Total Desconto", data: "TOTAL_DESCONTO" },

      { title: "<span style='color: var(--textDesconto);'>Qtde Total</span>", data: "QTDE_TOT" },
      { title: "<span style='color: var(--textDesconto);'>Valor Total</span>", data: "VALOR_TOT" },
      { title: "ID", data: "ID" }
    ];

    $('#tabelaPedido').DataTable({
      bPaginate: true,
      search: false,
      destroy: true,
      colReorder: true,
      order: [],
      info: false,
      filter: false,
      scrollY: '300px',
      scrollX: true,
      autoWidth: true,
      columns: dataSetCols,
      data: sDados,
      columnDefs: [
        {
          render: function (data) {
            if (data && !isNaN(data)) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            }
            return '';
          },
          targets: [11, 12, 13, 14, 15, 16, 23, 24, 25, 26, 27, 28],
          className: 'pr-4 text-right'


        },
        {
          targets: [10, 21],
          render: function (data, type) {
            if (!data) return '';
            if (type === 'display') {
              const [ano, mes, dia] = data.split('-');
              return `${dia}/${mes}/${ano}`;
            }
            return data;
          },
        },
        {
          targets: [29],
          visible: false
        }
      ],
      createdRow: function (row, data, dataIndex) {
        $('td', row).eq(27).css({ 'color': 'var(--textDesconto)', 'font-weight': 'bold' });
        $('td', row).eq(28).css({ 'color': 'var(--textDesconto)', 'font-weight': 'bold' });

        if (data.LIBERADO == 'N') {
          $('td', row).eq(10).css({ 'color': 'rgba(245, 81, 81, 1)', 'font-weight': 'bold' });
        } else if (data.LIBERADO == 'S') {
          $('td', row).eq(10).css({ 'color': 'var(--textDesconto)', 'font-weight': 'bold' });
        }
      }
    });

    $('#tabelaPedido_length').prepend('<button class="buttonColVis" id="buttonColVisPedido"><i class="fas fa-cogs"></i></button>');
    $('#tabelaPedido_length').prepend('<button class="buttonExcel" id="buttonExcelPedido"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisPedido').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelPedido').prop('title', 'Exportar')

    $('#buttonColVisPedido').on('click', async function () {
      $.LoadingOverlay('show');
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcelPedido').on('click', async function () {
      let dados = $("#tabelaPedido").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Liberacao Financeira - Pedidos', '#tabelaPedido', '', 999, false, false, dados);
    })

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaPedido').DataTable().columns(colunas.liberacaoFinanceiraPedidos ?? []).visible(false);
    $('#tabelaPedido').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.liberacaoFinanceiraPedidos).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })

    $(document).off("click", ".campoSel").on("click", ".campoSel", function () {
      $(this).toggleClass("selecionado", this.checked);
    });
  }

  async function retornaFiltro(aplicandoRegra = false) {
    let where = ' 1 = 1 ';
    where += $('#txtDtFaturaDe').val() != '' ? ` AND PEDIDO.DT_FATURA >= '${$('#txtDtFaturaDe').val()}' ` : '';
    where += $('#txtDtFaturaAte').val() != '' ? ` AND PEDIDO.DT_FATURA <= '${$('#txtDtFaturaAte').val()}' ` : '';
    where += $('#txtDtEmissaoDe').val() != '' ? ` AND PEDIDO.DT_EMISSAO >= '${$('#txtDtEmissaoDe').val()}' ` : '';
    where += $('#txtDtEmissaoAte').val() != '' ? ` AND PEDIDO.DT_EMISSAO <= '${$('#txtDtEmissaoAte').val()}' ` : '';
    where += $('#txtDtSaidaDe').val() != '' ? ` AND PEDIDO.DT_SAIDA >= '${$('#txtDtSaidaDe').val()}' ` : '';
    where += $('#txtDtSaidaAte').val() != '' ? ` AND PEDIDO.DT_SAIDA <= '${$('#txtDtSaidaAte').val()}' ` : '';
    where += $('#txtPeriodoEntDe').val() != '' ? ` AND PEDIDO.PERIODO >= '${pegaChave('#txtPeriodoEntDe')}' ` : '';
    where += $('#txtPeriodoEntAte').val() != '' ? ` AND PEDIDO.PERIODO <= '${pegaChave('#txtPeriodoEntAte')}' ` : '';
    where += $('#txtPedido').val().length > 0 ? ` AND PEDIDO.NUMERO IN (${await formataListas($('#txtPedido').val().toString())}) ` : '';
    where += $('#txtCliente').val() != '' ? ` AND PEDIDO.CODCLI = '${pegaChave('#txtCliente')}' ` : '';
    where += $('#txtRepresentante').val() != '' ? ` AND PEDIDO.CODREP = '${pegaChave('#txtRepresentante')}' ` : '';
    where += $('#txtColecao').val() != '' ? ` AND PEDIDO.COLECAO = '${pegaChave('#txtColecao')}' ` : '';
    if (aplicandoRegra) {
      where += ` AND PEDIDO.FINANCEIRO = '0' AND PEDIDO.BLOQUEIO = '0' `
    } else {
      where += $('#radioBloqVendas').prop('checked') ? ` AND PEDIDO.BLOQUEIO = '0' ` : '';
      where += $('#radioBloqFinan').prop('checked') ? ` AND PEDIDO.FINANCEIRO = '0' ` : '';
      where += $('#radioBloqFinanLibVend').prop('checked') ? ` AND (PEDIDO.BLOQUEIO = '1' AND PEDIDO.FINANCEIRO = '0') ` : '';
      where += $('#radioBloqExp').prop('checked') ? ` AND PEDIDO.FINANCEIRO = '2' ` : '';

      if (existePedRegra) {
        where += $('#txtPedRegras').val().length > 0 ? ` AND VENPEDREGRAS.COD_REGRA IN (${await formataListas($('#txtPedRegras').val().toString())}) ` : '';
        where += $('#txtSituacao').val() != '' ? ` AND VENPEDREGRAS.LIBERADO = '${pegaChave('#txtSituacao')}' ` : '';
      }
    }
    where += $('#txtStatus').val() != '' ? ` AND PEDIDO.STATUS = '${pegaChave('#txtStatus')}' ` : '';
    where += $('#txtTipoVenda').val() != '' ? ` AND PEDIDO.ID_TIPO = ${pegaChave('#txtTipoVenda')}` : ''

    where += $('#rgPedidoExpPendente').prop('checked') ? `AND (SELECT SUM(COALESCE(PEDIDO3.QTDE, 0)) QTDE FROM [PEDIDO3] PEDIDO3 where PEDIDO3.NUMERO = PEDIDO.NUMERO) > 0` : '';
    where += $('#rgPedidoSemExpedicao').prop('checked') ? `AND (SELECT SUM(COALESCE(PEDIDO3.QTDE, 0)) QTDE FROM [PEDIDO3] PEDIDO3 where PEDIDO3.NUMERO = PEDIDO.NUMERO) <= 0` : '';

    where += ` AND PEDIDO.EMP_ID = '${getCookie('emp_id')}' `;
    return where;
  }

  function retornaGroupBy(tipoBanco) {

    const groupByObs =
      tipoBanco === 'ORACLE'
        ? 'CAST(PEDIDO.OBS AS VARCHAR2(4000))'
        : 'PEDIDO.OBS';

    let groupBy = `PEDIDO.NUMERO, ENTIDADE.NOME, ENTIDADE.CODCLI, ENTIDADE.CNPJ, ENTIDADE.CREDITO, ENTIDADE.GRUPO, REPRESEN.NOME, PERFIL.CODIGO, PERFIL.DESCRICAO, NOTA_EMBARQUE.DT_CADASTRO, REGIAO.REGIAO, REGIAO.DESCRICAO, CONDICAO.CODCOND, CONDICAO.DESCRICAO, PEDIDO.COND_PAGTO, VENPEDREGRAS.COD_REGRA, ENTIDADE.CREDITO, ${groupByObs}, PEDIDO.DT_EMISSAO, PED_REGRAS.REGRA, PEDIDO.ID, VENPEDREGRAS.LIBERADO`;

    groupBy += $('#rgPedidoPendentes').prop('checked') || $('#rgPedidoExpPendente').prop('checked') || $('#rgPedidoSemExpedicao').prop('checked') ? ` HAVING SUM(COALESCE(PED_ITEN.QTDE, 0)) > 0 ` : '';
    groupBy += $('#rgPedidoFaturados').prop('checked') ? ` HAVING SUM(COALESCE(PED_ITEN.QTDE_F, 0)) > 0 ` : '';
    groupBy += $('#rgPedidoParcFat').prop('checked') ? ` HAVING SUM(COALESCE(PED_ITEN.QTDE_F, 0)) > 0 AND SUM(COALESCE(PED_ITEN.QTDE, 0)) > 0 ` : '';

    return groupBy
  }

  $('#tabelaPedido').on('click', '.btn-analise', async function () {
    const rowData = $('#tabelaPedido').DataTable().row($(this).closest('tr')).data();

    const tabAnaliseFinanceira = window.parent.document.querySelector('.content-wrapper.iframe-mode').querySelector('.tab-content').querySelector('#panel--sisplan_web-analisefinanceira')

    if (tabAnaliseFinanceira == null) {
      localStorage.setItem('clientesanalisefinanceira', `[${rowData.CODCLI}] - ${rowData.NOME}`)
      parent.document.querySelector('#menu_relatorio_analisefinanceira .nav-link').click();
    } else {
      await msgAlerta('Tela já aberta, verifique.');
    }
  });

  $('#tabelaPedido').on('click', '.btn-bloqueios', async function () {
    const rowData = $('#tabelaPedido').DataTable().row($(this).closest('tr')).data();
    const numero = rowData.NUMERO;

    $('#tituloBloqueios').html(`[${numero}] - Bloqueios Comerciais`)

    await carregaModalBloqueios(numero);
  });

  $('#tabelaPedido').on('click', '.btn-limite', async function () {
    const rowData = $('#tabelaPedido').DataTable().row($(this).closest('tr')).data();
    const codcli = rowData.CODCLI;

    $('#tituloCredito').html(`[${codcli}] - Alterar Limite de Crédito`)

    await maskInputValorCredito()
    $('#modalLimiteCredito').modal('show');
    await carregaDadosLimite(codcli)

  });

  async function carregaModalBloqueios(numero) {
    $.LoadingOverlay('show')
    try {
      const dadosSelect = {
        tabela: 'VENPEDREGRAS',
        camposSelect: ['PED_REGRAS.CODIGO, PED_REGRAS.REGRA'],
        leftJoin: [
          { tabela: 'PEDIDO', condicao: 'PEDIDO.ID = VENPEDREGRAS.ID_PED' },
          { tabela: 'PED_REGRAS', condicao: 'PED_REGRAS.CODIGO = VENPEDREGRAS.COD_REGRA' }
        ],
        where: [`PEDIDO.NUMERO = '${numero}' AND VENPEDREGRAS.TIPO = 'C'`]
      };

      const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
      if (!retornoSelect) {
        msgAlerta('Não foi possível buscar os dados dos itens.');
        return;
      }

      const dataSetCols = [
        { title: "Código", data: "CODIGO" },
        { title: "Descrição", data: "REGRA" },
      ];

      criaDataTablePadrao('#tabelaBloqueiosComerciais', false, false, false, false, true, false, '', retornoSelect, dataSetCols, [], [], [], [], {}, 2, '', '', false, [], []);
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
      $('#modalBloqueios').modal('show');
    }
  }

  $('#modalBloqueios').on('shown.bs.modal', function () {
    $('#tabelaBloqueiosComerciais').DataTable().columns.adjust().draw(false)
  })

  $('.liberarBloq').on('change', function () {
    if ($(this)[0].id == 'radioBloquear') {
      $('#divMotivo').removeClass('d-none')
    } else {
      $('#divMotivo').addClass('d-none')
    }
  })

  async function aplicaRegraPedidos(numeros) {
    const response = await requisicao('POST', '/sisplan/pedido/v1/aplicaregraped?', '', JSON.stringify({ PEDIDOS: numeros }));

    if (!response) {
      $.LoadingOverlay('hide');
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      $.LoadingOverlay('hide');
      msgErro(jsonStr.mensagem);
      return;
    }
  }

  function addPesquisaAutocompleta() {
    componenteFiltro('pedido', true)
    componenteFiltro('status', false)
    componenteFiltro('pedRegras', true)

    $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`, ["#txtCNPJ"], ["CNPJ"], ["CNPJ"]);
    $('#btn-Cliente').pesquisa_serverside(['#txtCliente', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, "Pesquisa Cliente");
    $('#btn-limpa-Cliente').on('click', function () { $('#txtCliente').val(''); });

    $('#txtRepresentante').autocompleta(1, `JSON={ "tabela":"represen", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": ["ativo = 'S' and nome <> 'CONSUMIDOR FINAL'"]}`,);
    $('#btn-Representante').pesquisa_array(['#txtRepresentante'], ['CODREP'], ['NOME'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "codrep", "nome" ], "where": ["ativo = 'S' and nome <> 'CONSUMIDOR FINAL'"]}`, "Pesquisa Represen", "represen");
    $('#btn-limpa-Representante').on('click', function () { $('#txtRepresentante').val(''); });

    $('#txtColecao').autocompleta(1, `JSON={ "tabela":"COLECAO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Colecao').pesquisa('#txtColecao', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Coleção', 'colecao');
    $('#btn-limpa-Colecao').on('click', function () { $('#txtColecao').val('') });

    $('#txtPeriodoEntDe').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-PeriodoEntDe').pesquisa('#txtPeriodoEntDe', 'PRAZO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO", "DESCRICAO"]}`, 'Pesquisa Código', 'TABPRZ');
    $('#btn-limpa-PeriodoEntDe').on('click', function () {
      $('#txtPeriodoEntDe').val('');
    });

    $('#txtPeriodoEntAte').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-PeriodoEntAte').pesquisa('#txtPeriodoEntAte', 'PRAZO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO", "DESCRICAO"]}`, 'Pesquisa Código', 'TABPRZ');
    $('#btn-limpa-PeriodoEntAte').on('click', function () {
      $('#txtPeriodoEntAte').val('');
    });

    componenteFiltro('tipo', false, false, 'TipoVenda', ["AREA = 'COM'"])
  }

  $("#btnIncluirBloqueio").on("click", function () {
    const selecionados = $(".campoSel:checked");
    try {

      if (selecionados.length <= 0) {
        throw new Error("Necessário selecionar um pedido.");
      } else if (selecionados.length > 1) {
        throw new Error("Não é permitido selecionar mais de um pedido para incluir o bloqueio.");
      }

      $("#modalIncluirBloqueio").modal("show");
      $("#modalIncluirBloqueio").prop("tela", "LIBERACAO_FINANCEIRO");

    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    }
  })

  async function maskInputValorCredito() {

    const tipoBanco = await retornaDatabase()

    const decimal =
      tipoBanco === 'ORACLE'
        ? ','
        : '.';

    $('#txtLimiteCredito').maskMoney({
      decimal: decimal,
      thousands: '',
      precision: 2
    });
  }

  $('#txtLimiteCredito').on('change', function () {
    $('#btnGravarModalLimiteCredito')
      .prop('disabled', !$(this).val())
  })

  $('#btnGravarModalLimiteCredito').on('click', async function () {
    const valorLimite = $('#txtLimiteCredito').val()
    const codcli = $('#tituloCredito').text().match(/\[(.*?)\]/)?.[1] || '';
    msgAlerta('Deseja realmente alterar o limite de crédito?',
      () => { },
      () => { },
      async () => {
        await gravarNovoLimite(valorLimite, codcli)
      }
    )
  })

  async function carregaDadosLimite(codcli) {
    const value = await buscaValor(
      'ENTIDADE',
      'CREDITO',
      'CODCLI',
      codcli
    );

    if (value) {
      const credito = value[Object.keys(value)[0]];
      $('#txtLimiteCredito').val(credito);
    }
  }


  async function gravarNovoLimite(valorLimite, codcli) {
    $.LoadingOverlay('show')
    try {
      const response = await requisicao(
        "POST",
        `/sisplan/pedido/v1/alteralimitecredito?VALOR=${valorLimite}&CODCLI=${codcli}&EMPRESA=${getCookie('empresa')}&USUARIO=${getCookie('usuario')}&TELA='LIBERACAO_FINANCEIRO'`,
        "",
        null,
        36000000
      );

      if (!response) {
        return;
      }

      if (response.status != 200) {
        let jsonStr = await response.json();
        msgErro(jsonStr.mensagem);
        return;
      }

      toastr.success("Limite de crédito alterado com sucesso!", "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          $('#modalLimiteCredito').modal('hide')
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });

    } catch (e) {
      msgErro('Não foi possível realizar a alteração do limite de crédito.')
      console.log(e)
    } finally {
      $.LoadingOverlay('hide')
      $('#btnConsultar').trigger('click')
      $('#txtLimiteCredito').val('')
    }

  }

});