$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([
      {
        element: '#abaGeral',
        popover: {
          title: 'Campos de Filtro',
          description: 'Campos para filtrar o pedido a ser liberado.',
          position: 'bottom'
        }
      },
      {
        element: '#btnConsultar',
        popover: {
          title: 'Botão Consultar',
          description: 'Clique aqui para realizar a consulta de pedidos.',
          position: 'left'
        }
      },
      {
        element: '#btnLiberar',
        popover: {
          title: 'Botão Confirmar',
          description: 'Clique aqui para liberar/bloquear os pedidos selecionados.',
          position: 'left'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  const existePedRegra = await verificaExistePedRegra()

  if (existePedRegra) {
    $('.containerMotivo').removeClass('d-none')
    $('.periodoEntregaPadrao').addClass('d-none')
    $('.periodoEntregaMotivo').removeClass('d-none')
  } else {
    $('.containerMotivo').addClass('d-none')
    $('.periodoEntregaPadrao').removeClass('d-none')
    $('.periodoEntregaMotivo').addClass('d-none')
  }

  addPesquisaAutocompleta();
  await carregaValoresPadroes()
  const parametrosVenda = await BuscaParametrosVenda();
  const bPrecoCorTam = parametrosVenda[5] == "1";

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  if (colunas == null || colunas.liberacaoComercialPedidos == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, liberacaoComercialPedidos: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();

      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, liberacaoComercialPedidos: novasColunas }))
      $('#tabelaPedido').DataTable().columns().visible(true);
      $('#tabelaPedido').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

      $('#modal-ColunasVisiveis').modal('hide');
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaPedido').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });
    adicionaColunas(cols, colunasInvisiveis.liberacaoComercialPedidos ?? [], ['Selecionar'])
  })
  /////COLUNAS INVISIVEIS

  $('#btnConsultar').on('click', async () => { await buscaPedidos() });

  $('#tabelaPedido tbody').on('click', 'input[type="checkbox"]', async function (e) {
    e.stopPropagation();
    const tabela = $('#tabelaPedido').DataTable();
    const $linha = $(this).closest('tr');
    const marcado = $(this).is(':checked');
    tabela.$('tr.selecionado').removeClass('selecionado');
    if (marcado) {
      $linha.addClass('selecionado');
      const dadosLinha = tabela.row($linha).data();
      if (dadosLinha) {
        await buscaDadosPedido(dadosLinha.NUMERO, dadosLinha.CODCLI);
      }
    } else {
      $linha.removeClass('selecionado');
    }
  });

  $('#btnLiberar').on('click', async function () {
    await gravaDados();
  });

  async function gravaDados() {
    let arrPedidos = [];
    const liberarBloquear = $('#radioLiberar').prop('checked') ? '1' : '0';
    const mensagem = liberarBloquear == '0' ? pegaValor('#txtMotivo') : ''
    if (liberarBloquear == '0' && mensagem == '') {
      msgAlerta('Para prosseguir com o bloqueio de pedidos, é necessário informar o motivo.')
      return
    }

    $('.selecionado').closest('tr').map((index, item) => {
      arrPedidos.push({
        NUMERO: item.children[1].innerHTML,
        CODCLI: item.children[2].innerHTML,
        BLOQUEIO: liberarBloquear,
      })
    });

    if (arrPedidos.length == 0) {
      msgAlerta('Nenhum pedido selecionado para liberar.');
      return;
    }

    const response = await requisicao('POST', '/sisplan/pedido/v1/liberapedido?', 'TELA=LIBERACAO_COMERCIAL_WEB', JSON.stringify({ PEDIDOS: arrPedidos, MENSAGEM: mensagem }));

    if (!response) {
      $.LoadingOverlay('hide');
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      $.LoadingOverlay('hide');
      msgErro(jsonStr.mensagem);
      return;
    }
    criaMensagemSucesso('Liberação efetuada com sucesso.', () => { window.location.reload() })
  }

  async function buscaDadosPedido(sPedido, sCodcli) {
    $.LoadingOverlay('show');
    try {
      const itens = await retornaItens(sPedido);
      insereItens(itens);

      await retornaReceber(sCodcli);

    } catch (err) {
      console.error(err)
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function buscaPedidos() {
    $.LoadingOverlay('show');
    try {
      if (existePedRegra) {
        const sWhereNumPed = await retornaFiltro(true);
        const numerosPed = await retornaNumerosPed(sWhereNumPed)

        await aplicaRegraPedidos(numerosPed)
      }

      const tipoBanco = await retornaDatabase()

      const sWhere = await retornaFiltro();
      const sGroupBy = retornaGroupBy(tipoBanco);
      const dados = await retornaDados(sWhere, sGroupBy);

      if (dados && dados.length == 0) {
        msgAlerta('Nenhum dado encontrado, favor verificar os filtros.')
        return;
      }

      insereDadosTabela(dados);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function retornaNumerosPed(sWhere) {
    const camposSelect = ['PEDIDO.NUMERO',];

    const dadosSelect = {
      tabela: 'PEDIDO',
      camposSelect,
      where: [`${sWhere}`],
      groupBy: ['PEDIDO.NUMERO']
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados do pedido.');
      return;
    }
    return retornoSelect;
  }

  async function retornaDados(sWhere, sGroupBy) {
    const listaLeftJoin = [{ tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = PEDIDO.CODCLI' },
    { tabela: 'PED_ITEN', condicao: 'PEDIDO.NUMERO = PED_ITEN.NUMERO' },
    { tabela: "VENPEDREGRAS", condicao: "VENPEDREGRAS.ID_PED = PEDIDO.ID AND VENPEDREGRAS.TIPO = 'C'" },
    { tabela: "REPRESEN", condicao: "REPRESEN.CODREP = ENTIDADE.CODREP" },
    { tabela: "PERFIL", condicao: "PERFIL.CODIGO = ENTIDADE.PERFIL" },
    { tabela: "NOTA_EMBARQUE", condicao: "NOTA_EMBARQUE.FATURA = PEDIDO.NOTA" },
    { tabela: "REGIAO", condicao: "REGIAO.REGIAO = PEDIDO.TAB_PRE" },
    { tabela: "COND_PAGTO", condicao: "CAST(COND_PAGTO.CODCOND AS VARCHAR(999)) = CAST(PEDIDO.COND_PAGTO AS VARCHAR(999))" },
    { tabela: "CONDICAO", condicao: "CAST(CONDICAO.CODCOND AS VARCHAR(999)) = CAST(PEDIDO.COND_PAGTO AS VARCHAR(999))" },
    { tabela: "PED_REGRAS", condicao: "PED_REGRAS.CODIGO = VENPEDREGRAS.COD_REGRA" }];

    const tipoBanco = await retornaDatabase();

    const campoEmissao =
      tipoBanco === 'ORACLE'
        ? 'CAST(PEDIDO.DT_EMISSAO AS VARCHAR2(4000)) EMISSAO'
        : 'PEDIDO.DT_EMISSAO EMISSAO';

    const campoObs =
      tipoBanco === 'ORACLE'
        ? 'CAST(PEDIDO.OBS AS VARCHAR2(4000)) OBS'
        : 'PEDIDO.OBS OBS';

    const camposSelect = ['PEDIDO.NUMERO',
      'ENTIDADE.NOME',
      'ENTIDADE.CODCLI',
      campoEmissao,
      'PEDIDO.COND_PAGTO COND_PAGTO',
      campoObs,
      'ENTIDADE.CNPJ CNPJ',
      'ENTIDADE.GRUPO GRUPO',
      'REPRESEN.NOME REPRESENTANTE',
      'PERFIL.CODIGO COD_PERFIL',
      'PERFIL.DESCRICAO DESC_PERFIL',
      'NOTA_EMBARQUE.DT_CADASTRO DT_EMBARQUE',
      'REGIAO.REGIAO TAB_PRECO',
      'REGIAO.DESCRICAO DESC_TABPRECO',
      'PEDIDO.COND_PAGTO PGTO',
      'CONDICAO.DESCRICAO DESC_PGTO',
      'SUM(PED_ITEN.PRECO_ORIG) - SUM(PED_ITEN.PRECO) TOTAL_DESCONTO',
      `SUM((PED_ITEN.QTDE_F [SOMA] PED_ITEN.QTDE [SOMA] PED_ITEN.QTDE_CANC) * CAST(PED_ITEN.PRECO_ORIG AS ${tipoBanco === 'ORACLE' ? 'NUMBER' : 'DECIMAL(18,5)'})) VALOR_BRUTO`,
      `SUM((PED_ITEN.QTDE_F [SOMA] PED_ITEN.QTDE [SOMA] PED_ITEN.QTDE_CANC) * CAST(PED_ITEN.PRECO AS ${tipoBanco === 'ORACLE' ? 'NUMBER' : 'DECIMAL(18,5)'})) TOTAL_LIQUIDO`,
      'VENPEDREGRAS.COD_REGRA MOTIVO',
      'PED_REGRAS.REGRA DESC_MOTIVO',
      'VENPEDREGRAS.LIBERADO',
      'SUM(PED_ITEN.QTDE) QTDE_PEND',
      'SUM(PED_ITEN.QTDE * CAST(PED_ITEN.PRECO AS DECIMAL(18,5))) VALOR_PEND',
      'SUM(PED_ITEN.QTDE_F) QTDE_FAT',
      'SUM(PED_ITEN.QTDE_F * CAST(PED_ITEN.PRECO AS DECIMAL(18,5))) VALOR_FAT',
      'SUM(PED_ITEN.QTDE_CANC) QTDE_CANC',
      'SUM(PED_ITEN.QTDE_CANC * CAST(PED_ITEN.PRECO AS DECIMAL(18,5))) VALOR_CANC',
      'SUM(PED_ITEN.QTDE_F [SOMA] PED_ITEN.QTDE [SOMA] PED_ITEN.QTDE_CANC) QTDE_TOT',
      'SUM((PED_ITEN.QTDE_F [SOMA] PED_ITEN.QTDE [SOMA] PED_ITEN.QTDE_CANC) * CAST(PED_ITEN.PRECO AS DECIMAL(18,5))) VALOR_TOT',
      'PEDIDO.ID'];

    const dadosSelect = {
      tabela: 'PEDIDO',
      camposSelect,
      leftJoin: listaLeftJoin,
      where: [`${sWhere}`],
      groupBy: [sGroupBy]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados do pedido.');
      return;
    }
    return retornoSelect;
  }

  $('#txtDtEmissaoDe').val('2026-01-01')
  $('#txtDtEmissaoAte').val('2026-01-31')

  async function retornaItens(sPedido) {
    let camposSelect = [
      'PED_ITEN.CODIGO',
      'COALESCE(PRODUTO.DESCRICAO, MATERIAL.DESCRICAO) DESCRICAO',
      'PED_ITEN.COR',
      'PED_ITEN.TAM',
      'PED_ITEN.QTDE',
      'PED_ITEN.PRECO_ORIG',
      'PED_ITEN.PRECO',
      'PED_ITEN.DESC_ITEM DESCONTO',
    ]

    let tabelasLeftJoin = [
      {
        tabela: 'PRODUTO',
        condicao: 'PRODUTO.CODIGO = PED_ITEN.CODIGO'
      },
      {
        tabela: 'MATERIAL',
        condicao: 'MATERIAL.CODIGO = PED_ITEN.CODIGO'
      }
    ]

    if (!bPrecoCorTam) {
      camposSelect = [
        ...camposSelect,
        '(((COALESCE(CAST(PED_ITEN.PRECO AS DECIMAL(18,5)),0) - COALESCE(TABPRECO.PRECO_MEDIO,0))/COALESCE(CAST(PED_ITEN.PRECO AS DECIMAL(18,5)),0))*100) MARGEM',
        'COALESCE(TABPRECO.PRECO_84,0) PRECO_G',
        'COALESCE(TABPRECO.PRECO_91,0) PRECO_D'
      ]

      tabelasLeftJoin = [
        ...tabelasLeftJoin,
        { tabela: 'TABPRECO', condicao: 'PED_ITEN.CODIGO = TABPRECO.CODIGO' }
      ]
    }

    const dadosSelect = {
      tabela: 'PED_ITEN',
      camposSelect: camposSelect,
      leftJoin: tabelasLeftJoin,
      where: [`PED_ITEN.NUMERO = '${sPedido}'`]
    };

    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados dos itens.');
      return;
    }
    return retornoSelect;
  }

  function insereItens(sDados) {
    const dataSetCols = [
      { title: "Código", data: "CODIGO" },
      { title: "Descrição", data: "DESCRICAO" },
      { title: "Cor", data: "COR" },
      { title: "Tam", data: "TAM" },
      { title: "Qtde", data: "QTDE" },
      { title: "Preço Orig.", data: "PRECO_ORIG" },
      { title: "Preço", data: "PRECO" },
      { title: "Desconto", data: "DESCONTO" },
    ];


    let colunasDecimais = [5, 6, 7]

    if (!bPrecoCorTam) {
      dataSetCols.push(
        { title: "Margem", data: "MARGEM" },
        { title: "Preço G", data: "PRECO_G" },
        { title: "Preço D", data: "PRECO_D" })
      colunasDecimais = [
        ...colunasDecimais,
        8,
        9,
        10
      ]
    }

    criaDataTablePadrao('#tabelaItens', false, false, false, false, true, false, '', sDados, dataSetCols, [], [], [], colunasDecimais, {}, 2, '', '', false, [], [4]);
    $('#tabelaItens').DataTable().columns.adjust().draw(false)
  }

  async function retornaReceber(sCodcli) {
    const dadosSelect = {
      tabela: 'RECEBER',
      camposSelect: ['RECEBER.NUMERO', 'RECEBER.DT_EMISSAO', 'RECEBER.DT_VENCTO', 'MAX(RECEBERB.DT_PAGTO) AS DT_PAGTO',
        'RECEBER.SITUACAO', 'TABSIT.DESCRICAO AS DESCSIT', 'RECEBER.VALOR2 AS VALOR', 'CADBAN.BANCO', 'CADBAN.NOME_BANCO',
        'RECEBER.VALOR_PAGO', 'RECEBER.STATUS'],
      leftJoin: [{ tabela: 'TABSIT', condicao: 'RECEBER.SITUACAO = TABSIT.CODIGO' },
      { tabela: 'RECEBERB', condicao: 'RECEBER.NUMERO = RECEBERB.NUMERO' },
      { tabela: 'CADBAN', condicao: 'CADBAN.BANCO = RECEBER.BANCO' }],
      where: [`RECEBER.CODCLI = '${sCodcli}'`,
        `((RECEBER.VALOR2 [SOMA] RECEBER.JUROS) > (RECEBER.VALOR_PAGO [SOMA] RECEBER.DESCONTO [SOMA] RECEBER.VAL_DEV))`,
        `RECEBER.STATUS NOT IN ('DESD', 'AGRU', 'CANC')`],
      groupBy: ['RECEBER.NUMERO', 'RECEBER.DT_EMISSAO', 'RECEBER.DT_VENCTO',
        'RECEBER.SITUACAO', 'TABSIT.DESCRICAO', 'RECEBER.VALOR2', 'CADBAN.BANCO', 'CADBAN.NOME_BANCO',
        'RECEBER.VALOR_PAGO', 'RECEBER.STATUS'],
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      throw new Error('Não foi possível buscar os dados do receber do pedido.')
    }

    const dataSetCols = [
      { title: "Número", data: 'NUMERO' },
      { title: "Emissão", data: 'DT_EMISSAO' },
      { title: "Vencimento", data: 'DT_VENCTO' },
      { title: "Data Pag.", data: 'DT_PAGTO' },
      { title: "Situação", data: 'SITUACAO' },
      { title: "Desc. Situação", data: 'DESCSIT' },
      { title: "Valor", data: 'VALOR' },
      { title: "Valor Pago", data: 'VALOR_PAGO' },
      { title: "Banco", data: 'BANCO' },
      { title: "Nome Banco", data: 'NOME_BANCO' },
      { title: "Status", data: 'STATUS' },
    ];

    criaDataTablePadrao('#tabelaReceber', false, false, false, false, true, true, '300px', retornoSelect, dataSetCols, [10], [1, 2, 3], [], [6, 7], {}, 2, '', '', false, [], [6, 7]);
  }

  function insereDadosTabela(sDados) {
    const dataSetCols = [
      {
        title: "Selecionar",
        data: "SEL",
        render: function (data, type, row, meta) {
          return `<div class="icheck-primary d-inline">
                  <input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel">
                  <label for="check_col_${meta.row}_row_${meta.col}"></label>
                </div>`;
        },
      },
      { title: "Número", data: "NUMERO" },
      { title: "Codcli", data: "CODCLI" },
      {
        title: "Nome",
        data: "NOME",
        render: function (data, type, row, meta) {
          const buttonAnaliseFinan = `<i class="nav-icon fas fa-clipboard-check ml-2 icon-blue btn-analise" title="Análise Financeira"></i>`;
          const buttonBloqueioFinanceiro = existePedRegra ? `<i class="nav-icon fas fa-info-circle ml-2 icon-red btn-bloqueios" title="Bloqueios Financeiros"></i>` : ``;
          return `<div data-id="${row.id}" style="cursor: pointer; display: flex; align-items: center;"> <label class="mt-2">${data}</label> <div>${buttonAnaliseFinan}${buttonBloqueioFinanceiro}</div> </div>`;
        }
      },
      { title: "CNPJ", data: "CNPJ" },
      { title: "Representante", data: "REPRESENTANTE" },
      { title: "Grupo Econômico", data: "COD_PERFIL" },
      { title: "Desc Grupo Econômico", data: "DESC_PERFIL" },
      { title: "Motivo", data: "MOTIVO" },
      { title: "Desc Motivo", data: "DESC_MOTIVO", },
      {
        title: "Status Motivo",
        data: "LIBERADO",
        render: function (data) {
          if (data == 'N') {
            return 'Bloqueado'
          } else if (data == 'S') {
            return 'Liberado';
          }

          return ''
        },

      },
      { title: "Qtde Pendente", data: "QTDE_PEND" },
      { title: "Valor Pendente", data: "VALOR_PEND" },
      { title: "Qtde Faturado", data: "QTDE_FAT" },
      { title: "Valor Faturado", data: "VALOR_FAT" },
      { title: "Qtde Cancelado", data: "QTDE_CANC" },
      { title: "Valor Cancelado", data: "VALOR_CANC" },
      { title: "Cond. Pagto", data: "PGTO" },
      { title: "Desc Cond. Pagto", data: "DESC_PGTO" },
      { title: "Tab Preço", data: "TAB_PRECO" },
      { title: "Desc Tab Preço", data: "DESC_TABPRECO" },
      { title: "Data Embarque", data: "DT_EMBARQUE" },
      { title: "Obs", data: "OBS" },
      { title: "Valor Bruto", data: "VALOR_BRUTO" },
      { title: "Valor Liquido", data: "TOTAL_LIQUIDO" },
      { title: "Total Desconto", data: "TOTAL_DESCONTO" },

      { title: "<span style='color: var(--textDesconto);'>Qtde Total</span>", data: "QTDE_TOT" },
      { title: "<span style='color: var(--textDesconto);'>Valor Total</span>", data: "VALOR_TOT" },
      { title: "ID", data: "ID" }
    ];

    $('#tabelaPedido').DataTable({
      bPaginate: true,
      search: false,
      destroy: true,
      colReorder: true,
      order: [],
      info: false,
      filter: false,
      scrollY: '300px',
      scrollX: true,
      autoWidth: true,
      columns: dataSetCols,
      data: sDados,
      columnDefs: [
        {
          render: function (data) {
            if (data && !isNaN(data)) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            }
            return '';
          },
          targets: [11, 12, 13, 14, 15, 16, 23, 24, 25, 26, 27],
          className: 'pr-4 text-right',
        },
        {
          targets: [10, 21],
          render: function (data, type) {
            if (!data) return '';
            if (type === 'display') {
              const [ano, mes, dia] = data.split('-');
              return `${dia}/${mes}/${ano}`;
            }
            return data;
          },
        },
        {
          targets: [28],
          visible: false
        }
      ],
      createdRow: function (row, data, dataIndex) {
        $('td', row).eq(26).css({ 'color': 'var(--textDesconto)', 'font-weight': 'bold' });
        $('td', row).eq(27).css({ 'color': 'var(--textDesconto)', 'font-weight': 'bold' });

        if (data.LIBERADO == 'N') {
          $('td', row).eq(10).css({ 'color': 'rgba(245, 81, 81, 1)', 'font-weight': 'bold' });
        } else if (data.LIBERADO == 'S') {
          $('td', row).eq(10).css({ 'color': 'var(--textDesconto)', 'font-weight': 'bold' });
        }
      }
    });

    $('#tabelaPedido_length').prepend('<button class="buttonColVis" id="buttonColVisPedido"><i class="fas fa-cogs"></i></button>');
    $('#tabelaPedido_length').prepend('<button class="buttonExcel" id="buttonExcelPedido"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisPedido').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelPedido').prop('title', 'Exportar')

    $('#buttonColVisPedido').on('click', async function () {
      $.LoadingOverlay('show');
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcelPedido').on('click', async function () {
      let dados = $("#tabelaPedido").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Liberacao Comercial - Pedidos', '#tabelaPedido', '', 999, false, false, dados);
    })

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaPedido').DataTable().columns(colunas.liberacaoComercialPedidos ?? []).visible(false);
    $('#tabelaPedido').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.liberacaoComercialPedidos).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })

    $(document).off("click", ".campoSel").on("click", ".campoSel", function () {
      $(this).toggleClass("selecionado", this.checked);
    });
  }

  async function retornaFiltro(aplicandoRegra = false) {
    let where = ' 1 = 1 ';
    where += $('#txtDtFaturaDe').val() != '' ? ` AND PEDIDO.DT_FATURA >= '${$('#txtDtFaturaDe').val()}' ` : '';
    where += $('#txtDtFaturaAte').val() != '' ? ` AND PEDIDO.DT_FATURA <= '${$('#txtDtFaturaAte').val()}' ` : '';
    where += $('#txtDtEmissaoDe').val() != '' ? ` AND PEDIDO.DT_EMISSAO >= '${$('#txtDtEmissaoDe').val()}' ` : '';
    where += $('#txtDtEmissaoAte').val() != '' ? ` AND PEDIDO.DT_EMISSAO <= '${$('#txtDtEmissaoAte').val()}' ` : '';
    where += $('#txtDtSaidaDe').val() != '' ? ` AND PEDIDO.DT_SAIDA >= '${$('#txtDtSaidaDe').val()}' ` : '';
    where += $('#txtDtSaidaAte').val() != '' ? ` AND PEDIDO.DT_SAIDA <= '${$('#txtDtSaidaAte').val()}' ` : '';
    where += $('#txtPeriodoEntDe').val() != '' ? ` AND PEDIDO.PERIODO >= '${pegaChave('#txtPeriodoEntDe')}' ` : '';
    where += $('#txtPeriodoEntAte').val() != '' ? ` AND PEDIDO.PERIODO <= '${pegaChave('#txtPeriodoEntAte')}' ` : '';
    where += $('#txtPedido').val().length > 0 ? ` AND PEDIDO.NUMERO IN (${await formataListas($('#txtPedido').val().toString())}) ` : '';
    where += $('#txtCliente').val() != '' ? ` AND PEDIDO.CODCLI = '${pegaChave('#txtCliente')}' ` : '';
    where += $('#txtRepresentante').val() != '' ? ` AND PEDIDO.CODREP = '${pegaChave('#txtRepresentante')}' ` : '';
    where += $('#txtColecao').val() != '' ? ` AND PEDIDO.COLECAO = '${pegaChave('#txtColecao')}' ` : '';
    if (aplicandoRegra) {
      where += ` AND PEDIDO.FINANCEIRO = '0' AND PEDIDO.BLOQUEIO = '0' `
    } else {
      where += $('#radioBloqVendas').prop('checked') ? ` AND PEDIDO.BLOQUEIO = '0' ` : '';
      where += $('#radioBloqFinan').prop('checked') ? ` AND PEDIDO.FINANCEIRO = '0' ` : '';
      where += $('#radioBloqVendLibFinan').prop('checked') ? ` AND (PEDIDO.BLOQUEIO = '0' AND PEDIDO.FINANCEIRO = '1') ` : '';
      where += $('#radioBloqExp').prop('checked') ? ` AND PEDIDO.FINANCEIRO = '2' ` : '';

      if (existePedRegra) {
        where += $('#txtPedRegras').val().length > 0 ? ` AND VENPEDREGRAS.COD_REGRA IN (${await formataListas($('#txtPedRegras').val().toString())}) ` : '';
        where += $('#txtSituacao').val() != '' ? ` AND VENPEDREGRAS.LIBERADO = '${pegaChave('#txtSituacao')}' ` : '';
      }
    }
    where += $('#txtStatus').val() != '' ? ` AND PEDIDO.STATUS = '${pegaChave('#txtStatus')}' ` : '';
    where += $('#txtTipoVenda').val() != '' ? ` AND PEDIDO.ID_TIPO = ${pegaChave('#txtTipoVenda')}` : ''

    where += $('#rgPedidoExpPendente').prop('checked') ? `AND (SELECT SUM(COALESCE(PEDIDO3.QTDE, 0)) QTDE FROM [PEDIDO3] PEDIDO3 where PEDIDO3.NUMERO = PEDIDO.NUMERO) > 0` : '';
    where += $('#rgPedidoSemExpedicao').prop('checked') ? `AND (SELECT SUM(COALESCE(PEDIDO3.QTDE, 0)) QTDE FROM [PEDIDO3] PEDIDO3 where PEDIDO3.NUMERO = PEDIDO.NUMERO) <= 0` : '';

    where += ` AND PEDIDO.EMP_ID = '${getCookie('emp_id')}' `;
    return where;
  }

  function retornaGroupBy(tipoBanco) {

    const groupByObs =
      tipoBanco === 'ORACLE'
        ? 'CAST(PEDIDO.OBS AS VARCHAR2(4000))'
        : 'PEDIDO.OBS';

    let groupBy = `PEDIDO.NUMERO, ENTIDADE.NOME, ENTIDADE.CODCLI, ENTIDADE.CNPJ, ENTIDADE.CREDITO, ENTIDADE.GRUPO, REPRESEN.NOME, PERFIL.CODIGO, PERFIL.DESCRICAO, NOTA_EMBARQUE.DT_CADASTRO, REGIAO.REGIAO, REGIAO.DESCRICAO, CONDICAO.CODCOND, CONDICAO.DESCRICAO, PEDIDO.COND_PAGTO, VENPEDREGRAS.COD_REGRA, ${groupByObs}, PEDIDO.DT_EMISSAO, PED_REGRAS.REGRA, PEDIDO.ID, VENPEDREGRAS.LIBERADO`;

    groupBy += $('#rgPedidoPendentes').prop('checked') || $('#rgPedidoExpPendente').prop('checked') || $('#rgPedidoSemExpedicao').prop('checked') ? ` HAVING SUM(COALESCE(PED_ITEN.QTDE, 0)) > 0 ` : '';
    groupBy += $('#rgPedidoFaturados').prop('checked') ? ` HAVING SUM(COALESCE(PED_ITEN.QTDE_F, 0)) > 0 ` : '';
    groupBy += $('#rgPedidoParcFat').prop('checked') ? ` HAVING SUM(COALESCE(PED_ITEN.QTDE_F, 0)) > 0 AND SUM(COALESCE(PED_ITEN.QTDE, 0)) > 0 ` : '';

    return groupBy
  }

  $('#tabelaPedido').on('click', '.btn-analise', async function () {
    const rowData = $('#tabelaPedido').DataTable().row($(this).closest('tr')).data();

    const tabAnaliseFinanceira = window.parent.document.querySelector('.content-wrapper.iframe-mode').querySelector('.tab-content').querySelector('#panel--sisplan_web-analisefinanceira')

    if (tabAnaliseFinanceira == null) {
      localStorage.setItem('clientesanalisefinanceira', `[${rowData.CODCLI}] - ${rowData.NOME}`)
      parent.document.querySelector('#menu_relatorio_analisefinanceira .nav-link').click();
    } else {
      await msgAlerta('Tela já aberta, verifique.');
    }
  });

  $('#tabelaPedido').on('click', '.btn-bloqueios', async function () {
    const rowData = $('#tabelaPedido').DataTable().row($(this).closest('tr')).data();
    const numero = rowData.NUMERO;

    $('#tituloBloqueios').html(`[${numero}] - Bloqueios Financeiros`)

    await carregaModalBloqueios(numero);
  });

  async function carregaModalBloqueios(numero) {
    $.LoadingOverlay('show')
    try {
      const dadosSelect = {
        tabela: 'VENPEDREGRAS',
        camposSelect: ['PED_REGRAS.CODIGO, PED_REGRAS.REGRA'],
        leftJoin: [
          { tabela: 'PEDIDO', condicao: 'PEDIDO.ID = VENPEDREGRAS.ID_PED' },
          { tabela: 'PED_REGRAS', condicao: 'PED_REGRAS.CODIGO = VENPEDREGRAS.COD_REGRA' }
        ],
        where: [`PEDIDO.NUMERO = '${numero}' AND VENPEDREGRAS.TIPO = 'F'`]
      };

      const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
      if (!retornoSelect) {
        msgAlerta('Não foi possível buscar os dados dos itens.');
        return;
      }

      const dataSetCols = [
        { title: "Código", data: "CODIGO" },
        { title: "Descrição", data: "REGRA" },
      ];

      criaDataTablePadrao('#tabelaBloqueiosFinanceiros', false, false, false, false, true, false, '', retornoSelect, dataSetCols, [], [], [], [], {}, 2, '', '', false, [], []);
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
      $('#modalBloqueios').modal('show');
    }
  }

  $('#modalBloqueios').on('shown.bs.modal', function () {
    $('#tabelaBloqueiosFinanceiros').DataTable().columns.adjust().draw(false)
  })

  async function carregaValoresPadroes() {
    try {
      const jsonStr = await buscaValoresPadroes('PEDIDO')

      jsonStr.map(async item => {
        switch (item.CAMPO) {
          case 'STATUS_LIB_COMERCIAL': {
            insereValor('#txtStatus', item.VALOR, { tabela: 'SITPROD', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR })
            break;
          }
          default:
            break;
        }
      });
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível buscar os valores padrões.`)
    }
  };

  $('.liberarBloq').on('change', function () {
    if ($(this)[0].id == 'radioBloquear') {
      $('#divMotivo').removeClass('d-none')
    } else {
      $('#divMotivo').addClass('d-none')
    }
  })

  async function aplicaRegraPedidos(numeros) {
    const response = await requisicao('POST', '/sisplan/pedido/v1/aplicaregraped?', '', JSON.stringify({ PEDIDOS: numeros }));

    if (!response) {
      $.LoadingOverlay('hide');
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      $.LoadingOverlay('hide');
      msgErro(jsonStr.mensagem);
      return;
    }
  }

  function addPesquisaAutocompleta() {
    componenteFiltro('pedido', true)
    componenteFiltro('status', false)
    componenteFiltro('pedRegras', true)

    $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`, ["#txtCNPJ"], ["CNPJ"], ["CNPJ"]);
    $('#btn-Cliente').pesquisa_serverside(['#txtCliente', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, "Pesquisa Cliente");
    $('#btn-limpa-Cliente').on('click', function () { $('#txtCliente').val(''); });

    $('#txtRepresentante').autocompleta(1, `JSON={ "tabela":"represen", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": ["ativo = 'S' and nome <> 'CONSUMIDOR FINAL'"]}`,);
    $('#btn-Representante').pesquisa_array(['#txtRepresentante'], ['CODREP'], ['NOME'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "codrep", "nome" ], "where": ["ativo = 'S' and nome <> 'CONSUMIDOR FINAL'"]}`, "Pesquisa Represen", "represen");
    $('#btn-limpa-Representante').on('click', function () { $('#txtRepresentante').val(''); });

    $('#txtColecao').autocompleta(1, `JSON={ "tabela":"COLECAO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Colecao').pesquisa('#txtColecao', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Coleção', 'colecao');
    $('#btn-limpa-Colecao').on('click', function () { $('#txtColecao').val('') });

    $('#txtPeriodoEntDe').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-PeriodoEntDe').pesquisa('#txtPeriodoEntDe', 'PRAZO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO", "DESCRICAO"]}`, 'Pesquisa Código', 'TABPRZ');
    $('#btn-limpa-PeriodoEntDe').on('click', function () {
      $('#txtPeriodoEntDe').val('');
    });

    $('#txtPeriodoEntAte').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-PeriodoEntAte').pesquisa('#txtPeriodoEntAte', 'PRAZO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO", "DESCRICAO"]}`, 'Pesquisa Código', 'TABPRZ');
    $('#btn-limpa-PeriodoEntAte').on('click', function () {
      $('#txtPeriodoEntAte').val('');
    });

    componenteFiltro('tipo', false, false, 'TipoVenda', ["AREA = 'COM'"])
  }

  $("#btnIncluirBloqueio").on("click", function () {
    const selecionados = $(".campoSel:checked");
    try {

      if (selecionados.length <= 0) {
        throw new Error("Necessário selecionar um pedido.");
      } else if (selecionados.length > 1) {
        throw new Error("Não é permitido selecionar mais de um pedido para incluir o bloqueio.");
      }

      $("#modalIncluirBloqueio").modal("show");
      $("#modalIncluirBloqueio").prop("tela", "LIBERACAO_COMERCIAL");

    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    }
  })

});