$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([
            {
                element: '#btnNovoGrupo',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de um grupo.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaGrupo',
                popover: {
                    title: 'Tabela Grupos',
                    description: 'Aqui estão os dados dos grupos cadastrados.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("GRUPODASH");

    

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
          '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
          '      ' + data + ' ' +
          '    </button> ' +
          '    <div class="dropdown-menu"> ' +
          '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
          '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  '+
          '</div>';
        return retorno;
      };

    consultaGrupos();

    async function consultaGrupos() {
        try {

            $.LoadingOverlay("show");
            const response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', 'JSON={ "tabela":"grupo_dash_web", "camposSelect":[ "id", "descricao"], "where": null}', null);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            $('#tabelaGrupo').DataTable({
                destroy: true,
                lengthChange: false,
                serverside: true,
                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": [{
                    "data": "ID"
                },
                {
                    "data": "DESCRICAO"
                },
                ],
                "columnDefs": [{
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                      }
                }]
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        }

    }

    $('#btnNovoGrupo').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "grupo_dash/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $('#tabelaGrupo').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            const data = $('#tabelaGrupo').DataTable().row($(this).parents('tr')).data();
            window.location.href = `grupo_dash/${data.ID}`;
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaGrupo').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            const data = $('#tabelaGrupo').DataTable().row($(this)).data();
            window.location.href = `grupo_dash/${data.ID}`;
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaGrupo').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaGrupo").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/sisplan/dashboard/v1/dash_grupo_web?", `ID=${encodeURIComponent(valorLinha.ID)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }
});