$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#tutorialConteudo",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtCodigo",
        popover: {
          title: "Código",
          description:
            "Aqui adicionamos o código para o Enquadramento IPI.",
          position: "top",
        },
      },
      {
        element: "#selectGrupo",
        popover: {
          title: "Grupo CST",
          description:
            "Neste campo escolhemos o grupo CST para o Enquadramento IPI.",
          position: "top",
        },
      },
      {
        element: "#txtDescricao",
        popover: {
          title: "Descrição",
          description:
            "Neste campo adicionamos a descrição para o Enquadramento IPI.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar o cadastro.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let enquadra = parametros[parametros.length - 1];

  $("#btnVoltar").on("click", async function () {
    await deletaRegistro("ENQUADRA", getCookie("usuario"), enquadra);
    window.location.href = `${BASE_URI}/enquadra`;
  });

  $(document).ready(async function () {
    $("#msform").validate({
      debug: false,
      ignore: "",
      rules: {
        txtCodigo: {
          required: true,
        },
        txtDescricao: {
          required: true,
        },
      },
      messages: {
        txtCodigo: {
          required: "Informe um código válido.",
        },
        txtDescricao: {
          required: "Informe uma descrição válida.",
        },
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });

    if (enquadra != "" && enquadra != "create") {
      if ((await liberarRegistro("ENQUADRA", enquadra)) == false) {
        window.location.href = "../enquadra";
      } else {
        $("#txtCodigo").attr("readonly", true);
        carregaDados(enquadra);
      }
    }

    async function carregaDados(enquadraEdit) {
      try {
        $.LoadingOverlay("show");
        try {
          let response = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ 
                            "tabela":"enquadra", 
                            "camposSelect":["codigo", "descricao", "grupo_cst"], 
                            "where": ["codigo = '${enquadraEdit}'"]}`,
            null
          );
          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          $("#txtCodigo").val(jsonStr.RESULT[0][0].CODIGO);
          $("#txtDescricao").val(jsonStr.RESULT[0][0].DESCRICAO);
          $("#selectGrupo").val(jsonStr.RESULT[0][0].GRUPO_CST);
        } catch (error) {
          console.error(error);
          msgErro(`Não foi possível buscar os dados do preço: ${error}`);
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }

    $(".radio-group .radio").click(function () {
      $(this).parent().find(".radio").removeClass("selected");
      $(this).addClass("selected");
    });

    $(".submit").click(function () {
      return false;
    });
  });

  $("#txtCodigo").change(async function () {
    try {
      $.LoadingOverlay("show");
      try {
        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"enquadra", 
                "camposSelect":["codigo"], 
                "where": ["codigo = '${$("#txtCodigo").val()}'"]}`,
          null
        );

        if (!response) {
          return;
        }
        let jsonStr = await response.json();
        if (jsonStr.RESULT[0].length > 0) {
          msgAlerta("Enquadramento IPI já cadastrado.");
          $("#txtCodigo").val("");
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $("#btnGravar").click(async function () {
    try {
      let validator = $("#msform").validate();
      validator.form();
      let erros = 0;
      erros = validator.numberOfInvalids();

      if (erros == 0) {
        $.LoadingOverlay("show");

        let enquadraClasse = {};

        enquadraClasse.CODIGO = $("#txtCodigo").val();
        enquadraClasse.DESCRICAO = $("#txtDescricao").val();
        enquadraClasse.GRUPO_CST = $("#selectGrupo").val();

        let response = await requisicao(
          "POST",
          "/Sisplan/Cadastros/v1/enquadra?",
          `JSON=${encodeURIComponent(JSON.stringify(enquadraClasse))}`,
          null
        );

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr
          .success("Cadastro efetuado com sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              window.location.href = `${BASE_URI}/enquadra`;
            },
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      }
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
      msgErro(`Não foi possível gravar os dados da situação: ${error}`);
    }
  });
});
