$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnNovoDeposito",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para iniciar o cadastro de um depósito.",
          position: "right",
        },
      },
      {
        element: "#tabelaDeposito",
        popover: {
          title: "Tabela Depósitos",
          description: "Aqui estão os dados dos depósitos cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});
$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("DEPOSITO");

  // autocompleta
  $("#txtSetorConsulta").autocompleta(
    1,
    `JSON={ "tabela":"cadfluxo", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );
  $("#txtClienteConsulta").autocompleta(
    3,
    `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`
  );
  $("#txtDepositoConsulta").autocompleta(
    1,
    `JSON={ "tabela":"deposito", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );
  // pesquisa
  $("#btn-Setor").pesquisa(
    "#txtSetorConsulta",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadfluxo", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Setor",
    "cadfluxo"
  );
  $("#btn-Cliente").pesquisa(
    "#txtClienteConsulta",
    "CODCLI",
    "NOME",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}`,
    "Pesquisa Cliente",
    "entidade"
  );
  $("#btn-deposito").pesquisa(
    "#txtDepositoConsulta",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"deposito", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Depósito",
    "deposito"
  );
  // limpa campos
  $("#btn-limpa-Setor").on("click", function () {
    $("#txtSetorConsulta").val("");
  });

  $("#btn-limpa-Cliente").on("click", function () {
    $("#txtClienteConsulta").val("");
  });

  $("#btn-limpa-deposito").on("click", function () {
    $("#txtDepositoConsulta").val("");
  });

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnNovoDeposito").on("click", function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "deposito/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });


  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  consultaDeposito();

  $("#btnConsultar").on("click", async function () {
    $("#modal-filtros").modal("hide");
    await consultaDeposito(true);
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtDepositoConsulta").val("");
    $("#txtSetorConsulta").val("");
    $("#txtClienteConsulta").val("");
  });

  async function consultaDeposito(bBotao = false) {
    try {
      $.LoadingOverlay("show");
      let response;
      let setor =
        pegaChave("#txtSetorConsulta") != ""
          ? ` AND SETOR = '${pegaChave("#txtSetorConsulta")}'`
          : "";
      let cliente =
        pegaChave("#txtClienteConsulta") != ""
          ? ` AND CODCLI = '${pegaChave("#txtClienteConsulta")}'`
          : "";
      let deposito =
        pegaChave("#txtDepositoConsulta") != ""
          ? ` AND CODIGO = '${pegaChave("#txtDepositoConsulta")}'`
          : "";

      if (bBotao) {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          `JSON={ "tabela":"deposito", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["1=1 ${setor} ${cliente} ${deposito}"]}`,
          null
        );
      } else {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          `JSON={ "tabela":"deposito", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`,
          null
        );
      }

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      if (colunasInvisiveis == null || colunasInvisiveis.acessoCadDeposito == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadDeposito: ['EMPRESA'] }));
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      }

      $("#tabelaDeposito").DataTable({
        destroy: true,
        lengthChange: true,
        paging: true,
        searching: true,
        scrollX: true,
        scrollY: '350px',
        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "CODIGO",
            title: "Código"
          },
          {
            data: "DESCRICAO",
            title: "Descrição"
          },
        ],
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });

      $('#tabelaDeposito_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaDeposito_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const dados = $("#tabelaDeposito").DataTable().data().toArray();
        await exportaCSV("", "", undefined, null, 'Relatório da aba de acesso cadastro de Depósito', '', '', 999, false, false, dados);
      });

      $('#tabelaDeposito').DataTable().columns().every(function () {
        if ((colunasInvisiveis.acessoCadDeposito).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
      msgErro(`Não foi possível buscar os dados do cliente: ${error}`);
    }
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaDeposito').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            });
        });

        adicionaColunas(cols, colunasInvisiveis.acessoCadDeposito ?? ['EMPRESA']);
    });

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            removeColunasFixas(novasColunas, ["CODIGO"]);
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadDeposito: novasColunas }));

            $('#tabelaDeposito').DataTable().columns().visible(true);

            $('#tabelaDeposito').DataTable().columns().every(function () {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    });

  $("#tabelaDeposito").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaDeposito")
        .DataTable()
        .row($(this).parents("tr"))
        .data();
      let registroLiberado = await verificarRegistro("DEPOSITO", data.CODIGO);
      if (registroLiberado) {
        window.location.href = `deposito/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaDeposito").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaDeposito").DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro("DEPOSITO", data.CODIGO);
      if (registroLiberado) {
        window.location.href = `deposito/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaDeposito').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaDeposito").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/deposito?", `CODIGODEPOSITO=${encodeURIComponent(valorLinha.CODIGO)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }
});
