$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true
    });

    driver.defineSteps([{
      element: '#conteudo',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para o cadastro.',
        position: 'top'
      }
    },
    {
      element: '#txtDataIni',
      popover: {
        title: 'Cotação De:',
        description: 'Data de Início da cotação deste registro.',
        position: 'top'
      }
    },
    {
      element: '#txtDataFim',
      popover: {
        title: 'Cotação Até:',
        description: 'Data de Fim da cotação deste registro',
        position: 'top'
      }
    },
    {
      element: '#slMes',
      popover: {
        title: 'Data por Mês',
        description: 'Ao selecionar o mês, e confirmar, é aplicado a data de inicial e final do mês escolhido.',
        position: 'top'
      }
    },
    {
      element: '#defineMes',
      popover: {
        title: 'Confirmação do Mês',
        description: 'Clique aqui para confirmar o mês selecionado.',
        position: 'top'
      }
    },
    {
      element: '#txtConsultaMoeda',
      popover: {
        title: 'Moeda da Cotação',
        description: 'Aqui, definimos a moeda que usaremos na cotação deste registro.',
        position: 'top'
      }
    },
    {
      element: '#txtValorCompra',
      popover: {
        title: 'Valor de Compra',
        description: 'Aqui, definimos o valor de compra desta cotação.',
        position: 'top'
      }
    },
    {
      element: '#txtValorVenda',
      popover: {
        title: 'Valor de Venda',
        description: 'Aqui, definimos o valor de venda desta cotação.',
        position: 'top'
      }
    },
    {
      element: '#txtValorVenda',
      popover: {
        title: 'Valor de Venda',
        description: 'Aqui, definimos o valor de venda desta cotação.',
        position: 'top'
      }
    },
    {
      element: '#btnBC',
      popover: {
        title: 'Cotação do Banco Central',
        description: 'Ao clicar, abre uma tela para pesquisa de cotações por moeda no Banco Central.',
        position: 'top'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "left",
      },
    },
    {
      element: '#btnGravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar a Cotação de Moeda.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let cotacaoMoeda = parametros[parametros.length - 1];

  let moeda;
  let data;

  if (cotacaoMoeda != "" && cotacaoMoeda != "create") {
    const resultadoStatus = cotacaoMoeda.split('&');
    moeda = resultadoStatus[0];
    data = resultadoStatus[1].split('-').join('/');
    try {
      $.LoadingOverlay("show");
      try {
        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"VALOR_MOEDA", 
          "camposSelect":[
          "DATA", "MOEDA","VALOR_COMPRA", "VALOR, DT_COTACAO"
          ],
          "where": ["MOEDA = '${moeda}'", "DATA = '${data}'"]}`,
          null
        );

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          msgAlerta(jsonStr.RESULT[0].mensagem);
          return;
        }

        let dtCotacao = jsonStr.RESULT[0][0].DT_COTACAO;
        if (dtCotacao.includes(' ')) {
          dtCotacao = dtCotacao.split(' ')[0];
        }

        $("#txtDataIni").val(dtCotacao);
        $('#txtDataFim').val(dtCotacao);
        descricaoMoeda = await buscaValor("MOEDA", "DESCRICAO", "CODMOE", `${moeda}`);
        insereValor('#txtConsultaMoeda', moeda, descricaoMoeda.DESCRICAO);
        $('#txtValorCompra').val(jsonStr.RESULT[0][0].VALOR_COMPRA);
        $('#txtValorVenda').val(jsonStr.RESULT[0][0].VALOR);

        $('#txtDataIni, #txtDataFim, #txtConsultaMoeda, #btnConsultaMoeda, #btnLimpaMoeda, #slMes, #defineMes').prop('disabled', true);

      } catch (error) {
        console.error(error);
        msgAlerta(`Não foi possível buscar os dados:`);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/cotacao_moeda`;
  })

  $(function () {
    $('#txtValorVenda, #txtValorCompra').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 4,
    })
  })

  $('#txtConsultaMoeda').autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE chave", "DESCRICAO descricao"], "where": null}`);
  $('#btnConsultaMoeda').pesquisa('#txtConsultaMoeda', 'CODMOE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":["CODMOE", "DESCRICAO"]}`, 'Consulta Tipo Fiscal', 'MOEDA');
  $('#btnLimpaMoeda').on('click', () => { $('#txtConsultaMoeda').val('') });

  //Preenche datas
  $('#defineMes').on('click', function () {
    gerarDiasMes()
  })

  $('#txtDataIni').on('blur', function () {
    const dataSelecionada = new Date($(this).val());
    const agora = new Date();

    console.log('Data selecionada:', dataSelecionada);
    console.log('Data atual:', agora);

    // Verifica se a data selecionada é menor que a data atual
    if (dataSelecionada < agora) {
      msgAlerta('A data de início da cotação não pode ser anterior à data atual.');
      $(this).val(agora.toISOString().split('T')[0]); // Define a data atual como valor do campo
    }
  });

  let tabelaCadastroCotacao = $('#tabelaCadastroCotacao').DataTable({
    columsDefs: [
      {
        render(data) {
          return parseFloat(data).toLocaleString("pt-BR", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2
          });
        },
        targets: [2, 3],
      },
    ]
  });

  //Confirma as informações e alimenta tabela para gravação
  $('#btnConfirmar').on('click', function () {
    tabelaCadastroCotacao.clear().draw();
    const fields = [
      { id: '#txtDataIni', message: 'Preencha o campo "Data de Cotação De"' },
      { id: '#txtDataFim', message: 'Preencha o campo "Data de Cotação Até"' },
      { id: '#txtConsultaMoeda', message: 'Preencha o campo "Moeda"' },
      { id: '#txtValorCompra', message: 'Preencha o campo "Valor Compra"' },
      { id: '#txtValorVenda', message: 'Preencha o campo "Valor Venda"' }
    ];

    for (const field of fields) {
      if ($(field.id).val() == '') {
        msgAlerta(field.message);
        return;
      }
    }
    let moeda = pegaChave('#txtConsultaMoeda');
    let descricao = pegaDescricao('#txtConsultaMoeda');
    let valorCompra = $('#txtValorCompra').val();
    let valorVenda = $('#txtValorVenda').val();
    let dataIniStr = $('#txtDataIni').val();
    let dataFimStr = $('#txtDataFim').val();

    let dataIniParts = dataIniStr.split('-');
    let dataFimParts = dataFimStr.split('-');
    let dataIni = new Date(dataIniParts[0], dataIniParts[1] - 1, dataIniParts[2]);
    let dataFim = new Date(dataFimParts[0], dataFimParts[1] - 1, dataFimParts[2]);
    {
      for (let d = new Date(dataIni); d <= dataFim; d.setDate(d.getDate() + 1)) {
        let dia = ('0' + d.getDate()).slice(-2);
        let mes = ('0' + (d.getMonth() + 1)).slice(-2);
        let ano = d.getFullYear();
        let data = `${dia}/${mes}/${ano}`;
        tabelaCadastroCotacao.row.add([
          moeda,
          descricao,
          valorCompra,
          valorVenda,
          data,
          false // Indentificador se a cotação é oficial ou não
        ]).draw(false);
      }
    }
  });

  $('#btnGravar').on('click', async function () {
    await gravarCotacao()
  })

  async function gravarCotacao() {
    $.LoadingOverlay('show')
    try {
      const tabelaCadastroCotacao = $('#tabelaCadastroCotacao').DataTable();
      const registrostabelaCadastroCotacao = tabelaCadastroCotacao.rows().data();
      if (registrostabelaCadastroCotacao.length === 0) {
        msgAlerta('Nenhum item encontrado na tabela!');
        return;
      }

      const cotacoes = [];

      tabelaCadastroCotacao.rows().every(function () {
        const data = this.data();
        const itemTabela = {
          moeda: data[0],
          valorCompra: data[2],
          valorVenda: data[3],
          data: data[4],
          cotacaoOficial: data[5] === 'S' ? 'S' : 'N'
        };
        cotacoes.push(itemTabela);
      });

      let response = await requisicao('POST', '/sisplan/cadastros/v1/gravacotacoes?', '', `LISTACOTACOES=${(JSON.stringify({ ListaCotacaoMoeda: cotacoes }))}`, 360000);


      if (!response) {
        $.LoadingOverlay("hide");
        return;
      };

      if (response.status != 200) {
        let jsonStr = await response.json();
        $.LoadingOverlay("hide");
        msgErro(jsonStr.mensagem);
        return;
      }
      $.LoadingOverlay("hide");
      toastr.success(
        `Cadastro efetuado com sucesso!`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/cotacao_moeda`;
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });
    } catch (err) {
      console.log(err);
      msgAlerta('Não foi possivel gravar os dados.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  //Função que alimenta os campos de data de cotação, os intervalos do mês selecionado
  function gerarDiasMes() {
    let mesSelecionado = parseInt($('#slMes').val());
    let dataAtual = new Date();
    let mesAtual = dataAtual.getMonth() + 1;
    let anoAtual = dataAtual.getFullYear();

    if (mesSelecionado < mesAtual) {
      msgAlerta('Data informada não pode ser menor que a data atual!');
    } else {
      let primeiroDia, ultimoDia;
      if (mesSelecionado === mesAtual) {
        primeiroDia = dataAtual.toISOString().split('T')[0];
        ultimoDia = new Date(anoAtual, mesAtual, 0).toISOString().split('T')[0];
      } else {
        primeiroDia = new Date(anoAtual, mesSelecionado - 1, 1).toISOString().split('T')[0];
        ultimoDia = new Date(anoAtual, mesSelecionado, 0).toISOString().split('T')[0];
      }

      $('#txtDataIni').val(primeiroDia);
      $('#txtDataFim').val(ultimoDia);
    }
  }

  // Modal Banco Central
  $('#txtConsultaMoedaBC').autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE chave", "DESCRICAO descricao"], "where": null}`);
  $('#btnConsultaMoedaBC').pesquisa('#txtConsultaMoedaBC', 'CODMOE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":["CODMOE", "DESCRICAO"]}`, 'Consulta Tipo Fiscal', 'MOEDA');
  $('#btnLimpaMoedaBC').on('click', () => { $('#txtConsultaMoedaBC').val('') });

  $('#btnBC').on('click', () => { $('#modalBancoCentral').modal('show') });

  await defineDataAnterior('#txtDataIniModalBC');
  await defineDataAnterior('#txtDataFimModalBC');

  $('#btnConsultarBC').on('click', async function () {
    const fields = [
      { id: '#txtDataIniModalBC', message: 'Preencha o campo "Data de Cotação De"' },
      { id: '#txtDataFimModalBC', message: 'Preencha o campo "Data de Cotação Até"' },
      { id: '#txtConsultaMoedaBC', message: 'Preencha o campo "Moeda"' },
    ];

    for (const field of fields) {
      if ($(field.id).val() === '') {
        msgAlerta(field.message);
        return;
      }
    }

    let dataIni = new Date($('#txtDataIniModalBC').val());
    let dataFim = new Date($('#txtDataFimModalBC').val());
    let dataAtual = new Date();
    dataAtual.setHours(0, 0, 0, 0); //compara apenas a data sem considerar a hora

    if (dataFim > dataAtual) {
      msgAlerta('Data até informada não pode ser maior que a data atual');
      return;
    }

    if (dataIni > dataAtual) {
      msgAlerta('Data inicial informada não pode ser maior que a data atual');
      return;
    }
    await fazConsulta();
  });

  async function buscaParametros() {
    let pDtConsultaIni = $('#txtDataIniModalBC').val();
    let pDtConsultaFim = $('#txtDataFimModalBC').val();
    let pMoeda = pegaChave("#txtConsultaMoedaBC");


    let retorno =
      `DTCONSULTAINIMODALBC=${pDtConsultaIni}` +
      `&DTCONSULTAFIMMODALBC=${pDtConsultaFim}` +
      `&MOEDA=${pMoeda}` +
      `&COTACAOMOEDA=true`;
    return retorno;
  };

  async function fazConsulta() {
    try {
      $.LoadingOverlay("show");
      let params = await buscaParametros();
      let response = await requisicao('GET', '/sisplan/cadastros/v1/cotacaobc?', params, '', 15000);

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgAlerta(jsonStr[0] && jsonStr[0].mensagem ? jsonStr[0].mensagem : 'Erro na consulta');
        return;
      }

      if (!jsonStr || jsonStr.length === 0) {
        $.LoadingOverlay("hide");
        msgAlerta('Nenhum registro encontrado para esta moeda.');
        $('#tabelaCotacaoBC').DataTable().clear().draw();
        return;
      }

      let tabelaCotacaoBC = $('#tabelaCotacaoBC').DataTable({
        columns: [
          { title: "Data" },
          { title: "Valor Compra" },
          { title: "Valor Venda" },
          { title: "Cotação Oficial" }
        ],
        columnDefs: [
          {
            render(data, type, row, meta) {
              if (type === 'display' && meta.col == 1 || meta.col == 2) {
                return parseFloat(data).toLocaleString("pt-BR", { maximumFractionDigits: 4 });
              }
              return data;
            },
            targets: [1, 2],
          }
        ],
        destroy: true
      });

      $('#tabelaCotacaoBC tbody').on('click', 'tr', function () {
        if ($(this).hasClass('selected')) {
          $(this).removeClass('selected');
        } else {
          tabelaCotacaoBC.$('tr.selected').removeClass('selected');
          $(this).addClass('selected');
        }
      });

      tabelaCotacaoBC.clear().draw();

      jsonStr.forEach((cotacao) => {
        let valorCompra = cotacao.TAXACOMPRA;
        let valorVenda = cotacao.TAXAVENDA;
        let data = cotacao.DATA;

        let dataParts = data.split(' ');
        let dataSemTraco = dataParts[0].split('-');
        let dataFormatada = `${dataSemTraco[2]}/${dataSemTraco[1]}/${dataSemTraco[0]}`;

        tabelaCotacaoBC.row.add([
          dataFormatada,
          valorCompra,
          valorVenda,
          'S'
        ]).draw(false);
      });
      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  $('#btnConfirmarBC').on('click', async function () {
    const tabelaCotacaoBC = $('#tabelaCotacaoBC').DataTable();
    const linhaSelecionada = tabelaCotacaoBC.row('.selected').data();

    if (!linhaSelecionada) {
      msgAlerta("Por favor, selecione uma linha antes de confirmar.");
      return;
    }

    const valorCompra = linhaSelecionada[1];
    const valorVenda = linhaSelecionada[2];
    const cotacaoOficial = linhaSelecionada[3];
    let moeda = pegaChave('#txtConsultaMoedaBC');

    $('#txtValorCompra').val(valorCompra);
    $('#txtValorVenda').val(valorVenda);
    descricaoMoeda = await buscaValor("MOEDA", "DESCRICAO", "CODMOE", `${moeda}`);
    insereValor('#txtConsultaMoeda', moeda, descricaoMoeda.DESCRICAO);
    $('#txtValorVenda').val(valorVenda);

    let dataIniStr = $('#txtDataIni').val();
    let dataIniParts = dataIniStr.split('-');
    let dataIni = new Date(dataIniParts[0], dataIniParts[1] - 1, dataIniParts[2]);
    let dia = ('0' + dataIni.getDate()).slice(-2);
    let mes = ('0' + (dataIni.getMonth() + 1)).slice(-2);
    let ano = dataIni.getFullYear();
    let data = `${dia}/${mes}/${ano}`;

    $('#tabelaCadastroCotacao').DataTable().row.add([
      moeda,
      descricaoMoeda.DESCRICAO,
      valorCompra,
      valorVenda,
      data,
      cotacaoOficial // Adiciona a informação de cotacao oficial
    ]).draw(false);

    tabelaCotacaoBC.clear().draw();
    $('#modalBancoCentral').modal('hide');
  });

  async function defineDataAnterior(inputId) {
    const inputData = $(inputId);
    const hoje = new Date();
    hoje.setDate(hoje.getDate() - 1);
    const dataAnterior = hoje.toISOString().split('T')[0];
    inputData.val(dataAnterior);

    inputData.on('blur', function () {
      const dataSelecionada = new Date($(this).val());
      const agora = new Date();
      const horaAtual = agora.getHours();
      const minutosAtuais = agora.getMinutes();

      console.log('Data selecionada:', dataSelecionada);
      console.log('Data atual:', agora);
      console.log('Hora atual:', horaAtual);
      console.log('Minutos atuais:', minutosAtuais);

      // Verifica se a data selecionada é igual à data atual e se é antes das 13:30
      if (dataSelecionada.toISOString().split('T')[0] === agora.toISOString().split('T')[0] &&
        (horaAtual < 13 || (horaAtual === 13 && minutosAtuais < 30))) {
        msgAlerta('A cotação do dólar só é liberada após as 13h30. Selecione uma data anterior.');
        $(this).val(dataAnterior);
      }
    });
  }

});
