$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([{
      element: '#btnFiltros',
      popover: {
        title: 'Botão Filtros',
        description: 'Clique aqui para filtrar a consulta da tabela de LOG.',
        position: 'right'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(function () {
  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnLimparFiltros").on("click", function () {
    LimpaCamposFiltro();
  });

  $("#btnConsultar").on("click", async function () {
    $("#modal-filtros").modal("hide");
    await ConsultaLogs($('.abaLink.active')[0].id != 'tabLogs');
  });

  $('.abaLink').on('click', function () {
    const infoBtn = $('#btnInfoAcao')

    if (this.id === 'tabLogs') {
      $('#divForm').removeClass('d-none')
      $('#divTabela').addClass('d-none')
      $('#lblAcao').text('Ação: ')
      $('#lblAcao').append(infoBtn)
      infoBtn.attr('title', 'Este campo faz a busca da coluna Descrição na tabela de Log')
      $('#txtAcao').attr('placeholder', 'Ação')
    } else {
      $('#divForm').addClass('d-none')
      $('#divTabela').removeClass('d-none')
      $('#lblAcao').text('Alteração: ')
      $('#lblAcao').append(infoBtn)
      infoBtn.attr('title', 'Este campo faz a busca da coluna Alteração na tabela de Log_Alteracao')
      $('#txtAcao').attr('placeholder', 'Alteração')
    }
  })

  preencheOrdenacaoTela('RelLog')
  retornaHintRelatorio('btnImprimir', 'RelLog')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/imprimirrellog?`;
        const ordem = `&TELA_ORDENACAO=RelLog&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const filtros = await retornaFiltros();
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelLog');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelLog');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function retornaFiltros(logAlteracao = false) {
    const usuario = $('#txtUsuario').val()
    const empresa = pegaChave('#txtEmpresa')
    const acao = $('#txtAcao').val()
    const chave = $('#txtChave').val()
    const form = $('#txtForm').val()
    const tela = $('#txtTela').val()
    const dataIni = $('#txtDataIni').val()
    const dataFim = $('#txtDataFim').val()
    const tabela = $('#txtTabela').val()

    const filtros =
      `USER=${usuario}&` +
      `EMP=${empresa}&` +
      `ACAO=${acao}&` +
      `CHAVE=${chave}&` +
      `FORM=${form}&` +
      `DATAINI=${dataIni}&` +
      `DATAFIM=${dataFim}&` +
      `TELA=${tela}&` +
      `LOGALTERACAO=${logAlteracao}&` +
      `TABELA=${tabela}`;

    return filtros;
  }

  $("#txtEmpresa").autocompleta(1, `JSON={ "tabela":"empresa", "camposSelect":[ "emp_pat chave", "emp_nome descricao"], "where": null}`);
  $("#btn-empresa").pesquisa("#txtEmpresa", "EMP_PAT", "EMP_NOME", `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"empresa", "camposSelect":[ "EMP_PAT", "EMP_NOME"]}`, "Pesquisa Empresa", "empresa");
  $("#btn-limpa-empresa").on("click", function () {
    $("#txtEmpresa").val('');
  });

  function LimpaCamposFiltro() {
    $("#txtUsuario").val("");
    $("#txtEmpresa").val("");
    $("#txtAcao").val("");
    $("#txtChave").val("");
    $("#txtTela").val("");
    $("#txtForm").val("");
    $('#txtDataIni').val('1200-01-01');
    $('#txtDataFim').val('2500-12-01');
  };

  async function ConsultaLogs(logAlteracao = false) {
    $.LoadingOverlay('show')
    try {
      const url = '/sisplan/log/v1/consultalog?';
      const filtros = await retornaFiltros(logAlteracao)
      const response = await requisicao('GET', url, filtros, ``, 360000);

      const json = await response.json()

      if (json) {
        const { resultado, mensagem } = json
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        if (!logAlteracao) {
          if ($.fn.DataTable.isDataTable('#tabelaLogs')) {
            $('#tabelaLogs').DataTable().destroy()
            $('#tabelaLogs').empty()
          }

          const dataSetCols = [
            { title: "Chave", data: "chave" },
            { title: "Data", data: "data" },
            { title: "Descrição", data: "descricao" },
            { title: "Empresa", data: "empresa" },
            {
              title: "Hora",
              data: "hora",
              render (data) {
                return retornarDataISOEmYMD({
                  dataISO: data,
                  incluirHora: true,
                  separadorData: '/',
                  usarUTC: true
                });
              }
            },
            { title: "Operação", data: "operacao" },
            { title: "Tela", data: "tela" },
            { title: "Usuário", data: "usuario" },
            { title: "Form", data: "form" },
          ]

          $('#tabelaLogs').DataTable({
            destroy: true,
            autoWidth: true,
            data: resultado.logs,
            columns: dataSetCols,
            columnDefs: [
              {
                type: 'date-br',
                targets: [1],
                render: function (data) {
                  if (data != undefined && data != '') {
                    x = data.slice(0, 10).split('-');
                    return `${x[2]}/${x[1]}/${x[0]}`;
                  } else {
                    return ''
                  }
                }
              },]
          });

        } else {

          if ($.fn.DataTable.isDataTable('#tabelaLogAlteracao')) {
            $('#tabelaLogAlteracao').DataTable().destroy()
            $('#tabelaLogAlteracao').empty()
          }

          const dataSetCols = [
            {
              title: "Data",
              data: "dataHora",
              render: function (data) {
                return retornarDataISOEmYMD({
                  dataISO: data,
                  incluirHora: true,
                  separadorData: '/'
                })
              }
            },
            { title: "Chave", data: "campoChave" },
            { title: "Empresa", data: "empresa" },
            { title: "Tabela", data: "tabela" },
            { title: "Tela", data: "tela" },
            { title: "Usuário", data: "usuario" },
            { title: "Alteração", data: "alteracao" },
          ]

          $('#tabelaLogAlteracao').DataTable({
            destroy: true,
            autoWidth: true,
            data: resultado.logs,
            columns: dataSetCols,
            scrollX: true,
          });

          let tabelaDetalhes = null;

          $('#tabelaLogAlteracao tbody').on('click', 'tr', function () {
            const tabelaPrincipal = $('#tabelaLogAlteracao').DataTable();

            if ($(this).hasClass('selected')) {
              $(this).removeClass('selected');
              $('#txtLogDetalhe').val('');

              if ($.fn.DataTable.isDataTable('#tabelaDetalhesLog')) {
                tabelaDetalhes.clear().draw();
              }

            } else {
              tabelaPrincipal.$('tr.selected').removeClass('selected');
              $(this).addClass('selected');

              const dados = tabelaPrincipal.row(this).data();
              $('#txtLogDetalhe').val(dados.alteracao || '');

              const sAlteracao = dados.alteracao || '';
              const hasAntNovo = sAlteracao.includes('Ant.') && sAlteracao.includes('Novo.');

              let mapaCampos = {};

              if (/Campo:/.test(sAlteracao)) {
                /* quando é --> Campo: <nome> Ant. <valor> | Nov. <valor> */
                const campos = sAlteracao.split(/Campo:/).map(x => x.trim()).filter(x => x);

                campos.forEach(str => {
                  const match = str.match(/^([^\s]+)\s+Ant\.\s*(.*?)\s*\|\s*Nov\.\s*(.*)$/);
                  if (match) {
                    const campo = match[1].trim();
                    const antigo = match[2].trim();
                    const novo = match[3].trim();
                    mapaCampos[campo] = { campo, Antigo: antigo, Novo: novo };
                  }
                });

              } else if (hasAntNovo) {
                /* quando é  --> Ant.<nome>=<valor> | Nov.<nome>=<valor> */
                const regexAntNovo = /(Ant\.[^=]+=[\s\S]*?)(?=Ant\.|Novo\.|$)|(Novo\.[^=]+=[\s\S]*?)(?=Ant\.|Novo\.|$)/g;
                let linhas = [...sAlteracao.matchAll(regexAntNovo)].map(m => m[0].trim());
                linhas = linhas.map(linha => linha.replace(/\|$/, '').trim());

                linhas.forEach(linha => {
                  const [chave, ...resto] = linha.split('=');
                  let valor = resto.join('=').trim();
                  valor = valor.replace(/^\|/, '').replace(/\|$/, '');

                  if (!chave) return;

                  let tipo = null;
                  let campo = chave;

                  if (chave.startsWith('Ant.')) {
                    tipo = 'Antigo';
                    campo = chave.replace('Ant.', '');
                  } else if (chave.startsWith('Novo.')) {
                    tipo = 'Novo';
                    campo = chave.replace('Novo.', '');
                  } else {
                    tipo = hasAntNovo ? null : 'Novo';
                  }

                  if (!mapaCampos[campo]) mapaCampos[campo] = { campo, Antigo: '', Novo: '' };
                  if (tipo) mapaCampos[campo][tipo] = valor;
                });

              } else {
                /* quando não cai em bosta nenhuma e é separado por --> ; */
                const linhas = sAlteracao.split(';').map(x => x.trim()).filter(x => x);
                linhas.forEach(linha => {
                  const [campo, ...resto] = linha.split('=');
                  const valor = resto.join('=').trim();
                  if (!campo) return;
                  mapaCampos[campo] = { campo, Antigo: '', Novo: valor };
                });
              }

              const dataSetDetalhes = Object.values(mapaCampos);

              if ($.fn.DataTable.isDataTable('#tabelaDetalhesLog')) {
                tabelaDetalhes.destroy();
                $('#tabelaDetalhesLog tbody').empty();
              }

              tabelaDetalhes = $('#tabelaDetalhesLog').DataTable({
                data: dataSetDetalhes,
                columns: [
                  { title: 'Campo', data: 'campo' },
                  { title: 'Antigo', data: 'Antigo' },
                  { title: 'Novo', data: 'Novo' }
                ],
                scrollY: '400px',
                scrollCollapse: true,
                paging: false,
                searching: false,
                info: false,
                autoWidth: true
              });
            }
          });

        }
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  };

});
