$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    })
    driver.defineSteps([
      {
        element: "#tutorial-step1",
        popover: {
          title: "Campos",
          description:
            "Aqui se encontram os campos essenciais para consultar e gravar as informações.",
          position: "bottom",
        },
      },
      {
        element: '#btnVoltar',
        popover: {
          title: 'Voltar',
          description: 'Aqui está o botão para voltar à consulta.',
          position: 'bottom'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Gravar',
          description: 'Aqui está o botão para gravar as informações.',
          position: 'bottom'
        }
      }
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  componenteFiltro('cotacao', true, true)
  componenteFiltro('solicitacao', true, true)
  componenteFiltro('fornecedor', true, true)
  componenteFiltro('itemCotacao', true, true, 'Codigo')
  componenteFiltro('cor', true, true)
  componenteFiltro('tamanho2', true, true, 'Tamanho')
  componenteFiltro('funcionario', true, true, 'Solicitante')
  componenteFiltro('centroCusto', true, true)
  componenteFiltro('tipo', true, true)
  componenteFiltro('grupoMA', true, true, 'GrupoMaterial', ["TIPO = 'M'"])
  componenteFiltro('grupoPA', true, true, 'GrupoProduto')
  componenteFiltro('grupoMA', true, true, 'GrupoServico', ["TIPO = 'S'"])
  componenteFiltro('subGrupo', true, true, 'SubgrupoMaterial')

  $('#btnConsultar').on('click', function () {
    consultar()
    $('#modalFiltros').modal('hide')
  })

  function consultar() {
    ItensCotacaoCancelados.retornarFiltros()
      .then((filtros) => {
        ItensCotacaoCancelados.criarTabelaItens({ filtros })
      })
    ItensCotacaoCancelados.idsSelecionados.clear()
  }

  $("#tabelaItens").on('change', '.checkSel', function () {
    const linha = $(this).closest('tr')
    const [data] = $('#tabelaItens').DataTable().rows(linha).data().toArray()
    const { id } = data
    const isChecked = this.checked
    $(linha).toggleClass('selected', isChecked)

    if (!isChecked) {
      ItensCotacaoCancelados.idsSelecionados.delete(id)
      return
    }

    ItensCotacaoCancelados.idsSelecionados.add(id)
  })

  PerfilCotacoes.preencherFiltrosPerfilCompras().then((result) => {
    if (!result) {
      return
    }
    consultar()
  })

  function limparFiltros() {
    $('#txtCotacao').empty().trigger('change')
    $('#txtSolicitacao').empty().trigger('change')
    $('#txtFornecedor').empty().trigger('change')
    $('#txtCodigo').empty().trigger('change')
    $('#txtCor').empty().trigger('change')
    $('#txtTamanho').empty().trigger('change')
    $('#txtSolicitante').empty().trigger('change')
    if (!$('#txtCentroCusto').prop('disabled')) {
      $('#txtCentroCusto').empty().trigger('change')
    }
    if (!$('#txtTipo').prop('disabled')) {
      $('#txtTipo').empty().trigger('change')
    }
    $('#txtCodigoFornecedor').val('')
    $('#txtCorFornecedor').val('')
    if (!$('#txtGrupoMaterial').prop('disabled')) {
      $('#txtGrupoMaterial').empty().trigger('change')
    }
    if (!$('#txtGrupoProduto').prop('disabled')) {
      $('#txtGrupoProduto').empty().trigger('change')
    }
    if (!$('#txtGrupoServico').prop('disabled')) {
      $('#txtGrupoServico').empty().trigger('change')
    }
    if (!$('#txtSubgrupoMaterial').prop('disabled')) {
      $('#txtSubgrupoMaterial').empty().trigger('change')
    }
    $('#txtValidadeDe').val('1200-01-01')
    $('#txtValidadeAte').val('2500-12-31')
  }

  $('#btnLimparFiltros').on('click', function () {
    limparFiltros()
  })

  $('#btnFiltros').on('click', function () {
    $('#modalFiltros').modal('show')
  })

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/central_compras`
  })
})

window.ItensCotacaoCancelados = window.ItensCotacaoCancelados || {}

ItensCotacaoCancelados.idsSelecionados = new Set()

ItensCotacaoCancelados.criarTabelaItens = () => {
  if ($.fn.DataTable.isDataTable('#tabelaItens')) {
    $('#tabelaItens').DataTable().destroy()
    $('#tabelaItens').empty()
  }

  const columns = [
    {
      data: 'sel',
      title: `<div class="icheck-primary d-inline">
                <input type="checkbox" id="cbSelAll">
                <label for="cbSelAll"></label>
              </div>
              `,
      render: (_data, _type, _row, { row: rowIndex, col: colIndex }) => (
        `<div class="icheck-primary d-inline">
          <input type="checkbox" id="check_col_${colIndex}_row_${rowIndex}" class="checkSel">
          <label for="check_col_${colIndex}_row_${rowIndex}"></label>
        </div>`
      )
    },
    {
      data: 'numero',
      title: 'Número',
    },
    {
      data: 'fornecedor',
      title: 'Fornecedor',
    },
    {
      data: 'nome',
      title: 'Nome',
    },
    {
      data: 'codigo',
      title: 'Código',
    },
    {
      data: 'descricao',
      title: 'Descrição',
    },
    {
      data: 'cor',
      title: 'Cor',
    },
    {
      data: 'codigoItemFornecedor',
      title: 'Código Fornecedor',
    },
    {
      data: 'descricaoItemFornecedor',
      title: 'Descrição Fornecedor',
    },
    {
      data: 'corItemFornecedor',
      title: 'Cor Fornecedor',
    },
    {
      data: 'fatorConversaoFornecedor',
      title: 'Fator Conversão Fornecedor',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'condicao',
      title: 'Condição',
    },
    {
      data: 'desconto',
      title: 'Desconto',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'frete',
      title: 'Frete',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'icms',
      title: 'Icms',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'quantidadeCotada',
      title: 'Quantidade Cotada',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'validade',
      title: 'Validade',
      render: function (data) {
        return retornarDataISOEmYMD({ dataISO: data, reverso: true, usarUTC: true })
      }
    },
    {
      data: 'situacao',
      title: 'Situação',
    },
    {
      data: 'status',
      title: 'Status',
    },
    {
      data: 'id',
      title: 'Id',
      visible: false,
    },
  ]

  $('#tabelaItens').DataTable({
    sort: false,
    paging: true,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    pageLength: 23,
    colReorder: true,
    serverSide: true,
    ajax: {
      url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/centralcompras/cotacao/v1/itenscancelados`,
      type: "POST",
      headers: {
        'Authorization': getCookie('accessToken') ? 'Bearer ' + getCookie('accessToken') : '',
      },
      data: function (data) {
        const { start, length, draw } = data;
        return JSON.stringify({
          filtros: {},
          paginacao: {
            quantidadeMaximaRegistros: length,
            quantidadeRegistrosPular: start,
            contadorRequisicoes: draw,
          },
          empresa: getCookie('empresa'),
        })
      },
      dataSrc: function (json) {
        if (!json || !json.data) {
          return []
        }
        return json.data
      },
      cache: true,
      beforeSend: function () {
        $.LoadingOverlay('show')
      },
      complete: function () {
        $.LoadingOverlay('hide')
      },
    },
    autoWidth: true,
    columns,
    scrollX: true,
    scrollY: '737px',
    rowCallback: function (row, data) {
      const ids = [...ItensCotacaoCancelados.idsSelecionados]
      const isChecked = ids?.some(item => item === data.id) ?? false
      $(row).toggleClass('selected', isChecked)
      const checkbox = $(row).find('.checkSel')
      $(checkbox).prop('checked', isChecked)
    },
  })
  ItensCotacaoCancelados.adicionarEventoSelecionarTodos()
  UtilsCentralCompras.criarContainerBotoes({
    tabela: 'tabelaItens',
  })
  UtilsCentralCompras.habilitarEsconderColunas({
    tabela: 'tabelaItens',
    tela: 'ItensCotacaoCancelados',
  })
  UtilsCentralCompras.habilitarExportarCsv({
    tabela: 'tabelaItens',
    status: 'C',
    tipo: 'COT',
    retornarFiltros: ItensCotacaoCancelados.retornarFiltros,
  })
}

ItensCotacaoCancelados.adicionarEventoSelecionarTodos = () => {
  $('#cbSelAll').off('change')
  $('#cbSelAll').on('change', async function () {
    const isChecked = this.checked
    const table = $('#tabelaItens').DataTable()
    if (!isChecked) {
      ItensCotacaoCancelados.idsSelecionados.clear()
      table.draw(false)
      return
    }

    const filtros = await ItensCotacaoCancelados.retornarFiltros()

    $.LoadingOverlay('show')
    requisicao(
      'POST',
      `/sisplan/centralcompras/cotacao/v1/selecionartodositenscancelados?`,
      '',
      JSON.stringify({ filtros, status: 'R' }),
      3600000
    ).then(async (response) => {
      const json = await response.json()

      if (json) {
        const { resultado, mensagem } = json
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }
        if (!resultado)
          throw new Error('Ids não foram buscados corretamente do back-end.')

        const { ids } = resultado
        ids?.forEach((id) => ItensCotacaoCancelados.idsSelecionados.add(id))
      }
      table.draw(false)
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao selecionar todos os itens.')
    }).finally(() => $.LoadingOverlay('hide'))
  })
}

ItensCotacaoCancelados.retornarFiltros = async function () {
  const cotacao = await formataListas($('#txtCotacao').val().toString())
  const solicitacao = await formataListas($('#txtSolicitacao').val().toString())
  const fornecedor = await formataListas($('#txtFornecedor').val().toString())
  const codigo = await formataListas($('#txtCodigo').val().toString())
  const cor = await formataListas($('#txtCor').val().toString())
  const tamanho = await formataListas($('#txtTamanho').val().toString())
  const solicitante = await formataListas($('#txtSolicitante').val().toString())
  const centroCusto = await formataListas($('#txtCentroCusto').val().toString())
  const codigoFornecedor = $('#txtCodigoFornecedor').val()
  const corFornecedor = $('#txtCorFornecedor').val()
  const validadeDe = $('#txtValidadeDe').val() || '1200-01-01'
  const validadeAte = $('#txtValidadeAte').val() || '1200-01-01'
  const tipo = await formataListas($('#txtTipo').val().toString())
  const grupoMaterial = await formataListas($('#txtGrupoMaterial').val().toString())
  const grupoProduto = await formataListas($('#txtGrupoProduto').val().toString())
  const grupoServico = await formataListas($('#txtGrupoServico').val().toString())
  const subgrupoMaterial = await formataListas($('#txtSubgrupoMaterial').val().toString())

  return {
    cotacao,
    solicitacao,
    fornecedor,
    codigo,
    cor,
    tamanho,
    solicitante,
    centroCusto,
    codigoFornecedor,
    corFornecedor,
    validadeDe,
    validadeAte,
    tipo,
    grupoMaterial,
    grupoProduto,
    grupoServico,
    subgrupoMaterial,
  }
}