$(document).ready(async function () {
  componenteFiltro('entidade', false, false, 'FornecedorCapa')
  componenteFiltro('colecao', false, false, 'ColecaoCapa')
  componenteFiltro('motivo', false, false, 'MotivoCapa')
  componenteFiltro('centroCusto', false, false, 'CentroCustoCapa')
  componenteFiltro('tipo', false, false, 'TipoCapa')

  $('.campoFloat').maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  })

  $('#formCapa').validate({
    rules: {
      fornecedor: {
        required: true,
      },
    },
    messages: {
      fornecedor: 'Fornecedor é obrigatório.',
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback')
      element.closest('.form-group').append(error)
    },
    highlight(element) {
      $(element).addClass('is-invalid')
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid')
    },
    submitHandler: async (_form, event) => {
      event.preventDefault()
      msgAlerta(
        'Deseja gravar os dados?',
        () => null,
        () => null,
        () => {
          const dados = retornarDadosConfirmar()
          confirmar(dados)
        }
      )
    }
  })

  const confirmar = (dados) => {
    $.LoadingOverlay('show')
    requisicao(
      'PUT',
      `/sisplan/centralcompras/compra/v1/capa?`,
      '',
      JSON.stringify(dados),
      3600000
    ).then(async (response) => {
      const json = await response.json()
      if (json) {
        const { mensagem } = json
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        toastr.success("Dados gravados com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onShown() {
            const { App } = ModalManutencaoCompraCentralCompras
            App.criarTabelaItens()
            $('#modalManutencao').modal('hide')
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      }
    }).finally(() => $.LoadingOverlay('hide'))
  }

  const retornarDadosConfirmar = () => {
    const id = $('#txtIdCapa').val()
    const numero = $('#txtNumeroCapa').val()
    const usuario = $('#txtUsuarioCapa').val()
    const dataEmissao = $('#txtEmissaoCapa').val()
    const dataEntrega = $('#txtEntregaCapa').val()
    const fornecedor = retornarChaveDescricao('#txtFornecedorCapa')
    const colecao = retornarChaveDescricao('#txtColecaoCapa')
    const motivo = retornarChaveDescricao('#txtMotivoCapa')
    const observacao = $('#txtObservacaoCapa').val()
    const status = $('#selectStatus').val()
    const centroCusto = retornarChaveDescricao('#txtCentroCustoCapa')
    const tipo = retornarChaveDescricao('#txtTipoCapa')

    return {
      id,
      numero,
      usuario,
      dataEmissao,
      dataEntrega,
      fornecedor: fornecedor.chave,
      descricaoFornecedor: fornecedor.descricao,
      colecao: colecao.chave,
      descricaoColecao: colecao.descricao,
      motivo: motivo.chave,
      descricaoMotivo: motivo.descricao,
      centroCusto: centroCusto.chave,
      observacao,
      status,
      tipo: tipo.chave,
    }
  }

  $('#modalManutencao').on('shown.bs.modal', () => ModalManutencaoCompraCentralCompras.carregarApp($('#selectStatus').val()))

  $('#modalManutencao').on('hide.bs.modal', () => {
    ModalManutencaoCompraCentralCompras.limparModal()
  })
})

window.ModalManutencaoCompraCentralCompras = window.ModalManutencaoCompraCentralCompras || {}

ModalManutencaoCompraCentralCompras.App = null

ModalManutencaoCompraCentralCompras.carregarApp = (status) => {
  switch (status) {
    case 'D':
      ModalManutencaoCompraCentralCompras.App = ComprasDigitadas
      break
    case 'N':
      ModalManutencaoCompraCentralCompras.App = ComprasRetornadas
      break
    default:
      break
  }
}

ModalManutencaoCompraCentralCompras.dadosCapa = {}

ModalManutencaoCompraCentralCompras.limparModal = () => {
  ModalManutencaoCompraCentralCompras.limparCampos()
}

ModalManutencaoCompraCentralCompras.carregarModalManutencao = (dadosEditar, situacao) => {
  ModalManutencaoCompraCentralCompras.preencherDadosModalEditar(dadosEditar)
  $('#selectStatus').val(situacao)
  $('#modalManutencao').modal('show')
}

ModalManutencaoCompraCentralCompras.preencherDadosModalEditar = (dados) => {
  ModalManutencaoCompraCentralCompras.preencherCamposCapa(dados)
  ModalManutencaoCompraCentralCompras.dadosCapa = dados
}

ModalManutencaoCompraCentralCompras.preencherCamposCapa = (dados) => {
  if (!dados || !dados.id) return
  insereValor('#txtIdCapa', dados.id)
  dados.numero ? insereValor('#txtNumeroCapa', dados.numero) : $('#txtNumeroCapa').val('')
  dados.usuario ? insereValor('#txtUsuarioCapa', dados.usuario) : $('#txtUsuarioCapa').val('')
  dados.dataEmissao ? insereValor('#txtEmissaoCapa', dados.dataEmissao.split('T')[0]) : $('#txtEmissaoCapa').val('')
  dados.dataEntrega ? insereValor('#txtEntregaCapa', dados.dataEntrega.split('T')[0]) : $('#txtEntregaCapa').val('')
  dados.fornecedor ? insereValor('#txtFornecedorCapa', dados.fornecedor, dados.nomeFornecedor) : $('#txtFornecedorCapa').val('')
  dados.colecao ? insereValor('#txtColecaoCapa', dados.colecao, dados.descricaoColecao) : $('#txtColecaoCapa').val('')
  dados.motivo ? insereValor('#txtMotivoCapa', dados.motivo, dados.descricaoMotivo) : $('#txtMotivoCapa').val('')
  dados.centroCusto ? insereValor('#txtCentroCustoCapa', dados.centroCusto, dados.descricaoCentroCusto) : $('#txtCentroCustoCapa').val('')
  dados.observacao ? insereValor('#txtObservacaoCapa', dados.observacao) : $('#txtObservacaoCapa').val('')
  dados.tipo && dados.tipo !== 0 ? insereValor('#txtTipoCapa', dados.tipo, dados.descricaoTipo) : $('#txtTipoCapa').val('')
}

ModalManutencaoCompraCentralCompras.limparCampos = () => $('.camposCapaManutencao').val('')