$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    })
    driver.defineSteps([
      {
        element: "#tutorial-step1",
        popover: {
          title: "Campos",
          description:
            "Aqui se encontram os campos essenciais para consultar e gravar as informações.",
          position: "bottom",
        },
      },
      {
        element: '#btnVoltar',
        popover: {
          title: 'Voltar',
          description: 'Aqui está o botão para voltar à consulta.',
          position: 'bottom'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Gravar',
          description: 'Aqui está o botão para gravar as informações.',
          position: 'bottom'
        }
      }
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  const url = window.location.href
  const query = url.split('/')[url.split('/').length - 1]

  const params = new URLSearchParams(query);

  const id = params.get("ID");
  const status = params.get("STATUS");

  if (!id || !status) {
    window.history.back()
    return
  }

  if (!['D', 'N'].includes(status)) {
    $('#btnAlterar').addClass('d-none')
  }

  ItensCompra.consultar(id)

  $('#btnAlterar').on('click', function () {
    const dadosEditar = $('#tabelaItens').DataTable().data().toArray()
    if (!dadosEditar || dadosEditar.length === 0) {
      return
    }
    ModalManutencaoItensCompraCentralCompras.carregarModalManutencao(dadosEditar, 'D', id, dadosEditar?.[0]?.numero ?? '')
  })

  $('#btnVoltar').on('click', function () {
    window.history.back()
  })
})

window.ItensCompra = window.ItensCompra || {}

ItensCompra.consultar = async function (id) {
  const dados = await ItensCompra.buscarItens(id)

  ItensCompra.criarTabelaItens(dados)
}

ItensCompra.buscarItens = async (id) => {
  try {
    $.LoadingOverlay('show')
    const response = await requisicao("GET", `/sisplan/centralcompras/compra/v1/itens?`, `ID=${id}`, '', 3600000)

    const dados = await response.json()

    if (!dados) {
      return
    }

    const { mensagem, resultado } = dados
    if (mensagem?.codigo !== 200) {
      throw mensagem?.mensagem
    }

    return resultado ?? []
  } catch (error) {
    console.error(error)
    msgErro('Ocorreu um erro ao buscar os itens.')
  } finally {
    $.LoadingOverlay('hide')
  }
}

ItensCompra.criarTabelaItens = (data) => {
  if ($.fn.DataTable.isDataTable('#tabelaItens')) {
    $('#tabelaItens').DataTable().destroy()
    $('#tabelaItens').empty()
  }

  const columns = [
    {
      data: 'numero',
      title: 'Número',
    },
    {
      data: 'dataEmissao',
      title: 'Emissão',
      render(data) {
        return retornarDataISOEmYMD({ dataISO: data, usarUTC: true, reverso: true, separadorData: '/' })
      },
    },
    {
      data: 'dataEntrega',
      title: 'Entrega',
      render(data) {
        return retornarDataISOEmYMD({ dataISO: data, usarUTC: true, reverso: true, separadorData: '/' })
      },
    },
    {
      data: 'prazo',
      title: 'Prazo',
    },
    {
      data: 'descricaoPrazo',
      title: 'Descrição Prazo',
    },
    {
      data: 'colecao',
      title: 'Coleção',
    },
    {
      data: 'descricaoColecao',
      title: 'Descrição Coleção',
    },
    {
      data: 'motivo',
      title: 'Motivo',
    },
    {
      data: 'descricaoMotivo',
      title: 'Descrição Motivo',
    },
    {
      data: 'centroCusto',
      title: 'Centro de Custo',
    },
    {
      data: 'descricaoCentroCusto',
      title: 'Descrição Centro de Custo',
    },
    {
      data: 'ordem',
      title: 'Ordem',
    },
    {
      data: 'tipoItem',
      title: 'Tipo Item',
    },
    {
      data: 'codigo',
      title: 'Código',
    },
    {
      data: 'descricao',
      title: 'Descrição',
    },
    {
      data: 'cor',
      title: 'Cor',
    },
    {
      data: 'descricaoCor',
      title: 'Descrição Cor',
    },
    {
      data: 'tamanho',
      title: 'Tamanho',
    },
    {
      data: 'descricaoTamanho',
      title: 'Descrição Tamanho',
      visible: false,
    },
    {
      data: 'deposito',
      title: 'Depósito',
    },
    {
      data: 'descricaoDeposito',
      title: 'Descrição Depósito',
    },
    {
      data: 'fornecedor',
      title: 'Fornecedor',
    },
    {
      data: 'nomeFornecedor',
      title: 'Nome Fornecedor',
    },
    {
      data: 'contaContabil',
      title: 'Conta Contábil',
    },
    {
      data: 'descricaoContaContabil',
      title: 'Descrição Conta Contábil',
    },
    {
      data: 'especificacao',
      title: 'Especificação',
    },
    {
      data: 'unidade',
      title: 'Unidade',
    },
    {
      data: 'unidadeCompra',
      title: 'Unidade de Compra',
    },
    {
      data: 'fatorConversao',
      title: 'Fator de Conversão',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data })
      }
    },
    {
      data: 'quantidade',
      title: 'Quantidade',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data })
      }
    },
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data })
      }
    },
    {
      data: 'valor',
      title: 'Valor',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data })
      }
    },
    {
      data: 'observacao',
      title: 'Observação',
    },
    {
      data: 'usuario',
      title: 'Usuário',
    },
    {
      data: 'id',
      title: 'Id',
      visible: false,
    },
    {
      data: 'idCapa',
      title: 'Id Capa',
      visible: false,
    },
  ]

  $('#tabelaItens').DataTable({
    sort: false,
    paging: false,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    colReorder: true,
    autoWidth: true,
    data,
    columns,
    scrollX: true,
    scrollY: '737px',
  })
  // UtilsCentralCompras.criarContainerBotoes({
  //   tabela: 'tabelaItens',
  // })
  // UtilsCentralCompras.habilitarEsconderColunas({
  //   tabela: 'tabelaItens',
  //   tela: 'itensCompraDigitados',
  // })
  // UtilsCentralCompras.habilitarExportarCsv({
  //   tabela: 'tabelaItens',
  //   status: 'D',
  //   tipo: 'COM',
  // })
}