$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([{
            element: '#formcard1',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtPlaca',
            popover: {
                title: 'Placa',
                description: 'Neste campo adicionamos a placa do véiculo.',
                position: 'top'
            }
        },
        {
            element: '#txtChassi',
            popover: {
                title: 'Chassi',
                description: 'Neste campo adicionamos o Chassi do veículo.',
                position: 'top'
            }
        },
        {
            element: "#txtMarca",
            popover: {
                title: "Marca",
                description:
                    "Neste campo adicionamos a agência do banco.",
                position: "top",
            },
        },
        {
            element: "#txtProprietario",
            popover: {
                title: "Proprietário",
                description:
                    "Neste campo adicionamos o proprietário do veículo",
                position: "top",
            },
        },
        {
            element: "#txtMotorista",
            popover: {
                title: "Motorista",
                description:
                    "Neste campo adicionamos o condutor do veículo.",
                position: "top",
            },
        },
        {
            element: "#txtCidade",
            popover: {
                title: "Cidade",
                description:
                    "Neste campo adicionamos a cidade onde se encontra o veículo.",
                position: "top",
            },
        },
        {
            element: "#txtModelo",
            popover: {
                title: "Modelo",
                description:
                    "Neste campo adicionamos o modelo do veículo.",
                position: "top",
            },
        },
        {
            element: '#btnVoltar',
            popover: {
                title: 'Botão Voltar',
                description: 'Clique aqui para voltar para a tela de consulta.',
                position: 'left'
            }
        },
        {
            element: '#avancar1',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para ir para a próxima aba.',
                position: 'left'
            }
        },
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let veiculo = parametros[parametros.length - 1];

    await preencheSelectUF()
    async function preencheSelectUF() {
        try {
            let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={ "tabela":"TABUF",
            "camposSelect":["CODIGO"], 
            "where": ["1 = 1"]}
            `, null);

            if (!response) {
                return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
                msgAlerta(jsonStr.RESULT[0].mensagem);
                return;
            }
            var selectElement = document.getElementById('txtUF');
            jsonStr.RESULT[0].map((item) => {
                let option = document.createElement("option");
                option.value = item.CODIGO;
                option.textContent = item.CODIGO;
                selectElement.appendChild(option);
            })
        } catch (e) {
            console.log(e)
        }
    }

    let contaFs = 1;

    $("#checkAtivo").attr("checked", true);

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('CADVEICULO', getCookie('usuario'), String(veiculo));
        window.location.href = `${BASE_URI}/cadveiculo`;
    });

    $(document).ready(function () {

        let currentFs; let nextFs; let previousFs;
        let opacity;

        $(".next").click(function () {

            contaFs += 1;

            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {

                currentFs = $(this).parent();
                nextFs = $(this).parent().next();

                $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

                nextFs.show();
                currentFs.animate({
                    opacity: 0
                }, {
                    step(now) {
                        opacity = 1 - now;

                        currentFs.css({
                            'display': 'none',
                            'position': 'relative'
                        });
                        nextFs.css({
                            'opacity': opacity
                        });
                    },
                    duration: 600
                });
            }
        });

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                },
                txtBanco: {
                    required: true,
                },
                txtAgencia: {
                    required: true,
                },
                txtConta: {
                    required: true,
                }
            },
            messages: {
                txtPlaca: {
                    required: "Informe uma placa válida.",
                },
                txtMarca: {
                    required: "Informe uma marca válida."
                },
                txtModelo: {
                    required: "Informe um modelo válido."
                },
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('#txtValor').maskMoney({
            decimal: '.',
            thousands: '',
            precision: 2
        });
        $('#txtValorIPVA').maskMoney({
            decimal: '.',
            thousands: '',
            precision: 2
        });
        $('#txtValorLicenciamento').maskMoney({
            decimal: '.',
            thousands: '',
            precision: 2
        });
        $('#txtValorSegObrig').maskMoney({
            decimal: '.',
            thousands: '',
            precision: 2
        });

        $(".previous").click(function () {

            contaFs -= 1;

            currentFs = $(this).parent();
            previousFs = $(this).parent().prev();
            $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");
            previousFs.show();
            currentFs.animate({
                opacity: 0
            }, {
                step(now) {
                    opacity = 1 - now;
                    currentFs.css({
                        'display': 'none',
                        'position': 'relative'
                    });
                    previousFs.css({
                        'opacity': opacity
                    });
                },
                duration: 600
            });
        });

        $(".submit").click(function () {
            return false;
        });
    });

    $('#txtProprietario').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": ["ATIVO = 'S'"]}`);
    $('#btnProprietario').pesquisa('#txtProprietario', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": ["ATIVO = 'S'"]}`, 'Pesquisa Proprietário', 'ENITDADE');
    $('#txtMotorista').autocompleta(1, `JSON={ "tabela":"MOTORISTA", "camposSelect":[ "CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);
    $('#btnMotorista').pesquisa('#txtMotorista', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"]}`, 'Pesquisa Motorista', 'MOTORISTA');
    $('#txtCidade').autocompleta(1, `JSON={ "tabela":"TABUF", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btnCidade').pesquisa('#txtCidade', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABUF", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Cidade', 'TABUF');
    $('#txtSeguradora').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": ["ATIVO = 'S'"]}`);
    $('#btnSeguradora').pesquisa('#txtSeguradora', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": ["ATIVO = 'S'"]}`, 'Pesquisa Seguradora', 'ENTIDADE');

    $('#btnLimpaProprietario').on('click', function () {
        $('#txtProprietario').val('');
    });

    $('#btnLimpaModelo').on('click', function () {
        $('#txtMotorista').val('');
    });

    $('#btnLimpaCidade').on('click', function () {
        $('#txtCidade').val('');
    });

    $('#btnLimpaSeguradora').on('click', function () {
        $('#txtSeguradora').val('');
    });

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    if (veiculo != '' && veiculo != 'create') {
        $('#account').css('cursor', 'pointer');
        $('#payment').css('cursor', 'pointer');
        if (await liberarRegistro('CADVEICULO', veiculo) == false) {
            window.location.href = '../cadveiculo';
        } else {
            carregaDados(veiculo);
        }
    }

    async function carregaDados(veiculo) {
        try {
            $.LoadingOverlay("show");
            try {
                let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={ "tabela":"VEICULO",
                "camposSelect":["MARCA, MODELO, PLACA, PLACA2, MOTORISTA, ANO, CHASSI, COD_MUN, COR_CABINE, COR_CARROC, MOTOR, TIPO_CARROC",
                "TIPO_RODADO, TIPO_VEIC, VEIC_TERCEIRO, RENAVAM, TIPO_PROPRIETARIO, UF_LICENCIAMENTO, ANO_MODELO, QTDE_PASSAGEIRO", 
                "OBS, CAPAC_KG, CAPAC_M3, TARA, ATIVO, KM_RETORNO, SEGURADORA, APOLICE ,VENCT_APOLICE, VLR_APOLICE",
                "VENC_IPVA, VENC_LICENCIAMENTO, VLR_IPVA, VLR_LICENCIAMENTO, VENC_SEGU_OBRIG, VLR_SEGU_OBRIG, CONDUTOR, VEIC_CARONA",
                "COMPART1, QTDE_COMPART, LACRE_COMP1, ID_PATRIMONIO, HR_RETORNO, TIPO_MAN"], 
                "where": ["PLACA = '${veiculo}'"]}
                `, null);

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr.RESULT[0].mensagem);
                    return;
                }

                $('#txtPlaca').val(jsonStr.RESULT[0][0].PLACA);
                $('#txtPlaca').prop('disabled', true)
                $('#txtChassi').val(jsonStr.RESULT[0][0].CHASSI);
                $('#txtAno').val(jsonStr.RESULT[0][0].ANO);
                $('#checkAtivo').prop('checked', (jsonStr.RESULT[0][0].ATIVO == 'S' ? true : false))
                $('#txtMarca').val(jsonStr.RESULT[0][0].MARCA);

                insereValor('#txtProprietario', jsonStr.RESULT[0][0].MOTORISTA, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: jsonStr.RESULT[0][0].MOTORISTA });
                insereValor('#txtMotorista', jsonStr.RESULT[0][0].CONDUTOR, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: jsonStr.RESULT[0][0].CONDUTOR });
                insereValor('#txtCidade', jsonStr.RESULT[0][0].COD_MUN, { tabela: 'TABUF', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: jsonStr.RESULT[0][0].COD_MUN });
                insereValor('#txtSeguradora', jsonStr.RESULT[0][0].SEGURADORA, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: jsonStr.RESULT[0][0].SEGURADORA });

                $('#txtModelo').val(jsonStr.RESULT[0][0].MODELO);
                $('#txtApolice').val(jsonStr.RESULT[0][0].APOLICE);
                $('#dtVencimento').val(jsonStr.RESULT[0][0].VENCT_APOLICE);
                $('#txtValor').val(jsonStr.RESULT[0][0].VLR_APOLICE);
                $('#dtVencimentoIPVA').val(jsonStr.RESULT[0][0].VENC_IPVA);
                $('#txtValorIPVA').val(jsonStr.RESULT[0][0].VLR_IPVA);
                $('#dtVencimentoLicenciamento').val(jsonStr.RESULT[0][0].VENC_LICENCIAMENTO);
                $('#txtValorLicenciamento').val(jsonStr.RESULT[0][0].VLR_LICENCIAMENTO);
                $('#dtVencimentoSegObrig').val(jsonStr.RESULT[0][0].VENC_SEGU_OBRIG);
                $('#txtValorSegObrig').val(jsonStr.RESULT[0][0].VLR_SEGU_OBRIG);
                $('#txtTipoVeiculo').val(jsonStr.RESULT[0][0].TIPO_VEIC)
                $('#txtTipoCarroceria').val(jsonStr.RESULT[0][0].TIPO_CARROC)
                $('#txtTipoRodado').val(jsonStr.RESULT[0][0].TIPO_RODADO)
                $('#txtUF').val(jsonStr.RESULT[0][0].UF_LICENCIAMENTO)

            } catch (error) {
                console.error(error);
                msgAlerta(`Não foi possível buscar os dados do veículo.`);
            };
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('#txtPlaca').on('blur', async function () {
        if (await Existe('VEICULO', ['PLACA'], [$('#txtPlaca').val()])) {
            throw msgAlerta('Veículo já existe, verifique!')
        }
    })

    $("#gravar").on('click', async function () {
        $.LoadingOverlay('show')
        try {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                if ($('#txtPlaca').val() === '') {
                    throw await msgAlerta(`Necessário informar uma placa.`);
                }

                if ($('#txtMarca').val() === '') {
                    throw await msgAlerta(`Necessário informar uma marca.`);
                }

                if ($('#txtAno').val() === '') {
                    throw await msgAlerta(`Necessário informar o ano do veículo.`);
                }

                if ($('#txtModelo').val() === '') {
                    throw await msgAlerta(`Necessário informar um modelo.`);
                }

                if ($('#txtTipoVeiculo').val() == null) {
                    throw await msgAlerta(`Necessário informar um tipo de veículo.`);
                }

                if ($('#txtTipoCarroceria').val() == null) {
                    throw await msgAlerta(`Necessário informar um tipo de carroceria.`);
                }

                if ($('#txtTipoRodado').val() == null) {
                    throw await msgAlerta(`Necessário informar um tipo de rodado.`);
                }

                if ($('#txtUF').val() == null) {
                    throw await msgAlerta(`Necessário informar a UF de licenciamento.`);
                }

                body = {
                    placa: $('#txtPlaca').val(),
                    ativo: $('#checkAtivo').is(':checked') ? 'S' : 'N',
                    chassi: $('#txtChassi').val(),
                    marca: $('#txtMarca').val(),
                    ano: $('#txtAno').val(),
                    condutor: pegaChave('#txtMotorista'),
                    motorista: pegaChave('#txtProprietario'),
                    cod_mun: pegaChave('#txtCidade'),
                    modelo: $('#txtModelo').val(),
                    seguradora: pegaChave('#txtSeguradora'),
                    apolice: $('#txtApolice').val(),
                    venct_apolice: $('#dtVencimento').val(),
                    vlr_apolice: $('#txtValor').val(),
                    venc_ipva: $('#dtVencimentoIPVA').val(),
                    vlr_ipva: $('#txtValorIPVA').val(),
                    venc_licenciamento: $('#dtVencimentoLicenciamento').val(),
                    vlr_licenciamento: $('#txtValorLicenciamento').val(),
                    venc_segu_obrig: $('#dtVencimentoSegObrig').val(),
                    vlr_segu_obrig: $('#txtValorSegObrig').val(),
                    tipo_veic: $('#txtTipoVeiculo').val(),
                    tipo_rodado: $('#txtTipoRodado').val(),
                    tipo_carroc: $('#txtTipoCarroceria').val(),
                    uf_licenciamento: $('#txtUF').val()
                }

                let response = await requisicao('POST', '/sisplan/cadastros/v1/veiculo?', '', `JSON=${JSON.stringify(body)}`, 15000);

                if (!response) {
                    return;
                };

                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgAlerta(jsonStr.mensagem);
                    return;
                }

                toastr.success(
                    `Cadastro efetuado com sucesso!
                    Veículo: ${body.placa}`,
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                        error: 'alert-error',
                        info: 'alert-info',
                        success: 'alert-success',
                        warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/cadveiculo`;
                    }
                }
                ).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px"
                });
            };
        } catch (error) {
            console.log(error)
        } finally {
            $.LoadingOverlay("hide");
        }


    });

    $('#account').on('click', function () {
        if (veiculo != 'create') {
            if (contaFs == 2) {
                $('#voltar2').trigger('click');
            }
        }
    });

    $('#payment').on('click', function () {
        if (veiculo != 'create') {
            if (contaFs == 1) {
                $('#avancar1').trigger('click');
            }
        }
    });
});