$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([
            {
                element: '#divGeral',
                popover: {
                    title: 'Área dos dados da Redução Z',
                    description: 'Nessa área é possível informar os dados da Redução Z.',
                    position: 'bottom'
                }
            },
            {
                element: '#divNumeroECF',
                popover: {
                    title: 'Campo Número ECF',
                    description: 'Nesse campo é possível informar a ECF.',
                    position: 'bottom'
                }
            },
            {
                element: '#divMovimentoReducaoZ',
                popover: {
                    title: 'Campo Data Movimento Redução Z',
                    description: 'Nesse campo é possível informar a data da Redução Z, caso já tenha sido feito cadastro com a ECF, '+
                    'os dados de impostos e pagamentos já serão preenchidos, se por ventura tiver algum cadastro na data correspondente, será possível editá-lo.',
                    position: 'bottom'
                }
            },
            {
                element: '#divImpostos',
                popover: {
                    title: 'Área dos Impostos',
                    description: 'Nessa área é possível informar os dados dos impostos.',
                    position: 'bottom'
                }
            },
            {
                element: '#divPagamentos',
                popover: {
                    title: 'Área dos Pagamentos',
                    description: 'Nessa área é possível informar os dados dos pagamentos.',
                    position: 'bottom'
                }
            },
            {
                element: '#btnGravar',
                popover: {
                    title: 'Botão Gravar',
                    description: 'Clique aqui para gravar os dados.',
                    position: 'left'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    await iniciaTela();


    async function iniciaTela() {

        $(function () {
            $("#timepicker").datetimepicker({
                format: "HH:mm:ss"
            });
        });
        $("#txtHoraEmissaoRedZ").mask("00:00:00");

        $('#txtNumeroECF').select2({
            placeholder: "Selecione ou digite uma nova opção",
            tags: true,
            allowClear: true,
            language: {
                maximumSelected: function (limit) {
                    return "Você pode selecionar apenas uma ECF";
                },
                noResults: function () {
                    return ''
                }
            },
            maximumSelectionLength: 1,

        });
        $('.select2-search__field').attr('style', function (i, s) { return s + 'height: 100% !important;' });
        await retornaECFs();

        criaDataTablePadrao('#tabelaImpostos', false, false, false, false, true, false, '150px');
        criaDataTablePadrao('#tabelaPagamentos', false, false, false, false, true, false, '150px');
        adicionaRegistroTabelas("#tabelaImpostos");
        adicionaRegistroTabelas("#tabelaPagamentos");
    }

    $("#btnAdicionarImpostos").on("click", function () {
        adicionaRegistroTabelas("#tabelaImpostos");
    })

    $("#btnAdicionarPagamentos").on("click", function () {
        adicionaRegistroTabelas("#tabelaPagamentos");
    })

    $("#txtMovimentoRedZ").on("blur", async function () {
        try {
            $.LoadingOverlay('show');
            const serieECF = $("#txtNumeroECF").val();
            const dataMovimento = $("#txtMovimentoRedZ").val();
            $("#tabelaImpostos").DataTable().clear().draw(false);
            $("#tabelaPagamentos").DataTable().clear().draw(false);

            if (dataMovimento != "" && serieECF != "") {
                await buscaDados(dataMovimento, serieECF);
            }
        } finally {
            $.LoadingOverlay('hide');
        }

    })

    $("#btnGravar").on("click", async function () {
        try {
            $("#btnGravar").prop("disabled", true);
            if ($("#txtNumeroECF").val() == "") {
                msgAlerta("Número da ECF não preenchido, verifique.")
                return;
            }

            if ($("#txtMovimentoRedZ").val() == "") {
                msgAlerta("Data de movimento da Redução Z não preenchido, verifique.")
                return;
            }

            if (!validaTotalImpostos()) {
                msgAlerta("Valor total dos impostos não confere com a venda bruta diária.");
                return;
            }

            if (!validaTotalPagamentos()) {
                msgAlerta("Valor total dos pagamentos não confere com a venda bruta diária.");
                return;
            }

          await gravar();
        } finally {
            $("#btnGravar").prop("disabled", false);
        }
    })

    $("#txtVendaBrutaDiaria").on("change", function () {
        if ($(this).val() == "") {
            $(this).val(0);
        }
    })

    function adicionaRegistroTabelas(id, codigo = "", descricao = "", observacao = "", valor = 0) {
        const idElemento = id.substring(7);
        const index = $(id).DataTable().rows().count();
        const inputs = [];

        inputs.push(` <input type="text" class="input-default focus form-control"
            id="txtCodigo${idElemento}${index}" value="${codigo}" class="form-control"> </input> `);
        inputs.push(` <input type="text" class="input-default focus form-control"
            id="txtDescricao${idElemento}${index}" value="${descricao}" class="form-control"> </input> `);
        if (idElemento == "Impostos") {
            inputs.push(` <input type="text" class="input-default focus form-control"
            id="txtObservacao${idElemento}${index}" value="${observacao}" class="form-control" readonly> </input> `);
        }
        inputs.push(` <input type="number" class="input-default focus form-control valor-${idElemento.toLowerCase()}"
            id="txtValor${idElemento}${index}" value="${valor}" class="form-control"> </input> `);

        $(id).DataTable().row.add(inputs).draw(false);

        $(".valor-impostos, .valor-pagamentos").on("change", function () {
            if ($(this).val() == "") {
                $(this).val(0);
            }
        })

    }

    async function retornaECFs() {
        const pesquisaParam = {
            tabela: "VENDA_REDZ",
            camposSelect: ["DISTINCT SERIE_ECF"],
            where: [`EMP_ID = ${getCookie("emp_id")}`]
        }

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        if (jsonStr.length > 0) {
            jsonStr.forEach(ecf => {
                if (ecf.SERIE_ECF == "") {
                    return;
                }
                const option = {
                    id: ecf.SERIE_ECF,
                    text: ecf.SERIE_ECF
                }
                const newOption = new Option(option.text, option.id, true, false);
                $("#txtNumeroECF").append(newOption).trigger('change');
            });
        }

    }

    async function existeReducao(data, ECF) {
        const pesquisaParam = {
            tabela: 'VENDA_REDZ',
            camposSelect: ['DATA'],
            where: [`DATA = '${data}' AND SERIE_ECF = '${ECF}'`],
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        if (jsonStr.length > 0) {
            return true
        }

        return false;

    }

    async function buscaDados(dataMovimento, serieECF) {
        let pesquisaParam;
        if (!await existeReducao(dataMovimento, serieECF)) {
            pesquisaParam = {
                tabela: "VENDA_REDZ",
                camposSelect: ["DISTINCT CODIGO", "DESCRICAO", "TIPO", "0 AS VALOR"],
                where: [`EMP_ID = ${getCookie("emp_id")} AND SERIE_ECF = '${serieECF}'`],
                orderBy: ["TIPO"]
            }
        } else {
            pesquisaParam = {
                tabela: "VENDA_REDZ",
                camposSelect: ["CODIGO", "DESCRICAO", "SERIE_ECF", "TIPO", "CASE WHEN VALOR = '' THEN '0' ELSE VALOR END AS VALOR"],
                where: [`EMP_ID = ${getCookie("emp_id")} AND DATA = '${dataMovimento}' AND SERIE_ECF = '${serieECF}'`],
                orderBy: ["TIPO"]
            }
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        if (jsonStr.length > 0) {

            for (let i = 0; i < jsonStr.length; i++) {
                if (jsonStr[i].TIPO == "IMPOSTO") {
                    adicionaRegistroTabelas("#tabelaImpostos", jsonStr[i].CODIGO, jsonStr[i].DESCRICAO, '', jsonStr[i].VALOR);
                } else if (jsonStr[i].TIPO == "PAGTO") {
                    adicionaRegistroTabelas("#tabelaPagamentos", jsonStr[i].CODIGO, jsonStr[i].DESCRICAO, '', jsonStr[i].VALOR);
                } else if (jsonStr[i].TIPO == "REDUCAO") {
                    switch (jsonStr[i].CODIGO) {
                        case "04": {
                            $("#txtModeloECF").val(jsonStr[i].VALOR);
                            break;
                        }
                        case "06": {
                            $("#txtContadorRedZ").val(jsonStr[i].VALOR);
                            break;
                        }
                        case "07": {
                            $("#txtCOORedZ").val(jsonStr[i].VALOR);
                            break;
                        }
                        case "08": {
                            $("#txtCRORedZ").val(jsonStr[i].VALOR);
                            break;
                        }
                        case "10": {
                            const data = jsonStr[i].VALOR == 0 ? $("#txtMovimentoRedZ").val() : await converteData("CONSULTAR", jsonStr[i].VALOR);
                            $("#txtDataEmissaoRedZ").val(data);
                            break;
                        }
                        case "11": {
                            const hora = jsonStr[i].VALOR != '' ? await validaHorario(jsonStr[i].VALOR) : "22:00:00";
                            $("#txtHoraEmissaoRedZ").val(hora);
                            break;
                        }
                        case "12": {
                            $("#txtVendaBrutaDiaria").val(jsonStr[i].VALOR);
                            break;
                        }
                        case "14": {
                            $("#txtTotalizadorGeral").val(jsonStr[i].VALOR);
                            break;
                        }
                        default: {
                            break;
                        }

                    }
                }
            }
            await ajustaObservacao();
        }
    }

    async function ajustaObservacao() {
        const dados = $("#tabelaImpostos").DataTable().data().toArray();

        for (let i = 0; i < dados.length; i++) {
            const codigo = $(`#txtCodigoImpostos${i}`).val();
            let observacao = "";
            switch (codigo) {
                case "AS": {
                    observacao = "Acréscimo - ISSQN";
                    break;
                }
                case "AT": {
                    observacao = "Acréscimo - ICMS";
                    break;
                }
                case "Can-S": {
                    observacao = "Cancelamento - ISSQN";
                    break;
                }
                case "Can-T": {
                    observacao = "Cancelamento - ICMS";
                    break;
                }
                case "DS": {
                    observacao = "Desconto - ISSQN";
                    break;
                }
                case "DT": {
                    observacao = "Desconto - ICMS";
                    break;
                }
                case "F1": {
                    observacao = "Substituição Tributária - ICMS";
                    break;
                }
                case "FS1": {
                    observacao = "Substituição Tributária - ISSQN";
                    break;
                }
                case "I1": {
                    observacao = "Isento - ICMS";
                    break;
                }
                case "IS1": {
                    observacao = "Isento - ISSQN";
                    break;
                }
                case "N1": {
                    observacao = "Não-incidência - ICMS";
                    break;
                }
                case "NS1": {
                    observacao = "Não-incidência - ISSQN";
                    break;
                }
                case "OPNF": {
                    observacao = "Operações Não Fiscais";
                    break;
                }
            }
            switch (codigo.substring(2, 10)) {
                case "T0700": {
                    observacao = "Alíquota de ICMS  -  7 %";
                    break;
                }
                case "T1200": {
                    observacao = "Alíquota de ICMS  - 12 %";
                    break;
                }
                case "T1700": {
                    observacao = "Alíquota de ICMS  - 17 %";
                    break;
                }
                case "T2500": {
                    observacao = "Alíquota de ICMS  - 25 %";
                    break;
                }
                case "S0500": {
                    observacao = "Alíquota de ISSQN -  5 %";
                    break;
                }
                case "T0400": {
                    observacao = "Alíquota de ICMS -  4 %";
                    break;
                }
            }
            $(`#txtObservacaoImpostos${i}`).val(observacao);
        }

    }

    async function validaHorario(horario) {
        const formatoTempo = /^\d\d:\d\d:\d\d$/;

        if (formatoTempo.test(horario)) {
            return horario;
        } else {
            return "22:00:00";
        }
    }

    async function converteData(operacao, data) {
        if (operacao.toUpperCase() == "GRAVAR") {
            const dateParts = data.split("-");
            const dia = dateParts[2].padStart(2, '0');
            const mes = dateParts[1].padStart(2, '0');
            const ano = dateParts[0].substring(2);
            return dia + "/" + mes + "/" + ano;
        } else if (operacao.toUpperCase() == "CONSULTAR") {
            const dateParts = data.split("/");
            const dia = dateParts[0].padStart(2, '0');
            const mes = dateParts[1].padStart(2, '0');
            const anoAtual = new Date().getFullYear().toString();
            const ano = anoAtual.substring(0, 2) + dateParts[2];
            return ano + '-' + mes + '-' + dia;
        }

    }

    function validaTotalImpostos() {
        const totalRedZ = parseFloat($("#txtVendaBrutaDiaria").val());
        let totalImpostos = 0;

        $(".valor-impostos").toArray().forEach(input => {

            totalImpostos += parseFloat($(input).val());

        });

        return totalImpostos == totalRedZ;

    }

    function validaTotalPagamentos() {
        const totalRedZ = parseFloat($("#txtVendaBrutaDiaria").val());
        let valorDesc = 0;
        let totalPagamentos = 0;

        $(".valor-pagamentos").toArray().forEach((input, i) => {
            if ($(`#txtCodigoPagamentos${i}`).val() != "51" && $(`#txtCodigoPagamentos${i}`).val() != "52" && $(`#txtCodigoPagamentos${i}`).val() != "TR") {
                totalPagamentos += parseFloat($(input).val());
            }
            if ($(`#txtCodigoPagamentos${i}`).val() == "TR") {
                totalPagamentos -= parseFloat($(input).val());
            }
        });

        $(".valor-impostos").toArray().forEach((input, i) => {
            if ($(`#txtCodigoImpostos${i}`).val() == "DT") {
                valorDesc += parseFloat($(input).val());
            }
            if ($(`#txtCodigoImpostos${i}`).val() == "Can-T") {
                valorDesc += parseFloat($(input).val());
            }
            if ($(`#txtCodigoImpostos${i}`).val() == "Can-S") {
                valorDesc += parseFloat($(input).val());
            }
        });

        return totalPagamentos - valorDesc == totalRedZ;

    }

    async function gravar() {
        try {
            $.LoadingOverlay('show');

            const redz = {
                SERIE_ECF: $("#txtNumeroECF").val().toString(),
                MODELO_ECF: $("#txtModeloECF").val(),
                CONTADOR_REDZ: $("#txtContadorRedZ").val(),
                COO_REDZ: $("#txtCOORedZ").val(),
                CRO_REDZ: $("#txtCRORedZ").val(),
                DATA_MOVIMENTO: $("#txtMovimentoRedZ").val(),
                DATA_EMISSAO: $("#txtDataEmissaoRedZ").val() != "" ? await converteData("GRAVAR", $("#txtDataEmissaoRedZ").val()) : "",
                HORA_EMISSAO: $("#txtHoraEmissaoRedZ").val(),
                VENDA_BRUTA: $("#txtVendaBrutaDiaria").val(),
                TOTALIZADOR_GERAL: $("#txtTotalizadorGeral").val(),
                IMPOSTOS: await retornaRegistrosDataTable("IMPOSTOS"),
                PAGAMENTOS: await retornaRegistrosDataTable("PAGAMENTOS")
            }

            const response = await requisicao("POST", "/sisplan/cadastros/v1/cadreducaoz?", "", `JSON=${JSON.stringify(redz)}`, 120000);

            if (!response) {
                msgAlerta("Não foi possível gravar os dados. Tente novamente.");
                return;
            }

            if (response.status != 200) {
                msgAlerta("Não foi possível gravar os dados. Tente novamente.");
                return;
            }

            await criaMensagemSucesso("Redução Z gravada com sucesso.", () => { window.location.reload(); })

        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function retornaRegistrosDataTable(tipo) {

        if (tipo == "IMPOSTOS") {
            const dados = $("#tabelaImpostos").DataTable().data().toArray();
            const listaImpostos = [];

            for (let i = 0; i < dados.length; i++) {
                if ($(`#txtCodigoImpostos${i}`).val() != "") {
                    listaImpostos.push({
                        CODIGO: $(`#txtCodigoImpostos${i}`).val(),
                        DESCRICAO: $(`#txtDescricaoImpostos${i}`).val(),
                        OBSERVACAO: $(`#txtObservacaoImpostos${i}`).val(),
                        VALOR: $(`#txtValorImpostos${i}`).val()
                    });
                }
            }
            return listaImpostos;
        } else {
            const dados = $("#tabelaPagamentos").DataTable().data().toArray();
            const listaPagamentos = [];

            for (let i = 0; i < dados.length; i++) {
                if ($(`#txtCodigoPagamentos${i}`).val() != "") {
                    listaPagamentos.push({
                        CODIGO: $(`#txtCodigoPagamentos${i}`).val(),
                        DESCRICAO: $(`#txtDescricaoPagamentos${i}`).val(),
                        VALOR: $(`#txtValorPagamentos${i}`).val()
                    });
                }
            }
            return listaPagamentos;
        }

    }

});