<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Prazo</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.261.14.1">
    <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.261.14.1">
    <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" href="dist/css/custom.css?versao=3.261.14.1">
    <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.261.14.1">
    <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.261.14.1" />
    <link rel="shortcut icon" href="favicon.ico">
    <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.261.14.1">
    <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.261.14.1" />
    <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.261.14.1">
    <link rel="stylesheet" href="dist/css/sisplan.newColorsButtons.css?versao=3.261.14.1" type="text/css" />
    <link rel="stylesheet" href="dist/css/sisplan.adjustDataTableButtons.css?versao=3.261.14.1" type="text/css" />
    <style>
        #tabelaPrazo td div button {
            padding: .0rem .5rem;
            margin: .0rem;
        }

        #tabelaPrazo td {
            padding: 5px 8px !important;
        }

        .table.dataTable tbody td,
        th {
            white-space: nowrap;
            text-overflow: ellipsis;
            overflow: hidden;
        }

        #tabelaPrazo_length {
            margin-top: 15px;
        }

        .dataTables_scroll {
            margin-top: -5px !important;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
        <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6 flex">
                            <h1 class="m-0 text-dark">Prazo</h1>
                            <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                                <i class="fas fa-question-circle"></i></button>
                        </div>
                    </div>
                </div>
                <div class="container-fluid" id="tabelaPrazoForne">
                    <div class="row card">
                        <div class="col-sm-12 d-flex justify-content-between" style="margin-top: 8px; padding-left: 20px; padding-right: 20px; z-index: 9999;">
                            <div class="d-flex align-items-center mt-2">
                                <button class="btn btnFiltros btn-sisp" id="btnFiltros"><span class="fas fa-filter"></span> Filtros</button>
                                <button class="btn btn-danger btn-sisp marginBtnH" id="btnNovoPrazo"><span class="fas fa-plus"></span> Incluir</button>
                                <button class="btn btn-primary btn-sisp marginBtnH" id="btnDistSemana"><span class="fas fa-sitemap"></span> Dist. Semana</button>
                            </div>
                        </div>
                        <div class="col-sm-12 table-responsive card-body" style="margin-top: -15px; height: 80vh">
                            <table id="tabelaPrazo" class="table table-sm table-sm-sisp table-select table-hover" width="100%">
                                <thead>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content" id="modalBody">
                    <div class="modal-header">
                        <h4 class="modal-title">Filtros</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12  col-12 form-group">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo">Código:</label>
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtCodigo" name="txtCodigo" placeholder="Código">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnCodigo" name="btnCodigo" data-button="absolute" type="button">
                                            <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btnACodigo" type="button">
                                            <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="row">
                            <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
                            <button class="btn btn-danger btn-sisp marginBtnH" id="btnLimparFiltros"><span class="fas fa-trash"></span> Limpar Filtros</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div id="modal-dist-semana" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content" id="modalBody">
                    <div class="modal-header">
                        <h4 class="modal-title">Distribuir Semanas</h4>
                        
                        <div class="form-group ml-4 icheck-primary" style="margin-top: 8px!important">
                            <input type="checkbox" class="" checked name="Ativo" id="cbDiaUtil">
                            <label class="form-check-label pr-1" for="cbDiaUtil">Somente Dia Útil</label>
                        </div>

                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row mb-4">
                            <div class="form-group col-md-4 col-sm-12">
                                <label for="dtIni" class="d-block mb-2">Data Início/Fim:</label>
                                <div class="input-group d-flex gap-2">
                                    <input type="date" max="2500-12-31" class="input-default focus form-control flex-fill" id="dtIni" value="1200-01-01" name="dtIni">
                                    <input type="date" max="2500-12-31" class="input-default focus form-control flex-fill" id="dtFim" value="2500-12-31" name="dtFim">
                                </div>
                            </div>
                            
                            <div class="form-group col-md-2 col-sm-12">
                                <label for="inptDias" class="d-block mb-2">Dias:</label>
                                <div class="input-group">
                                    <input type="number" class="input-default focus form-control w-100" id="inptDias" name="dtFatPedidoDe">
                                </div>
                            </div>
                            
                            <div class="form-group col-md-3 col-sm-12">
                                <label class="mb-2 w-auto">Status:</label>
                                <div class="form-row d-flex flex-column gap-2">
                                    <div class="icheck-primary d-flex align-items-center">
                                        <input type="checkbox" class="mr-2" name="Ativo" id="cbAtivo" checked>
                                        <label class="form-check-label ml-2" for="cbAtivo">Ativo</label>
                                    </div>
                                    <div class="icheck-primary d-flex align-items-center">
                                        <input type="checkbox" class="mr-2" name="Ativo" id="cbBloqVenda">
                                        <label class="form-check-label ml-2" for="cbBloqVenda">Bloqueia Venda</label>
                                    </div>
                                    <div class="icheck-primary d-flex align-items-center">
                                        <input type="checkbox" class="mr-2" name="Ativo" id="cbAtivoPro">
                                        <label class="form-check-label ml-2" for="cbAtivoPro">Ativo Produção</label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group col-md-3 col-sm-12">
                                <label class="mb-2 w-auto">Iniciar Semana:</label>
                                <div class="form-row d-flex flex-column gap-2">
                                    <div class="icheck-primary d-flex align-items-center">
                                        <input type="radio" class="mr-2" checked name="Consumo" id="rgDtIni">
                                        <label class="form-check-label ml-2" for="rgDtIni">Data Inicio</label>
                                    </div>
                                    <div class="icheck-primary d-flex align-items-center">
                                        <input type="radio" class="mr-2" name="Consumo" id="rgDtFim">
                                        <label class="form-check-label ml-2" for="rgDtFim">Data Fim</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12 table-responsive card-body">
                            <table id="tabDistSem" class="table table-sm table-sm-sisp table-select table-hover" width="100%">
                                <thead>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer d-flex justify-content-between">
                        <div>
                            <button id="btnDistSemana-Processar" class="btn btn-primary btn-sisp">
                                <span class="fas fa-cogs"></span> Processar
                            </button>
                        </div>
                        <div>
                            <button class="btn btn-danger btn-sisp" id="btnModalDesistir" disabled>
                                <span class="fas fa-times"></span> Desistir
                            </button>
                            <button class="btn btnVerde btn-sisp" id="btnModalConfirmar" disabled>
                                <span class="fas fa-check"></span> Confirmar
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
    include_once('../../../modais.php');
    ?>
    <aside class="control-sidebar control-sidebar-dark">
    </aside>
    </div>
    <script src="plugins/jquery/jquery.min.js?versao=3.261.14.1"></script>
    <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.261.14.1"></script>
    <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.261.14.1"></script>
    <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.261.14.1"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.261.14.1"></script>
    <script src="dist/js/adminlte.min.js?versao=3.261.14.1"></script>
    <script src="dist/js/sisplan.js?versao=3.261.14.1"></script>
    <script src="utils/funcoes.js?versao=3.261.14.1"></script>
    <script src="utils/cookies.js?versao=3.261.14.1"></script>
    <script src="dist/js/requisicoes.js?versao=3.261.14.1"></script>
    <script src="dist/js/loadingoverlay.min.js?versao=3.261.14.1"></script>
    <script src="dist/js/driver.min.js?versao=3.261.14.1"></script>
    <script src="plugins/toastr/toastr.min.js?versao=3.261.14.1"></script>

    <script type="text/javascript" src="dist/js/sum().js?versao=3.261.14.1"></script>
    <script type="text/javascript" src="config.js?versao=3.261.14.1"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('CADPRAZO');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            sArquivo = `${BASE_URI}/pages/cadprazo/acesso_cadprazo/acesso_cadprazo.js?versao=3.261.14.1`;
            insereJavaScriptPagina(sArquivo);

        });
    </script>
</body>

</html>