$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([
      {
        element: '#abaGeral',
        popover: {
          title: 'Tabela para Cadastro',
          description: 'Abas referentes às telas, com campos a serem preenchidos com valores padrões.',
          position: 'bottom'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Botão Gravar',
          description: 'Clique aqui para gravar os Valores Padrões.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const parametrosVenda = await BuscaParametrosVenda();
  if (!['1', '3', '4'].includes(parametrosVenda[72])) {
    $('#tabCashback').addClass('d-none');
  }
  let valoresPadroes = [
    //PRODUTO
    { TABELA: 'PRODUTO', CAMPO: 'UNIDADE', DESCRICAO: 'UNIDADE DO PRODUTO', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'UNI_VENDA', DESCRICAO: 'UNIDADE DE VENDA', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'CODFIS', DESCRICAO: 'CÓDIGO NCM', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'ICMS', DESCRICAO: 'PERCENTUAL DE ICMS', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'CODTRIB', DESCRICAO: 'CST DE ICMS', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'CODIPI', DESCRICAO: 'CST DE IPI DE SAÍDA', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'CODIPI_ENT', DESCRICAO: 'CST DE IPI DE ENTRADA', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'IPI', DESCRICAO: 'PERCENTUAL DE IPI', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'POSSE', DESCRICAO: 'POSSE', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'STATUS', DESCRICAO: 'STATUS', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'GRUPO_PRODUTO', DESCRICAO: 'GRUPO DE PRODUTO', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'ECF_TRIB', DESCRICAO: 'ST DO ICMS', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'NATUREZA', DESCRICAO: 'NATUREZA', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'TIPO_PROD', DESCRICAO: 'TIPO CÓDIGO', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'SETOR', DESCRICAO: 'SETOR PADRÃO NOS CONSUMOS', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'APLICACAO', DESCRICAO: 'APLICAÇÃO PADRÃO NOS CONSUMOS', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'COLECAO', DESCRICAO: 'COLEÇÃO PADRÃO', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'UNI_EXP', DESCRICAO: 'UNIDADE EXPORTAÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'DIV_EXP', DESCRICAO: 'CONVERSÃO EXPORTAÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'ETIQUETA', DESCRICAO: 'ETIQUETA', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'LINHA', DESCRICAO: 'LINHA', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'ATIVO', DESCRICAO: 'ATIVO', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'COR_ENT_MANUAL', DESCRICAO: 'COR ENTRADA MANUAL', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'COR_SAI_MANUAL', DESCRICAO: 'COR SAÍDA MANUAL', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'COR', DESCRICAO: 'COR PADRÃO PARA CADASTRO DE PRODUTO', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'FAIXA_TAMANHO', DESCRICAO: 'FAIXA DE TAMANHO PADRÃO PARA CADASTRO DE PRODUTO', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'MARCA', DESCRICAO: 'MARCA', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'CATEGORIA', DESCRICAO: 'CATEGORIA', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'MODELO', DESCRICAO: 'MODELO', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'TAMANHO', DESCRICAO: 'TAMANHO', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'TIPO_VENDA', DESCRICAO: 'DEFINE O TIPO DE VENDA AO ADICIONAR TIPO DE VENDA/REGRA', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'TRIBUTACAO', DESCRICAO: 'DEFINE A TRIBUTAÇÃO AO ADICIONAR TIPO DE VENDA/REGRA', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'REGRA', DESCRICAO: 'DEFINE A REGRA AO ADICIONAR TIPO DE VENDA/REGRA', VALOR: '', HINT: '' },
    { TABELA: 'PRODUTO', CAMPO: 'SPED', DESCRICAO: 'DEFINE O CODIGO SPED AO ADICIONAR TIPO DE VENDA/REGRA', VALOR: '', HINT: '' },

    //MATERIAL
    { TABELA: 'MATERIAL', CAMPO: 'UNIDADE', DESCRICAO: 'UNIDADE DO MATERIAL', VALOR: '', HINT: '' },
    { TABELA: 'MATERIAL', CAMPO: 'UNI_COM', DESCRICAO: 'UNIDADE DE COMPRA', VALOR: '', HINT: '' },
    { TABELA: 'MATERIAL', CAMPO: 'CODFIS', DESCRICAO: 'CÓDIGO NCM', VALOR: '', HINT: '' },
    { TABELA: 'MATERIAL', CAMPO: 'CODTRI', DESCRICAO: 'CST DE ICMS DE SAÍDA', VALOR: '', HINT: '' },
    { TABELA: 'MATERIAL', CAMPO: 'CODTRI_ENT', DESCRICAO: 'CST DE ICMS DE ENTRADA', VALOR: '', HINT: '' },
    { TABELA: 'MATERIAL', CAMPO: 'CODIPI', DESCRICAO: 'CST DE IPI DE SAÍDA', VALOR: '', HINT: '' },
    { TABELA: 'MATERIAL', CAMPO: 'CODIPI_ENT', DESCRICAO: 'CST DE IPI DE ENTRADA', VALOR: '', HINT: '' },
    { TABELA: 'MATERIAL', CAMPO: 'CDCENTRO', DESCRICAO: 'CENTRO DE CUSTO', VALOR: '', HINT: '' },
    { TABELA: 'MATERIAL', CAMPO: 'IPI', DESCRICAO: 'PERCENTUAL DE IPI', VALOR: '', HINT: '' },
    { TABELA: 'MATERIAL', CAMPO: 'POSSE', DESCRICAO: 'POSSE', VALOR: '', HINT: '' },
    { TABELA: 'MATERIAL', CAMPO: 'SPED', DESCRICAO: 'SPED', VALOR: '', HINT: '' },
    { TABELA: 'MATERIAL', CAMPO: 'TRIBUTACAO', DESCRICAO: 'TRIBUTAÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'MATERIAL', CAMPO: 'ENQUADRA', DESCRICAO: 'ENQUADRAMENTO IPI', VALOR: '', HINT: '' },
    { TABELA: 'MATERIAL', CAMPO: 'NATUREZA', DESCRICAO: 'NATUREZA', VALOR: '', HINT: '' },
    { TABELA: 'MATERIAL', CAMPO: 'STATUS', DESCRICAO: 'STATUS', VALOR: '', HINT: '' },
    { TABELA: 'MATERIAL', CAMPO: 'GRUPO_MA', DESCRICAO: 'GRUPO DO MATERIAL', VALOR: '', HINT: '' },
    { TABELA: 'MATERIAL', CAMPO: 'SUBGRUPO_MA', DESCRICAO: 'SUBGRUPO DO MATERIAL', VALOR: '', HINT: '' },
    { TABELA: 'MATERIAL', CAMPO: 'ATIVO', DESCRICAO: 'ATIVO', VALOR: '', HINT: '' },
    { TABELA: 'MATERIAL', CAMPO: 'ESTOQUE', DESCRICAO: 'CONTROLA ESTOQUE (S = Controla Estoque / N = Não Controla Estoque)', VALOR: '', HINT: '' },
    { TABELA: 'MATERIAL', CAMPO: 'PESO', DESCRICAO: 'PESO (Ex: 5.35 "Ponto para separar decimais.")', VALOR: '', HINT: '' },
    { TABELA: 'MATERIAL', CAMPO: 'COR', DESCRICAO: 'COR PADRÃO PARA CADASTRO DE MATERIAL', VALOR: '', HINT: '' },

    //ENTIDADE
    { TABELA: 'ENTIDADE', CAMPO: 'CC_CLIENTE', DESCRICAO: 'CODIGO/INICIO CONTA CONTABIL CLIENTE', VALOR: '', HINT: 'Verificar parâmentro do web Financeiro posição 15' },
    { TABELA: 'ENTIDADE', CAMPO: 'CC_FORNECEDOR', DESCRICAO: 'CODIGO/INICIO CONTA CONTABIL FORNECEDOR', VALOR: '', HINT: 'Verificar parâmentro do web Financeiro posição 15' },
    { TABELA: 'ENTIDADE', CAMPO: 'CC_ADIANTAMENTO', DESCRICAO: 'CODIGO/INICIO CONTA CONTABIL ADIANTAMENTO', VALOR: '', HINT: 'Verificar parâmentro do web Financeiro posição 15' },
    { TABELA: 'ENTIDADE', CAMPO: 'CC_DEVOLUCAO', DESCRICAO: 'CODIGO/INICIO CONTA CONTABIL DEVOLUCAO', VALOR: '', HINT: 'Verificar parâmentro do web Financeiro posição 15' },
    { TABELA: 'ENTIDADE', CAMPO: 'CF_ADIANTAMENTO', DESCRICAO: 'CODIGO/INICIO CONTA FORNECEDOR ADIANTAMENTO', VALOR: '', HINT: 'Verificar parâmentro do web Financeiro posição 15' },
    { TABELA: 'ENTIDADE', CAMPO: 'CF_DEVOLUCAO', DESCRICAO: 'CODIGO/INICIO CONTA FORNECEDOR DEVOLUCAO', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'GRUPO_CLI', DESCRICAO: 'GRUPO DE ENTIDADE', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'HISTORICO', DESCRICAO: 'HISTORICO', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'BANCO', DESCRICAO: 'BANCO', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'SIT_DUP', DESCRICAO: 'SITUACAO DUPLICATA', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'IE_DESTINATARIO', DESCRICAO: 'INDICADOR DO IE DE DESTINATARIO', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'CODREP', DESCRICAO: 'REPRESENTANTE', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'RAMO_ATIV', DESCRICAO: 'RAMO ATIV', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'CONS_FINAL', DESCRICAO: 'CONSUMIDOR FINAL', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'NATUREZA', DESCRICAO: 'NATUREZA SAIDA', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'NATUREZA_ENTRA', DESCRICAO: 'NATUREZA ENTRADA', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'TRANSPORTE', DESCRICAO: 'TRANSPORTADORA', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'TRIBUTACAO', DESCRICAO: 'VALOR PADRÃO AO CADASTRAR ENTIDADE', VALOR: '', HINT: 'Valor fixo da aba tributação ao cadastrar entidade.' },
    { TABELA: 'ENTIDADE', CAMPO: 'TP_FRETE', DESCRICAO: 'TIPO DE FRETE', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'CLASSE', DESCRICAO: 'CLASSE GERENCIAL', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'EMAIL', DESCRICAO: 'EMAIL', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'FORMA_PAGTO', DESCRICAO: 'FORMAS DE PAGAMENTO (SEPARAR POR VIRGULA QUANDO + DE 1)', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'MARKUP', DESCRICAO: 'MARKUP', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'MOEDAS', DESCRICAO: 'MOEDAS (SEPARAR POR VIRGULA QUANDO + DE 1)', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'TIPO_ENTIDADE', DESCRICAO: 'TIPO DA ENTIDADE', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'VAL_LIMIT_CONSIGNADO', DESCRICAO: 'VALOR INICIAL LIMITE DE CRÉDITO CONSIGNADO', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'VAL_LIMIT_VENDA', DESCRICAO: 'VALOR INICIAL LIMITE DE CRÉDITO VENDA', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'VAL_LIMIT_MAIOR_12', DESCRICAO: 'VALOR LIMITE DE CRÉDITO PARA CLIENTES CADASTRADOS COM MAIS DE 12 MESES', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'PERC_RECALC_LIMIT_CR', DESCRICAO: 'PERCENTUAL PARA RECALCULAR LIMITE DE CRÉDITO', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'NUMERO_MESES_RECALC', DESCRICAO: 'NÚMERO DE MESES PARA RECALCULAR LIMITE DE CRÉDITO', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'TIPO_PESSOA', DESCRICAO: 'TIPO PESSOA DA ENTIDADE', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'CEP_PADRAO', DESCRICAO: 'CEP PADRAO PARA CADASTRAR UM NOVO CLIENTE', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'NUMERO_PADRAO', DESCRICAO: 'NÚMERO DE ENDEREÇO PADRÃO DO CLIENTE.', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'PAIS', DESCRICAO: 'CÓDIGO DO PAÍS PADRÃO PARA CADASTRAR UM NOVO CLIENTE', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'TABELA_PRECO', DESCRICAO: 'CÓDIGO DA TABELA DE PREÇO', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'COD_CONF_XML', DESCRICAO: 'CÓDIGO DA CONFIGURAÇÃO DO XML', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'REQUER_ANALISE', DESCRICAO: 'IDENTIFICA SE CADASTRO NOVO REQUER ANÁLISE', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'DDI', DESCRICAO: 'DDI TELEFONE', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'DDD', DESCRICAO: 'DDD TELEFONE', VALOR: '', HINT: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'TELEFONE', DESCRICAO: 'TELEFONE', VALOR: '', HINT: '' },

    //PEDIDO
    { TABELA: 'PEDIDO', CAMPO: 'DEPOSITO', DESCRICAO: 'DEPOSITO', VALOR: '', HINT: '' },
    { TABELA: 'PEDIDO', CAMPO: 'OPER_FISCAL', DESCRICAO: 'OPERAÇÃO FISCAL', VALOR: '', HINT: '' },
    { TABELA: 'PEDIDO', CAMPO: 'STATUS', DESCRICAO: 'STATUS', VALOR: '', HINT: '' },
    { TABELA: 'PEDIDO', CAMPO: 'QUALIDADE', DESCRICAO: 'QUALIDADE', VALOR: '', HINT: '' },
    { TABELA: 'PEDIDO', CAMPO: 'TIPO_OF', DESCRICAO: 'TIPO OF', VALOR: '', HINT: '' },
    { TABELA: 'PEDIDO', CAMPO: 'TIPO', DESCRICAO: 'TIPO', VALOR: '', HINT: '' },
    { TABELA: 'PEDIDO', CAMPO: 'TRANSPORTADORA', DESCRICAO: 'TRANSPORTADORA', VALOR: '', HINT: '' },
    { TABELA: 'PEDIDO', CAMPO: 'SIT_DUP', DESCRICAO: 'SIT_DUP', VALOR: '', HINT: '' },
    { TABELA: 'PEDIDO', CAMPO: 'HISTORICO', DESCRICAO: 'HISTORICO', VALOR: '', HINT: '' },
    { TABELA: 'PEDIDO', CAMPO: 'DEP_FILHO', DESCRICAO: 'DEP_FILHO', VALOR: '', HINT: '' },
    { TABELA: 'PEDIDO', CAMPO: 'STATUS_CANC_API', DESCRICAO: 'STATUS_CANC_API', VALOR: '', HINT: '' },
    { TABELA: 'PEDIDO', CAMPO: 'STATUS_ANTECIPACAO', DESCRICAO: 'STATUS_ANTECIPACAO', VALOR: '', HINT: '' },
    { TABELA: 'PEDIDO', CAMPO: 'ITEM_PADRAO', DESCRICAO: 'ITEM PADRÃO (P/M)', VALOR: '', HINT: '' },
    { TABELA: 'PEDIDO', CAMPO: 'STATUS_DEST', DESCRICAO: 'DEFINE STATUS AO IMPRIMIR O PEDIDO NO RELATÓRIO DE PEDIDOS', VALOR: '', HINT: '' },
    { TABELA: 'PEDIDO', CAMPO: 'TIPO_VENDA', DESCRICAO: 'DEFINE O TIPO DE VENDA', VALOR: '', HINT: '' },
    { TABELA: 'PEDIDO', CAMPO: 'RESPONSAVEL', DESCRICAO: 'DEFINE O RESPONSÁVEL PADRÃO AO INCLUIR PEDIDO', VALOR: '', HINT: '' },
    { TABELA: 'PEDIDO', CAMPO: 'COLECAO', DESCRICAO: 'DEFINE A COLEÇÃO PADRÃO AO INCLUIR PEDIDO', VALOR: '', HINT: '' },
    { TABELA: 'PEDIDO', CAMPO: 'STATUS_LIB_COMERCIAL', DESCRICAO: 'DEFINE O STATUS PADRÃO PARA REALIZAR A LIBERAÇÃO COMERCIAL', VALOR: '', HINT: '' },
    { TABELA: 'PEDIDO', CAMPO: 'TABELA_PRECO', DESCRICAO: 'TABELA DE PREÇO PADRÃO', VALOR: '', HINT: '' },
    { TABELA: 'PEDIDO', CAMPO: 'PRAZO_ENTREGA', DESCRICAO: 'PRAZO DE ENTREGA', VALOR: '', HINT: '' },
    { TABELA: 'PEDIDO', CAMPO: 'PRAZO_PRODUCAO', DESCRICAO: 'PRAZO DE PRODUÇÃO', VALOR: '', HINT: '' },

    //NOTA_ENTRA
    { TABELA: 'NOTA_ENTRA', CAMPO: 'NATUREZA', DESCRICAO: 'NATUREZA', VALOR: '', HINT: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'NAT_SERVICO', DESCRICAO: 'NATUREZA SERVIÇO', VALOR: '', HINT: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'OPERACAO', DESCRICAO: 'OPERACAO', VALOR: '', HINT: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'DEPOSITO', DESCRICAO: 'DEPOSITO', VALOR: '', HINT: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'TP_MOV', DESCRICAO: 'TIPO DE MOVIMENTAÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'HISTORICO', DESCRICAO: 'HISTORICO', VALOR: '', HINT: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'SITUACAO', DESCRICAO: 'SITUACAO', VALOR: '', HINT: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'CONTA', DESCRICAO: 'CONTA', VALOR: '', HINT: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'BANCO', DESCRICAO: 'BANCO', VALOR: '', HINT: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'CLASSE', DESCRICAO: 'CLASSE', VALOR: '', HINT: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'TIPO_ITEM', DESCRICAO: 'TIPO ITEM PADRÃO AO CADASTRAR NOVOS ITENS NA ENTRADA DE NF', VALOR: '', HINT: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'IMP_IMPOSTO_NOTA', DESCRICAO: ' TRAZER MARCADO A OPÇÃO IMPORTAR IMPOSTOS DA NOTA (S/N)', VALOR: '', HINT: '' },

    //NOTA
    { TABELA: 'NOTA', CAMPO: 'NATUREZA', DESCRICAO: 'NATUREZA', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'OPERACAO', DESCRICAO: 'OPERACAO', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'DEPOSITO', DESCRICAO: 'DEPOSITO', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'UF_EMBARQUE', DESCRICAO: 'UF EMBARQUE', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'LOCAL_EMBARQUE', DESCRICAO: 'LOCAL EMBARQUE', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'PRESENCA', DESCRICAO: 'PRESENÇA', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'MOEDA', DESCRICAO: 'MOEDA', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'HISTORICO', DESCRICAO: 'HISTÓRICO', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'BANCO', DESCRICAO: 'BANCO', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'SITUACAO', DESCRICAO: 'SITUAÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'CLASSE_GERENCIAL', DESCRICAO: 'CLASSE GERENCIAL', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'ENDERECO_A_FATURAR', DESCRICAO: 'ENDEREÇO PARA PUXAR NO FATURAMENTO DA EXPEDIÇÃO E FATURAMENTO GERAL IMPORTANDO O PEDIDO', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'NAO_ALTERA_DIFAL', DESCRICAO: 'BLOQUEIA EDIÇÃO NO CHECK DIFAL', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'RECEITA_DIFAL', DESCRICAO: 'DEFINE O CÓDIGO PADRÃO PARA RECEITA DO DIFAL', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'DETALHE_DIFAL', DESCRICAO: 'DEFINE O VALOR PADRÃO PARA DETALHE DO DIFAL', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'RECEITA_POBREZA', DESCRICAO: 'DEFINE O CÓDIGO PADRÃO PARA RECEITA DE POBREZA', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'DETALHE_POBREZA', DESCRICAO: 'DEFINE VALOR PADRÃO PARA DETALHE DE POBREZA', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'COD_BAIXA_CANCEL_NFE', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO (CANCELAMENTO DE NF-E)', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'ENVIA_EMAIL_ATRASO', DESCRICAO: 'EMAILS PARA ENVIAR CLIENTES COM PENDÊNCIA (SEPARADO POR ;)', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'OPERACAO_BRINDE', DESCRICAO: 'CÓDIGO DE OPERAÇÃO PADRÃO PARA FATURAMENTO DE BRINDE', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'APENAS_FAT_WEB', DESCRICAO: 'FILTRA APENAS FATURAMENTO WEB (IMPRESSÃO NFE E RELFATURAMENTO)', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'NAO_ALTERA_EXPEDIDOS', DESCRICAO: 'TRAZ O CHECK SOMENTE EXPEDIDOS MARCADO E BLOQUEADO AO IMPORTAR PEDIDOS NO FATURAMENTO GERAL', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'NFCE_CONTINGENCIA', DESCRICAO: '0 OU VAZIO TRANSMITE NORMAL, 1 TRANSMITE EM CONTINGENCIA', VALOR: '', HINT: '' },
    { TABELA: 'NOTA', CAMPO: 'BLOQUEIO_GNRE', DESCRICAO: 'VALORES S OU N, POR PADRÃO GRAVA COMO S', VALOR: '', HINT: '' },

    //ESTOQUE
    { TABELA: 'ESTOQUE', CAMPO: 'TIPO', DESCRICAO: 'TIPO DE MOVIMENTO', VALOR: '', HINT: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'DEPOSITO', DESCRICAO: 'DEPOSITO', VALOR: '', HINT: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'QUALIDADE', DESCRICAO: 'Entrada/Saída Manual Produto | QUALIDADE (CÓDIGO)', VALOR: '', HINT: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'QUALIDADE_MATERIAL', DESCRICAO: 'Entrada/Saída Manual Material | QUALIDADE  (CÓDIGO)', VALOR: '', HINT: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'TIPO_CONFERENCIA', DESCRICAO: 'TIPO CONFERENCIA', VALOR: '', HINT: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'LOTE_MATERIAL', DESCRICAO: 'LOTE DO MATERIAL', VALOR: '', HINT: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'ENTRADA_MAT', DESCRICAO: 'Tela: Entrada Manual Material |  TIPO DE ENTRADA (CÓDIGO)', VALOR: '', HINT: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'ENTRADA_PROD', DESCRICAO: 'Tela: Entrada Manual Produto |  TIPO DE ENTRADA (CÓDIGO)', VALOR: '', HINT: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'SAIDA_MAT', DESCRICAO: 'Tela: Saída Manual Material |  TIPO SAÍDA (CÓDIGO)', VALOR: '', HINT: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'SAIDA_PROD', DESCRICAO: 'Tela: Saída Manual Produto |  TIPO SAÍDA (CÓDIGO)', VALOR: '', HINT: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'MOV_IMPORTACAO', DESCRICAO: 'Tela: Importação |  TIPO MOVIMENTO (CÓDIGO)', VALOR: '', HINT: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'MERCAD_TIPO_SAIDA', DESCRICAO: 'Tela: Mercadorias |  TIPO MOVIMENTO SAÍDA (CÓDIGO)', VALOR: '', HINT: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'MERCAD_TIPO_ENTRADA', DESCRICAO: 'Tela: Mercadorias |  TIPO MOVIMENTO ENTRADA (CÓDIGO)', VALOR: '', HINT: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'CONF_TIPO_BAIXA', DESCRICAO: 'Tela: Conferência de Inventário | TIPO DE BAIXA (CÓDIGO)', VALOR: '', HINT: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'MERCAD_DEPOSITO_SAIDA', DESCRICAO: 'Tela: Mercadorias Produto | Depósito Saída (CÓDIGO)', VALOR: '', HINT: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'MERCAD_DEPOSITO_ENTRADA', DESCRICAO: 'Tela: Mercadorias Produto | Depósito Entrada (CÓDIGO)', VALOR: '', HINT: '' },

    //TRANS_DEPOSITO
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'FUNCIONARIO_PROD', DESCRICAO: 'FUNCIONARIO (PRODUTO)', VALOR: '', HINT: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'DEPOSITO_ORIGEM_PROD', DESCRICAO: 'DEPÓSITO ORIGEM (PRODUTO)', VALOR: '', HINT: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'DEPOSITO_DEST_PROD', DESCRICAO: 'DEPÓSITO DESTINO (PRODUTO)', VALOR: '', HINT: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'TIPO_MOVTO_PROD', DESCRICAO: 'TIPO DE MOVIMENTO SAÍDA (PRODUTO)', VALOR: '', HINT: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'TIPO_MOVTO_PROD_ENTR', DESCRICAO: 'TIPO DE MOVIMENTO ENTRADA (PRODUTO)', VALOR: '', HINT: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'FUNCIONARIO_MAT', DESCRICAO: 'FUNCIONARIO (MATERIAL)', VALOR: '', HINT: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'DEPOSITO_ORIGEM_MAT', DESCRICAO: 'DEPÓSITO ORIGEM (MATERIAL)', VALOR: '', HINT: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'DEPOSITO_DEST_MAT', DESCRICAO: 'DEPÓSITO DESTINO (MATERIAL)', VALOR: '', HINT: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'TIPO_MOVTO_MAT', DESCRICAO: 'TIPO DE MOVIMENTO SAÍDA (MATERIAL)', VALOR: '', HINT: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'TIPO_MOVTO_MAT_ENTRA', DESCRICAO: 'TIPO DE MOVIMENTO ENTRADA (MATERIAL)', VALOR: '', HINT: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'COD_BAIXA_ESTR_SAID', DESCRICAO: 'CÓDIGO DE BAIXA DE ENTRADA NO ESTORNO (MATERIAL)', VALOR: '', HINT: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'COD_BAIXA_ESTR_ENTR', DESCRICAO: 'CODIGO DE BAIXA DE SAÍDA NO ESTORNO (MATERIAL)', VALOR: '', HINT: '' },

    //RECEBER
    { TABELA: 'RECEBER', CAMPO: 'CLASSE', DESCRICAO: 'CLASSE GERENCIAL', VALOR: '', HINT: '' },
    { TABELA: 'RECEBER', CAMPO: 'SITUACAO', DESCRICAO: 'SITUAÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'RECEBER', CAMPO: 'STATUS', DESCRICAO: 'STATUS', VALOR: '', HINT: '' },
    { TABELA: 'RECEBER', CAMPO: 'MOEDA', DESCRICAO: 'MOEDA', VALOR: '', HINT: '' },
    { TABELA: 'RECEBER', CAMPO: 'CONTA', DESCRICAO: 'CONTA', VALOR: '', HINT: '' },
    { TABELA: 'RECEBER', CAMPO: 'EMISSAO_DE', DESCRICAO: 'CONSIDERAR O DIA 1º DO MÊS ATUAL PARA A CONSULTA DAS DUPLICATAS (INFORMAR S PARA ATIVAR).', VALOR: '', HINT: '' },
    { TABELA: 'RECEBER', CAMPO: 'VENCIMENTO_DE', DESCRICAO: 'CONSIDERAR O DIA 1º DO MÊS ATUAL PARA A CONSULTA DAS DUPLICATAS (INFORMAR S PARA ATIVAR).', VALOR: '', HINT: '' },
    { TABELA: 'RECEBER', CAMPO: 'PAGAMENTO_DE', DESCRICAO: 'CONSIDERAR O DIA 1º DO MÊS ATUAL PARA A CONSULTA DAS DUPLICATAS (INFORMAR S PARA ATIVAR).', VALOR: '', HINT: '' },
    { TABELA: 'RECEBER', CAMPO: 'CFOP_PAGTO_INTEGRADO', DESCRICAO: 'SERÁ RESPONSÁVEL POR PREENCHER A NATUREZA DA NFCE QUANDO FOR BAIXADO UM RECEBER COM PAGAMENTO INTEGRADO (SOMENTE RS)', VALOR: '', HINT: '' },
    { TABELA: 'RECEBER', CAMPO: 'NCM_PAGTO_INTEGRADO', DESCRICAO: 'INFORMAR O CAMPO CÓDIGO DO CADASTRO DE NCM, SERÁ RESPONSÁVEL POR PREENCHER O NCM DA NFCE QUANDO FOR BAIXADO UM RECEBER COM PAGAMENTO INTEGRADO (SOMENTE RS)', VALOR: '', HINT: '' },
    { TABELA: 'RECEBER', CAMPO: 'HISTORICO_DESD', DESCRICAO: 'HISTÓRICO SUGERIDO AO DESDOBRAR DUPLICATA', VALOR: '', HINT: '' },
    { TABELA: 'RECEBER', CAMPO: 'SITUACAO_DESD', DESCRICAO: 'SITUAÇÃO SUGERIDA AO DESDOBRAR DUPLICATA', VALOR: '', HINT: '' },
    { TABELA: 'RECEBER', CAMPO: 'PERC_JUROS', DESCRICAO: 'CONSIDERAR O PERCENTUAL DE JUROS AO REALIZAR A BAIXA NO RECEBER', VALOR: '', HINT: '' },
    { TABELA: 'RECEBER', CAMPO: 'DIAS_TOLERANCIA_JUROS', DESCRICAO: 'CONSIDERAR ACIMA DE X DIAS PARA PERMITIR CALCULAR O JUROS AO REALIZAR A BAIXA NO RECEBER', VALOR: '', HINT: '' },
    { TABELA: 'RECEBER', CAMPO: 'DIAS_UTEIS', DESCRICAO: 'DEFINIRÁ SE DEVE CONSIDERAR SOMENTE OS DIAS ÚTEIS PARA DATAS NO RECEBER', VALOR: '', HINT: '' },

    //PAGTO
    { TABELA: 'PAGTO', CAMPO: 'EMISSAO_DE', DESCRICAO: 'CONSIDERAR O DIA 1º DO MÊS ATUAL PARA A CONSULTA DAS DUPLICATAS (INFORMAR S PARA ATIVAR).', VALOR: '', HINT: '' },
    { TABELA: 'PAGTO', CAMPO: 'VENCIMENTO_DE', DESCRICAO: 'CONSIDERAR O DIA 1º DO MÊS ATUAL PARA A CONSULTA DAS DUPLICATAS (INFORMAR S PARA ATIVAR).', VALOR: '', HINT: '' },
    { TABELA: 'PAGTO', CAMPO: 'INTERVALO_DIAS_EMISSAO', DESCRICAO: 'INTERVALO DE DIAS DE EMISSAO', VALOR: '', HINT: '' },
    { TABELA: 'PAGTO', CAMPO: 'STATUS', DESCRICAO: 'STATUS', VALOR: '', HINT: '' },
    { TABELA: 'PAGTO', CAMPO: 'SITUACAO', DESCRICAO: 'SITUACAO', VALOR: '', HINT: '' },
    { TABELA: 'PAGTO', CAMPO: 'FORNECEDOR', DESCRICAO: 'FORNECEDOR', VALOR: '', HINT: '' },
    { TABELA: 'PAGTO', CAMPO: 'CLASSE_GERENCIAL', DESCRICAO: 'CLASSE GERENCIAL', VALOR: '', HINT: '' },
    { TABELA: 'PAGTO', CAMPO: 'HISTORICO', DESCRICAO: 'HISTÓRICO', VALOR: '', HINT: '' },
    { TABELA: 'PAGTO', CAMPO: 'SITUACAO_CODIGO', DESCRICAO: 'CÓDIGO DA SITUAÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'PAGTO', CAMPO: 'BANCO', DESCRICAO: 'BANCO', VALOR: '', HINT: '' },
    { TABELA: 'PAGTO', CAMPO: 'CONTA', DESCRICAO: 'CONTA', VALOR: '', HINT: '' },
    { TABELA: 'PAGTO', CAMPO: 'SITUACAO_DUP', DESCRICAO: 'SITUAÇÃO DUPLICATA', VALOR: '', HINT: '' },

    //LOJA
    { TABELA: 'LOJA', CAMPO: 'INFORMACOES_CLIENTE', DESCRICAO: 'ABRE A TELA DE INFORMAÇÕES CLIENTE AO SAIR DO CAMPO DE CLIENTE (INFORMAR S PARA ATIVAR)', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'RETORNA_USUARIO', DESCRICAO: 'RETORNA USUÁRIO LOGADO AO ABRIR OS FILTROS DO RELATÓRIO DE VENDA (INFORMAR S PARA ATIVAR)', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'BUSCA_PRECO_PEDIDO', DESCRICAO: 'MARCA CHECK BUSCA PREÇO PEDIDO NO MODAL DE IMPORTAÇÃO DENTRO DA PRÉ-VENDA (INFORMAR "Sim" PARA ATIVAR)', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'LANCAR_ANTECIPACAO', DESCRICAO: 'MARCA CHECK LANÇAR COMO ANTECIPAÇÃO NO MODAL DE CARTÃO PRESENTE DO LOJA (INFORMAR "Sim" PARA ATIVAR)', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'DIAS_CARTAO_PRES', DESCRICAO: 'DIAS PADRÃO PARA VALIDADE AO CRIAR O CARTÃO PRESENTE', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'DIAS_CONFERENCIA', DESCRICAO: 'DIAS PARA BLOQUEIO DO FECHAMENTO DE CAIXA CASO TENHA MERCADORIA NÃO CONFERIDA PELA TELA DE MERCADORIAS', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'VALOR_MAX_NFCE', DESCRICAO: 'VALOR MÁXIMO PERMITIDO PARA GERAR NFCE NA VENDA', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'COD_BAIXA_VENDA', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO (VENDA)', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'COD_BAIXA_CANC_VENDA', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO (CANCELAMENTO DE VENDA)', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'COD_BAIXA_DESDOB_SAI', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO DE SAIDA (DESDOBRAMENTO DE LOTE PELA VENDA)', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'COD_BAIXA_DESDOB_ENT', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO DE ENTRADA (DESDOBRAMENTO DE LOTE PELA VENDA)', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'COD_BAIXA_VENDA_PEND', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO (VENDA PENDENTE)', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'COD_BAIXA_BRINDE', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO (BRINDE)', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'COD_BAIXA_C_BRINDE', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO (CANCELAMENTO DE BRINDE)', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'QUALIDADE', DESCRICAO: 'DEFINIRÁ A QUALIDADE PADRÃO NOS ITENS DA VENDA (NECESSÁRIO TER O PARÂMETRO 42 DO VENDAS CONFIGURADO)', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'TAB_PRECO_BRINDE', DESCRICAO: 'DEFINIRÁ A TABELA DE PREÇO PADRÃO DO BRINDE', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'MOEDA_NAO_INTEGRANET', DESCRICAO: 'CÓDIGO DAS MOEDAS QUE NÃO SERÃO INTEGRADAS COM O NETSHOPPING (SE CONTER DUAS OU MAIS SEPARE POR VÍRGULA. EXEMPLO: 0,1,2)', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'DIAS_DUPL_ATRASO', DESCRICAO: 'IRÁ SOMAR OS DIAS APÓS O VENCIMENTO PARA BLOQUEAR AS DUPLICATAS EM ATRASO (QUANDO PARÂMETRO VENDA 24 FOR DIFERENTE DE NÃO CONTROLAR)', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'DESCONTO_ITENS_PROMOCIONAIS', DESCRICAO: 'DEFINIRÁ SE VIRÁ MARCADO POR PADRÃO A OPÇÃO DE NÃO APLICAR DESCONTO EM ITENS PROMOCIONAIS AO DAR DESCONTO EM MASSA', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'STATUS', DESCRICAO: 'STATUS DA VENDA', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'TAB_PRECO_CONSIG', DESCRICAO: 'DEFINIRÁ A TABELA DE PREÇO PADRÃO DO CONSIGNADO', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'LOTE_PESQUISA_ITENS', DESCRICAO: 'DEFINIRÁ O LOTE PADRÃO PARA PESQUISA DE MATERIAIS DENTRO DA VENDA', VALOR: '', HINT: '' },
    { TABELA: 'LOJA', CAMPO: 'CONTA_DEBITO_MOEDA_CONTABIL', DESCRICAO: 'IRÁ BUSCAR A CONTA DÉBITO DA MOEDA AO FAZER O LANÇAMENTO FINANCEIRO DO CONTÁBIL', VALOR: '', HINT: '' },

    //CASHBACK
    { TABELA: 'CASHBACK', CAMPO: 'VAL_MIN', DESCRICAO: 'VALOR MÍNIMO DE CASHBACK NECESSÁRIO PARA UTILIZAR NA VENDA', VALOR: '', HINT: 'Exemplo: Se informar R$ 50,00 e tiver um saldo de cashback de R$ 5,00 não poderá utilizar na venda. Somente com saldo de R$ 50,00 ou superior' },
    { TABELA: 'CASHBACK', CAMPO: 'PERCENTUAL', DESCRICAO: 'PERCENTUAL', VALOR: '', HINT: 'Exemplo: Informe o valor (automaticamente será considerado em %) para gerar cashback na venda' },
    { TABELA: 'CASHBACK', CAMPO: 'VALIDADE', DESCRICAO: 'TEMPO DE VALIDADE EM DIAS', VALOR: '', HINT: 'Exemplo: Cashback de R$ 10,00 gerado no dia de hoje, vencerá em XXX dias corridos e não poderá mais ser utilizado' },
    { TABELA: 'CASHBACK', CAMPO: 'PERC_MAX', DESCRICAO: 'PERCENTUAL MÁXIMO DE UTILIZAÇÃO NA VENDA', VALOR: '', HINT: 'Exemplo: Saldo de cashback é de R$ 500,00 somente X % pode ser utilizado na venda' },
    { TABELA: 'CASHBACK', CAMPO: 'VALOR', DESCRICAO: 'VALOR MÍNIMO DA VENDA PARA UTILIZAR O CASHBACK', VALOR: '', HINT: 'Exemplo: Somente vendas acima de X valor, pode ser utilizado o cashback' },
    { TABELA: 'CASHBACK', CAMPO: 'PRZ_UTILIZACAO', DESCRICAO: 'PRAZO DE DIAS PARA INICIAR A UTILIZAÇÃO DO CASHBACK', VALOR: '', HINT: 'Exemplo: Cashback de R$ 10,00 gerado no dia de hoje, só poderá ser utilizado daqui XXX dias' },

    //DESDOBRALOTE
    { TABELA: 'DESDOBRALOTE', CAMPO: 'TIPO_BAIXA', DESCRICAO: 'TIPO DE BAIXA', VALOR: '', HINT: '' },
    { TABELA: 'DESDOBRALOTE', CAMPO: 'DEPOSITO', DESCRICAO: 'DEPOSITO', VALOR: '', HINT: '' },
    { TABELA: 'DESDOBRALOTE', CAMPO: 'DEPOSITO_ENTRADA', DESCRICAO: 'DEPOSITO DE ENTRADA', VALOR: '', HINT: '' },
    { TABELA: 'DESDOBRALOTE', CAMPO: 'LOCAL', DESCRICAO: 'LOCAL', VALOR: '', HINT: '' },
    { TABELA: 'DESDOBRALOTE', CAMPO: 'SEQ_LOTE_DESDOBRADO', DESCRICAO: 'DEFINIRÁ O TAMANHO DO SEQUENCIAL DO NOVO LOTE GERADO', VALOR: '', HINT: '' },

    //DEVOLUCAO
    { TABELA: 'DEVOLUCAO', CAMPO: 'CLIENTE_PADRAO', DESCRICAO: 'SERÁ RESPONSÁVEL POR PREENCHER AUTOMATICAMENTE O CAMPO CLIENTE NA DEVOLUÇÃO (INFORMAR SOMENTE O CODCLI)', VALOR: '', HINT: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'VENC_ANTECIPACAO', DESCRICAO: 'DEFINIRÁ O VENCIMENTO DA ANTECIPAÇÃO A PARTIR DO DIA DE EMISSÃO (INFORMAR QTDE DE DIAS)', VALOR: '', HINT: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'BANCO', DESCRICAO: 'DEFINIRÁ O BANCO DA ANTECIPAÇÃO GERADA AO EFETUAR UMA DEVOLUÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'CONTA', DESCRICAO: 'DEFINIRÁ A CONTA DA ANTECIPAÇÃO GERADA AO EFETUAR UMA DEVOLUÇÃO (INFORMAR O NÚMERO DA CONTA)', VALOR: '', HINT: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'CLASSE', DESCRICAO: 'DEFINIRÁ A CLASSE DA ANTECIPAÇÃO GERADA AO EFETUAR UMA DEVOLUÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'HISTORICO', DESCRICAO: 'DEFINIRÁ O HISTÓRICO DA ANTECIPAÇÃO GERADA AO EFETUAR UMA DEVOLUÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'SITUACAO', DESCRICAO: 'DEFINIRÁ O SITUAÇÃO DA ANTECIPAÇÃO GERADA AO EFETUAR UMA DEVOLUÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'MOEDA', DESCRICAO: 'DEFINIRÁ A MOEDA DA ANTECIPAÇÃO GERADA AO EFETUAR UMA DEVOLUÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'DEPOSITO', DESCRICAO: 'DEFINIRÁ O DEPÓSITO DE UMA DEVOLUÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'COD_BAIXA_DEVOLUCAO', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO (DEVOLUÇÃO DE VENDA)', VALOR: '', HINT: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'COD_BAIXA_CANC_DEVOL', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO (CANCELAMENTO DE DEVOLUÇÃO)', VALOR: '', HINT: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'COD_BAIXA_DEV_CONS', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO (DEVOLUÇÃO PARCIAL NO AGRUPAMENTO DE VENDA)', VALOR: '', HINT: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'CONS_VENDA_DEV', DESCRICAO: 'CONSIDERAR APENAS ITENS NÃO DEVOLVIDOS NA PESQUISA DE ITENS AO REALIZAR UMA DEVOLUÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'DEVOLUCAO', CAMPO: 'DIAS_DEVOLUCAO', DESCRICAO: 'DEFINE A QUANTIDADE DE DIAS PARA ACEITAR A DEVOLUÇÃO SEM SOLICITAR SENHA DE SUPERVISOR (NECESSÁRIO TER O PARÂMETRO 14 DO VENDAS CONFIGURADO)', VALOR: '', HINT: '' },

    //ESCRITURAL //RETORNO
    { TABELA: 'RETORNO', CAMPO: 'CARTEIRA_REGISTRO', DESCRICAO: 'DEFINE SE O FLAG "CARTEIRA TEM REGISTRO" VEM SELECIONADO', VALOR: '', HINT: '' },
    { TABELA: 'RETORNO', CAMPO: 'CARTEIRA', DESCRICAO: 'DEFINE O VALOR PADRÃO DO CAMPO CARTEIRA', VALOR: '', HINT: '' },
    { TABELA: 'RETORNO', CAMPO: 'CLASSE_BAIXA', DESCRICAO: 'DEFINE O VALOR VALOR PADRÃO DO CAMPO CLASSE - BAIXA', VALOR: '', HINT: '' },
    { TABELA: 'RETORNO', CAMPO: 'CLASSE_JUROS', DESCRICAO: 'DEFINE O VALOR VALOR PADRÃO DO CAMPO CLASSE - JUROS', VALOR: '', HINT: '' },
    { TABELA: 'RETORNO', CAMPO: 'CLASSE_DESCONTO', DESCRICAO: 'DEFINE O VALOR VALOR PADRÃO DO CAMPO CLASSE - DESCONTO', VALOR: '', HINT: '' },
    { TABELA: 'RETORNO', CAMPO: 'HISTORICO', DESCRICAO: 'DEFINE O VALOR VALOR PADRÃO DO CAMPO HISTÓRICO', VALOR: '', HINT: '' },

    //EXTRATO_CARTAO
    { TABELA: 'EXTRATO_CARTAO', CAMPO: 'VALOR_DIFERENCA', DESCRICAO: 'CENTAVOS PARA ARREDONDAMENTO ENTRE O VALOR DA DUPLICATA E O VALOR PAGO NO CARTÃO', VALOR: '', HINT: '' },

    //LIBERACAO_EXPEDICAO
    { TABELA: 'LIBERACAO_EXPEDICAO', CAMPO: 'STATUS', DESCRICAO: 'STATUS PADRÃO CONSULTA', VALOR: '', HINT: '' },

    //B2B
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'TIPO', DESCRICAO: 'TIPO DO PEDIDO PADRÃO MAIS MIX', VALOR: '', HINT: '' },
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'MOTIVO', DESCRICAO: 'CAMPO MOTIVO QUE SERÁ GRAVADO NA ORDEM DE COMPRA', VALOR: '', HINT: '' },
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'COLECAO', DESCRICAO: 'CAMPO COLEÇÃO QUE SERÁ GRAVADO NA ORDEM DE COMPRA', VALOR: '', HINT: '' },
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'EMPRESA', DESCRICAO: 'CAMPO EMPRESA QUE SERÁ GRAVADO NA ORDEM DE COMPRA', VALOR: '', HINT: '' },
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'FRETE', DESCRICAO: 'CAMPO FRETE QUE SERÁ GRAVADO NA ORDEM DE COMPRA', VALOR: '', HINT: '' },
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'OBS', DESCRICAO: 'CAMPO OBSERVAÇÃO QUE SERÁ GRAVADO NA ORDEM DE COMPRA', VALOR: '', HINT: '' },
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'LIBERADO', DESCRICAO: 'CAMPO LIBERADO QUE SERÁ GRAVADO NA ORDEM DE COMPRA', VALOR: '', HINT: '' },
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'TELA', DESCRICAO: 'CAMPO TELA QUE SERÁ GRAVADO NA ORDEM DE COMPRA', VALOR: '', HINT: '' },
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'VAL_COTACAO', DESCRICAO: 'CAMPO VALOR DE COTAÇÃO QUE SERÁ GRAVADO NA ORDEM DE COMPRA', VALOR: '', HINT: '' },
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'SITUACAO', DESCRICAO: 'CAMPO SITUACAO QUE SERÁ GRAVADO NOS ITENS DA ORDEM DE COMPRA', VALOR: '', HINT: '' },
    { TABELA: 'B2B_MAIS_MIX', CAMPO: 'C_CUSTO', DESCRICAO: 'CAMPO C_CUSTO QUE SERÁ GRAVADO NOS ITENS DA ORDEM DE COMPRA', VALOR: '', HINT: '' },

    { TABELA: 'B2B_PRODUCAO', CAMPO: 'VALIDA_PERCENTUAL', DESCRICAO: 'VALIDA SE O PEDIDO VAI COM O STATUS BLOQUEADO FINANCEIRO DEPENDENDO DO PERCENTUAL DO VALOR DE ENTRADA.', VALOR: '', HINT: '' },

    { TABELA: 'B2B_ALTERACAO_PEDIDO', CAMPO: 'STATUS_CANCELAR', DESCRICAO: 'DEFINE STATUS DO PEDIDO B2B AO CLICAR EM CANCELAR NA TELA DE ALTERAÇÃO PEDIDOS B2B', VALOR: '', HINT: '' },

    // CRIAR PEDIDO
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'FATURA', DESCRICAO: 'FATURA DO PEDIDO', VALOR: '', HINT: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'PERIODO', DESCRICAO: 'PERÍODO DO PEDIDO', VALOR: '', HINT: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'MOEDA', DESCRICAO: 'MOEDA DO PEDIDO', VALOR: '', HINT: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'SITUACAO', DESCRICAO: 'SITUAÇÃO DO PEDIDO', VALOR: '', HINT: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'DEPOSITO', DESCRICAO: 'DEPÓSITO DO PEDIDO', VALOR: '', HINT: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'STATUS', DESCRICAO: 'STATUS DO PEDIDO', VALOR: '', HINT: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'DIAS_FATURA', DESCRICAO: 'ACRESCENTA X DIAS NA DATA DE EMISSÃO PARA SUGERIR A DATA DE FATURA', VALOR: '', HINT: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'DIAS_ENTREGA', DESCRICAO: 'ACRESCENTA X DIAS NA DATA DE EMISSÃO PARA SUGERIR A DATA DE ENTREGA', VALOR: '', HINT: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'DIAS_SAIDA', DESCRICAO: 'ACRESCENTA X DIAS NA DATA DE EMISSÃO PARA SUGERIR A DATA DE SAÍDA', VALOR: '', HINT: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'DIAS_SAIDA', DESCRICAO: 'ACRESCENTA X DIAS NA DATA DE EMISSÃO PARA SUGERIR A DATA DE SAÍDA', VALOR: '', HINT: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'EMP_FAT', DESCRICAO: 'DEFINE A EMPRESA DE FATURAMENTO DO PEDIDO', VALOR: '', HINT: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'OPERACAO_FISCAL', DESCRICAO: 'DEFINE A OPERAÇÃO FISCAL DO PEDIDO', VALOR: '', HINT: '' },
    { TABELA: 'CRIAR_PEDIDO', CAMPO: 'TRANSPORTADORA', DESCRICAO: 'DEFINE A TRANSPORTADORA DO PEDIDO', VALOR: '', HINT: '' },

    //PRECO_MEDIO
    { TABELA: 'PRECO_MEDIO', CAMPO: 'CONSIDERAR_COR', DESCRICAO: 'CONSIDERAR A COR PARA CALCULAR O PREÇO MÉDIO DO PRODUTO', VALOR: '', HINT: '' },
    { TABELA: 'PRECO_MEDIO', CAMPO: 'CONSIDERAR_TAM', DESCRICAO: 'CONSIDERAR O TAMANHO PARA CALCULAR O PREÇO MÉDIO DO PRODUTO', VALOR: '', HINT: '' },
    { TABELA: 'PRECO_MEDIO', CAMPO: 'CONSIDERAR_DEPOSITO', DESCRICAO: 'CONSIDERAR O DEPÓSITO PARA CALCULAR O PREÇO MÉDIO DO PRODUTO', VALOR: '', HINT: '' },
    { TABELA: 'PRECO_MEDIO', CAMPO: 'CONSIDERAR_QUALIDADE', DESCRICAO: 'CONSIDERAR A QUALIDADE PARA CALCULAR O PREÇO MÉDIO DO PRODUTO', VALOR: '', HINT: '' },
    { TABELA: 'PRECO_MEDIO', CAMPO: 'CONSIDERAR_LOTE', DESCRICAO: 'CONSIDERAR O LOTE PARA CALCULAR O PREÇO MÉDIO DO PRODUTO', VALOR: '', HINT: '' },
    { TABELA: 'PRECO_MEDIO', CAMPO: 'CONSIDERAR_LOCAL', DESCRICAO: 'CONSIDERAR O LOCAL PARA CALCULAR O PREÇO MÉDIO DO PRODUTO', VALOR: '', HINT: '' },
    { TABELA: 'PRECO_MEDIO', CAMPO: 'DESCONTO_ICMS', DESCRICAO: 'DESCONTAR ICMS NO CALCULO DO PREÇO MÉDIO NA ENTRADA DO PRODUTO', VALOR: '', HINT: '' },

    // PRECO_MEDIO_MAT
    { TABELA: 'PRECO_MEDIO_MAT', CAMPO: 'CONS_COR_MAT', DESCRICAO: 'CONSIDERAR A COR PARA CALCULAR O PREÇO MÉDIO DO MATERIAL', VALOR: '', HINT: '' },
    { TABELA: 'PRECO_MEDIO_MAT', CAMPO: 'CONS_DEPOSITO_MAT', DESCRICAO: 'CONSIDERAR O DEPÓSITO PARA CALCULAR O PREÇO MÉDIO DO MATERIAL', VALOR: '', HINT: '' },
    { TABELA: 'PRECO_MEDIO_MAT', CAMPO: 'CONS_QUALIDADE_MAT', DESCRICAO: 'CONSIDERAR A QUALIDADE PARA CALCULAR O PREÇO MÉDIO DO MATERIAL', VALOR: '', HINT: '' },
    { TABELA: 'PRECO_MEDIO_MAT', CAMPO: 'CONS_LOTE_MAT', DESCRICAO: 'CONSIDERAR O LOTE PARA CALCULAR O PREÇO MÉDIO DO MATERIAL', VALOR: '', HINT: '' },
    { TABELA: 'PRECO_MEDIO_MAT', CAMPO: 'CONS_LOCAL_MAT', DESCRICAO: 'CONSIDERAR O LOCAL PARA CALCULAR O PREÇO MÉDIO DO MATERIAL', VALOR: '', HINT: '' },

    // LOJA/VENDA // ANTECIPAÇÃO PEDIDO
    { TABELA: 'ANTECIPACAO_PEDIDO', CAMPO: 'MOEDA', DESCRICAO: 'MOEDA DA ANTECIPAÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'ANTECIPACAO_PEDIDO', CAMPO: 'CONTA', DESCRICAO: 'CONTA DA ANTECIPAÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'ANTECIPACAO_PEDIDO', CAMPO: 'CLASSE', DESCRICAO: 'CLASSE DA ANTECIPAÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'ANTECIPACAO_PEDIDO', CAMPO: 'HISTORICO', DESCRICAO: 'HISTORICO DA ANTECIPAÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'ANTECIPACAO_PEDIDO', CAMPO: 'BANCO', DESCRICAO: 'BANCO DA ANTECIPAÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'ANTECIPACAO_PEDIDO', CAMPO: 'SITUACAO', DESCRICAO: 'SITUACAO DA ANTECIPAÇÃO', VALOR: '', HINT: '' },

    // ORDEM DE PRODUÇÃO
    { TABELA: 'CADOF', CAMPO: 'DEPOSITO', DESCRICAO: 'CÓDIGO DO DEPÓSITO', VALOR: '', HINT: '' },
    { TABELA: 'CADOF', CAMPO: 'PERIODO', DESCRICAO: 'CÓDIGO DO PERÍODO', VALOR: '', HINT: '' },
    { TABELA: 'CADOF', CAMPO: 'TIPO', DESCRICAO: 'ID DO TIPO', VALOR: '', HINT: '' },

    // BAIXA DE CONSUMOS
    { TABELA: 'BAIXA_CONSUMOS', CAMPO: 'DEPOSITO', DESCRICAO: 'CÓDIGO DO DEPÓSITO', VALOR: '', HINT: '' },
    { TABELA: 'BAIXA_CONSUMOS', CAMPO: 'CLIENTE', DESCRICAO: 'CÓDIGO DO CLIENTE (CODCLI)', VALOR: '', HINT: '' },

    //ORÇAMENTO
    { TABELA: 'ORCAMENTO', CAMPO: 'MOEDA', DESCRICAO: 'CÓDIGO DA MOEDA', VALOR: '', HINT: '' },
    { TABELA: 'ORCAMENTO', CAMPO: 'HISTORICO', DESCRICAO: 'CÓDIGO DO HISTÓRICO', VALOR: '', HINT: '' },
    { TABELA: 'ORCAMENTO', CAMPO: 'BANCO', DESCRICAO: 'CÓDIGO DO BANCO', VALOR: '', HINT: '' },
    { TABELA: 'ORCAMENTO', CAMPO: 'SITUACAO', DESCRICAO: 'CÓDIGO DA SITUAÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'ORCAMENTO', CAMPO: 'CLASSEGER', DESCRICAO: 'CÓDIGO DA CLASSE GERENCIAL', VALOR: '', HINT: '' },
    { TABELA: 'ORCAMENTO', CAMPO: 'TABPRECO', DESCRICAO: 'CÓDIGO DA TABELA DE PREÇO', VALOR: '', HINT: '' },
    { TABELA: 'ORCAMENTO', CAMPO: 'STATUS', DESCRICAO: 'DEFINE O STATUS COMERCIAL AO INCLUIR UM ORÇAMENTO', VALOR: '', HINT: '' },
    { TABELA: 'ORCAMENTO', CAMPO: 'DIAS_VALIDADE', DESCRICAO: 'CAMPO DIAS VALIDADE PARA FAZER O CALCULO DO CAMPO DATA VALIDADE', VALOR: '', HINT: '' },
    { TABELA: 'ORCAMENTO', CAMPO: 'DIAS', DESCRICAO: 'CAMPO DIAS PARA FAZER O CALCULO DO CAMPO DATA ENTREGA E SAIDA', VALOR: '', HINT: '' },
    { TABELA: 'ORCAMENTO', CAMPO: 'PRAZO_ENTREGA', DESCRICAO: 'CAMPO COM O CÓDIGO DO PRAZO DE ENTREGA (USADO QUANDO TRANSFORMAR O ORÇAMENTO EM PEDIDO)', VALOR: '', HINT: '' },
    { TABELA: 'ORCAMENTO', CAMPO: 'PRAZO_PRODUCAO', DESCRICAO: 'CAMPO COM O CÓDIGO DO PRAZO DE PRODUÇÃO (USADO QUANDO TRANSFORMAR O ORÇAMENTO EM PEDIDO)', VALOR: '', HINT: '' },
    { TABELA: 'ORCAMENTO', CAMPO: 'TIPO_VENDA', DESCRICAO: 'CAMPO COM O CÓDIGO DO TIPO DE VENDA (USADO QUANDO TRANSFORMAR O ORÇAMENTO EM PEDIDO)', VALOR: '', HINT: '' },

    //SERVIÇOS
    { TABELA: 'OS', CAMPO: 'MOEDA', DESCRICAO: 'CÓDIGO DA MOEDA', VALOR: '', HINT: '' },
    { TABELA: 'OS', CAMPO: 'STATUS', DESCRICAO: 'CÓDIGO DO STATUS', VALOR: '', HINT: '' },
    { TABELA: 'OS', CAMPO: 'TAB_PRECO', DESCRICAO: 'CÓDIGO DA TABELA DE PREÇO', VALOR: '', HINT: '' },

    //DEMANDA ECOMMERCE
    { TABELA: 'DEMANDA_ECOMMERCE', CAMPO: 'TIPO_BAIXA', DESCRICAO: 'TIPO DE BAIXA TRANSFERÊNCIA', VALOR: '', HINT: '' },
    { TABELA: 'DEMANDA_ECOMMERCE', CAMPO: 'DEPOSITO', DESCRICAO: 'DEPÓSITO TRANSITÓRIO DO E-COMMERCE PARA ONDE IRÃO AS PEÇAS TRANSFERIDAS', VALOR: '', HINT: '' },

    //MOVIMENTAÇÕES
    { TABELA: 'MOVIMENTACOES', CAMPO: 'ENTRADA_MAT', DESCRICAO: 'Tela: Entrada Manual Material |  TIPO DE ENTRADA (CÓDIGO)', VALOR: '', HINT: '' },
    { TABELA: 'MOVIMENTACOES', CAMPO: 'ENTRADA_PROD', DESCRICAO: 'Tela: Entrada Manual Produto |  TIPO DE ENTRADA (CÓDIGO)', VALOR: '', HINT: '' },
    { TABELA: 'MOVIMENTACOES', CAMPO: 'SAIDA_MAT', DESCRICAO: 'Tela: Saída Manual Material |  TIPO SAÍDA (CÓDIGO)', VALOR: '', HINT: '' },
    { TABELA: 'MOVIMENTACOES', CAMPO: 'SAIDA_PROD', DESCRICAO: 'Tela: Saída Manual Produto |  TIPO SAÍDA (CÓDIGO)', VALOR: '', HINT: '' },
    { TABELA: 'MOVIMENTACOES', CAMPO: 'MOV_IMPORTACAO', DESCRICAO: 'Tela: Importação |  TIPO MOVIMENTO (CÓDIGO)', VALOR: '', HINT: '' },
    { TABELA: 'MOVIMENTACOES', CAMPO: 'MERCAD_TIPO_SAIDA', DESCRICAO: 'Tela: Mercadorias |  TIPO MOVIMENTO SAÍDA (CÓDIGO)', VALOR: '', HINT: '' },
    { TABELA: 'MOVIMENTACOES', CAMPO: 'MERCAD_TIPO_ENTRADA', DESCRICAO: 'Tela: Mercadorias |  TIPO MOVIMENTO ENTRADA (CÓDIGO)', VALOR: '', HINT: '' },
    { TABELA: 'MOVIMENTACOES', CAMPO: 'CONF_TIPO_BAIXA', DESCRICAO: 'Tela: Conferência de Inventário | TIPO DE BAIXA (CÓDIGO)', VALOR: '', HINT: '' },

    { TABELA: 'TRANSF_MERCADORIAS', CAMPO: 'COD_BAIXA_CANC_ENVIO', DESCRICAO: 'CÓDIGO DE BAIXA PADRÃO PARA O ESTORNO DO ESTOQUE AO CANCELAR ENVIO', VALOR: '', HINT: '' },
    { TABELA: 'TRANSF_MERCADORIAS', CAMPO: 'OPERACAO', DESCRICAO: 'OPERACÃO PADRÃO PARA GERAR NOTA FISCAL', VALOR: '', HINT: '' },

    //SIGEP
    { TABELA: 'SIGEP', CAMPO: 'SERVICO', DESCRICAO: 'SERVIÇO', VALOR: '', HINT: '' },
    { TABELA: 'SIGEP', CAMPO: 'TIPO_OBJETO', DESCRICAO: 'TIPO DO OBJETO', VALOR: '', HINT: '' },
    { TABELA: 'SIGEP', CAMPO: 'ALTURA', DESCRICAO: 'ALTURA', VALOR: '', HINT: '' },
    { TABELA: 'SIGEP', CAMPO: 'LARGURA', DESCRICAO: 'LARGURA', VALOR: '', HINT: '' },
    { TABELA: 'SIGEP', CAMPO: 'COMPRIMENTO', DESCRICAO: 'COMPRIMENTO', VALOR: '', HINT: '' },

    // PEDIDO //GERAR ANTECIPACAO
    { TABELA: 'GERAR_ANTECIPACAO', CAMPO: 'MOEDA', DESCRICAO: 'MOEDA DA ANTECIPAÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'GERAR_ANTECIPACAO', CAMPO: 'HISTORICO', DESCRICAO: 'HISTORICO DA ANTECIPAÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'GERAR_ANTECIPACAO', CAMPO: 'CLASSE', DESCRICAO: 'CLASSE DA ANTECIPAÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'GERAR_ANTECIPACAO', CAMPO: 'SITUACAO', DESCRICAO: 'SITUACAO DA ANTECIPAÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'GERAR_ANTECIPACAO', CAMPO: 'CONTA', DESCRICAO: 'CONTA DA ANTECIPAÇÃO', VALOR: '', HINT: '' },
    { TABELA: 'GERAR_ANTECIPACAO', CAMPO: 'BANCO', DESCRICAO: 'BANCO DA ANTECIPAÇÃO', VALOR: '', HINT: '' },

    // COMPRAS - ORDEM DE COMPRA
    // COMPRAS - BAIXA DE ORDEM DE COMPRA
    { TABELA: 'BAIXA_ORDEM_COMPRA', CAMPO: 'DEPOSITO', DESCRICAO: 'DEPÓSITO PADRÃO PARA BAIXA DE ORDEM DE COMPRA', VALOR: '', HINT: '' },
    { TABELA: 'BAIXA_ORDEM_COMPRA', CAMPO: 'FUNCIONARIO', DESCRICAO: 'FUNCIONÁRIO PADRÃO PARA BAIXA DE ORDEM DE COMPRA', VALOR: '', HINT: '' },
    { TABELA: 'BAIXA_ORDEM_COMPRA', CAMPO: 'TIPO_MOVIMENTO', DESCRICAO: 'TIPO DE MOVIMENTO PADRÃO PARA BAIXA DE ORDEM DE COMPRA', VALOR: '', HINT: '' },

    // CARTAO PRESENTE
    { TABELA: 'CARTAO_PRESENTE', CAMPO: 'MOEDA', DESCRICAO: 'MOEDA DA ANTECIPAÇÃO GERADA NO CARTÃO PRESENTE', VALOR: '', HINT: '' },
    { TABELA: 'CARTAO_PRESENTE', CAMPO: 'HISTORICO', DESCRICAO: 'HISTORICO DA ANTECIPAÇÃO GERADA NO CARTÃO PRESENTE', VALOR: '', HINT: '' },
    { TABELA: 'CARTAO_PRESENTE', CAMPO: 'SITUACAO', DESCRICAO: 'SITUAÇÃO DA ANTECIPAÇÃO GERADA NO CARTÃO PRESENTE', VALOR: '', HINT: '' },
    { TABELA: 'CARTAO_PRESENTE', CAMPO: 'CLASSE_GERENCIAL', DESCRICAO: 'CLASSE GERENCIAL DA ANTECIPAÇÃO GERADA NO CARTÃO PRESENTE', VALOR: '', HINT: '' },
    { TABELA: 'CARTAO_PRESENTE', CAMPO: 'BANCO', DESCRICAO: 'BANCO DA ANTECIPAÇÃO GERADA NO CARTÃO PRESENTE', VALOR: '', HINT: '' },
    { TABELA: 'CARTAO_PRESENTE', CAMPO: 'CONTA', DESCRICAO: 'CONTA DA ANTECIPAÇÃO GERADA NO CARTÃO PRESENTE', VALOR: '', HINT: '' },
  ];

  criaDataTablePadrao('#tabelaProduto', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaMaterial', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaEntidade', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaPedido', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaEntradaNf', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaFaturamento', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaEstoque', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaPrecoMedio', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaTransfDep', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaReceber', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaContasPagar', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaLoja', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaCashback', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaDesdobraLote', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaDevolucao', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaRetorno', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaEnvio', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaExtratoCartao', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaLiberacaoExpedicao', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaPedidoB2BMaisMix', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaPedidoB2BProducao', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaAlteracaoPedidoB2B', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaCriarPedido', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaAntecipacaoPedido', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaCadOf', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaBaixaConsumos', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaOrcamento', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaServicos', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaDemandaEcommerce', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaTransfMercadorias', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaSigep', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaGerarAntecipacao', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaPrecoMedioMaterial', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaOrdemCompra', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaBaixaOrdemCompra', false, false, false, true, true, false, '400px');
  criaDataTablePadrao('#tabelaCartaoPresente', false, false, false, true, true, false, '400px');

  preencheCampos();
  await carregaValores();

  $('#tabelaProduto').DataTable().columns.adjust().draw(false);

  $("#tabPedidoCapa, #tabMaterial, #tabProduto, #tabEntidade, #tabEntradaNf, #tabFaturamento," +
    "#tabEstoque, #tabTransfDep, #tabReceber, #tabContasPagar, #tabLoja, #tabCashback, #tabDesdobraLote," +
    "#tabVenda, #tabDevolucao, #tabCriarPedido, #tabAntecipacaoPedido, #tabRetorno, #tabEnvio," +
    "#tabExtratoCartao, #tabLiberacaoExpedicao, #tabMaisMix, #tabCadOf, #tabOrcamento, #tabServicos," +
    "#tabDemandaEcommerce, #tabTransfMercadorias, #tabSigep, #tabAlteracaoB2B, #tabPedido," +
    "#tabGerarAntecipacao, #tabPrecoMedio, #tabPrecoMedioMaterial, #tabOrdemCompra, #tabBaixaOrdemCompra" +
    "#tabCartaoPresente, #tabBaixaConsumos").on('click', function () {
      setTimeout(() => {
        $('#tabelaProduto').DataTable().columns.adjust().draw(false);
        $('#tabelaMaterial').DataTable().columns.adjust().draw(false);
        $('#tabelaEntidade').DataTable().columns.adjust().draw(false);
        $('#tabelaPedido').DataTable().columns.adjust().draw(false);
        $('#tabelaEntradaNf').DataTable().columns.adjust().draw(false);
        $('#tabelaFaturamento').DataTable().columns.adjust().draw(false);
        $('#tabelaEstoque').DataTable().columns.adjust().draw(false);
        $('#tabelaPrecoMedio').DataTable().columns.adjust().draw(false);
        $('#tabelaTransfDep').DataTable().columns.adjust().draw(false);
        $('#tabelaReceber').DataTable().columns.adjust().draw(false);
        $('#tabelaContasPagar').DataTable().columns.adjust().draw(false);
        $('#tabelaLoja').DataTable().columns.adjust().draw(false);
        $('#tabelaCashback').DataTable().columns.adjust().draw(false);
        $('#tabelaDesdobraLote').DataTable().columns.adjust().draw(false);
        $("#tabelaDevolucao").DataTable().columns.adjust().draw(false);
        $("#tabelaRetorno").DataTable().columns.adjust().draw(false);
        $("#tabelaEnvio").DataTable().columns.adjust().draw(false);
        $("#tabelaExtratoCartao").DataTable().columns.adjust().draw(false);
        $("#tabelaLiberacaoExpedicao").DataTable().columns.adjust().draw(false);
        $("#tabelaPedidoB2BMaisMix").DataTable().columns.adjust().draw(false);
        $("#tabelaPedidoB2BProducao").DataTable().columns.adjust().draw(false);
        $("#tabelaAlteracaoPedidoB2B").DataTable().columns.adjust().draw(false);
        $("#tabelaCriarPedido").DataTable().columns.adjust().draw(false);
        $("#tabelaAntecipacaoPedido").DataTable().columns.adjust().draw(false);
        $("#tabelaCadOf").DataTable().columns.adjust().draw(false);
        $("#tabelaBaixaConsumos").DataTable().columns.adjust().draw(false);
        $("#tabelaOrcamento").DataTable().columns.adjust().draw(false);
        $("#tabelaServicos").DataTable().columns.adjust().draw(false);
        $("#tabelaDemandaEcommerce").DataTable().columns.adjust().draw(false);
        $("#tabelaTransfMercadorias").DataTable().columns.adjust().draw(false);
        $("#tabelaSigep").DataTable().columns.adjust().draw(false);
        $("#tabelaGerarAntecipacao").DataTable().columns.adjust().draw(false);
        $("#tabelaOrdemCompra").DataTable().columns.adjust().draw(false);
        $("#tabelaBaixaOrdemCompra").DataTable().columns.adjust().draw(false);
        $("#tabelaCartaoPresente").DataTable().columns.adjust().draw(false);
      }, 175);
    });

  $('#btnGravar').on('click', async function () {
    await gravaDados();
  });

  async function preencheCampos() {
    valoresPadroes.map(async item => {
      if (item.TABELA == 'PRODUTO' && item.CAMPO != 'TIPO_VENDA') {
        $('#tabelaProduto').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'MATERIAL') {
        $('#tabelaMaterial').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'ENTIDADE' && item.CAMPO == "TIPO_ENTIDADE") {
        $('#tabelaEntidade').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="" selected>Selecione um tipo de entidade</option>` +
          `<option value="CLIENTE">Cliente</option>` +
          `<option value="FORNECEDOR">Fornecedor</option>` +
          `<option value="TERCEIROS">Terceiros</option>` +
          `<option value="REPRESENTANTE">Representante</option>` +
          `<option value="PROSPECTO">Prospecto</option>` +
          `<option value="FUNCIONARIO">Funcionário</option>` +
          `</select>`]).draw(false);
      } else if (item.TABELA == 'ENTIDADE' && item.CAMPO == "TRIBUTACAO") {
        $('#tabelaEntidade').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="" selected>Selecione um tipo de Tributação</option>` +
          `<option value="A">A - Normal s/ Substituição</option>` +
          `<option value="N">N - Normal c/ Substituição - Regime Normal</option>` +
          `<option value="L">L - Normal c/ Substituição - Simples Nacional</option>` +
          `<option value="D">D - Diferenciada c/ Substituição</option>` +
          `<option value="S">S - Simples</option>` +
          `<option value="R">R - Simples s/ Inscrição Estadual</option>` +
          `<option value="C">C - Carga Média</option>` +
          `<option value="P">P - Substituição com Alíq.Simples</option>` +
          `</select>`]).draw(false);
      } else if (item.TABELA == 'ENTIDADE' && item.CAMPO == "CONS_FINAL") {
        $('#tabelaEntidade').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="" selected>Selecione um tipo de entidade</option>` +
          `<option value="Sim">Sim</option>` +
          `<option value="Nao">Não</option>` +
          `</select>`]).draw(false);
      } else if (item.TABELA == 'ENTIDADE' && item.CAMPO == "TIPO_PESSOA") {
        const tabelaEnt = $('#tabelaEntidade').DataTable();
        const pesquisaParam = {
          tabela: 'TPDOCPESSOA',
          camposSelect: ['DESCRICAO', 'MASCARA'],
          where: ['1 = 1'],
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        if (jsonStr.length > 0) {
          const selectOptions = jsonStr.map(valor => `<option value="${valor.MASCARA}">${valor.DESCRICAO}</option>`).join('');
          const selectHtml = `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                    <option value="" selected>Nenhum</option>
                                    ${selectOptions}
                                </select>`;
          tabelaEnt.row.add([item.CAMPO, item.DESCRICAO, selectHtml]).draw(false);
        } else {
          tabelaEnt.row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                            <option value="" selected>Nenhum</option>
                                                            <option value="###.###.###-##">Física</option>
                                                            <option value="##.###.###/####-##">Jurídica</option>
                                                            <option value="##########-#">Exterior</option>
                                                          </select>`]).draw(false);
        }
      } else if (item.TABELA == "ENTIDADE" && item.CAMPO == 'IE_DESTINATARIO') {
        $('#tabelaEntidade').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                            <option value="" selected>Nenhum</option>
                                                            <option value="1">Contribuinte ICMS (informar a IE do destinatário)</option>
                                                            <option value="2">Contribuinte isento de Inscrição no cadastro de Contribuintes do ICMS</option>
                                                            <option value="9">Não Contribuinte, que pode ou não possuir Inscrição Estadual no Cadastro de Contribuintes do ICMS</option>
                                                          </select>`]).draw(false);
      } else if (item.TABELA == "ENTIDADE") {
        $('#tabelaEntidade').DataTable().row.add([item.CAMPO, `<span title="${item.HINT}">${item.DESCRICAO}</span>`, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PEDIDO') {
        $('#tabelaPedido').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'NOTA_ENTRA' && item.CAMPO != 'TIPO_ITEM') {
        $('#tabelaEntradaNf').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'NOTA' && (item.CAMPO != 'ENDERECO_A_FATURAR') && (item.CAMPO != 'NAO_ALTERA_DIFAL') && (item.CAMPO != 'NAO_ALTERA_EXPEDIDOS')) {
        $('#tabelaFaturamento').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'ESTOQUE') {
        $('#tabelaEstoque').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'TRANSF_DEPOSITO') {
        $('#tabelaTransfDep').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RECEBER' && item.CAMPO == 'CLASSE') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RECEBER' && item.CAMPO == 'STATUS') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                                             <option value="TODOS">Todos</option>
                                                                             <option value="DUPL" selected>Duplicatas</option>
                                                                             <option value="ANTE">Antecipações</option>
                                                                             <option value="ORCA">Orçamentos</option>
                                                                             <option value="CHEQ">Cheques</option>
                                                                             <option value="CHDE">Cheques Devolvidos</option>
                                                                             <option value="DESD">Desdobradas</option>
                                                                             <option value="AGRU">Agrupadas</option>
                                                                             <option value="CANC">Canceladas</option>
                                                                             <option value="DEVO">Devolução</option>
                                                                             <option value="AVDD">Aviso Débito</option>
                                                                             <option value="PRESENTE">Cartão Presente</option>
                                                                             </select>` ]).draw(false);
      } else if (item.TABELA == 'RECEBER' && item.CAMPO == 'SITUACAO') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                                              <option value="Todos">Todos</option>
                                                                              <option value="Em Aberto" selected>Em Aberto</option>
                                                                              <option value="Perdidas">Perdidas</option>
                                                                              <option value="Pagas">Pagas</option>
                                                                              </select>`]).draw(false);
      } else if (item.TABELA == 'RECEBER' && item.CAMPO == 'DIAS_UTEIS') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                                              <option value="0" selected>Não</option>
                                                                              <option value="1">Sim</option>
                                                                              </select>`]).draw(false);
      } else if (item.TABELA == 'RECEBER') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RECEBER' && item.CAMPO == 'EMISSAO_DE') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RECEBER' && item.CAMPO == 'VENCIMENTO_DE') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RECEBER' && item.CAMPO == 'PAGAMENTO_DE') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PAGTO' &&
        (item.CAMPO == 'CONTA' || item.CAMPO == 'BANCO' || item.CAMPO == 'SITUACAO_CODIGO' || item.CAMPO == 'HISTORICO' || item.CAMPO == 'CLASSE_GERENCIAL' || item.CAMPO == 'SITUACAO_DUP' || item.CAMPO == 'FORNECEDOR')) {
        $('#tabelaContasPagar').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PAGTO' && item.CAMPO == 'EMISSAO_DE') {
        $('#tabelaContasPagar').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PAGTO' && item.CAMPO == 'VENCIMENTO_DE') {
        $('#tabelaContasPagar').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PAGTO' && item.CAMPO == 'INTERVALO_DIAS_EMISSAO') {
        $('#tabelaContasPagar').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PAGTO' && item.CAMPO == 'STATUS') {
        $('#tabelaContasPagar').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                                                  <option value="">Todos</option>
                                                                                  <option value="DUPL">A.Ps</option>
                                                                                  <option value="ANTE">Antecipações</option>
                                                                                  <option value="ORCA">Orçamentos</option>
                                                                                  <option value="CHEQ">Cheques</option>
                                                                                  <option value="CHDE">Cheques Devolvidos</option>
                                                                                  <option value="CHCA">Cheques Cancelados</option>
                                                                                  <option value="DESD">Desdobradas</option>
                                                                                  <option value="AGRU">Agrupadas</option>
                                                                                </select>` ]).draw(false);
      } else if (item.TABELA == 'PAGTO' && item.CAMPO == 'SITUACAO') {
        $('#tabelaContasPagar').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                                                <option value="">Todos</option>
                                                                                <option value="Aberto">Aberto</option>
                                                                                <option value="Pagas">Pagas</option>
                                                                                <option value="Devolvidas">Devolvidas</option>
                                                                                </select>`]).draw(false);
      } else if (item.TABELA == 'LOJA') {
        if (item.CAMPO == 'DESCONTO_ITENS_PROMOCIONAIS' || item.CAMPO == 'CONTA_DEBITO_MOEDA_CONTABIL') {
          $('#tabelaLoja').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                                                  <option selected value="N">Não</option>
                                                                                  <option value="S">Sim</option>
                                                                                 </select>` ]).draw(false);
        } else {
          $('#tabelaLoja').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
        }
      } else if (item.TABELA == 'CASHBACK') {
        $('#tabelaCashback').DataTable().row.add([item.CAMPO, `<span title="${item.HINT}">${item.DESCRICAO}</span>`, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == "DESDOBRALOTE" && item.CAMPO == "SEQ_LOTE_DESDOBRADO") {
        $('#tabelaDesdobraLote').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="" selected>Selecione o tamanho do sequencial</option>` +
          `<option value="1">1</option>` +
          `<option value="2">2</option>` +
          `<option value="3">3</option>` +
          `<option value="4">4</option>` +
          `</select>`]).draw(false);
      }
      else if (item.TABELA == 'DESDOBRALOTE') {
        $('#tabelaDesdobraLote').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'EXTRATO_CARTAO') {
        $('#tabelaExtratoCartao').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RETORNO' && item.CAMPO == 'CARTEIRA_REGISTRO') {
        $('#tabelaRetorno').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                                                  <option value="">Todos</option>
                                                                                  <option value="S">Selecionado</option>
                                                                                  <option value="N">Não Seleciona</option>
                                                                                </select>` ]).draw(false);
      } else if (item.TABELA == 'RETORNO' && item.CAMPO == 'CARTEIRA') {
        $('#tabelaRetorno').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RETORNO' && item.CAMPO == 'CLASSE_BAIXA') {
        $('#tabelaRetorno').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RETORNO' && item.CAMPO == 'CLASSE_JUROS') {
        $('#tabelaRetorno').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RETORNO' && item.CAMPO == 'CLASSE_DESCONTO') {
        $('#tabelaRetorno').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RETORNO' && item.CAMPO == 'HISTORICO') {
        $('#tabelaRetorno').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PRODUTO' && item.CAMPO == 'TIPO_VENDA') {
        $('#tabelaProduto').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="" selected></option>` +
          `<option value="0">Produção</option>` +
          `<option value="1">Revenda</option>` +
          `</select>`]).draw(false);
      } else if (item.TABELA == 'NOTA_ENTRA' && item.CAMPO == 'TIPO_ITEM') {
        $('#tabelaEntradaNf').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="" selected></option>` +
          `<option value="P">P</option>` +
          `<option value="M">M</option>` +
          `</select>`]).draw(false);
      } else if (item.TABELA == 'NOTA' && item.CAMPO == 'ENDERECO_A_FATURAR') {
        $('#tabelaFaturamento').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="P" selected>PADRÃO</option>` +
          `<option value="ENT">ENTREGA</option>` +
          `<option value="COB">COBRANÇA</option>` +
          `<option value="EMP">EMPRESA</option>` +
          `<option value="PED">PEDIDO</option>` +
          `</select>`]).draw(false);
      } else if (item.TABELA == 'NOTA' && item.CAMPO == 'NAO_ALTERA_DIFAL') {
        $('#tabelaFaturamento').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="N" selected>NÃO</option>` +
          `<option value="S">SIM</option>` +
          `</select>`]).draw(false);
      } else if (item.TABELA == 'NOTA' && item.CAMPO == 'NAO_ALTERA_EXPEDIDOS') {
        $('#tabelaFaturamento').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="N" selected>NÃO</option>` +
          `<option value="S">SIM</option>` +
          `</select>`]).draw(false);
      } else if (item.TABELA == "DEVOLUCAO") {
        if (item.CAMPO == "VENC_ANTECIPACAO") {
          $('#tabelaDevolucao').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
          $(`#txt${item.TABELA + item.CAMPO}`).on("blur", function () {
            if ($(`#txt${item.TABELA + item.CAMPO}`).val() == "") {
              $(`#txt${item.TABELA + item.CAMPO}`).val("0");
            }
          })
          $(`#txt${item.TABELA + item.CAMPO}`).trigger("blur");
        } else if (item.CAMPO == 'CONS_VENDA_DEV') {
          $('#tabelaDevolucao').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                                                  <option selected value="N">Não</option>
                                                                                  <option value="S">Sim</option>
                                                                                 </select>` ]).draw(false);
        } else if (item.CAMPO == "DIAS_DEVOLUCAO") {
          $('#tabelaDevolucao').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
          $(`#txt${item.TABELA + item.CAMPO}`).on("blur", function () {
            if ($(`#txt${item.TABELA + item.CAMPO}`).val() == "") {
              $(`#txt${item.TABELA + item.CAMPO}`).val("0");
            }
          })
          $(`#txt${item.TABELA + item.CAMPO}`).trigger("blur")
        } else {
          $('#tabelaDevolucao').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
        }
      } else if (item.TABELA == 'LIBERACAO_EXPEDICAO') {
        $('#tabelaLiberacaoExpedicao').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'B2B_MAIS_MIX') {
        $('#tabelaPedidoB2BMaisMix').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'B2B_PRODUCAO') {
        $('#tabelaPedidoB2BProducao').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'B2B_ALTERACAO_PEDIDO') {
        $('#tabelaAlteracaoPedidoB2B').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'CRIAR_PEDIDO' && item.CAMPO == 'EMP_FAT') {
        $('#tabelaCriarPedido').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">`]).draw(false);
      } else if (item.TABELA == 'CRIAR_PEDIDO') {
        $('#tabelaCriarPedido').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'ANTECIPACAO_PEDIDO') {
        $('#tabelaAntecipacaoPedido').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PRECO_MEDIO') {
        $('#tabelaPrecoMedio').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="N" selected>Não</option>` +
          `<option value="S">Sim</option>` +
          `</select>`]).draw(false);
      } else if (item.TABELA == "CADOF") {
        $('#tabelaCadOf').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == "BAIXA_CONSUMOS") {
        $('#tabelaBaixaConsumos').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'ORCAMENTO' && item.CAMPO == 'STATUS') {
        $('#tabelaOrcamento').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="" selected>Selecione uma opção</option>` +
          `<option value="0">Bloqueado</option>` +
          `<option value="1">Liberado</option>` +
          `</select>`]).draw(false);
      } else if (item.TABELA == "ORCAMENTO") {
        $('#tabelaOrcamento').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == "OS") {
        $('#tabelaServicos').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == "DEMANDA_ECOMMERCE") {
        $('#tabelaDemandaEcommerce').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == "TRANSF_MERCADORIAS") {
        $('#tabelaTransfMercadorias').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA === 'SIGEP') {
        $('#tabelaSigep').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false)
      } else if (item.TABELA == 'GERAR_ANTECIPACAO') {
        $('#tabelaGerarAntecipacao').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PRECO_MEDIO_MAT') {
        $('#tabelaPrecoMedioMaterial').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="N" selected>Não</option>` +
          `<option value="S">Sim</option>` +
          `</select>`]).draw(false);
      } else if (item.TABELA === 'BAIXA_ORDEM_COMPRA') {
        $('#tabelaBaixaOrdemCompra').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA === 'CARTAO_PRESENTE') {
        $('#tabelaCartaoPresente').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      }
    });

    await adicionaEmpresas();
  };

  async function abreCadastroCep(cepField) {
    $('#modal-CEP').attr('cepField', cepField[0].id)
    $('#modal-CEP').modal('show');
    $('#txt_Cep').val('');
    $('#txtEndereco').val('');
    $('#txtBairroCEP').val('');
    $('#txtUfCEPCadastro').val('');
    $('#txtCidadeCEPCadastro').val('');
    $('#txtPaisCEPCadastro').val('');
    if ((cepField.val() != '') || (cepField.val() != undefined) || (cepField.val() != null)) {
      $('#txt_Cep').val(`${cepField.val().substr(0, 5)}-${cepField.val().substr(-3)}`);
    }
  }

  async function BuscaECadastraCep(cepInput) {
    try {
      $.LoadingOverlay("show");
      try {
        const cep = cepInput.val().replace('-', '').trim();
        const response = await requisicao('GET', '/sisplan/cep/v1/CEP?', `CEP=${cep}`, null);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
          msgAlerta(jsonStr.mensagem, () => { abreCadastroCep(cepInput) }, undefined, undefined);
          return;
        }

        return [jsonStr.nOMCIDADE, jsonStr.eSTCEP, jsonStr.nOMCEP, jsonStr.bAIRRO];

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  async function retornaCepValido() {
    if ($('#txtENTIDADECEP_PADRAO').val() !== '') {
      await BuscaECadastraCep($('#txtENTIDADECEP_PADRAO'));
    }
  };

  $('#txtENTIDADECEP_PADRAO').on('blur', async function () {
    event.preventDefault();
    try {
      $.LoadingOverlay('show');
      await retornaCepValido()
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  async function adicionaEmpresas() {
    const pesquisaParam = {
      tabela: 'EMPRESA',
      camposSelect: ['EMP_PAT', 'EMP_NOME'],
      where: ['1 = 1'],
      orderBy: ['EMP_PAT']
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    jsonStr.map(emp => {
      $("#txtCRIAR_PEDIDOEMP_FAT").append(new Option(`${emp.EMP_PAT} - ${emp.EMP_NOME}`, emp.EMP_PAT.replace('_', '')));
    });
  };

  function retornaInput(sTabela, sCampo) {
    return `<input type="text" class="input-default focus" id="txt${sTabela}${sCampo}">`;
  };

  async function carregaValores() {
    let valores;
    valores = await retornaJsonPesquisaPadrao(JSON.stringify({
      tabela: "TABPADRAO",
      camposSelect: ["CAMPO", "TABELA", "VALOR"],
      where: [`EMP_ID = ${getCookie('emp_id')}`]
    }));

    if (valores.length == 0) {
      valores = await retornaJsonPesquisaPadrao(JSON.stringify({
        tabela: "TABPADRAO",
        camposSelect: ["CAMPO", "TABELA", "VALOR"]
      }));
    };

    valores.map(item => { insereValor(`#txt${item.TABELA}${item.CAMPO}`, item.VALOR); });
  };

  $('#tabLoja').on('click', function () {
    $('#tabVenda').trigger('click')
  })

  $('#tabPedidoCapa').on('click', function () {
    $('#tabPedido').trigger('click')
  })

  $('#tabEstoque').on('click', function () {
    $('#tabMovimentacao').trigger('click')
  })
  $('#tabCadOf').on('click', function () {
    $('#tabOrdemProducao').trigger('click')
  })

  async function gravaDados() {
    $.LoadingOverlay('show');
    try {
      valoresPadroes.map(item => {
        item.VALOR = pegaValor(`#txt${item.TABELA}${item.CAMPO}`);
      });

      const response = await requisicao('POST', '/sisplan/cadastros/v1/cadpadrao?', '', JSON.stringify({ LISTAITENS: valoresPadroes }), 60000);

      if (!response) {
        msgAlerta('Não foi possível gravar os valores padrões, tente novamente.');
        return;
      };

      if (response.status != 200) {
        msgAlerta('Não foi possível gravar os valores padrões, tente novamente.');
        return;
      };

      criaMensagemSucesso('Valores padrões gravados com sucesso.');

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide')
    }
  };

});
