$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
      onNext: (Element) => {
        if ((Element.node.id == 'avancar1')) {
          $('#avancar1').trigger('click');
        } else if ((Element.node.id == 'avancar2')) {
          $('#avancar2').trigger('click');
        };
      },
      onPrevious: (Element) => {
        if ((Element.node.id == 'voltar3')) {
          $('#voltar3').trigger('click');
        } else if ((Element.node.id == 'voltar2')) {
          $('#voltar2').trigger('click');
        };
      }
    });

    driver.defineSteps([{
      element: '.dadosGerais',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os dados gerais.',
        position: 'top'
      }
    },
    {
      element: '.dadosCores',
      popover: {
        title: 'Cores',
        description: 'Aqui estão as cores.',
        position: 'top'
      }
    },
    {
      element: '.divResumo',
      popover: {
        title: 'Quantidade setores',
        description: 'Tabela com o resumo das quantidades de cada setor/parte.',
        position: 'top'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "left",
      },
    },
    {
      element: '#avancar1',
      popover: {
        title: 'Botão Avançar',
        description: 'Clique aqui para ir para a próxima aba.',
        position: 'left'
      }
    },
    {
      element: '#voltar2',
      popover: {
        title: 'Botão para Voltar',
        description: 'Clique aqui para voltar a aba anterior.',
        position: 'top'
      }
    },
    {
      element: '.divPartes',
      popover: {
        title: 'Partes',
        description: 'Aqui estão as partes que podem ser geradas na OF.',
        position: 'top'
      }
    },
    {
      element: '.divFluxo',
      popover: {
        title: 'Fluxo',
        description: 'Fluxo que o OF será gerada.',
        position: 'top'
      }
    },
    {
      element: '#btnAgendamento',
      popover: {
        title: 'Botão Agendamento',
        description: 'Clique aqui para abrir o modal de agendamento.',
        position: 'top'
      }
    },
    {
      element: '#avancar2',
      popover: {
        title: 'Botão Avançar',
        description: 'Clique aqui para ir para a próxima aba.',
        position: 'left'
      }
    },
    {
      element: '#voltar3',
      popover: {
        title: 'Botão para Voltar',
        description: 'Clique aqui para voltar a aba anterior.',
        position: 'top'
      }
    },
    {
      element: '.divGrade',
      popover: {
        title: 'Grade',
        description: 'Informe as quantidades da OF.',
        position: 'top'
      }
    },
    {
      element: '#btnGravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar as informações da OF.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $('#msform').validate({
    debug: false,
    ignore: "",
    rules: {
      txtParte: {
        required: true,
      },
      txtSetor: {
        required: true,
      },
      txtEmpresaDestino: {
        required: true,
      },
      txtQualidade: {
        required: true,
      },
      txtTipoBaixa: {
        required: true,
      },
      txtDeposito: {
        required: true,
      },
      txtProximoSetor: {
        required: true,
      }
    },
    messages: {
      txtParte: {
        required: "Informe a parte."
      },
      txtSetor: {
        required: "Informe um setor."
      },
      txtEmpresaDestino: {
        required: "Informe a empresa destino."
      },
      txtQualidade: {
        required: "Informe uma qualidade."
      },
      txtTipoBaixa: {
        required: "Informe um Tipo de Baixa."
      },
      txtDeposito: {
        required: "Informe um Depósito."
      },
      txtProximoSetor: {
        required: "Informe um setor."
      }
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight(element) {
      $(element).addClass('is-invalid');
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid');
    }
  });

  $('#account').css('cursor', 'pointer');
  $('#payment').css('cursor', 'pointer');

  const queryString = window.location.href;
  const parametros = queryString.split('/');
  const ordemproducao = parametros[parametros.length - 1];

  let contaFs = 1;
  $('#account').on('click', function () {
    if (contaFs == 2) {
      $('#voltar2').trigger('click');
    }
  });

  $('#payment').on('click', function () {
    if (contaFs == 1) {
      $('#avancar1').trigger('click');
    } else if (contaFs == 3) {
      $('#voltar3').trigger('click');
    }
  });

  $('#confirm').on('click', function () {
    if (contaFs == 2) {
      $('#avancar2').trigger('click');
    }
  });

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro("CADOF", getCookie("usuario"), $('#txtNumeroOrdem').val());
    window.location.href = `${BASE_URI}/cadof`;
  });

  $('#btnCalcular').on('click', async function () {
    await calculaAgendamento();
    if ($.fn.DataTable.isDataTable('#tabelaAgendamento')) {
      await sleep(1000);
      $("#tabelaAgendamento").DataTable().columns.adjust().draw(false);
    }
  });

  $('#btnConfirmar').on('click', async function () {
    await confirmarAgendamento();
  });

  $('#btnExcluir').on('click', async function () {
    await excluiAgendamento();
  });

  $('#btnFechar').on('click', async function () {
    $('#modal-agendamento').modal('hide');
  });

  $('#btnBuscarFaccao').on('click', async function () {
    await BuscaFaccaoAgendamento();
    if ($.fn.DataTable.isDataTable('#tabelaAgendamento')) {
      await sleep(1000);
      $("#tabelaAgendamento").DataTable().columns.adjust().draw(false);
    }
  });

  $('#btnAgendamento').on('click', async function () {
    await modalAgendamento();
    if ($.fn.DataTable.isDataTable('#tabelaAgendamento')) {
      await sleep(1000);
      $("#tabelaAgendamento").DataTable().columns.adjust().draw(false);
    }
  });

  $("#btnGravar").click(async function () {
    $.LoadingOverlay('show');
    try {
      validaDados();
      await gravarOF();
    } catch (error) {
      console.error(error);
      msgErro(`Não foi possível gravar a ordem de produção: ${error}`);
    } finally {
      $.LoadingOverlay('hide');
    }
  });


  $(".next").click(async function () {
    let validator = $("#msform").validate();
    let liberado = true;

    if ($(this).attr("id") == "avancar1") {
      validator.element("#txtTabPrazo");
      validator.element("#txtNumeroOrdem");
      validator.element("#txtProduto");

      if (!(validator.element("#txtTabPrazo") && validator.element("#txtNumeroOrdem") && validator.element("#txtProduto"))) {
        liberado = false;
      }
    } else if ($(this).attr("id") == "avancar2") {
      validator.element("#txtFluxo");

      if (!(validator.element("#txtFluxo"))) {
        liberado = false;
      }
    }

    if (liberado) {
      contaFs += 1;
      // currentFs = $(this).parent();
      currentFs = $(this).closest("fieldset");
      nextFs = $(this).closest("fieldset").next();

      $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

      nextFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;

            currentFs.css({
              display: "none",
              position: "relative",
            });
            nextFs.css({
              opacity,
            });
          },
          duration: 600,
        }
      );
    } else {
      msgAlerta('Necessário informar os campos obrigatórios!');
    }
  });

  $(".previous").click(function () {
    contaFs -= 1;

    currentFs = $(this).closest("fieldset");
    previousFs = $(this).closest("fieldset").prev();
    $("#progressbar li")
      .eq($("fieldset").index(currentFs))
      .removeClass("active");
    previousFs.show();
    currentFs.animate(
      {
        opacity: 0,
      },
      {
        step(now) {
          opacity = 1 - now;
          currentFs.css({
            display: "none",
            position: "relative",
          });
          previousFs.css({
            opacity,
          });
        },
        duration: 600,
      }
    );
  });

  if (ordemproducao != 'create') {
    await BuscaDadosOF(ordemproducao);
  } else {
    setarDataAtual('txtDtInicio');
    setarDataPraFrente('txtDtFim', new Date(), 30);
    setarDataAtual('txtDtCadastro');
    const qtdeDigitoNumeroOF = await BuscaParametrosOrdemProducao();
    $('#txtNumeroOrdem').prop('maxlength', parseInt(qtdeDigitoNumeroOF[1].VALOR) + 6)
    await carregaValoresPadroesCadOF()
    $('#txtNumeroOrdem').focus()
  }

  CriaPesquisasTela();
  async function BuscaDadosOF(Numero) {
    try {
      $.LoadingOverlay('show');
      try {
        let sNumero = Numero;
        if (sNumero.includes('duplicar')) {
          sNumero = sNumero.split('duplicar')[0];
        }
        const params = `NUMERO=${sNumero}`
        const response = await requisicao('GET', '/sisplan/cadof/v1/cadof?', params, undefined, 30000);

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        jsonStr = jsonStr.resultado[0];
        insereValor('#txtTabPrazo', jsonStr.periodo, jsonStr.periodo);

        $("#txtNumeroOrdem").val(sNumero);
        if (!Numero.includes('duplicar')) {
          $('#chkFaccao').prop('checked', true);
          $('#txtNumeroOrdem').prop('disabled', true);
          $('#txtProduto').prop('disabled', true);
          $('#btnProduto').prop('disabled', true);
          $('#txtPedido').prop('disabled', true);
          $('#btnPedido').prop('disabled', true);
          $('#btnLimpaPedido').prop('disabled', true);
          $('#btnLimpaProduto').prop('disabled', true);
          $("#txtDtCadastro").val(jsonStr.data_Cad != undefined ? jsonStr.data_Cad.slice(0, 10) : 0);
          $("#txtDtInicio").val(jsonStr.dt_Inicio != undefined ? jsonStr.dt_Inicio.slice(0, 10) : 0);
          insereValor('#txtPedido', jsonStr.pedido, {tabela: 'PEDIDO', campoBusca: 'CODCLI', campoWhere: 'NUMERO', valorWhere: jsonStr.pedido})
        } else {
          setarDataAtual('txtDtInicio');
          setarDataAtual('txtDtCadastro');
          const novaUrl = window.location.href.replace(/\/\d+duplicar$/, "/create");
          window.history.pushState(null, null, novaUrl);
        }

        $("#txtProgramacao").val(jsonStr.programacao);
        insereValor("#txtTipo", jsonStr.id_Tipo, jsonStr.desc_Tipo);
        insereValor("#txtProduto", jsonStr.codigo, jsonStr.desc_Produto);
        insereValor("#txtMaquina", jsonStr.maquina, jsonStr.desc_Maquina);
        $("#txtDtFim").val(jsonStr.dt_Final != undefined ? jsonStr.dt_Final.slice(0, 10) : 0);
        insereValor("#txtDeposito", jsonStr.deposito, jsonStr.desc_Deposito);
        insereValor("#txtFluxo", jsonStr.fluxo, jsonStr.desc_Fluxo);
        $("#txtObs").val(jsonStr.observacao);

        CriaTabelaPartes(jsonStr.partes);
        CriaTabelaFluxo(jsonStr.tbFluxo);
        await ExplodeGradeProduto();
        if (!Numero.includes('duplicar')) {
          bloqueiaCamposQtde();
        }
        if (Numero.includes('duplicar')) {
          $("#txtNumeroOrdem").val('');
        }
      } catch (error) {
        console.error(error);
        msgErro(`Não foi possível buscar os dados ${error}`);
        $("#txtNumeroOrdem").val('');
      }
    } finally {
      $.LoadingOverlay('hide');
    };
  }

  $('#avancar1').on('click', async function () {
    if ($.fn.DataTable.isDataTable('#tabelaFluxo')) {
      await sleep(1000);
      if (!$('#chkFaccao').prop('checked')) {
        $('#txtFluxo').trigger('focusout')
      };
      $("#tabelaFluxo").DataTable().columns.adjust().draw(false);
    }
  })

  $('#voltar3').on('click', async function () {
    if ($.fn.DataTable.isDataTable('#tabelaFluxo')) {
      await sleep(1000);
      if (!$('#chkFaccao').prop('checked')) {
        $('#txtFluxo').trigger('focusout')
      };
      $("#tabelaFluxo").DataTable().columns.adjust().draw(false);
    }
  })

  $('#avancar2').on('click', async function () {
    if ($.fn.DataTable.isDataTable('#tabelaGradeProduto')) {
      await sleep(1000);
      $("#tabelaGradeProduto").DataTable().columns.adjust().draw(false);
    }
  })

  $('#txtProduto').on('focusout', async function () {
    if (pegaChave(this) != '') {
      await BuscaPartesFluxo('');
      await ExplodeGradeProduto();
    }
  })

  $('#txtFluxo').on('focusout', async function () {
    if ((pegaChave(this) != '') && (pegaChave('#txtProduto') != '')) {
      await BuscaPartesFluxo(pegaChave(this));
    }
  })

  $('#txtTabPrazo').on('focusout', async function () {
    if ((pegaChave(this) != '') && (($('#txtNumeroOrdem').val() == '') || (!$('#txtNumeroOrdem').prop('disabled')))) {
      await ProximoNumeroOF();
    }
    if (pegaChave(this) != '') {
      const dataFim = await buscaValor('TABPRZ', 'DT_FIM', 'PRAZO', pegaChave(this));
      if (dataFim.DT_FIM == '1899-12-30') {
        setarDataPraFrente('txtDtFim', new Date(), 30);
      } else {
        $('#txtDtFim').val(dataFim.DT_FIM);
      }
    }
  })

  $('#txtDataDespacho').on('focusout', async function () {
    const diaSemana = await buscaValor('ANO', 'DIA_SEMANA, DIA_UTIL_PROD', 'DATA', pegaValor(this));
    $("#diaSemana").text(diaSemana.DIA_SEMANA);
    $("#diaSemana").css('color', diaSemana.DIA_UTIL_PROD == 'S' ? 'green' : 'red');
  });

  function CriaPesquisasTela() {
    var separador = "' - '";

    $('#txtTabPrazo').autocompleta(1, `JSON={
      "tabela": "TABPRZ",
      "camposSelect": ["TABPRZ.PRAZO CHAVE", "TABPRZ.DESCRICAO"],
      "where": ["TABPRZ.ATIVO_PRODUCAO = 'S'"]
    }`);

    $('#btnTabPrazo').pesquisa_serverside(['#txtTabPrazo'], ['TABPRZ.PRAZO'], ['TABPRZ.DESCRICAO'], `{
      "tabela":"TABPRZ",
      "camposSelect": ["TABPRZ.PRAZO", "TABPRZ.DESCRICAO"],
      "where": ["TABPRZ.ATIVO_PRODUCAO = 'S'"]
    }`, 'Pesquisa Prazo');

    $('#btnLimpaTabPrazo').on('click', function () {
      $('#txtTabPrazo').val('');
    });

    $('#txtMaquina').autocompleta(1, `JSON={
      "tabela": "MAQUINA",
      "camposSelect": ["MAQUINA.MAQUINA CHAVE", "MAQUINA.DESCRICAO"],
      "where": null
    }`);

    $('#btnMaquina').pesquisa_serverside(['#txtMaquina'], ['MAQUINA.MAQUINA'], ['MAQUINA.DESCRICAO'], `{
      "tabela":"MAQUINA",
      "camposSelect": ["MAQUINA.MAQUINA", "MAQUINA.DESCRICAO"],
      "where": null
    }`, 'Pesquisa Máquina');

    $('#btnLimpaMaquina').on('click', function () {
      $('#txtMaquina').val('');
    });

    $('#txtTipo').autocompleta(1, `JSON={
      "tabela": "TIPO",
      "camposSelect": ["TIPO.ID CHAVE", "TIPO.DESCRICAO"],
      "where": ["TIPO.AREA = 'PRO' AND TIPO.ATIVO = 'S'"]
    }`);

    $('#btnTipo').pesquisa_serverside(['#txtTipo'], ['TIPO.ID'], ['TIPO.DESCRICAO'], `{
      "tabela":"TIPO",
      "camposSelect": ["TIPO.ID", "TIPO.DESCRICAO"],
      "where": ["TIPO.AREA = 'PRO' AND TIPO.ATIVO = 'S'"]
    }`, 'Pesquisa Tipo');

    $('#btnLimpaTipo').on('click', function () {
      $('#txtTipo').val('');
    });

    $('#txtProduto').autocompleta(1, `JSON={
      "tabela": "PRODUTO",
      "camposSelect": ["PRODUTO.CODIGO CHAVE", "PRODUTO.DESCRICAO"],
      "where": null
    }`);

    $('#btnProduto').pesquisa_serverside(['#txtProduto'], ['CODIGO'], ['DESCRICAO'], `{
      "tabela":"PRODUTO",
      "camposSelect": [
      "CODIGO",
      "CODIGO2",
      "DESCRICAO",
      "GRUPO",
      "LINHA",
      "COLECAO",
      "MARCA",
      "ETIQUETA"
    ],
    "where": ["CODIGO <> ''"]
    }`, 'Pesquisa Produto');

    $('#btnLimpaProduto').on('click', function () {
      $('#txtProduto').val('');
    });

    $('#txtDeposito').autocompleta(1, `JSON={
      "tabela": "DEPOSITO",
      "camposSelect": ["DEPOSITO.CODIGO CHAVE", "DEPOSITO.DESCRICAO"],
      "where": null
    }`);

    $('#btnDeposito').pesquisa_serverside(['#txtDeposito'], ['DEPOSITO.CODIGO'], ['DEPOSITO.DESCRICAO'], `{
      "tabela":"DEPOSITO",
      "camposSelect": ["DEPOSITO.CODIGO", "DEPOSITO.DESCRICAO"],
      "where": null
    }`, 'Pesquisa Depósito');

    $('#btnLimpaDeposito').on('click', function () {
      $('#txtDeposito').val('');
    });

    $('#txtFluxo').autocompleta(1, `JSON={
      "tabela": "ROTEIRO",
      "camposSelect": ["ROTEIRO.CODIGO CHAVE", "ROTEIRO.DESCRICAO"],
      "where": ["ROTEIRO.ATIVO = 'S'"]
    }`);

    $('#btnFluxo').pesquisa_serverside(['#txtFluxo'], ['ROTEIRO.CODIGO'], ['ROTEIRO.DESCRICAO'], `{
      "tabela":"ROTEIRO",
      "camposSelect": ["ROTEIRO.CODIGO", "ROTEIRO.DESCRICAO"],
      "where": ["ROTEIRO.ATIVO = 'S'"]
    }`, 'Pesquisa Fluxo');

    $('#btnLimpaFluxo').on('click', function () {
      $('#txtFluxo').val('');
    });

    $('#txtParte').autocompleta(1, `JSON={
      "tabela": "TIPO_APL",
      "camposSelect": ["TIPO_APL.CODIGO CHAVE", "TIPO_APL.DESCRICAO"],
      "where": ["TIPO_APL.ATIVO = 'S'"]
    }`);

    $('#btnParte').pesquisa_serverside(['#txtParte'], ['TIPO_APL.CODIGO'], ['TIPO_APL.DESCRICAO'], `{
      "tabela":"TIPO_APL",
      "camposSelect": ["TIPO_APL.CODIGO", "TIPO_APL.DESCRICAO"],
      "where": null
    }`, 'Pesquisa Parte');

    $('#btnLimpaParte').on('click', function () {
      $('#txtParte').val('');
    });

    $('#btnLimpaPedido').off('click');
    componenteFiltro('pedido', false, false)

    $('#btnLimpaPedido').on('click', function () {
      $('#txtPedido').trigger('blur');
    })
  }

  async function buscaItensPedido(pedido) {
    try {
      const pesquisa = {
        camposSelect: ['PED_ITEN.CODIGO', 'PED_ITEN.COR', 'PED_ITEN.TAM', 'PED_ITEN.QTDE', 'PRODUTO.DESCRICAO'],
        tabela: 'PED_ITEN',
        leftJoin: [{ tabela: 'PRODUTO', condicao: 'PED_ITEN.CODIGO = PRODUTO.CODIGO' }],
        where: [`PED_ITEN.NUMERO = '${pedido}'`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

      return jsonStr;
    } catch (e) {
      console.log(e);
      return [];
    }
  }

  async function buscaItensPedidoInserir(pedido) {
    try {
      const pesquisa = {
        camposSelect: ['PED_ITEN.CODIGO', 'PRODUTO.DESCRICAO'],
        tabela: 'PED_ITEN',
        leftJoin: [{ tabela: 'PRODUTO', condicao: 'PED_ITEN.CODIGO = PRODUTO.CODIGO' }],
        where: [`PED_ITEN.NUMERO = '${pedido}'`],
        groupby: ['PED_ITEN.CODIGO', 'PRODUTO.DESCRICAO']
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

      return jsonStr;
    } catch (e) {
      console.log(e);
      return [];
    }
  }

  $('#txtPedido').on('blur', async function () {
    const pedido = pegaChave(this);

    if (pedido != '') {
      const itensPedido = await buscaItensPedidoInserir(pedido)
      $('#txtProduto').val('');

      if (itensPedido.length == 1) {
        insereValor('#txtProduto', itensPedido[0].CODIGO, itensPedido[0].DESCRICAO);
        $('#txtProduto').trigger('focusout');
      }

      $('#txtProduto').off('autocompleta');
      $('#btnProduto').off('pesquisa_serverside');

      $('#txtProduto').autocompleta(1, `JSON={
        "tabela": "PRODUTO",
        "camposSelect": ["PRODUTO.CODIGO CHAVE", "PRODUTO.DESCRICAO"],
        "where": ["PRODUTO.CODIGO IN (SELECT DISTINCT CODIGO FROM [PED_ITEN] WHERE NUMERO = '${pedido}')"]
      }`);

      $('#btnProduto').pesquisa_serverside(['#txtProduto'], ['CODIGO'], ['DESCRICAO'], `{
        "tabela":"PRODUTO",
        "camposSelect": [
        "CODIGO",
        "DESCRICAO",
        "GRUPO",
        "LINHA",
        "COLECAO",
        "MARCA",
        "ETIQUETA"
      ],
      "where": ["PRODUTO.CODIGO IN (SELECT DISTINCT CODIGO FROM [PED_ITEN] WHERE NUMERO = '${pedido}')"]
      }`, 'Pesquisa Produto');
    } else {
      $('#txtProduto').autocompleta(1, `JSON={
        "tabela": "PRODUTO",
        "camposSelect": ["PRODUTO.CODIGO CHAVE", "PRODUTO.DESCRICAO"],
        "where": null
      }`);

      $('#btnProduto').pesquisa_serverside(['#txtProduto'], ['CODIGO'], ['DESCRICAO'], `{
        "tabela":"PRODUTO",
        "camposSelect": [
        "CODIGO",
        "DESCRICAO",
        "GRUPO",
        "LINHA",
        "COLECAO",
        "MARCA",
        "ETIQUETA"
      ],
      "where": null
      }`, 'Pesquisa Produto');
    }
  })

  async function ExplodeGradeProduto() {
    const codigo = pegaChave('#txtProduto');

    if (codigo == '') {
      return;
    };

    if ($.fn.DataTable.isDataTable('#tabelaGradeProduto')) {
      $('#tabelaGradeProduto').DataTable().destroy();
      $('#tabelaGradeProduto').empty();
    };

    let codigoGravado = await buscaValor('OF1', 'CODIGO', 'NUMERO', ordemproducao.split('duplicar')[0]);

    if (codigoGravado != undefined) {
      codigoGravado = codigoGravado.CODIGO;
    }

    const SQLAuxiliar = {
      tabela: "OF_ITEN",
      camposSelect: ["COR", "TAM", "QTDE QUANTIDADE"],
      where: [`NUMERO= '${$("#txtNumeroOrdem").val()}'`]
    };

    let params = '';
    if (ordemproducao != 'create') {
      params = `&SQLAUXILIAR=${JSON.stringify(SQLAuxiliar)}`;
    }

    const response = await requisicao('GET', '/sisplan/funcoes/v1/gradeproduto?', `CODIGO=${codigo}${params}`, null);
    const jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
    }

    for (let i = 0; i < parseInt(jsonStr.length); i++) {
      const colunas = Object.keys(jsonStr[i])
      const tamanhos = [];
      colunas.forEach((coluna) => {
        if (!['CODIGO', 'COR', 'DESC_COR', 'POSICAO'].includes(coluna)) {
          tamanhos.push(coluna.replace('BARRA', '/'));
        }
      });

      tamanhos?.sort();

      const jsonObject = jsonStr.map(obj => {
        const newObject = { ...obj };
        delete newObject.CODIGO;
        delete newObject.POSICAO;
        Object.keys(obj).forEach(key => {
          if (!['CODIGO', 'COR', 'POSICAO', 'DESC_COR'].includes(key)) {
            newObject[key] = `<input type="number" class="input-default focus form-control camposGrade camposInteiro" id="${newObject.COR + key}" value="${codigoGravado == obj['CODIGO'] ? obj[key] : ''}">`;
            newObject[key.split('HIFEN')[1]] = `<input type="number" data-tam="${key.split('HIFEN')[1]}" data-cor="${newObject.COR}" class="input-default focus form-control camposGrade camposInteiro" style="min-width: 70px" id="${newObject.COR + key.replace('/', 'BARRA')}" value="${codigoGravado == obj['CODIGO'] ? obj[key] : ''}">`;
            delete newObject[key];
          }
        });
        return { ...newObject };
      });

      if (i == 0) {
        const titulosFixos = ['COR', 'DESC_COR'];
        const titulosGeral = [...titulosFixos, ...tamanhos];
        const titulos = titulosGeral.map(titulo => {
          const coluna = ['COR', 'DESC_COR'].includes(titulo) ? titulo : titulo.split('HIFEN')[1];
          const objeto = { title: coluna, data: coluna };
          return objeto;
        });

        $("#tabelaGradeProduto").DataTable({
          destroy: true,
          filter: false,
          paging: false,
          autoWidth: true,
          columns: titulos,
          data: jsonObject,
          fixedHeader: true
        });
      }
    }

    await carregaItensPedido();
  };

  async function carregaItensPedido() {
    try {
      const pedido = pegaChave('#txtPedido');

      if (pedido && pedido != '') {
        const itensPedido = await buscaItensPedido(pedido);
        const produto = pegaChave('#txtProduto')

        $('.camposInteiro').toArray().forEach((e) => {
          try {
            const cor = $(e).attr('data-cor')
            const tam = $(e).attr('data-tam')
            const index = itensPedido.findIndex(obj => obj.CODIGO == produto && obj.COR == cor && obj.TAM == tam);

            if (index != -1) {
              $(e).val(itensPedido[index].QTDE);
            }
          } catch (e) {
            console.log(e);
          }
        })
      }
    } catch (e) {
      console.log(e);
    }
  }

  async function ProximoNumeroOF() {
    $.LoadingOverlay('show');
    try {
      const params = `PERIODO=${pegaChave('#txtTabPrazo')}`;
      const response = await requisicao('GET', '/sisplan/cadof/v1/proximonumero?', params, undefined, 30000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      $('#txtNumeroOrdem').val(jsonStr);
    } catch (error) {
      console.log('Erro na rotina ProximoNumeroOF' + error);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#txtNumeroOrdem').on('blur', async function () {
    if (!$('#txtNumeroOrdem').val()) {
      $('#txtNumeroOrdem').val(await RetornaProximo("OF1", "OF1", "NUMERO", 6))
    }
  })

  async function BuscaPartesFluxo(fluxo) {
    $.LoadingOverlay('show');
    try {
      const params = `CODIGO=${pegaChave('#txtProduto')}&FLUXO=${fluxo}`
      const response = await requisicao('GET', '/sisplan/cadof/v1/buscapartesfluxo?', params, undefined, 30000);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      jsonStr = jsonStr.resultado;
      insereValor('#txtFluxo', jsonStr[0].fluxo, jsonStr[0].desc_Fluxo);
      CriaTabelaPartes(jsonStr[0].partes);
      CriaTabelaFluxo(jsonStr[0].tbFluxo);
    } catch (error) {
      console.log('Erro na função BuscaPartesFluxo ' + error);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function CriaTabelaFluxo(jsonFluxo) {
    if ($.fn.DataTable.isDataTable('#tabelaFluxo')) {
      $('#tabelaFluxo').DataTable().destroy();
      $('#tabelaFluxo').empty();
    };

    const faccaoChecada = jsonFluxo[0] == null ? false : true;

    if (!faccaoChecada) { $('#chkFaccao').prop('checked', false) };

    const titulosFluxo = [
      { title: "Parte", data: "parte" },
      { title: "Setor", data: "setor" },
      { title: "Descrição", data: "descricao" },
      {
        title: "Data Prev.",
        data: "data_Prev",
        render: function (data, type, row) {
          if (type === "display") {
            const x = data.slice(0, 10).split('-');
            return `${x[2]}/${x[1]}/${x[0]}`;
          }
          return data;
        },
      },
      { title: "Dias", data: "dias" },
      { title: "Data Inf.", data: "data_Inf" },
      { title: "DATA_SAIDA", data: "data_Saida" },
      { title: "ORDEM", data: "ordem" },
      { title: "SABADO_UTIL", data: "sabado_Util" },
      { title: "DOMINGO_UTIL", data: "domingo_Util" },
      { title: "DIA_NEUTRO", data: "dia_Neutro" },
      { title: "PROD_PARALELO", data: "prod_Paralelo" },
      { title: "FACCAO", data: "faccao" },
      { title: "QTDE", data: "qtde" },
      { title: "OBS", data: "obs" }
    ];

    $("#tabelaFluxo").DataTable({
      destroy: true,
      filter: false,
      paging: false,
      scrollX: true,
      autoWidth: true,
      columns: titulosFluxo,
      data: faccaoChecada ? jsonFluxo : '',
      columnDefs: [
        {
          targets: [6, 7, 8, 9, 10, 11, 12, 13, 14],
          visible: false,
        },
        {
          "targets": [4],
          "className": 'pr-4 text-right'
        }
      ]
    });
  }

  function CriaTabelaPartes(jsonPartes) {
    if ($.fn.DataTable.isDataTable('#tabelaPartes')) {
      $('#tabelaPartes').DataTable().destroy();
      $('#tabelaPartes').empty();
    };

    const titulos = [
      {
        title: "Sel", data: "sel", render: function (data, type, row, meta) {
          if (type === "display") {
            if (data === "S") {
              return `<input type="checkbox" id="sel${meta.row}" checked="checked">`;
            } else {
              return `<input type="checkbox" id="sel${meta.row}">`;
            }
          }
          return data;
        }
      },
      { title: "Parte", data: "parte" },
      { title: "CodCli", data: "codCli" },
      { title: "Desc. Cli.", data: "desc_Cli" },
      { title: "Descrição", data: "descricao" },
      { title: "Estoque", data: "estoque" }
    ];

    $("#tabelaPartes").DataTable({
      destroy: true,
      filter: false,
      paging: false,
      autoWidth: true,
      columns: titulos,
      data: jsonPartes
    });
  }

  function validaDados() {
    const listaDados = $('#tabelaGradeProduto').DataTable().data().toArray();
    let qtde = 0;
    listaDados.forEach(dado => {
      const objeto = Object.entries(dado);
      const colunas = objeto.map(prop => prop[0]);

      for (let i = 0; i < colunas.length; i++) {
        if (!['COR', 'DESC_COR'].includes(colunas[i])) {
          const seletor = $(`.camposGrade[data-tam='${colunas[i]}'][data-cor='${dado.COR}']`);
          qtde += isNaN(parseInt($(seletor).val())) ? 0 : parseInt($(seletor).val());
        }
      }
    });

    if (!qtde > 0) {
      throw new Error('Necessário informar a quantidade para gravar a ordem de produção.');
    }
  }

  async function gravarOF() {
    const OF1 = retornaDados();
    const response = await requisicao('POST', '/sisplan/cadof/v1/cadof?', '', JSON.stringify(OF1), 90000);

    if (!response) {
      $.LoadingOverlay('hide');
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      $.LoadingOverlay('hide');
      msgAlerta(jsonStr.mensagem.mensagem);
      return;
    }

    criaMensagemSucesso(`Ordem de produção ${$('#txtNumeroOrdem').val()} gravada com sucesso!`, () => { window.location.href = `${BASE_URI}/cadof`; });
  }

  function retornaDados() {
    const retorno = {
      Data_Cad: pegaValor('#txtDtCadastro'),
      Periodo: pegaChave('#txtTabPrazo'),
      Numero: pegaValor('#txtNumeroOrdem'),
      Parte: retornaParteSelecionada(),
      Programacao: pegaValor('#txtProgramacao'),
      Maquina: pegaChave('#txtMaquina'),
      Id_Tipo: pegaChave('#txtTipo'),
      Codigo: pegaChave('#txtProduto'),
      Dt_Inicio: pegaValor('#txtDtInicio'),
      Dt_Final: pegaValor('#txtDtFim'),
      Deposito: pegaChave('#txtDeposito'),
      Observacao: pegaValor('#txtObs'),
      Partes: retornaPartes(),
      LancaFaccao: $('#chkFaccao').prop('checked') ? 'S' : 'N',
      DescFinalSemana: $('#chkDescFinalSemana').prop('checked') ? 'S' : 'N',
      Fluxo: pegaChave('#txtFluxo'),
      TbFluxo: retornaFluxo(),
      Of_Iten: retornaItens(),
      Emp_Id: getCookie('emp_id'),
      Pedido: pegaChave('#txtPedido')
    }

    return retorno;
  }

  function retornaPartes() {
    let arrayPartes = [];
    $('#tabelaPartes').DataTable().data().toArray().forEach((item, index) => {
      arrayPartes.push({
        CodCli: item.codCli,
        Desc_Cli: item.desc_Cli,
        Descricao: item.descricao,
        Estoque: item.estoque,
        Fluxo: item.fluxo,
        Parte: item.parte,
        Sel: $(`#sel${index}`).prop('checked') ? 'S' : 'N'
      })
    });

    return arrayPartes;
  }

  function retornaFluxo() {
    let arrayFluxo = [];
    $('#tabelaFluxo').DataTable().data().toArray().forEach((item, index) => {
      arrayFluxo.push({
        Data_Inf: item.data_Inf,
        Data_Prev: item.data_Prev,
        Descricao: item.descricao,
        Dia_Neutro: item.dia_Neutro,
        Dias: item.dias,
        Domingo_Util: item.domingo_Util,
        Fluxo: item.fluxo,
        Ordem: item.ordem,
        Parte: item.parte,
        Prod_Paralelo: item.prod_Paralelo,
        Sabado_Util: item.sabado_Util,
        Setor: item.setor
      })
    });

    return arrayFluxo;
  }

  function retornaItens() {
    let itens = [];
    const listaDados = $('#tabelaGradeProduto').DataTable().data().toArray();
    listaDados.forEach(dado => {
      const objeto = Object.entries(dado);
      const colunas = objeto.map(prop => prop[0]);

      for (let i = 0; i < colunas.length; i++) {
        if (!['COR', 'DESC_COR'].includes(colunas[i])) {
          // const idSemFormatacao = dado[colunas[i]].split('id="')[1].replace('"', '');
          // const idFormatado = idSemFormatacao.split("value=")[0].trim();
          const seletor = $(`.camposGrade[data-tam='${colunas[i]}'][data-cor='${dado.COR}']`);
          const retorno = {
            Cor: dado.COR,
            Tam: colunas[i],
            Qtde: parseFloat($(seletor).val())
          };
          itens.push(retorno);
        }
      }
    });

    return itens;
  }

  function retornaParteSelecionada() {
    let parte = '';
    $('#tabelaPartes').DataTable().data().toArray().forEach((item, index) => {
      if ($(`#sel${index}`).prop('checked')) {
        parte = item.parte;
      }
    });

    return parte;
  }

  async function modalAgendamento() {
    $('#txtNumero').val(pegaValor('#txtNumeroOrdem'));
    $('#txtDataDespacho').val(pegaValor('#txtDtInicio'));
    $('#txtDataDespacho').trigger('focusout');
    await buscaTipoProduto();
    const url = `/sisplan/cadof/v1/retornaagendamento?`;
    const tabela = $("#tabelaFluxo").DataTable().rows().data().toArray();
    const novaTabela = tabela.map((objetoOriginal) => {
      const objetoEmMaiusculas = {};

      for (const propriedade in objetoOriginal) {
        if (objetoOriginal.hasOwnProperty(propriedade)) {
          const valor = objetoOriginal[propriedade];
          objetoEmMaiusculas[propriedade.toUpperCase()] = typeof valor === 'string' ? valor.toUpperCase() : valor;
        }
      }

      return objetoEmMaiusculas;
    });
    const params = `JSON=${JSON.stringify(novaTabela)}&NUMERO=${pegaValor('#txtNumero')}`;
    const response = await requisicao("POST", url, "", params, null);
    const jsonStr = await response.json();
    if (response.status != 200) {
      msgAlerta(jsonStr.mensagem);
      return
    }

    criaTabelaAgendamento(jsonStr);
    $('#modal-agendamento').modal('show');
  }

  function criaTabelaAgendamento(jsonStr) {
    const titulosAgendamento = [
      {
        title: "Sel", data: "SEL",
        render: function (data, type, row, meta) {
          if (type === "display") {
            if (data === 'S') {
              return `<input type="checkbox" id="SEL${meta.row}" checked>`;
            } else {
              return `<input type="checkbox" id="SEL${meta.row}">`;
            }
          }
          return data;
        }
      },
      { title: "Parte", data: "PARTE" },
      { title: "Setor", data: "SETOR" },
      { title: "Descrição", data: "DESCRICAO" },
      { title: "Peças dia", data: "PECAS_DIA" },
      {
        title: "Data Prev.",
        data: "DATA_PREV",
        render: function (data, type, row, meta) {
          if (type === "display") {
            const rowIndex = meta.row;
            const id = `Data_Prev${rowIndex}`;
            const formattedDate = data ? data.slice(0, 10) : "";
            return `<input type="date" class="input-default focus form-control" id="${id}" value="${formattedDate}">`;
          }
          return data;
        }
      },
      {
        title: "Data Saída",
        data: "DATA_SAIDA",
        render: function (data, type, row, meta) {
          if (type === "display") {
            const rowIndex = meta.row;
            const id = `Data_Saida${rowIndex}`;
            const formattedDate = data ? data.slice(0, 10) : "";
            return `<input type="date" class="input-default focus form-control" id="${id}" value="${formattedDate}">`;
          }
          return data;
        }
      },
      { title: "Dias", data: "DIAS" },
      // {
      //   title: "Dias", data: "DIAS",
      //   render: function (data, type, row, meta) {
      //     if (type === "display") {
      //       const rowIndex = meta.row;
      //       const id = `Dias${rowIndex}`;
      //       return `<input type="number" class="input-default focus form-control camposInteiro" id="${id}" value="${data}" style="min-width: 60px">`;
      //     }
      //     return data;
      //   }
      // },
      { title: "Ordem", data: "ORDEM" },
      {
        title: "Sábado útil", data: "SABADO_UTIL",
        render: function (data, type, row, meta) {
          if (type === "display") {
            if (data === 'S') {
              return `<input type="checkbox" class="align-self-center" id="Sabado_Util${meta.row}" checked>`;
            } else {
              return `<input type="checkbox" class="align-self-center" id="Sabado_Util${meta.row}">`;
            }
          }
          return data;
        }
      },
      {
        title: "Domingo útil", data: "DOMINGO_UTIL",
        render: function (data, type, row, meta) {
          if (type === "display") {
            if (data === 'S') {
              return `<input type="checkbox" class="align-self-center" id="Domingo_Util${meta.row}" checked>`;
            } else {
              return `<input type="checkbox" class="align-self-center" id="Domingo_Util${meta.row}">`;
            }
          }
          return data;
        }
      },
      {
        title: "Dia_Neutro", data: "DIA_NEUTRO",
        render: function (data, type, row, meta) {
          if (type === "display") {
            if (data === 'S') {
              return `<input type="checkbox" class="align-self-center" id="Dia_Neutro${meta.row}" checked>`;
            } else {
              return `<input type="checkbox" class="align-self-center" id="Dia_Neutro${meta.row}">`;
            }
          }
          return data;
        }
      },
      {
        title: "Prod. Paralelo", data: "PROD_PARALELO",
        render: function (data, type, row, meta) {
          if (type === "display") {
            if (data === 'S') {
              return `<input type="checkbox" class="align-self-center" id="Prod_Paralelo${meta.row}" checked>`;
            } else {
              return `<input type="checkbox" class="align-self-center" id="Prod_Paralelo${meta.row}">`;
            }
          }
          return data;
        }
      },
      {
        title: "Facção", data: "FACCAO",
        render: function (data, type, row, meta) {
          if (type === "display") {
            const rowIndex = meta.row;
            const id = `Faccao${rowIndex}`;
            return `
            <div class="input-group" style="min-width: 244px">
              <input class="input-default focus form-control inputFaccao" type="text" id="${id}" value="${data}" style="min-width: 200px" readonly>
              <div class="input-group-append">
                <button class="btn bg-danger" id="btnLimpaFaccao${rowIndex}" name="btnLimpaFaccao${rowIndex}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
              </div>
            </div>
            `;
          }
          return data;
        }
      },
      {
        title: "Qtde", data: "QTDE",
        render: function (data, type, row, meta) {
          if (type === "display") {
            const rowIndex = meta.row;
            const id = `Qtde${rowIndex}`;
            return `<input type="number" class="input-default focus form-control camposInteiro" id="${id}" value="${data}" style="min-width: 60px">`;
          }
          return data;
        }
      },
      { title: "Dias Orig.", data: "DIAS_ORIG" },
      {
        title: "Obs", data: "OBS",
        render: function (data, type, row, meta) {
          if (type === "display") {
            const rowIndex = meta.row;
            const id = `Obs${rowIndex}`;
            return `<input type="text" class="input-default focus form-control" id="${id}" value="${data}" style="min-width: 200px">`;
          }
          return data;
        }
      },
    ];

    $("#tabelaAgendamento").DataTable({
      destroy: true,
      filter: false,
      paging: false,
      scrollX: true,
      autoWidth: true,
      columns: titulosAgendamento,
      data: jsonStr,
      columnDefs: [
        {
          "targets": [7],
          "className": 'pr-4 text-right'
        }
      ]
    });

    $('.camposInteiro').on('focusout', function () {
      const inputValue = $(this).val();
      if (!Number.isInteger(parseFloat(inputValue))) {
        msgAlerta('Permitido apenas números inteiros!');
        $(this).val(0);
      } else {
        $(this).val(parseInt(inputValue));
      }
    });

    for (let i = 0; i < $(".inputFaccao").length; i++) {
      $(`#btnLimpaFaccao${i}`).on('click', function () {
        $(`#Faccao${i}`).val('');
      });

      $(`#Faccao${i}`).pesquisa(
        `#Faccao${i}`,
        "CODCLI",
        "NOME",
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": ["ENTIDADE.TIPO_ENTIDADE LIKE '[PERCENTUAL]T[PERCENTUAL]'"]}`,
        "Pesquisa Entidade",
        "ENTIDADE"
      );
    }
  }

  function retornaArrayObjetoAgendamento(bMaiusculo = true, bChaveFaccao = true) {
    const retorno = [];
    if (bMaiusculo) {
      $('#tabelaAgendamento').DataTable().data().toArray().forEach((item, index) => {
        retorno.push({
          SEL: $(`#SEL${index}`).prop('checked') ? 'S' : 'N',
          PARTE: item.PARTE,
          SETOR: item.SETOR,
          DESCRICAO: item.DESCRICAO,
          PECAS_DIA: isNaN(parseInt(item.PECAS_DIA)) ? 0 : parseInt(item.PECAS_DIA),
          DATA_PREV: pegaValor(`#Data_Prev${index}`),
          DATA_SAIDA: pegaValor(`#Data_Saida${index}`),
          DIAS: isNaN(parseInt(item.DIAS)) ? 0 : parseInt(item.DIAS),
          ORDEM: isNaN(parseInt(item.ORDEM)) ? 0 : parseInt(item.ORDEM),
          SABADO_UTIL: $(`#Sabado_Util${index}`).prop('checked') ? 'S' : 'N',
          DOMINGO_UTIL: $(`#Domingo_Util${index}`).prop('checked') ? 'S' : 'N',
          DIA_NEUTRO: $(`#Dia_Neutro${index}`).prop('checked') ? 'S' : 'N',
          PROD_PARALELO: $(`#Prod_Paralelo${index}`).prop('checked') ? 'S' : 'N',
          FACCAO: pegaValor(`#Faccao${index}`),
          QTDE: isNaN(parseInt($(`#Qtde${index}`).val())) ? 0 : parseInt($(`#Qtde${index}`).val()),
          DIAS_ORIG: isNaN(parseInt(item.DIAS_ORIG)) ? 0 : parseInt(item.DIAS_ORIG),
          OBS: pegaValor(`#Obs${index}`)
        });
      })
    } else {
      $('#tabelaAgendamento').DataTable().data().toArray().forEach((item, index) => {
        retorno.push({
          sel: $(`#SEL${index}`).prop('checked') ? 'S' : 'N',
          parte: item.PARTE,
          setor: item.SETOR,
          descricao: item.DESCRICAO,
          pecas_Dia: isNaN(parseInt(item.PECAS_DIA)) ? 0 : parseInt(item.PECAS_DIA),
          data_Prev: pegaValor(`#Data_Prev${index}`),
          data_Saida: pegaValor(`#Data_Saida${index}`),
          data_Inf: '',
          dias: isNaN(parseInt(item.DIAS)) ? 0 : parseInt(item.DIAS),
          ordem: isNaN(parseInt(item.ORDEM)) ? 0 : parseInt(item.ORDEM),
          sabado_Util: $(`#Sabado_Util${index}`).prop('checked') ? 'S' : 'N',
          domingo_Util: $(`#Domingo_Util${index}`).prop('checked') ? 'S' : 'N',
          dia_Neutro: $(`#Dia_Neutro${index}`).prop('checked') ? 'S' : 'N',
          prod_Paralelo: $(`#Prod_Paralelo${index}`).prop('checked') ? 'S' : 'N',
          faccao: bChaveFaccao ? pegaChave(`#Faccao${index}`) : pegaValor(`#Faccao${index}`),
          qtde: isNaN(parseInt($(`#Qtde${index}`).val())) ? 0 : parseInt($(`#Qtde${index}`).val()),
          dias_Orig: isNaN(parseInt(item.DIAS_ORIG)) ? 0 : parseInt(item.DIAS_ORIG),
          obs: pegaValor(`#Obs${index}`)
        });
      })
    }

    return retorno;
  }

  async function calculaAgendamento() {
    $.LoadingOverlay('show');
    try {
      const url = `/sisplan/cadof/v1/calculaagendamento?`;
      const tabela = retornaArrayObjetoAgendamento();
      const params = `JSON=${JSON.stringify(tabela)}&CODIGO=${pegaChave('#txtProduto')}&DATA_DESPACHO=${formataDataBonita(pegaValor('#txtDataDespacho'))}`;
      const response = await requisicao("POST", url, "", params, null);
      const jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return
      }
      criaTabelaAgendamento(jsonStr);
    } catch (error) {
      console.log('Erro na função calculaAgendamento ' + error)
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function BuscaFaccaoAgendamento() {
    $.LoadingOverlay('show');
    try {
      const url = `/sisplan/cadof/v1/buscafaccaoagendamento?`;
      const tabela = retornaArrayObjetoAgendamento();
      const params = `JSON=${JSON.stringify(tabela)}&CODIGO=${pegaChave('#txtProduto')}`;
      const response = await requisicao("POST", url, "", params, null);
      const jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return
      }
      criaTabelaAgendamento(jsonStr);
    } catch (error) {
      console.log('Erro na função calculaAgendamento ' + error)
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function buscaTipoProduto() {
    const pesquisa = {
      camposSelect: ['PRODUTO.TIPO', 'CAD_TIPO_PROD.DESCRICAO'],
      tabela: 'PRODUTO',
      leftJoin: [{ tabela: 'CAD_TIPO_PROD', condicao: 'CAD_TIPO_PROD.CODIGO = PRODUTO.TIPO' }],
      where: [`PRODUTO.CODIGO = '${pegaChave('#txtProduto')}'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
    if (jsonStr.TIPO != '') {
      insereValor('#txtTipoProduto', jsonStr[0].TIPO, jsonStr[0].DESCRICAO);
    }
  }

  async function confirmarAgendamento() {
    $.LoadingOverlay('show');
    try {
      const url = `/sisplan/cadof/v1/agendamento?`;
      let tabela = retornaArrayObjetoAgendamento(false, false);
      CriaTabelaFluxo(tabela);
      tabela = retornaArrayObjetoAgendamento(false);
      const OF1 = {
        Data_Cad: pegaValor('#txtDtCadastro'),
        Periodo: pegaChave('#txtTabPrazo'),
        Numero: pegaValor('#txtNumeroOrdem'),
        Parte: retornaParteSelecionada(),
        Programacao: pegaValor('#txtProgramacao'),
        Maquina: pegaChave('#txtMaquina'),
        Id_Tipo: pegaChave('#txtTipo'),
        Codigo: pegaChave('#txtProduto'),
        Dt_Inicio: pegaValor('#txtDtInicio'),
        Dt_Final: pegaValor('#txtDtFim'),
        Deposito: pegaChave('#txtDeposito'),
        Observacao: pegaValor('#txtObs'),
        LancaFaccao: $('#chkFaccao').prop('checked') ? 'S' : 'N',
        DescFinalSemana: $('#chkDescFinalSemana').prop('checked') ? 'S' : 'N',
        Fluxo: pegaChave('#txtFluxo'),
        TbFluxo: tabela,
      }
      const response = await requisicao("POST", url, "", JSON.stringify(OF1), null);
      const jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return
      }
      $('#modal-agendamento').modal('hide');
    } catch (error) {
      console.log('Erro na função confirmarAgendamento ' + error)
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function excluiAgendamento() {
    $.LoadingOverlay('show');
    try {
      const url = `/sisplan/cadof/v1/agendamento?`;
      tabela = retornaArrayObjetoAgendamento(false);
      const OF1 = {
        Data_Cad: pegaValor('#txtDtCadastro'),
        Periodo: pegaChave('#txtTabPrazo'),
        Numero: pegaValor('#txtNumeroOrdem'),
        Parte: retornaParteSelecionada(),
        Programacao: pegaValor('#txtProgramacao'),
        Maquina: pegaChave('#txtMaquina'),
        Id_Tipo: pegaChave('#txtTipo'),
        Codigo: pegaChave('#txtProduto'),
        Dt_Inicio: pegaValor('#txtDtInicio'),
        Dt_Final: pegaValor('#txtDtFim'),
        Deposito: pegaChave('#txtDeposito'),
        Observacao: pegaValor('#txtObs'),
        LancaFaccao: $('#chkFaccao').prop('checked') ? 'S' : 'N',
        DescFinalSemana: $('#chkDescFinalSemana').prop('checked') ? 'S' : 'N',
        Fluxo: pegaChave('#txtFluxo'),
        TbFluxo: tabela,
      }
      const response = await requisicao("PUT", url, "", JSON.stringify(OF1), null); //necessário ser put para poder passar o body
      const jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return
      }
      $('#modal-agendamento').modal('hide');
    } catch (error) {
      console.log('Erro na função excluiAgendamento ' + error)
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function bloqueiaCamposQtde() {
    $('.camposInteiro').toArray().forEach((e) => {
      $(e).prop('disabled', true);
    })
  }

  async function carregaValoresPadroesCadOF() {
    const jsonStr = await buscaValoresPadroes('CADOF')

    jsonStr.map(async item => {
      switch (item.CAMPO) {
        case 'DEPOSITO': {
          insereValor('#txtDeposito', item.VALOR, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'PERIODO': {
          insereValor('#txtTabPrazo', item.VALOR, { tabela: 'TABPRZ', campoBusca: 'DESCRICAO', campoWhere: 'PRAZO', valorWhere: item.VALOR });
          break;
        }
        case 'TIPO': {
          insereValor('#txtTipo', item.VALOR, { tabela: 'TIPO', campoBusca: 'DESCRICAO', campoWhere: 'ID', valorWhere: item.VALOR });
          break;
        }
        default: break;
      }
    });
  };
});