/* eslint-disable prefer-rest-params */
let estaNoTutorial = false;
$('#tutorial').on('click', function () {
    estaNoTutorial = true;
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
            onNext: (Element) => {
                if ((Element.node.id == 'avancar1')) {
                    avancarPag();
                    $('#avancar1').trigger('click');
                };
                if ((Element.node.id == 'avancar2')) {
                    $('#avancar2').trigger('click');
                }
            },
            onPrevious: (Element) => {
                if (Element.node.id == 'tourEmpresas') {
                    $('#voltar').trigger('click');
                };
                if (Element.node.id == 'tourGuias') {
                    $('#voltar2').trigger('click');
                }
            }
        });

        driver.defineSteps([{
            element: '#formcard1',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtDesc',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtCpf',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtDiaPagto',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#avancar1',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para ir para a próxima aba.',
                position: 'left'
            }
        },
        {
            element: '#tourEmpresas',
            popover: {
                title: 'Empresas Disponíveis',
                description: 'Aqui estão as empresas do representante.',
                position: 'top'
            }
        },
        {
            element: '#avancar2',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para ir para a próxima aba.',
                position: 'left'
            }
        },
        {
            element: '#tourGuias',
            popover: {
                title: 'Dados de Alteração',
                description: 'Aqui estão os guias que este representate pode ter.',
                position: 'top'
            }
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar os dados do Representante.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    const queryString = window.location.href;
    const parametros = queryString.split("/");
    const chaveCadastro = parametros[parametros.length - 1];
    const habilitaCampoMaterial = await CopiaParametro('PEDIDO', 19) == 1;

    addPesquisas()

    if (habilitaCampoMaterial) {
        $('#divMaterialGeral').removeClass('d-none')
        $('#divGrupoMaterialGeral').removeClass('d-none')
    }

    $('.2casasDecimais').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('.3casasDecimais').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 3
    });

    $('.4casasDecimais').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 4
    });

    async function buscaDadosCadastro(id) {
        const response = await requisicao("GET", `/sisplan/cadcaracteristica/V1/buscadadoscadastro?`, `&ID=${id}`, '', 30000)

        if (!response) {
            return
        }

        const json = await response.json()
        if (response.status != 200) {
            msgErro(json.mensagem)
            return
        }

        const capa = JSON.parse(json.capa)
        const consumos = JSON.parse(json.consumos)
        const tecidos = JSON.parse(json.tecidos)
        const { caracteristicas } = json
        const subcaracteristicas = JSON.parse(caracteristicas.subcaracteristicas)

        if (subcaracteristicas.length > 0) {
            preencheCampos(subcaracteristicas, id)
        }

        const aplicacoesCaracteristicas = JSON.parse(caracteristicas.aplicacoes)
        const consumosCaracteristicas = JSON.parse(caracteristicas.consumos)
        const { fluxos } = json
        const fluxosFluxos = JSON.parse(fluxos.fluxos)
        const setoresFluxos = JSON.parse(fluxos.setores)
        const tpVenda = JSON.parse(json.tpVenda)

        preencheDadosCapa(capa[0] || {})
        criaTabelaConsumos(consumos)
        criaTabelaTecidos(tecidos)
        criaTabelaSubcaracteristicas(subcaracteristicas)
        criaTabelaAplicacoesCaracteristicas(aplicacoesCaracteristicas)
        criaTabelaConsumosCaracteristicas(consumosCaracteristicas)
        criaTabelaFluxos(fluxosFluxos)
        criaTabelaSetores(setoresFluxos)
        criaTabelaTpVenda(tpVenda)

        preencheSelectSubstituirConsumosCaracteristica()
    }

    async function preencheCampos(subcaracteristicas, id) {
        for (let i = 0; i<subcaracteristicas.length; i++) {
            subcaracteristicas[i].ARQUIVO_MOCKUP = subcaracteristicas[i].MOCKUP ? await buscarMockup(`${id}-${String(subcaracteristicas[i].ORDEM)}.svg`) : ''
            subcaracteristicas[i].SUBSTITUI_MOCKUP = subcaracteristicas[i].PARTE_MOCKUP ? 'S' : 'N'
        }
        return subcaracteristicas
    }

    function preencheDadosCapa(data) {
        if (habilitaCampoMaterial) insereValor('#txtMaterialGeral', data.MATERIAL, data.DESC_MATERIAL)
        if (habilitaCampoMaterial) insereValor('#txtGrupoMaterialGeral', data.GRUPO_MA, data.DESC_GRUPO_MA)
        insereValor('#txtIdGeral', data.ID)
        insereValor('#txtLinhaGeral', data.LINHA, data.DESC_LINHA)
        insereValor('#txtGrupoGeral', data.GRUPO, data.DESC_GRUPO)
        insereValor('#txtEtiquetaGeral', data.ETIQUETA, data.DESC_ETIQUETA)
        insereValor('#txtFaixaGeral', data.FAIXA, data.DESC_FAIXA)
        insereValor('#txtMarkupGeral', data.MARKUP, data.DESC_MARKUP)
        insereValor('#txtNCMGeral', data.NCM, data.DESC_CODFIS)
        insereValor('#txtDescricaoGeral', data.DESCRICAO)
        insereValor('#txtTempoCosturaGeral', data.TEMPO_COST)
        insereValor('#txtValorCosturaGeral', data.VALOR_COST)
        insereValor('#txtValorLinhaGeral', data.VALOR_LINHA)
        insereValor('#txtMExtraGeral', data.MARGEM)
        insereValor('#txtViradaGeral', data.VIRADA)
        $('#cbAtivoGeral').prop('checked', data.ATIVO === 'S')
        insereValor('#txtColecaoGeral', data.COLECAO, data.DESC_COLECAO)
        $('#txtArquivoImportar').val(data.MOCKUP)
    }

    $('.consumoControl').prop('disabled', true)
    $('.tecidoControl').prop('disabled', true)
    $('.caracteristicaControl').prop('disabled', true)
    $('.aplicacoesCaracteristicaControl').prop('disabled', true)
    $('.consumosCaracteristicaControl').prop('disabled', true)
    $('.fluxoControl').prop('disabled', true)

    $('#txtLinhaGeral, #txtGrupoGeral, #txtEtiquetaGeral').on('blur', async function () {
        const linha = pegaChave('#txtLinhaGeral')
        const grupo = pegaChave('#txtGrupoGeral')
        const etiqueta = pegaChave('#txtEtiquetaGeral')

        if (linha == '' || grupo == '' || etiqueta == '') {
            return
        }

        $.LoadingOverlay('show')
        try {
            if (await Existe('CARACT', ['COD_LINHA', 'COD_GRUPO', 'COD_ETQ'], [linha, grupo, etiqueta])) {
                await criaMensagemAlerta(`Já existe uma característica cadastrada com o Grupo, Linha e Etiqueta informados.\nImpossivel cadastrar novamente com estes dados!`, () => {
                    $('#txtEtiquetaGeral').val('')
                    $('#txtEtiquetaGeral').focus()
                })
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    // consumos
    $("#tabelaConsumos").on("click", "#btnAlterar", async function () {
        $($(this).closest('tr')).addClass('selected')
        const data = $("#tabelaConsumos").DataTable().row($(this).parents("tr")).data()
        insereValoresEdicaoConsumo(data)
        habilitaEdicaoConsumo()
    })

    $("#tabelaConsumos").on("click", "#btnExcluir", async function () {
        $("#tabelaConsumos").DataTable().row($(this).parents("tr")).remove().draw(false)
        preencheSelectSubstituirConsumosCaracteristica()
    })

    $('#btnIncluirConsumo').on('click', function () {
        habilitaEdicaoConsumo()
    })

    $('#btnDesistirConsumo').on('click', function () {
        desabilitaEdicaoConsumo()
    })
    $('#btnConfirmarConsumo').on('click', function () {
        const data = {
            QTDE: $('#txtQuantidadeConsumo').val(),
            CUSTO: $('#txtCustoUniConsumo').val(),
            CODIGO: pegaChave('#txtMaterialConsumo'),
            DESCRICAO: pegaDescricao('#txtMaterialConsumo'),
            ATIVO: $('#cbAtivoConsumo').prop('checked') ? 'S' : 'N',
            SETOR: pegaChave('#txtSetorConsumo'),
            DESC_SETOR: pegaDescricao('#txtSetorConsumo'),
            COR: pegaChave('#txtCorConsumo'),
            DESC_COR: pegaDescricao('#txtCorConsumo'),
            FAIXA: pegaChave('#txtFaixaConsumo'),
            DESC_FAIXA: pegaDescricao('#txtFaixaConsumo'),
            PRECO: $('#cbPrecoConsumo').prop('checked') ? 'S' : 'N',
            TIPO: isChecked('#radioMaterial') ? 'M' : 'P'
        }

        if (!data.CODIGO || data.CODIGO === '') {
            msgErro('Material não informado, impossível continuar.')
            return
        }

        if (!data.COR || data.COR === '') {
            msgErro('Cor não informada, impossível continuar.')
            return
        }

        if (!data.SETOR || data.SETOR === '') {
            msgErro('Setor não informado, impossível continuar.')
            return
        }

        adicionaRegistroConsumo(data)
        preencheSelectSubstituirConsumosCaracteristica()
    })

    $('input[name="tipoItem"]').change(function () {
        pesquisaItemConsumo();
    });

    // tecidos
    $("#tabelaTecidos").on("click", "#btnAlterar", async function () {
        $($(this).closest('tr')).addClass('selected')
        const data = $("#tabelaTecidos").DataTable().row($(this).parents("tr")).data()
        insereValoresEdicaoTecido(data)
        habilitaEdicaoTecido()
    })

    $("#tabelaTecidos").on("click", "#btnExcluir", async function () {
        $("#tabelaTecidos").DataTable().row($(this).parents("tr")).remove().draw(false)
    })

    $('#btnIncluirTecido').on('click', function () {
        habilitaEdicaoTecido()
    })

    $('#btnDesistirTecido').on('click', function () {
        desabilitaEdicaoTecido()
    })

    $('#btnConfirmarTecido').on('click', function () {
        const data = {
            CODIGO: pegaChave('#txtMaterialTecido'),
            DESCRICAO: pegaDescricao('#txtMaterialTecido')
        }

        if (!data.CODIGO || data.CODIGO === '') {
            msgErro('Material não informado, impossível continuar.')
            return
        }

        adicionaRegistroTecido(data)
    })

    // subcaracterísticas
    $("#tabelaSubcaracteristicas").on("click", "#btnAlterar", async function () {
        $($(this).closest('tr')).addClass('selected')
        const data = $("#tabelaSubcaracteristicas").DataTable().row($(this).parents("tr")).data()
        insereValoresEdicaoSubcaracteristica(data)
        habilitaEdicaoSubcaracteristica()
        filtraAplicacoesSubcaracteristicas(data)
        filtraConsumosSubcaracteristicas(data)
        $('#txtAplicacaoSubcaracteristica').prop('disabled', true)
        $('#btnAplicacaoSubcaracteristica').prop('disabled', true)
        $('#btnLimpaAplicacaoSubcaracteristica').prop('disabled', true)
        $('#txtCaracteristicaSubcaracteristica').prop('disabled', true)
        $('#btnCaracteristicaSubcaracteristica').prop('disabled', true)
        $('#btnLimpaCaracteristicaSubcaracteristica').prop('disabled', true)
    })

    $('#btnLimpaArquivo').on('click', function () {
        $('#txtArquivoImportar').val('')
        $('#mdModalUpload').val('')
        $('#btnLimpaArquivoParte').trigger('click') /* PARA LIMPAR OS DOIS CAMPOS */
    })

    $('#btnLimpaArquivoParte').on('click', function () {
        $('#txtArquivoImportarParte').val('')
        $('#mdModalUploadParte').val('')
    })

    $("#mockupHelp-1").prop("title", "Aqui você vai vincular o mockup principal da peça com base nos dados informados: linha, grupo e etiqueta.\nEle será usado como base para fazer as edições no orçamento com a SIA 🤖.")
    $("#mockupHelp-2").prop("title", "Aqui você vai vincular somente o mockup da parte que está fazendo o vínculo,\nou seja, manga, gola, corpo, etc.\nSerá substituído do mockup principal do produto na edição do\norçamento com a SIA 🤖.")
    $("#partHelp").prop("title", "Aqui você vai informar quais partes do mockup serão substituídas na edição de\nimagem do orçamento com a SIA 🤖, sempre separadas por um ponto e vírgula (;).")

    $("#tabelaSubcaracteristicas").on("click", "#btnTestar", async function () {
        if ($('#txtIdGeral').val() === '') return msgAlerta("Para realizar um teste é necessário gravar e entrar em modo alteração.")
        if ($('#txtArquivoImportar').val() !== '') {
            const data = $("#tabelaSubcaracteristicas").DataTable().row($(this).parents("tr")).data()

            $($(this).closest('tr')).addClass('selected')
            $('#modalTestar').modal('show')

            let parts = '';
            const partsInput = data.PARTE_MOCKUP.split(';')

            for (let i = 0; i < partsInput.length; i++) {
                parts += `<span class="cardPart ml-1">${partsInput[i]}</span>`
            }
            
            $("#parts").html(parts)
        } else {
            msgAlerta('Para realizar o teste é necessário vincular um mockup principal na aba "Dados Gerais".')
        }
    })

    $('#txtCorTeste').on('blur',async function () {
        const RGBSearch = await retornaRGB(pegaChave(this))
        const RGBColor = RGBSearch === '000000' ? '000000000' : RGBSearch

        if ((RGBColor === '000000000' && RGBSearch !== '000000') || RGBColor === '255255255') {
            const message = RGBColor === '000000000' 
                ? `A cor selecionada possui os valores RGB R:000, G:000, B:000, resultando na cor: Preto. Deseja continuar?` 
                : `A cor selecionada possui os valores RGB R:255, G:255, B:255, resultando na cor: Branco. Pode ser que a alteração não fique visível. Deseja continuar?`
            await msgAguardaConfirmacao(
                message, 
                ()=>{previewRGB(RGBColor)},
                ()=>{$(this).val('')}
            )
        } else {
            previewRGB(RGBColor)
        }
    })

    function previewRGB(rgb) {
        const RGB = `rgb(${rgb.substr(0,3)},${rgb.substr(3,3)},${rgb.substr(6,3)})`
        $('#colorPreview').css('background-color',RGB)
        $('#colorPreview').prop('title',`R:${rgb.substr(0,3)} G:${rgb.substr(3,3)} B:${rgb.substr(6,3)}`)
    }

    $("#tabelaSubcaracteristicas").on("click", "#btnExcluir", async function () {
        excluiSubcaracteristica($("#tabelaSubcaracteristicas").DataTable().row($(this).parents("tr")))
    })

    $('#btnIncluirSubcaracteristica').on('click', function () {
        $("#tabelaSubcaracteristicas tr").removeClass("selected")
        habilitaEdicaoSubcaracteristica()
        filtraAplicacoesSubcaracteristicas({ COD_APL: '', OPCIONAL: '' })
        filtraConsumosSubcaracteristicas({ COD_APL: '', OPCIONAL: '' })
    })

    $('#btnDesistirSubcaracteristica').on('click', function () {
        const aplicacoesData = JSON.parse(localStorage.getItem('aplicacoesSubcaracteristicas'))
        const consumosData = JSON.parse(localStorage.getItem('consumosSubcaracteristicas'))
        criaTabelaAplicacoesCaracteristicas(aplicacoesData)
        criaTabelaConsumosCaracteristicas(consumosData)
        desabilitaEdicaoSubcaracteristica()
    })

    $('#btnConfirmarSubcaracteristica').on('click', async function () {
        if ($('#txtArquivoImportarParte').val() !== '') 
            var ARQUIVO_MOCKUP = await buscaArquivoParte()

        const data = {
            COD_APL: pegaChave('#txtAplicacaoSubcaracteristica'),
            DESC_APL: pegaDescricao('#txtAplicacaoSubcaracteristica'),
            OPCIONAL: pegaChave('#txtCaracteristicaSubcaracteristica'),
            DESC_OPCIONAL: pegaDescricao('#txtCaracteristicaSubcaracteristica'),
            VALOR_VENDA: $('#txtValorVendaSubcaracteristica').val(),
            ATIVO: $('#cbAtivoSubcaracteristica').prop('checked') ? 'S' : 'N',
            IMP_NFE: $('#cbImprimeNFeSubcaracteristica').prop('checked') ? 'S' : 'N',
            TEMPO_ADC_COST: $('#txtTempoAdcCosturaSubcaracteristica').val(),
            PADRAO: $('#cbPadraoSubcaracteristica').prop('checked') ? 'S' : 'N',
            PARTE_MOCKUP: $('#txtParteMockup').val(),
            MOCKUP: $('#txtArquivoImportarParte').val(),
            ARQUIVO_MOCKUP: ARQUIVO_MOCKUP?.arquivo ?? null,
            SUBSTITUI_MOCKUP: $('#txtParteMockup').val() !== '' ? 'S' : 'N',
        }

        if (!data.COD_APL || data.COD_APL === '') {
            msgErro('Aplicação não informada, impossível continuar.')
            return
        }

        if (!data.OPCIONAL || data.OPCIONAL === '') {
            msgErro('Subcaracterística não informada, impossível continuar.')
            return
        }

        adicionaRegistroSubcaracteristica(data)
    })

    // aplicações características
    $("#tabelaAplicacoesCaracteristicas").on("click", "#btnAlterar", async function () {
        $($(this).closest('tr')).addClass('selected')
        const data = $("#tabelaAplicacoesCaracteristicas").DataTable().row($(this).parents("tr")).data()
        insereValoresEdicaoAplicacoesCaracteristica(data)
        habilitaEdicaoAplicacoesCaracteristica()
    })

    $("#tabelaAplicacoesCaracteristicas").on("click", "#btnExcluir", async function () {
        $("#tabelaAplicacoesCaracteristicas").DataTable().row($(this).parents("tr")).remove().draw(false)
    })

    $('#btnIncluirAplicacoesCaracteristica').on('click', function () {
        $("#tabelaAplicacoesCaracteristicas tr").removeClass("selected")
        habilitaEdicaoAplicacoesCaracteristica()
    })

    $('#btnDesistirAplicacoesCaracteristica').on('click', function () {
        desabilitaEdicaoAplicacoesCaracteristica()
    })

    $('#btnConfirmarAplicacoesCaracteristica').on('click', function () {
        const data = {
            COD_APL: pegaChave('#txtAplicacaoSubcaracteristica'),
            DESCRICAO: pegaDescricao('#txtAplicacaoSubcaracteristica'),
            QTDE: $('#txtQuantidadeAplicacoesCaracteristica').val(),
            QTDE_TECIDO: $('#txtQuantidadeTecidoAplicacoesCaracteristica').val(),
            SUBSTITUIR_CORTE: $('#cbSubstituirAplicacoesCaracteristica').prop('checked') ? 'S' : 'N',
            SUBCARACTERISTICA: pegaChave('#txtCaracteristicaSubcaracteristica'),
            TECIDO_FIXO: pegaChave('#txtTecidoFixoAplicacoesCaracteristica'),
            DESC_TECIDO: pegaDescricao('#txtTecidoFixoAplicacoesCaracteristica')
        }

        if (!data.COD_APL || data.COD_APL === '') {
            msgErro('Aplicação não informada, impossível continuar.')
            return
        }

        if (!data.SUBCARACTERISTICA || data.SUBCARACTERISTICA === '') {
            msgErro('Subcaracterística não informada, impossível continuar.')
            return
        }

        if (!data.TECIDO_FIXO || data.TECIDO_FIXO === '') {
            msgErro('Tecido não informado, impossível continuar.')
            return
        }

        adicionaRegistroAplicacoesCaracteristica(data)
    })

    // consumos características
    $("#tabelaConsumosCaracteristicas").on("click", "#btnAlterar", async function () {
        $($(this).closest('tr')).addClass('selected')
        const data = $("#tabelaConsumosCaracteristicas").DataTable().row($(this).parents("tr")).data()
        insereValoresEdicaoConsumosCaracteristica(data)
        habilitaEdicaoConsumosCaracteristica()
    })

    $("#tabelaConsumosCaracteristicas").on("click", "#btnExcluir", async function () {
        $("#tabelaConsumosCaracteristicas").DataTable().row($(this).parents("tr")).remove().draw(false)
    })

    $('#btnIncluirConsumosCaracteristica').on('click', function () {
        $("#tabelaConsumosCaracteristicas tr").removeClass("selected")
        habilitaEdicaoConsumosCaracteristica()
    })

    $('#btnDesistirConsumosCaracteristica').on('click', function () {
        desabilitaEdicaoConsumosCaracteristica()
    })

    $('#btnConfirmarConsumosCaracteristica').on('click', function () {
        const data = {
            COD_SUB: pegaChave('#txtCaracteristicaSubcaracteristica'),
            COD_APL: pegaChave('#txtAplicacaoSubcaracteristica'),
            COD_MAT: pegaChave('#txtMaterialConsumosCaracteristica'),
            DESC_MAT: pegaDescricao('#txtMaterialConsumosCaracteristica'),
            COD_COR: pegaChave('#txtCorConsumosCaracteristica'),
            DESC_COR: pegaDescricao('#txtCorConsumosCaracteristica'),
            QTDE: $('#txtQuantidadeConsumosCaracteristica').val(),
            CUSTO: $('#txtCustoUniFixoConsumosCaracteristica').val(),
            SETOR: pegaChave('#txtSetorConsumosCaracteristica'),
            DESC_SETOR: pegaDescricao('#txtSetorConsumosCaracteristica'),
            FAIXA: pegaChave('#txtFaixaConsumosCaracteristica'),
            DESC_FAIXA: pegaDescricao('#txtFaixaConsumosCaracteristica'),
            PRECO: $('#cbPrecoConsumosCaracteristica').prop('checked') ? 'S' : 'N',
            COD_SUBST: String($('#selectSubstituirConsumosCaracteristica option:selected').data('codigo')),
            DESC_SUBST: String($('#selectSubstituirConsumosCaracteristica option:selected').data('descricao')),
            ORDEM_SUBST: $('#selectSubstituirConsumosCaracteristica').val()
        }

        if (!data.COD_APL || data.COD_APL === '') {
            msgErro('Aplicação não informada, impossível continuar.')
            return
        }

        if (!data.COD_SUB || data.COD_SUB === '') {
            msgErro('Subcaracterística não informada, impossível continuar.')
            return
        }

        if (!data.COD_MAT || data.COD_MAT === '') {
            msgErro('Material não informado, impossível continuar.')
            return
        }

        if (!data.COD_COR || data.COD_COR === '') {
            msgErro('Cor não informada, impossível continuar.')
            return
        }

        if (!data.SETOR || data.SETOR === '') {
            msgErro('Setor não informado, impossível continuar.')
            return
        }

        adicionaRegistroConsumosCaracteristica(data)
    })

    // fluxos
    $("#tabelaFluxos").on("click", "#btnAlterar", async function () {
        $($(this).closest('tr')).addClass('selected')
        const data = $("#tabelaFluxos").DataTable().row($(this).parents("tr")).data()
        insereValoresEdicaoFluxo(data)
        habilitaEdicaoFluxo()
    })

    $("#tabelaFluxos").on("click", "#btnExcluir", async function () {
        excluiFluxo($("#tabelaFluxos").DataTable().row($(this).parents("tr")))
    })

    $('#btnIncluirFluxo').on('click', function () {
        $("#tabelaFluxos tr").removeClass("selected")
        filtraSetoresFluxo({ COD_FLUXO: ' ', COD_PARTE: ' ' })
        habilitaEdicaoFluxo()
    })

    $('#btnDesistirFluxo').on('click', function () {
        desabilitaEdicaoFluxo()
    })

    $('#btnConfirmarFluxo').on('click', async function () {
        const data = {
            COD_FLUXO: pegaChave('#txtFluxoFluxo'),
            DESC_FLUXO: pegaDescricao('#txtFluxoFluxo'),
            COD_PARTE: pegaChave('#txtParteFluxo'),
            DESC_PARTE: pegaDescricao('#txtParteFluxo'),
        }

        if (!data.COD_PARTE || data.COD_PARTE === '') {
            msgErro('Parte não informada, impossível continuar.')
            return
        }

        if (!data.COD_FLUXO || data.COD_FLUXO === '') {
            msgErro('Fluxo não informada, impossível continuar.')
            return
        }

        await adicionaRegistroFluxo(data)
    })

    await buscaDadosCadastro(chaveCadastro)

    if (chaveCadastro == 'create') {
        await carregaValoresPadroes()
    }

    $('#btnVoltar').on('click', function () {
        window.location.href = `${BASE_URI}/cadcaracteristica`;
    })

    $('#btnGravar').on('click', async function () {
        if ($('.addButton').filter('.d-none').length > 0) {
            msgErro('Existem registros em alteração, impossível continuar. Confirme ou desista das alterações e tente novamente.')
            return
        }
        msgAlerta('Deseja realmente gravar os dados?',
            () => { },
            () => { },
            async () => {
                const objCaracteristica = await retornaDadosGravar()
                const { capa, subcaracteristicas } = objCaracteristica

                if (!capa.linha || capa.linha === '') {
                    msgErro('Linha não informada, impossível continuar.')
                    return
                }

                if (!capa.grupo || capa.grupo === '') {
                    msgErro('Grupo não informado, impossível continuar.')
                    return
                }

                if (!capa.etiqueta || capa.etiqueta === '') {
                    msgErro('Etiqueta não informada, impossível continuar.')
                    return
                }

                // if (!capa.faixa || capa.faixa === '') {
                //     msgErro('Faixa não informada, impossível continuar.')
                //     return
                // }

                if (!subcaracteristicas || subcaracteristicas.length === 0) {
                    msgErro('Nenhuma característica informada, impossível continuar.')
                    return
                }

                await gravaDados(objCaracteristica)
            }
        )
    })

    async function retornaDadosGravar() {
        if ($('#txtArquivoImportar').val() !== '' && $('#txtIdGeral') !== '')
            var MOCKUP_CAPA = await buscaArquivoPrincipal()

        const capa = {
            id: $('#txtIdGeral').val() && $('#txtIdGeral').val() !== '' ? parseInt($('#txtIdGeral').val()) : 0,
            material: pegaChave('#txtMaterialGeral'),
            linha: pegaChave('#txtLinhaGeral'),
            grupo: pegaChave('#txtGrupoGeral'),
            etiqueta: pegaChave('#txtEtiquetaGeral'),
            faixa: pegaChave('#txtFaixaGeral'),
            markup: pegaChave('#txtMarkupGeral'),
            ncm: pegaChave('#txtNCMGeral'),
            descricao: $('#txtDescricaoGeral').val(),
            tempo_cost: $('#txtTempoCosturaGeral').val(),
            valor_cost: $('#txtValorCosturaGeral').val(),
            valor_linha: $('#txtValorLinhaGeral').val(),
            margem: $('#txtMExtraGeral').val(),
            virada: $('#txtViradaGeral').val(),
            ativo: $('#cbAtivoGeral').prop('checked') ? 'S' : 'N',
            grupo_material: pegaChave('#txtGrupoMaterialGeral'),
            colecao: pegaChave('#txtColecaoGeral'),
            mockup: MOCKUP_CAPA?.arquivo ?? null,
            nome_arquivo: $('#txtArquivoImportar').val()
        }

        const consumos =
            $('#tabelaConsumos')
                .DataTable()
                .data()
                .toArray()

        const tecidos = $('#tabelaTecidos').DataTable().data().toArray()

        const subcaracteristicas =
            $('#tabelaSubcaracteristicas')
                .DataTable()
                .data()
                .toArray()
                .map(e => {
                    const aplicacoes =
                        $('#tabelaAplicacoesCaracteristicas')
                            .DataTable()
                            .data()
                            .toArray()
                            .filter(d => d.COD_APL === e.COD_APL && d.SUBCARACTERISTICA === e.OPCIONAL)

                    const consumos =
                        $('#tabelaConsumosCaracteristicas')
                            .DataTable()
                            .data()
                            .toArray()
                            .filter(d => d.COD_APL === e.COD_APL && d.COD_SUB === e.OPCIONAL)

                    return {
                        ...e,
                        aplicacoes,
                        consumos
                    }
                })

        const fluxos =
            $('#tabelaFluxos')
                .DataTable()
                .data()
                .toArray()
                .map(e => {
                    const setores =
                        $('#tabelaSetores')
                            .DataTable()
                            .data()
                            .toArray()
                            .filter(d => d.COD_PARTE === e.PARTE && d.COD_FLUXO === e.FLUXO)
                    return {
                        ...e,
                        setores
                    }
                })

        const tpVenda =
            $('#tabelaTpVenda').DataTable().data().toArray()

        return {
            capa,
            consumos,
            tecidos,
            subcaracteristicas,
            fluxos,
            tpVenda
        }
    }

    function validacoesAnexo(mockupPrincipal, mockupCaract) {
        if (!mockupPrincipal && mockupCaract) {
            msgAlerta('Você não pode anexar somente um mockup para característica. Necessário ter um arquivo vinculado nos dados gerais.')
            return false
        } else return true
    }

    async function gravaDados(objCaracteristica) {
        try {
            $.LoadingOverlay('show')

            for (let i = 0; i < objCaracteristica.subcaracteristicas.length; i++) {
                const podeAnexar = validacoesAnexo($('#txtArquivoImportar').val(), objCaracteristica.subcaracteristicas[i].NOME_ARQUIVO)
                if (!podeAnexar) return msgAlerta('Você não pode anexar somente um mockup para característica. Necessário ter um arquivo vinculado nos dados gerais.')
            }

            const response = await requisicao("POST", `/sisplan/cadcaracteristica/V1/gravadados?`, ``, JSON.stringify(objCaracteristica), 600000)

            if (!response) {
                return
            }

            const json = await response.json()
            if (response.status != 200) {
                msgErro(json.mensagem)
                return
            }

            if ($('#txtArquivoImportar').val() !== '') {
                const arquivo = await buscaArquivoPrincipal()
                await anexaArquivo(arquivo, `${json.id}.svg`)

                for (let i = 0; i < objCaracteristica.subcaracteristicas.length; i++) {
                    const objSubcaract = objCaracteristica.subcaracteristicas[i]
                    
                    if (objSubcaract.ARQUIVO_MOCKUP && objSubcaract.MOCKUP) {
                        await anexaArquivo({ 
                                nome_arquivo: objSubcaract.NOME_ARQUIVO, 
                                arquivo: objSubcaract.ARQUIVO_MOCKUP, 
                                tipo: 'image/svg+xml'
                            },
                            `${json.id}-${objSubcaract.ORDEM}.svg`
                        )
                    }
                }
            }

            toastr.success("Dados gravados com sucesso!", "Confirmação", {
                toastClass: "alert",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                    window.location.href = `${BASE_URI}/cadcaracteristica`;
                },
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            })
        } catch (e) {
            console.log(e)
            msgErro('Ocorreu um problema ao gravar os dados, tente novamente.')
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    $('#btnAbrirVendaRegra').on('click', function () {
        $('#modalAdicionarVendaRegra').modal('show');
    });

    function addPesquisas() {
        componenteFiltro('material', false, false, 'MaterialGeral')
        componenteFiltro('grupoMA', false, false, 'GrupoMaterialGeral')
        componenteFiltro('linha', false, false, 'LinhaGeral')
        componenteFiltro('grupo', false, false, 'GrupoGeral')
        componenteFiltro('etiqueta', false, false, 'EtiquetaGeral')
        componenteFiltro('faixa', false, false, 'FaixaGeral', [`ATIVO = 'S'`])
        componenteFiltro('markup', false, false, 'MarkupGeral')
        componenteFiltro('ncm', false, false, 'NCMGeral')
        componenteFiltro('colecao', false, false, 'ColecaoGeral')

        componenteFiltro('material', false, false, 'MaterialConsumo')
        componenteFiltro('cor', false, false, 'CorConsumo')
        componenteFiltro('setor', false, false, 'SetorConsumo')
        componenteFiltro('faixa', false, false, 'FaixaConsumo')

        componenteFiltro('material', false, false, 'MaterialTecido')

        componenteFiltro('aplicacao', false, false, 'AplicacaoSubcaracteristica')
        componenteFiltro('caracteristica', false, false, 'CaracteristicaSubcaracteristica')

        componenteFiltro('material', false, false, 'TecidoFixoAplicacoesCaracteristica')

        componenteFiltro('material', false, false, 'MaterialConsumosCaracteristica')
        componenteFiltro('cor', false, false, 'CorConsumosCaracteristica')
        componenteFiltro('setor', false, false, 'SetorConsumosCaracteristica')
        componenteFiltro('faixa', false, false, 'FaixaConsumosCaracteristica')

        componenteFiltro('parte', false, false, 'ParteFluxo')
        componenteFiltro('fluxo', false, false, 'FluxoFluxo')

        componenteFiltro('cor', false, false, 'CorTeste')

        $('#txtMaterialConsumo').on('focusout', async function () {
            $.LoadingOverlay('show')
            try {
                const codigo = pegaChave('#txtMaterialConsumo');
                if (codigo == '') {
                    return;
                }

                $('#txtCorConsumo').off('autocompleta');
                $('#txtCorConsumo').autocompleta(1, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["MAT_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${codigo}' AND MAT_ITEN.ATIVO = 'S' AND CADCOR.INATIVO = 'N'"] }`, undefined, undefined, undefined);
                $('#btnCorConsumo').off();
                $('#btnCorConsumo').pesquisa_array(['#txtCorConsumo'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "MAT_ITEN.COR", "CADCOR.DESCRICAO" ],"leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${codigo}' AND MAT_ITEN.ATIVO = 'S' AND CADCOR.INATIVO = 'N'"]}`, 'Pesquisa Cor', 'CADCOR');
            } catch (error) {
                console.error(error)
                msgAlerta(error.message)
            } finally {
                $.LoadingOverlay('hide');
                await buscaPrecoMatCor();
            }
        })

        $('#txtEmpresaRegra').autocompleta(1, `JSON={ "tabela":"empresa", "camposSelect":[ "emp_pat chave, emp_nome descricao" ], "where": null}`);
        $('#btnEmpresaRegra').pesquisa('#txtEmpresaRegra', 'EMP_PAT', 'EMP_NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"empresa", "camposSelect":[ "replace(emp_pat,'_','') as EMP_PAT", "emp_nome"]}`, 'Pesquisa Empresa', 'empresa');
        $('#txtEmpresaRegra').change(async function () {
            valor = $('#txtEmpresaRegra').val();
            $('#txtEmpresaRegra').val(valor.replace('_', ''));
        });
        $('#btnAEmpresaRegra').on('click', function () {
            $('#txtEmpresaRegra').val('');
        });

        $('#txtRegra').autocompleta(1, `JSON={ "tabela":"regra", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
        $('#btnRegra').pesquisa('#txtRegra', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regra", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Regra', 'regra');
        $('#btnARegra').on('click', function () {
            $('#txtRegra').val('');
        });

        $('#txtSped').autocompleta(1, `JSON={ "tabela":"TABSPED", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
        $('#btnSped').pesquisa('#txtSped', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABSPED", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Código SPED', 'TABSPED');
        $('#btnASped').on('click', function () {
            $('#txtSped').val('');
        });
    }

    $('#tabelaTpVenda').on('click', '#btnExcluir', async function () {
        $("#tabelaTpVenda").DataTable().row($(this).parents("tr")).remove().draw(false)
    });

    async function carregaValoresPadroes() {
        const objTpVenda = {
            tributacao: '',
            regra: '',
            descRegra: '',
            sped: '',
            tpVenda: '',
        }
        const jsonStr = await buscaValoresPadroes('PRODUTO')

        jsonStr.map(async item => {
            switch (item.CAMPO) {
                case 'TRIBUTACAO': {
                    objTpVenda.tributacao = item.VALOR
                    $('#selectTrib').val(item.VALOR).change();
                    break;
                }
                case 'SPED': {
                    objTpVenda.sped = item.VALOR
                    insereValor('#txtSped', item.VALOR, { tabela: 'TABSPED', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'REGRA': {
                    objTpVenda.regra = item.VALOR
                    insereValor('#txtRegra', item.VALOR, { tabela: 'REGRA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'TIPO_VENDA': {
                    objTpVenda.tpVenda = item.VALOR
                    break;
                }
                case 'COLECAO': {
                    insereValor('#txtColecaoGeral', item.VALOR, { tabela: 'COLECAO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
            }
        });

        if (objTpVenda.tributacao != '' && objTpVenda.sped != '' && objTpVenda.tpVenda != '') {
            await preenhceTpVendaPadrao(objTpVenda)
        }
    };

    $(async function () {
        const modalUploadAnexos = $("#mdModalUpload");
        const Anexo = $('#txtArquivoImportar');
        const BotaoAnexo = $("#btnAddArquivo");
        BotaoAnexo.click(function (event) {
            event.preventDefault()
            modalUploadAnexos.click();
        });

        modalUploadAnexos.change(async function () {
            const value = $(this).val()
            if (value.split('.')[1] === 'svg') {
                const NomeAnexo = $(this).val().split('\\')[$(this).val().split('\\').length - 1];
                Anexo.val(NomeAnexo);
            } else {
                msgAlerta('Necessário informar um arquivo do tipo SVG.')
            }
        });
    });

    $(async function () {
        const modalUploadAnexos = $("#mdModalUploadParte");
        const Anexo = $('#txtArquivoImportarParte');
        const BotaoAnexo = $("#btnAddArquivoParte");
        BotaoAnexo.click(function (event) {
            if ($('#txtArquivoImportar').val() !== '') {
                event.preventDefault()
                modalUploadAnexos.click();
            } else {
                event.preventDefault()
                msgAlerta('Necessário vincular um mockup na aba "Dados Gerais" primeiro.')
            }
        });

        modalUploadAnexos.change(async function () {
            const value = $(this).val()
            if (value.split('.')[1] === 'svg') {
                const NomeAnexo = $(this).val().split('\\')[$(this).val().split('\\').length - 1];
                Anexo.val(NomeAnexo);
            } else {
                msgAlerta('Necessário informar um arquivo do tipo SVG.')
            }
        });
    });

    $('#viewMockup').on('click', async function (event) {
        event.preventDefault()
        await viewMockup($('#mdModalUpload')[0])
    })

    $('#viewMockupParte').on('click', async function (event) {
        event.preventDefault()
        await viewMockup($('#mdModalUploadParte')[0])
    })

    async function viewMockup(input) {
        try {
            if ($("#txtIdGeral").val() !== '' && input.files.length === 0) {
                const file = `${$("#txtIdGeral").val()}.svg`
                const blob = await buscarMockup(file)
                const url = URL.createObjectURL(blob);
                $(".imagepreview").attr('src', url);
            } else {
                if (input.files && input.files.length > 0) {
                    const file = input.files[0];
                    const url = URL.createObjectURL(file);
                    $(".imagepreview").attr('src', url);
                } else {               
                    throw new Error("Necessário selecionar um arquivo primeiro.");
                }
            }

            $('#imagemodal').modal('show');
        } catch (error) {
            msgAlerta(error.message)
        }
    }

    async function buscaArquivoPrincipal() {
        return new Promise((resolve, reject) => {
            const input = document.querySelector('#mdModalUpload');

            if (!input || !input.files || !input.files[0]) {
                reject('Nenhum arquivo encontrado.')
                return;
            }
        
            const file = input.files[0];
            const reader = new FileReader();

            reader.onloadend = function () {
                resolve({
                    nome_arquivo: $('#txtArquivoImportar').val(),
                    arquivo: reader.result,
                    tipo: file.type
                });
            };

            reader.onerror = reject;

            reader.readAsDataURL(file);
        });
    }

    async function buscaArquivoParte() {
        return new Promise((resolve, reject) => {
            const input = document.querySelector('#mdModalUploadParte');

            if (!input || !input.files || !input.files[0]) {
                reject('Nenhum arquivo encontrado.')
                return;
            }

            const file = input.files[0];
            const reader = new FileReader();

            reader.onloadend = function () {
                resolve({
                    nome_arquivo: $('#txtArquivoImportarParte').val(),
                    arquivo: reader.result,
                    tipo: file.type
                });
            };

            reader.onerror = reject;

            reader.readAsDataURL(file);
        });
    }

    async function anexaArquivo(baseString, nomeArquivo) {
        const sArquivo = `${nomeArquivo.split('.')[0]}.${nomeArquivo.split('.')[1]}`
        await anexarMockup(sArquivo, baseString)
    }
})

