$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([
            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para abrir os filtros.',
                    position: 'bottom'
                }
            },
            {
                element: '#txtLimiteNovo',
                popover: {
                    title: 'Campo Limite Novo',
                    description: 'Aqui Informamos o novo limite do cliente.',
                    position: 'left'
                }
            },
            {
                element: '#btnConfirmar',
                popover: {
                    title: 'Botão Confirmar',
                    description: 'Clique aqui para gravar os novos limites selecionados.',
                    position: 'left'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    addPesquisaAutocompleta();

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show')
    })

    $('#btnLimparFiltros').on('click', function () {
        $('#txtCliente').empty().trigger('change')
        $('#txtUsuario').val('')
        $('#txtTabuf').empty().trigger('change')

        $('#txtRendaDe').val('')
        $('#txtRendaAte').val('')
        $('#txtLimiteDe').val('')
        $('#txtLimiteAte').val('')

        preencheUsuarioLogado()
    })

    $('#btnConsultar').on('click', async () => { await buscaDados() });

    async function retornaFiltros() {
        const filtros = `RENDADE=${$('#txtRendaDe').val()}` +
            `&RENDAATE=${$('#txtRendaAte').val()}` +
            `&LIMITEDE=${$('#txtLimiteDe').val()}` +
            `&LIMITEATE=${$('#txtLimiteAte').val()}` +
            `&CODUSUARIO=${pegaChave('#txtUsuario')}` +
            `&CLIENTE=${await formataListas($('#txtCliente').val().toString())}` +
            `&UF=${await formataListas($('#txtTabuf').val().toString())}`;

        return filtros
    }

    async function buscaDados() {
        $.LoadingOverlay('show')
        try {
            if ($('#txtUsuario').val() == '') {
                throw new Error('Usuario não informado!')
            }

            const filtros = await retornaFiltros()
            const url = "/sisplan/atribuilimitecred/v1/atribuilimitecred?";
            const response = await requisicao("GET", url, `${filtros}&EMPRESA=${getCookie("empresa")}`, "", 360000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json()
            if (response.status != 200) {
                throw new Error(jsonStr.mensagem);
            }

            if (jsonStr[0].length <= 0) {
                throw new Error('Nenhum registro encontrado!')
            }

            const tbClientes = jsonStr[0]
            const tbApuracao = jsonStr[1]

            await montaDataTableCliente(tbClientes)
            await montaDataTableApuracao(tbApuracao)

            const limiteMaxUsr = await buscaValorListaWhere('VALIDA_CAMPO', ['VALOR'], ['TIPO', 'USUARIO'], ['1', pegaChave('#txtUsuario')])

            if (limiteMaxUsr) {
                $('#txtLimiteMaxUsuario').val(parseFloat(limiteMaxUsr.VALOR))
            } else {
                $('#txtLimiteMaxUsuario').val(0)
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
            $('#modal-filtros').modal('hide')
        }
    }

    async function montaDataTableCliente(jsonStr) {
        const dataSetCols = [
            {
                data: "SEL",
                title: "Sel"
            },
            {
                data: "CODCLI",
                title: "CodCli"
            },
            {
                data: "NOME",
                title: "Nome"
            },
            {
                data: "RENDA",
                title: "Renda"
            },
            {
                data: "LIMITEANTERIOR",
                title: "Limite Anterior"
            },
            {
                data: "NOTA",
                title: "Nota"
            },
            {
                data: "LIMITECALCULADO",
                title: "Limite Calculado"
            },
            {
                data: "LIMITENOVO",
                title: "Limite Novo"
            },
        ]

        dataSetCols[0].render = function (data, type, row, meta) {
            return '<div class="form-check pl-0">' +
                '<div class="icheck-primary">' +
                `<input style="height:20px" type="checkbox" checked id="check_col_${meta.col}_row_${meta.row}" class="align-self-center campoCheck"><label for="check_col_${meta.col}_row_${meta.row}"></label>` +
                '</div>' +
                '</div>';
        }

        $('#tabelaCliente').DataTable({
            bPaginate: true,
            search: false,
            destroy: true,
            colReorder: true,
            info: false,
            pageLength: 8,
            filter: false,
            lengthMenu: [[8, 10, 25, 50, 100], [8, 10, 25, 50, 100]],
            createdRow: function (row, data, dataIndex) {
                $(row).addClass('linhaAcesso');
            },
            autoWidth: true,
            columns: dataSetCols,
            data: jsonStr,
            columnDefs: [
                {
                    targets: [3, 5],
                    visible: false
                }
            ]
        });
    }

    $('#tabelaCliente').on('click', 'tr', function (e) {
        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
        } else {
            $('#tabelaCliente').DataTable().$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
        }

        const data = $('#tabelaCliente').DataTable().row($(this)).data();

        if (data.CODCLI != '') {
            $('#tabelaApuracao').DataTable().column(0).search(data.CODCLI).draw(false);
        } else {
            $('#tabelaApuracao').DataTable().column(0).search('').draw(false);
        }

        insereValor('#txtClienteConsulta', data.CODCLI, data.NOME)
        $('#txtRendaBruta').val(data.RENDA)
        $('#txtNota').val(data.NOTA)
        $('#txtLimiteAnterior').val(data.LIMITEANTERIOR)
        $('#txtLimiteCalculado').val(data.LIMITECALCULADO)
        $('#txtLimiteNovo').val(data.LIMITENOVO)
        $('#txtRowIndex').val($(this).index())
    });

    async function montaDataTableApuracao(jsonStr) {
        const dataSetCols = [
            {
                data: "CODCLI",
                title: "CodCli"
            },
            {
                data: "CODIGO",
                title: "Código"
            },
            {
                data: "DESCRICAO",
                title: "Descrição"
            },
            {
                data: "FATOR",
                title: "Fator"
            },
            {
                data: "VALORCAMPO",
                title: "Valor Campo"
            },
            {
                data: "VALORINICIAL",
                title: "Valor Inicial"
            },
            {
                data: "VALORFINAL",
                title: "Valor Final"
            },
            {
                data: "PONTOS",
                title: "Pontos"
            },
            {
                data: "NOTA",
                title: "Nota"
            },
            {
                data: "ERRO",
                title: "Erro"
            },
        ]

        $('#tabelaApuracao').DataTable({
            bPaginate: true,
            search: true,
            destroy: true,
            colReorder: true,
            info: false,
            filter: true,
            pageLength: 8,
            lengthMenu: [[8, 10, 25, 50, 100], [8, 10, 25, 50, 100]],
            autoWidth: true,
            columns: dataSetCols,
            data: jsonStr,
            columnDefs: [
                {
                    targets: [0],
                    visible: false
                }
            ]
        });

        $($('#tabelaCliente').DataTable().row(':eq(0)', { page: 'current' }).node()).trigger('click')
    }

    $('#btnConfirmar').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            if ($('#txtLimiteNovo').val() > $('#txtLimiteMaxUsuario').val()) return msgAlerta('Limite Novo é maior do que o limite máximo do usuário. Verifique!')
            await gravaDados();
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    });

    async function gravaDados() {
        let dataTable = $('#tabelaCliente').DataTable();
        let dadosSelecionados = [];

        dataTable.rows().every(function (rowIdx, tableLoop, rowLoop) {
            let data = this.data();
            let $node = $(this.node());
            const checkIsChecked = $($($($node.children()[0]).children()[0]).children()[0]).children('.campoCheck').is(':checked')

            if (checkIsChecked) {
                const obj = {
                    CODCLI: data.CODCLI,
                    LIMITEANTERIOR: data.LIMITEANTERIOR,
                    LIMITENOVO: data.LIMITENOVO,
                    OBS: $('#txtObs').val()
                }
                dadosSelecionados.push(obj);
            }
        });
        console.log(dadosSelecionados);

        const url = "/sisplan/atribuilimitecred/v1/atribuilimitecred?";
        const response = await requisicao('POST', url, null, JSON.stringify({ LIMITECRED: dadosSelecionados }));

        if (!response) {
            $.LoadingOverlay('hide');
            return;
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
            $.LoadingOverlay('hide');
            msgErro(jsonStr.mensagem);
            return;
        }

        criaMensagemSucesso('Limite de crédito alterados com sucesso!', () => { window.location.reload() })
    }

    function preencheUsuarioLogado() {
        const codUsuario = getCookie('cod_usuario');
        const nomeUsuario = getCookie('cod_usuario') == '0000' ? 'SISPLAN' : getCookie('usuario');
        insereValor('#txtUsuario', codUsuario, nomeUsuario);
    }

    $('#txtLimiteNovo').keyup(function (e) {
        if (e.keyCode == 13) {
            $('#txtLimiteNovo').trigger('blur')
        }
    })

    $('#txtLimiteNovo').on('blur', async function () {
        $.LoadingOverlay('show')
        try {
            await rotinaSaidaLimiteNovo($(this).val())

        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function rotinaSaidaLimiteNovo(val) {
        const limiteCalculado = parseFloat($('#txtLimiteCalculado').val())
        const limiteNovo = parseFloat(val)
        const limiteMaxUsr = parseFloat($('#txtLimiteMaxUsuario').val())

        if ((limiteNovo != limiteCalculado) && (limiteNovo > limiteMaxUsr)) {
            $('#txtLimiteNovo').focus()
            throw new Error('Limite novo informado não pode ser maior que o máximo permitido para o usuário.')
        }

        const dadosAtuais = $('#tabelaCliente').DataTable().row(parseInt($('#txtRowIndex').val())).data()

        dadosAtuais.LIMITENOVO = limiteNovo;

        $('#tabelaCliente').DataTable().row(parseInt($('#txtRowIndex').val())).data(dadosAtuais).draw(false)
        $($('.campoCheck')[parseInt($('#txtRowIndex').val())]).prop('checked', true)
    }

    retornaHintRelatorio('btnImprimir', 'RelAtribuiLimiteCred')

    $('#btnImprimir').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                const url = `/sisplan/impressao/v1/imprimiratribuilimitecred?`;
                const filtros = await retornaFiltros();
                const ordem = `&TELA_ORDENACAO=RelAtribuiLimiteCred&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelAtribuiLimiteCred');
                const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelAtribuiLimiteCred');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    function addPesquisaAutocompleta() {
        componenteFiltro('cliente', true)
        componenteFiltro('tabuf', true)

        $("#txtUsuario").autocompleta(1, `JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "CODIGO chave", "NOME descricao"], "where": null}`);
        $("#btnUsuario").pesquisa("#txtUsuario", "CODIGO", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "CODIGO", "NOME"]}`, "Pesquisa Usuário", "CAIXA_LOJA");
        $("#btnLimpaUsuario").on("click", function () {
            $("#txtUsuario").val("");
        });

        $('.inputValor').maskMoney({
            decimal: '.',
            thousands: '',
            precision: 2
        });

        preencheUsuarioLogado()
    }
});