$(document).ready(async function () {
  
  $('#txtBloqRet').autocompleta(1, `JSON={ "tabela":"PED_REGRAS", "camposSelect":[ "CODIGO CHAVE", "REGRA DESCRICAO"], "where": ["TIPO = 'M'"]}`);  
  $('#btnBloqRet').pesquisa('#txtBloqRet', 'CODIGO', 'REGRA', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PED_REGRAS", "camposSelect":[ "CODIGO", "REGRA" ], "where": ["TIPO = 'M'"]}`, 'Pesquisa Regra de Pedido', 'PED_REGRA');  
  $("#btnLimpaBloqRet").on("click", function () {
    $("#txtBloqRet").val("");        
  })

  $("#btnConfirmarBloqueio").on("click", async function () {
    $.LoadingOverlay("show");
    try {
      await incluirBloqueio();
      $("#txtBloqRet").val("");
      $("#modalIncluirBloqueio").modal("hide");
      criaMensagemSucesso("Bloqueio incluído com sucesso.");
    } catch (error) {
        console.error(error);
        msgAlerta(error.message);
    } finally {
        $.LoadingOverlay("hide");        
    }
  })

  async function incluirBloqueio() {
    const codigoBloqueio = pegaChave("#txtBloqRet");

    if (codigoBloqueio == "") {
      throw new Error("Necessário inserir um bloqueio.");
    }

    const registro = $("#tabelaPedido").DataTable().row($(".selecionado").closest("tr")).data();
    const IDUsuario = getCookie("id_usuario");
    const tela = $("#modalIncluirBloqueio").prop("tela");
    const params = `NUMERO_PEDIDO=${registro.NUMERO}`+
                   `&ID_PEDIDO=${registro.ID}`+
                   `&ID_USUARIO=${IDUsuario}`+
                   `&CODIGO_BLOQUEIO=${codigoBloqueio}`+
                   `&TELA=${tela}`;

    const response = await requisicao('POST', '/sisplan/pedido/v1/incluirbloqueio?', params, "", 120000);

    if (!response) {
      throw new Error("Não foi possível gravar o bloqueio.");
    }

    if (response.status != 200) {
      const json = await response.json();
      throw new Error(json.mensagem);
    }

  }

})